/*
 * Decompiled with CFR 0.152.
 */
package androidx.room;

import androidx.room.BaseRoomConnectionManager;
import androidx.room.DatabaseConfiguration;
import androidx.room.RoomDatabase;
import androidx.room.RoomOpenDelegate;
import androidx.room.Transactor;
import androidx.room.coroutines.AndroidSQLiteDriverConnectionPool;
import androidx.room.coroutines.ConnectionPool;
import androidx.room.coroutines.ConnectionPoolKt;
import androidx.room.driver.SupportSQLiteConnection;
import androidx.room.driver.SupportSQLiteConnectionPool;
import androidx.room.driver.SupportSQLiteDriver;
import androidx.sqlite.SQLiteConnection;
import androidx.sqlite.SQLiteDriver;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import androidx.sqlite.driver.AndroidSQLiteDriver;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001:\u000212B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B%\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u0006\u0010\u000bJ\b\u0010\u001d\u001a\u00020\u001eH\u0002J@\u0010\u001f\u001a\u0002H \"\u0004\b\u0000\u0010 2\u0006\u0010!\u001a\u00020\"2\"\u0010#\u001a\u001e\b\u0001\u0012\u0004\u0012\u00020%\u0012\n\u0012\b\u0012\u0004\u0012\u0002H 0&\u0012\u0006\u0012\u0004\u0018\u00010'0$H\u0096@\u00a2\u0006\u0002\u0010(J\u0015\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*H\u0010\u00a2\u0006\u0002\b,J\u0006\u0010-\u001a\u00020\u001eJ\u0006\u0010.\u001a\u00020\"J \u0010/\u001a\u00020\u0003*\u00020\u00032\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001e0\tH\u0002R\u0014\u0010\f\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\u0004\u0018\u00010\n8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Landroidx/room/RoomConnectionManager;", "Landroidx/room/BaseRoomConnectionManager;", "config", "Landroidx/room/DatabaseConfiguration;", "openDelegate", "Landroidx/room/RoomOpenDelegate;", "<init>", "(Landroidx/room/DatabaseConfiguration;Landroidx/room/RoomOpenDelegate;)V", "supportOpenHelperFactory", "Lkotlin/Function1;", "Landroidx/sqlite/db/SupportSQLiteOpenHelper;", "(Landroidx/room/DatabaseConfiguration;Lkotlin/jvm/functions/Function1;)V", "configuration", "getConfiguration", "()Landroidx/room/DatabaseConfiguration;", "getOpenDelegate", "()Landroidx/room/RoomOpenDelegate;", "callbacks", "", "Landroidx/room/RoomDatabase$Callback;", "getCallbacks", "()Ljava/util/List;", "connectionPool", "Landroidx/room/coroutines/ConnectionPool;", "supportOpenHelper", "getSupportOpenHelper$room_runtime_release", "()Landroidx/sqlite/db/SupportSQLiteOpenHelper;", "supportDatabase", "Landroidx/sqlite/db/SupportSQLiteDatabase;", "init", "", "useConnection", "R", "isReadOnly", "", "block", "Lkotlin/Function2;", "Landroidx/room/Transactor;", "Lkotlin/coroutines/Continuation;", "", "(ZLkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "resolveFileName", "", "fileName", "resolveFileName$room_runtime_release", "close", "isSupportDatabaseOpen", "installOnOpenCallback", "onOpen", "SupportOpenHelperCallback", "NoOpOpenDelegate", "room-runtime_release"})
public final class RoomConnectionManager
extends BaseRoomConnectionManager {
    @NotNull
    private final DatabaseConfiguration configuration;
    @NotNull
    private final RoomOpenDelegate openDelegate;
    @NotNull
    private final List<RoomDatabase.Callback> callbacks;
    @NotNull
    private final ConnectionPool connectionPool;
    @Nullable
    private SupportSQLiteDatabase supportDatabase;

    @Override
    @NotNull
    protected DatabaseConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    @NotNull
    protected RoomOpenDelegate getOpenDelegate() {
        return this.openDelegate;
    }

    @Override
    @NotNull
    protected List<RoomDatabase.Callback> getCallbacks() {
        return this.callbacks;
    }

    @Nullable
    public final SupportSQLiteOpenHelper getSupportOpenHelper$room_runtime_release() {
        ConnectionPool connectionPool = this.connectionPool;
        Object object = connectionPool instanceof SupportSQLiteConnectionPool ? (SupportSQLiteConnectionPool)connectionPool : null;
        return object != null && (object = ((SupportSQLiteConnectionPool)object).getSupportDriver$room_runtime_release()) != null ? ((SupportSQLiteDriver)object).getOpenHelper() : null;
    }

    public RoomConnectionManager(@NotNull DatabaseConfiguration config, @NotNull RoomOpenDelegate openDelegate) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)openDelegate, (String)"openDelegate");
        this.configuration = config;
        this.openDelegate = openDelegate;
        List<RoomDatabase.Callback> list = config.callbacks;
        if (list == null) {
            list = this.callbacks = CollectionsKt.emptyList();
        }
        if (config.sqliteDriver == null) {
            if (config.sqliteOpenHelperFactory == null) {
                boolean bl = false;
                String string = "SQLiteManager was constructed with both null driver and open helper factory!";
                throw new IllegalArgumentException(string.toString());
            }
            SupportSQLiteOpenHelper.Configuration openHelperConfig = SupportSQLiteOpenHelper.Configuration.Companion.builder(config.context).name(config.name).callback((SupportSQLiteOpenHelper.Callback)new SupportOpenHelperCallback(openDelegate.getVersion())).build();
            this.connectionPool = new SupportSQLiteConnectionPool(new SupportSQLiteDriver(config.sqliteOpenHelperFactory.create(openHelperConfig)));
        } else {
            ConnectionPool connectionPool;
            if (config.sqliteDriver instanceof AndroidSQLiteDriver) {
                SQLiteDriver sQLiteDriver = new BaseRoomConnectionManager.DriverWrapper(config.sqliteDriver);
                String string = config.name;
                if (string == null) {
                    string = ":memory:";
                }
                connectionPool = new AndroidSQLiteDriverConnectionPool(sQLiteDriver, string);
            } else {
                connectionPool = config.name == null ? ConnectionPoolKt.newSingleConnectionPool(new BaseRoomConnectionManager.DriverWrapper(config.sqliteDriver), ":memory:") : ConnectionPoolKt.newConnectionPool(new BaseRoomConnectionManager.DriverWrapper(config.sqliteDriver), config.name, this.getMaxNumberOfReaders(config.journalMode), this.getMaxNumberOfWriters(config.journalMode));
            }
            this.connectionPool = connectionPool;
        }
        this.init();
    }

    public RoomConnectionManager(@NotNull DatabaseConfiguration config, @NotNull Function1<? super DatabaseConfiguration, ? extends SupportSQLiteOpenHelper> supportOpenHelperFactory) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter(supportOpenHelperFactory, (String)"supportOpenHelperFactory");
        this.configuration = config;
        this.openDelegate = new NoOpOpenDelegate();
        List list = config.callbacks;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        this.callbacks = list;
        DatabaseConfiguration configWithCompatibilityCallback = this.installOnOpenCallback(config, (Function1<? super SupportSQLiteDatabase, Unit>)((Function1)arg_0 -> RoomConnectionManager._init_$lambda$1(this, arg_0)));
        this.connectionPool = new SupportSQLiteConnectionPool(new SupportSQLiteDriver((SupportSQLiteOpenHelper)supportOpenHelperFactory.invoke((Object)configWithCompatibilityCallback)));
        this.init();
    }

    private final void init() {
        block0: {
            boolean wal = this.getConfiguration().journalMode == RoomDatabase.JournalMode.WRITE_AHEAD_LOGGING;
            SupportSQLiteOpenHelper supportSQLiteOpenHelper = this.getSupportOpenHelper$room_runtime_release();
            if (supportSQLiteOpenHelper == null) break block0;
            supportSQLiteOpenHelper.setWriteAheadLoggingEnabled(wal);
        }
    }

    @Override
    @Nullable
    public <R> Object useConnection(boolean isReadOnly2, @NotNull Function2<? super Transactor, ? super Continuation<? super R>, ? extends Object> block, @NotNull Continuation<? super R> $completion) {
        return this.connectionPool.useConnection(isReadOnly2, block, $completion);
    }

    @Override
    @NotNull
    public String resolveFileName$room_runtime_release(@NotNull String fileName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        if (!Intrinsics.areEqual((Object)fileName, (Object)":memory:")) {
            String string2 = this.getConfiguration().context.getDatabasePath(fileName).getAbsolutePath();
            Intrinsics.checkNotNull((Object)string2);
            string = string2;
        } else {
            string = fileName;
        }
        return string;
    }

    public final void close() {
        this.connectionPool.close();
    }

    public final boolean isSupportDatabaseOpen() {
        SupportSQLiteDatabase supportSQLiteDatabase = this.supportDatabase;
        return supportSQLiteDatabase != null ? supportSQLiteDatabase.isOpen() : false;
    }

    private final DatabaseConfiguration installOnOpenCallback(DatabaseConfiguration $this$installOnOpenCallback, Function1<? super SupportSQLiteDatabase, Unit> onOpen) {
        List list = $this$installOnOpenCallback.callbacks;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List newCallbacks2 = CollectionsKt.plus((Collection)list, (Object)new RoomDatabase.Callback(onOpen){
            final /* synthetic */ Function1<SupportSQLiteDatabase, Unit> $onOpen;
            {
                this.$onOpen = $onOpen;
            }

            public void onOpen(SupportSQLiteDatabase db) {
                Intrinsics.checkNotNullParameter((Object)db, (String)"db");
                this.$onOpen.invoke((Object)db);
            }
        });
        return DatabaseConfiguration.copy$default($this$installOnOpenCallback, null, null, null, null, newCallbacks2, false, null, null, null, null, false, false, null, null, null, null, null, null, null, false, null, null, 0x3FFFEF, null);
    }

    private static final Unit _init_$lambda$1(RoomConnectionManager this$0, SupportSQLiteDatabase db) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        this$0.supportDatabase = db;
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u000f"}, d2={"Landroidx/room/RoomConnectionManager$NoOpOpenDelegate;", "Landroidx/room/RoomOpenDelegate;", "<init>", "()V", "onCreate", "", "connection", "Landroidx/sqlite/SQLiteConnection;", "onPreMigrate", "onValidateSchema", "Landroidx/room/RoomOpenDelegate$ValidationResult;", "onPostMigrate", "onOpen", "createAllTables", "dropAllTables", "room-runtime_release"})
    private static final class NoOpOpenDelegate
    extends RoomOpenDelegate {
        public NoOpOpenDelegate() {
            super(-1, "", "");
        }

        @Override
        public void onCreate(@NotNull SQLiteConnection connection) {
            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            throw new IllegalStateException("NOP delegate should never be called".toString());
        }

        @Override
        public void onPreMigrate(@NotNull SQLiteConnection connection) {
            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            throw new IllegalStateException("NOP delegate should never be called".toString());
        }

        @Override
        @NotNull
        public RoomOpenDelegate.ValidationResult onValidateSchema(@NotNull SQLiteConnection connection) {
            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            throw new IllegalStateException("NOP delegate should never be called".toString());
        }

        @Override
        public void onPostMigrate(@NotNull SQLiteConnection connection) {
            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            throw new IllegalStateException("NOP delegate should never be called".toString());
        }

        @Override
        public void onOpen(@NotNull SQLiteConnection connection) {
            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            throw new IllegalStateException("NOP delegate should never be called".toString());
        }

        @Override
        public void createAllTables(@NotNull SQLiteConnection connection) {
            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            throw new IllegalStateException("NOP delegate should never be called".toString());
        }

        @Override
        public void dropAllTables(@NotNull SQLiteConnection connection) {
            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            throw new IllegalStateException("NOP delegate should never be called".toString());
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003H\u0016J \u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000f"}, d2={"Landroidx/room/RoomConnectionManager$SupportOpenHelperCallback;", "Landroidx/sqlite/db/SupportSQLiteOpenHelper$Callback;", "version", "", "<init>", "(Landroidx/room/RoomConnectionManager;I)V", "onCreate", "", "db", "Landroidx/sqlite/db/SupportSQLiteDatabase;", "onUpgrade", "oldVersion", "newVersion", "onDowngrade", "onOpen", "room-runtime_release"})
    public final class SupportOpenHelperCallback
    extends SupportSQLiteOpenHelper.Callback {
        public SupportOpenHelperCallback(int version2) {
            super(version2);
        }

        public void onCreate(@NotNull SupportSQLiteDatabase db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            RoomConnectionManager.this.onCreate(new SupportSQLiteConnection(db));
        }

        public void onUpgrade(@NotNull SupportSQLiteDatabase db, int oldVersion, int newVersion) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            RoomConnectionManager.this.onMigrate(new SupportSQLiteConnection(db), oldVersion, newVersion);
        }

        public void onDowngrade(@NotNull SupportSQLiteDatabase db, int oldVersion, int newVersion) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            this.onUpgrade(db, oldVersion, newVersion);
        }

        public void onOpen(@NotNull SupportSQLiteDatabase db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            RoomConnectionManager.this.onOpen(new SupportSQLiteConnection(db));
            RoomConnectionManager.this.supportDatabase = db;
        }
    }
}

