/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.jarjarred.org.antlr.v4.codegen.model;

import androidx.room.jarjarred.org.antlr.v4.codegen.OutputModelFactory;
import androidx.room.jarjarred.org.antlr.v4.codegen.Target;
import androidx.room.jarjarred.org.antlr.v4.codegen.model.SrcOp;
import androidx.room.jarjarred.org.antlr.v4.codegen.model.TokenInfo;
import androidx.room.jarjarred.org.antlr.v4.runtime.misc.IntervalSet;
import androidx.room.jarjarred.org.antlr.v4.tool.ast.GrammarAST;
import java.util.ArrayList;
import java.util.List;

public class TestSetInline
extends SrcOp {
    public final int bitsetWordSize;
    public final String varName;
    public final Bitset[] bitsets;

    public TestSetInline(OutputModelFactory factory, GrammarAST ast, IntervalSet set, int wordSize) {
        super(factory, ast);
        this.bitsetWordSize = wordSize;
        Bitset[] withZeroOffset = TestSetInline.createBitsets(factory, set, wordSize, true);
        Bitset[] withoutZeroOffset = TestSetInline.createBitsets(factory, set, wordSize, false);
        this.bitsets = withZeroOffset.length <= withoutZeroOffset.length ? withZeroOffset : withoutZeroOffset;
        this.varName = "_la";
    }

    private static Bitset[] createBitsets(OutputModelFactory factory, IntervalSet set, int wordSize, boolean useZeroOffset) {
        ArrayList<Bitset> bitsetList = new ArrayList<Bitset>();
        Target target = factory.getGenerator().getTarget();
        Bitset current = null;
        for (int ttype : set.toArray()) {
            if (current == null || ttype > current.shift + wordSize - 1) {
                int shift = useZeroOffset && ttype >= 0 && ttype < wordSize - 1 ? 0 : ttype;
                current = new Bitset(shift);
                bitsetList.add(current);
            }
            current.addToken(ttype, target.getTokenTypeAsTargetLabel(factory.getGrammar(), ttype));
        }
        return bitsetList.toArray(new Bitset[0]);
    }

    public static final class Bitset {
        public final int shift;
        private final List<TokenInfo> tokens = new ArrayList<TokenInfo>();
        private long calculated;

        public Bitset(int shift) {
            this.shift = shift;
        }

        public void addToken(int type, String name) {
            this.tokens.add(new TokenInfo(type, name));
            this.calculated |= 1L << type - this.shift;
        }

        public List<TokenInfo> getTokens() {
            return this.tokens;
        }

        public long getCalculated() {
            return this.calculated;
        }
    }
}

