/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.writer;

import androidx.room.compiler.codegen.CodeLanguage;
import androidx.room.compiler.codegen.XClassName;
import androidx.room.compiler.codegen.XCodeBlock;
import androidx.room.compiler.codegen.XFunSpec;
import androidx.room.compiler.codegen.XMemberName;
import androidx.room.compiler.codegen.XName;
import androidx.room.compiler.codegen.XTypeName;
import androidx.room.ext.CollectionTypeNames;
import androidx.room.ext.CommonTypeNames;
import androidx.room.ext.KotlinTypeNames;
import androidx.room.ext.LambdaSpec;
import androidx.room.ext.RoomTypeNames;
import androidx.room.ext.SQLiteDriverTypeNames;
import androidx.room.ext.String_extKt;
import androidx.room.ext.Xpoet_extKt;
import androidx.room.solver.CodeGenScope;
import androidx.room.solver.query.result.RowAdapter;
import androidx.room.vo.QueryParameter;
import androidx.room.vo.Relation;
import androidx.room.vo.RelationCollector;
import androidx.room.writer.RelationCollectorFunctionWriter;
import androidx.room.writer.TypeWriter;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0014\u0010\u0012\u001a\u00020\f*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001c\u0010\u0016\u001a\u00020\f*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\nH\u0002J\f\u0010\u0018\u001a\u00020\f*\u00020\u0013H\u0002J\u001c\u0010\u0019\u001a\u00020\f*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Landroidx/room/writer/RelationCollectorFunctionWriter;", "Landroidx/room/writer/TypeWriter$SharedFunctionSpec;", "collector", "Landroidx/room/vo/RelationCollector;", "<init>", "(Landroidx/room/vo/RelationCollector;)V", "usingLongSparseArray", "", "usingArrayMap", "getUniqueKey", "", "prepare", "", "functionName", "writer", "Landroidx/room/writer/TypeWriter;", "builder", "Landroidx/room/compiler/codegen/XFunSpec$Builder;", "createStmtAndReturn", "Landroidx/room/compiler/codegen/XCodeBlock$Builder;", "scope", "Landroidx/room/solver/CodeGenScope;", "addRelationCollectorCode", "stmtVar", "addIsInputEmptyCheck", "addRecursiveFetchCall", "Companion", "room-compiler"})
@SourceDebugExtension(value={"SMAP\nRelationCollectorFunctionWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RelationCollectorFunctionWriter.kt\nandroidx/room/writer/RelationCollectorFunctionWriter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,256:1\n1#2:257\n*E\n"})
public final class RelationCollectorFunctionWriter
extends TypeWriter.SharedFunctionSpec {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RelationCollector collector;
    private final boolean usingLongSparseArray;
    private final boolean usingArrayMap;
    @NotNull
    public static final String PARAM_MAP_VARIABLE = "_map";
    @NotNull
    public static final String PARAM_CONNECTION_VARIABLE = "_connection";
    @NotNull
    public static final String KEY_SET_VARIABLE = "__mapKeySet";

    public RelationCollectorFunctionWriter(@NotNull RelationCollector collector) {
        Intrinsics.checkNotNullParameter((Object)collector, (String)"collector");
        super("fetchRelationship" + String_extKt.stripNonJava(collector.getRelation().getEntity().getTableName()) + "As" + String_extKt.stripNonJava(collector.getRelation().getDataClassTypeName().toString(CodeLanguage.JAVA)));
        this.collector = collector;
        this.usingLongSparseArray = Intrinsics.areEqual((Object)this.collector.getMapTypeName().getRawTypeName(), (Object)CollectionTypeNames.INSTANCE.getLONG_SPARSE_ARRAY());
        this.usingArrayMap = Intrinsics.areEqual((Object)this.collector.getMapTypeName().getRawTypeName(), (Object)CollectionTypeNames.INSTANCE.getARRAY_MAP());
    }

    @Override
    @NotNull
    public String getUniqueKey() {
        Relation relation = this.collector.getRelation();
        return "RelationCollectorFunctionWriter-" + this.collector.getMapTypeName() + "-" + relation.getEntity().getTypeName().toString(CodeLanguage.JAVA) + "-" + relation.getEntityProperty().getColumnName() + "-" + relation.getDataClassTypeName() + "-" + relation.createLoadAllSql();
    }

    @Override
    public void prepare(@NotNull String functionName, @NotNull TypeWriter writer, @NotNull XFunSpec.Builder builder) {
        XCodeBlock xCodeBlock;
        XCodeBlock.Builder builder2;
        Intrinsics.checkNotNullParameter((Object)functionName, (String)"functionName");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        CodeGenScope scope = new CodeGenScope(writer);
        XCodeBlock.Builder $this$prepare_u24lambda_u241 = builder2 = scope.getBuilder();
        boolean bl = false;
        this.addIsInputEmptyCheck($this$prepare_u24lambda_u241);
        XCodeBlock.Builder builder3 = new Object[2];
        if (this.usingLongSparseArray) {
            Object[] objectArray = new Object[]{PARAM_MAP_VARIABLE};
            xCodeBlock = XCodeBlock.Companion.of("%L.size()", objectArray);
        } else {
            xCodeBlock = Xpoet_extKt.CollectionsSizeExprCode(PARAM_MAP_VARIABLE);
        }
        builder3[0] = xCodeBlock;
        builder3[1] = "999";
        XCodeBlock.Builder $this$prepare_u24lambda_u241_u24lambda_u240 = builder3 = $this$prepare_u24lambda_u241.beginControlFlow("if (%L > %L)", (Object[])builder3);
        boolean bl2 = false;
        this.addRecursiveFetchCall($this$prepare_u24lambda_u241_u24lambda_u240, scope, functionName);
        $this$prepare_u24lambda_u241_u24lambda_u240.addStatement("return", new Object[0]);
        builder3.endControlFlow();
        this.createStmtAndReturn($this$prepare_u24lambda_u241, scope);
        XCodeBlock.Builder $this$prepare_u24lambda_u242 = builder2 = builder;
        boolean bl3 = false;
        $this$prepare_u24lambda_u242.addParameter(PARAM_CONNECTION_VARIABLE, (XTypeName)SQLiteDriverTypeNames.INSTANCE.getCONNECTION());
        $this$prepare_u24lambda_u242.addParameter(PARAM_MAP_VARIABLE, this.collector.getMapTypeName());
        $this$prepare_u24lambda_u242.addCode(scope.generate());
    }

    private final void createStmtAndReturn(XCodeBlock.Builder $this$createStmtAndReturn, CodeGenScope scope) {
        String stmtVar = scope.getTmpVar("_stmt");
        String sqlQueryVar = scope.getTmpVar("_sql");
        String connectionVar = scope.getTmpVar(PARAM_CONNECTION_VARIABLE);
        List<Pair<QueryParameter, String>> listSizeVars = this.collector.getQueryWriter().prepareQuery(sqlQueryVar, scope);
        Object[] objectArray = new Object[]{connectionVar, sqlQueryVar};
        $this$createStmtAndReturn.addLocalVal(stmtVar, (XTypeName)SQLiteDriverTypeNames.INSTANCE.getSTATEMENT(), "%L.prepare(%L)", objectArray);
        this.collector.getQueryWriter().bindArgs(stmtVar, listSizeVars, scope);
        this.addRelationCollectorCode($this$createStmtAndReturn, scope, stmtVar);
    }

    private final void addRelationCollectorCode(XCodeBlock.Builder $this$addRelationCollectorCode, CodeGenScope scope, String stmtVar) {
        XCodeBlock.Builder builder;
        Relation relation = this.collector.getRelation();
        XCodeBlock.Builder $this$addRelationCollectorCode_u24lambda_u246 = builder = $this$addRelationCollectorCode.beginControlFlow("try", new Object[0]);
        boolean bl = false;
        String itemKeyIndexVar = "_itemKeyIndex";
        if (relation.getJunction() != null) {
            int junctionParentColumnIndex = relation.getProjection().size();
            Object[] objectArray = new Object[]{relation.getJunction().getParentProperty().getColumnName()};
            $this$addRelationCollectorCode_u24lambda_u246.addStatement("// _junction.%L", objectArray);
            objectArray = new Object[]{junctionParentColumnIndex};
            v0 = $this$addRelationCollectorCode_u24lambda_u246.addLocalVal(itemKeyIndexVar, XTypeName.PRIMITIVE_INT, "%L", objectArray);
        } else {
            Object[] junctionParentColumnIndex = new Object[]{XMemberName.Companion.packageMember(RoomTypeNames.INSTANCE.getSTATEMENT_UTIL(), "getColumnIndex"), stmtVar, relation.getEntityProperty().getColumnName()};
            v0 = $this$addRelationCollectorCode_u24lambda_u246.addLocalVal(itemKeyIndexVar, XTypeName.PRIMITIVE_INT, "%M(%L, %S)", junctionParentColumnIndex);
        }
        Object[] junctionParentColumnIndex = new Object[]{itemKeyIndexVar};
        Object[] $this$addRelationCollectorCode_u24lambda_u246_u24lambda_u243 = junctionParentColumnIndex = $this$addRelationCollectorCode_u24lambda_u246.beginControlFlow("if (%L == -1)", junctionParentColumnIndex);
        boolean bl2 = false;
        $this$addRelationCollectorCode_u24lambda_u246_u24lambda_u243.addStatement("return", new Object[0]);
        $this$addRelationCollectorCode_u24lambda_u246.endControlFlow();
        RowAdapter.onStatementReady$default(this.collector.getRowAdapter(), stmtVar, scope, null, 4, null);
        String tmpVarName = scope.getTmpVar("_item");
        String stepName = "step";
        Object[] objectArray = new Object[]{stmtVar};
        Object[] $this$addRelationCollectorCode_u24lambda_u246_u24lambda_u245 = objectArray = $this$addRelationCollectorCode_u24lambda_u246.beginControlFlow("while (%L." + stepName + "())", objectArray);
        boolean bl3 = false;
        this.collector.readKey(stmtVar, itemKeyIndexVar, this.collector.getEntityKeyColumnReader(), scope, (Function2<? super XCodeBlock.Builder, ? super String, Unit>)((Function2)(arg_0, arg_1) -> RelationCollectorFunctionWriter.addRelationCollectorCode$lambda$6$lambda$5$lambda$4(this, scope, tmpVarName, relation, stmtVar, arg_0, arg_1)));
        $this$addRelationCollectorCode_u24lambda_u246.endControlFlow();
        XCodeBlock.Builder $this$addRelationCollectorCode_u24lambda_u247 = builder = $this$addRelationCollectorCode.nextControlFlow("finally", new Object[0]);
        boolean bl4 = false;
        Object[] objectArray2 = new Object[]{stmtVar};
        $this$addRelationCollectorCode_u24lambda_u247.addStatement("%L.close()", objectArray2);
        $this$addRelationCollectorCode.endControlFlow();
    }

    private final void addIsInputEmptyCheck(XCodeBlock.Builder $this$addIsInputEmptyCheck) {
        Object[] objectArray;
        Object[] objectArray2;
        if (this.usingLongSparseArray) {
            objectArray2 = new Object[]{PARAM_MAP_VARIABLE};
            objectArray = $this$addIsInputEmptyCheck.beginControlFlow("if (%L.isEmpty())", objectArray2);
        } else {
            Object[] objectArray3 = new XTypeName[]{this.collector.getKeyTypeName()};
            XTypeName keySetType = CommonTypeNames.INSTANCE.getSET().parametrizedBy((XTypeName[])objectArray3);
            XCodeBlock.Builder.addLocalVariable$default((XCodeBlock.Builder)$this$addIsInputEmptyCheck, (String)KEY_SET_VARIABLE, (XTypeName)keySetType, (boolean)false, (XCodeBlock)Xpoet_extKt.MapKeySetExprCode(PARAM_MAP_VARIABLE), (int)4, null);
            objectArray3 = new Object[]{KEY_SET_VARIABLE};
            objectArray = $this$addIsInputEmptyCheck.beginControlFlow("if (%L.isEmpty())", objectArray3);
        }
        Object[] $this$addIsInputEmptyCheck_u24lambda_u248 = objectArray2 = objectArray;
        boolean bl = false;
        $this$addIsInputEmptyCheck_u24lambda_u248.addStatement("return", new Object[0]);
        $this$addIsInputEmptyCheck.endControlFlow();
    }

    private final void addRecursiveFetchCall(XCodeBlock.Builder $this$addRecursiveFetchCall, CodeGenScope scope, String functionName) {
        XClassName it = RoomTypeNames.INSTANCE.getRELATION_UTIL();
        boolean bl = false;
        XMemberName utilFunction = this.usingLongSparseArray ? XMemberName.Companion.packageMember(it, "recursiveFetchLongSparseArray") : (this.usingArrayMap ? XMemberName.Companion.packageMember(it, "recursiveFetchArrayMap") : XMemberName.Companion.packageMember(it, XName.Companion.of("recursiveFetchHashMap", "recursiveFetchMap")));
        String paramName = scope.getTmpVar("_tmpMap");
        Object[] objectArray = new String[]{"%L", "%L"};
        List list = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Object[]{PARAM_MAP_VARIABLE, this.collector.getRelationTypeIsCollection()};
        List list2 = CollectionsKt.listOf((Object[])objectArray);
        objectArray = this.collector.getMapTypeName();
        XClassName xClassName = KotlinTypeNames.INSTANCE.getUNIT();
        boolean bl2 = scope.getJavaLambdaSyntaxAvailable();
        XCodeBlock recursiveFetchBlock2 = Xpoet_extKt.InvokeWithLambdaParameter$default(scope, utilFunction, list, list2, null, new LambdaSpec(paramName, functionName, (XTypeName)objectArray, xClassName, bl2){
            final /* synthetic */ String $paramName;
            final /* synthetic */ String $functionName;
            {
                this.$paramName = $paramName;
                this.$functionName = $functionName;
                super($super_call_param$1, $paramName, (XTypeName)$super_call_param$2, $super_call_param$3);
            }

            public void body(XCodeBlock.Builder $this$body, CodeGenScope scope) {
                Intrinsics.checkNotNullParameter((Object)$this$body, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
                Object[] objectArray = new Object[]{this.$functionName, "_connection", this.$paramName};
                XCodeBlock recursiveCall = XCodeBlock.Companion.of("%L(%L, %L)", objectArray);
                objectArray = new Object[]{recursiveCall};
                $this$body.addStatement("%L", objectArray);
                XCodeBlock.Builder.Companion.applyTo($this$body, CodeLanguage.JAVA, addRecursiveFetchCall.recursiveFetchBlock.1::body$lambda$0);
            }

            private static final Unit body$lambda$0(XCodeBlock.Builder $this$applyTo) {
                Intrinsics.checkNotNullParameter((Object)$this$applyTo, (String)"$this$applyTo");
                Object[] objectArray = new Object[]{KotlinTypeNames.INSTANCE.getUNIT()};
                $this$applyTo.addStatement("return %T.INSTANCE", objectArray);
                return Unit.INSTANCE;
            }
        }, 16, null);
        objectArray = new Object[]{recursiveFetchBlock2};
        $this$addRecursiveFetchCall.add("%L", objectArray);
    }

    private static final Unit addRelationCollectorCode$lambda$6$lambda$5$lambda$4(RelationCollectorFunctionWriter this$0, CodeGenScope $scope, String $tmpVarName, Relation $relation, String $stmtVar, XCodeBlock.Builder $this$readKey, String keyVar) {
        Intrinsics.checkNotNullParameter((Object)$this$readKey, (String)"$this$readKey");
        Intrinsics.checkNotNullParameter((Object)keyVar, (String)"keyVar");
        if (this$0.collector.getRelationTypeIsCollection()) {
            String relationVar = $scope.getTmpVar("_tmpRelation");
            Object[] objectArray = new Object[]{PARAM_MAP_VARIABLE, keyVar};
            $this$readKey.addLocalVal(relationVar, this$0.collector.getRelationTypeName().copy(true), "%L.get(%L)", objectArray);
            objectArray = new Object[]{relationVar};
            $this$readKey.beginControlFlow("if (%L != null)", objectArray);
            XCodeBlock.Builder.addLocalVariable$default((XCodeBlock.Builder)$this$readKey, (String)$tmpVarName, (XTypeName)$relation.getDataClassTypeName(), (boolean)false, null, (int)12, null);
            this$0.collector.getRowAdapter().convert($tmpVarName, $stmtVar, $scope);
            objectArray = new Object[]{relationVar, $tmpVarName};
            $this$readKey.addStatement("%L.add(%L)", objectArray);
            v0 = $this$readKey.endControlFlow();
        } else {
            Object[] objectArray = new Object[]{PARAM_MAP_VARIABLE, keyVar};
            $this$readKey.beginControlFlow("if (%N.containsKey(%L))", objectArray);
            XCodeBlock.Builder.addLocalVariable$default((XCodeBlock.Builder)$this$readKey, (String)$tmpVarName, (XTypeName)$relation.getDataClassTypeName(), (boolean)false, null, (int)12, null);
            this$0.collector.getRowAdapter().convert($tmpVarName, $stmtVar, $scope);
            objectArray = new Object[]{PARAM_MAP_VARIABLE, keyVar, $tmpVarName};
            $this$readKey.addStatement("%N.put(%L, %L)", objectArray);
            v0 = $this$readKey.endControlFlow();
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Landroidx/room/writer/RelationCollectorFunctionWriter$Companion;", "", "<init>", "()V", "PARAM_MAP_VARIABLE", "", "PARAM_CONNECTION_VARIABLE", "KEY_SET_VARIABLE", "room-compiler"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

