/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.writer;

import androidx.room.compiler.codegen.CodeLanguage;
import androidx.room.compiler.codegen.VisibilityModifier;
import androidx.room.compiler.codegen.XClassName;
import androidx.room.compiler.codegen.XCodeBlock;
import androidx.room.compiler.codegen.XFunSpec;
import androidx.room.compiler.codegen.XTypeName;
import androidx.room.compiler.codegen.XTypeSpec;
import androidx.room.compiler.processing.XElement;
import androidx.room.compiler.processing.XTypeElement;
import androidx.room.ext.RoomMemberNames;
import androidx.room.ext.RoomTypeNames;
import androidx.room.ext.SQLiteDriverMemberNames;
import androidx.room.ext.SQLiteDriverTypeNames;
import androidx.room.migration.bundle.BaseEntityBundle;
import androidx.room.migration.bundle.DatabaseViewBundle;
import androidx.room.migration.bundle.EntityBundle;
import androidx.room.migration.bundle.FtsEntityBundle;
import androidx.room.migration.bundle.IndexBundle;
import androidx.room.vo.AutoMigration;
import androidx.room.writer.TypeWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u001eH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010%\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010&\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J4\u0010'\u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120,H\u0002J\u0010\u0010-\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0018\u0010.\u001a\u00020!2\u0006\u0010*\u001a\u00020)2\u0006\u0010\"\u001a\u00020#H\u0002JN\u0010/\u001a\u00020!2\u0006\u00100\u001a\u00020\u00122\u0006\u00101\u001a\u00020\u00122\u0006\u00102\u001a\u00020)2\u0006\u00103\u001a\u00020)2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120,2\u0006\u0010\"\u001a\u00020#2\b\b\u0002\u00104\u001a\u000205H\u0002J(\u00106\u001a\u00020!2\u0006\u00100\u001a\u00020\u00122\u0006\u00107\u001a\u00020\u00122\u0006\u00101\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020#H\u0002J\u0018\u00108\u001a\u00020!2\u0006\u00109\u001a\u00020:2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010;\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010<\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010=\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010>\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0018\u0010?\u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010@\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00140\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006A"}, d2={"Landroidx/room/writer/AutoMigrationWriter;", "Landroidx/room/writer/TypeWriter;", "autoMigration", "Landroidx/room/vo/AutoMigration;", "dbElement", "Landroidx/room/compiler/processing/XTypeElement;", "writerContext", "Landroidx/room/writer/TypeWriter$WriterContext;", "<init>", "(Landroidx/room/vo/AutoMigration;Landroidx/room/compiler/processing/XTypeElement;Landroidx/room/writer/TypeWriter$WriterContext;)V", "addedColumns", "", "Landroidx/room/vo/AutoMigration$AddedColumn;", "addedTables", "", "Landroidx/room/vo/AutoMigration$AddedTable;", "renamedTables", "", "", "complexChangedTables", "Landroidx/room/vo/AutoMigration$ComplexChangedTable;", "deletedTables", "className", "Landroidx/room/compiler/codegen/XClassName;", "packageName", "getPackageName", "()Ljava/lang/String;", "createTypeSpecBuilder", "Landroidx/room/compiler/codegen/XTypeSpec$Builder;", "createConstructor", "Landroidx/room/compiler/codegen/XFunSpec;", "createMigrateMethod", "addMigrationStatements", "", "migrateBuilder", "Landroidx/room/compiler/codegen/XFunSpec$Builder;", "addDropViewStatements", "addRecreateViewStatements", "addComplexChangeStatements", "addStatementsToMigrateFtsTable", "oldTable", "Landroidx/room/migration/bundle/BaseEntityBundle;", "newTable", "renamedColumnsMap", "", "addSimpleChangeStatements", "addStatementsToCreateNewTable", "addStatementsToContentTransfer", "oldTableName", "tableNameWithNewPrefix", "oldEntityBundle", "newEntityBundle", "isFtsTableContentTransfer", "", "addStatementsToDropTableAndRenameTempTable", "newTableName", "addStatementsToRecreateIndexes", "table", "Landroidx/room/migration/bundle/EntityBundle;", "addDeleteTableStatements", "addRenameTableStatements", "addNewColumnStatements", "addNewTableStatements", "addDatabaseExecuteSqlStatement", "sql", "room-compiler"})
@SourceDebugExtension(value={"SMAP\nAutoMigrationWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AutoMigrationWriter.kt\nandroidx/room/writer/AutoMigrationWriter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,449:1\n1863#2,2:450\n1863#2,2:452\n1053#2:454\n1863#2,2:455\n1863#2,2:457\n774#2:459\n865#2,2:460\n1863#2,2:462\n1863#2,2:464\n1863#2:466\n1864#2:468\n1863#2,2:471\n1863#2,2:473\n1#3:467\n216#4,2:469\n*S KotlinDebug\n*F\n+ 1 AutoMigrationWriter.kt\nandroidx/room/writer/AutoMigrationWriter\n*L\n138#1:450,2\n149#1:452,2\n165#1:454\n166#1:455,2\n203#1:457,2\n294#1:459\n294#1:460,2\n308#1:462,2\n358#1:464,2\n369#1:466\n369#1:468\n395#1:471,2\n423#1:473,2\n381#1:469,2\n*E\n"})
public final class AutoMigrationWriter
extends TypeWriter {
    @NotNull
    private final AutoMigration autoMigration;
    @NotNull
    private final XTypeElement dbElement;
    @NotNull
    private final List<AutoMigration.AddedColumn> addedColumns;
    @NotNull
    private final Set<AutoMigration.AddedTable> addedTables;
    @NotNull
    private final Map<String, String> renamedTables;
    @NotNull
    private final Map<String, AutoMigration.ComplexChangedTable> complexChangedTables;
    @NotNull
    private final List<String> deletedTables;
    @NotNull
    private final XClassName className;
    @NotNull
    private final String packageName;

    public AutoMigrationWriter(@NotNull AutoMigration autoMigration, @NotNull XTypeElement dbElement, @NotNull TypeWriter.WriterContext writerContext) {
        Intrinsics.checkNotNullParameter((Object)autoMigration, (String)"autoMigration");
        Intrinsics.checkNotNullParameter((Object)dbElement, (String)"dbElement");
        Intrinsics.checkNotNullParameter((Object)writerContext, (String)"writerContext");
        super(writerContext);
        this.autoMigration = autoMigration;
        this.dbElement = dbElement;
        this.addedColumns = this.autoMigration.getSchemaDiff().getAddedColumns();
        this.addedTables = this.autoMigration.getSchemaDiff().getAddedTables();
        this.renamedTables = this.autoMigration.getSchemaDiff().getRenamedTables();
        this.complexChangedTables = this.autoMigration.getSchemaDiff().getComplexChangedTables();
        this.deletedTables = this.autoMigration.getSchemaDiff().getDeletedTables();
        this.className = this.autoMigration.getImplTypeName(this.dbElement.asClassName());
        this.packageName = this.className.getPackageName();
    }

    @Override
    @NotNull
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    @NotNull
    public XTypeSpec.Builder createTypeSpecBuilder() {
        return XTypeSpec.Builder.Companion.applyTo(XTypeSpec.Companion.classBuilder$default((XTypeSpec.Companion)XTypeSpec.Companion, (XClassName)this.className, (boolean)false, (int)2, null), (arg_0, arg_1) -> AutoMigrationWriter.createTypeSpecBuilder$lambda$0(this, arg_0, arg_1));
    }

    private final XFunSpec createConstructor() {
        XFunSpec.Builder builder;
        XFunSpec.Builder $this$createConstructor_u24lambda_u241 = builder = XFunSpec.Companion.constructorBuilder$default((XFunSpec.Companion)XFunSpec.Companion, (VisibilityModifier)VisibilityModifier.PUBLIC, (boolean)false, (int)2, null);
        boolean bl = false;
        XClassName xClassName = new XCodeBlock[2];
        Object[] objectArray = new Object[]{this.autoMigration.getFrom()};
        xClassName[0] = XCodeBlock.Companion.of("%L", objectArray);
        objectArray = new Object[]{this.autoMigration.getTo()};
        xClassName[1] = XCodeBlock.Companion.of("%L", objectArray);
        $this$createConstructor_u24lambda_u241.callSuperConstructor((XCodeBlock[])xClassName);
        if (this.autoMigration.isSpecProvided()) {
            xClassName = RoomTypeNames.INSTANCE.getAUTO_MIGRATION_SPEC();
            $this$createConstructor_u24lambda_u241.addParameter("callback", (XTypeName)xClassName);
            $this$createConstructor_u24lambda_u241.addStatement("this.callback = callback", new Object[0]);
        }
        return builder.build();
    }

    private final XFunSpec createMigrateMethod() {
        XFunSpec.Builder builder;
        XFunSpec.Builder $this$createMigrateMethod_u24lambda_u242 = builder = XFunSpec.Companion.builder$default((XFunSpec.Companion)XFunSpec.Companion, (String)"migrate", (VisibilityModifier)VisibilityModifier.PUBLIC, (boolean)false, (boolean)true, (boolean)false, (int)20, null);
        boolean bl = false;
        XClassName xClassName = SQLiteDriverTypeNames.INSTANCE.getCONNECTION();
        $this$createMigrateMethod_u24lambda_u242.addParameter("connection", (XTypeName)xClassName);
        this.addMigrationStatements($this$createMigrateMethod_u24lambda_u242);
        if (this.autoMigration.getSpecClassName() != null) {
            $this$createMigrateMethod_u24lambda_u242.addStatement("callback.onPostMigrate(connection)", new Object[0]);
        }
        XFunSpec.Builder migrateFunctionBuilder = builder;
        return migrateFunctionBuilder.build();
    }

    private final void addMigrationStatements(XFunSpec.Builder migrateBuilder) {
        this.addDropViewStatements(migrateBuilder);
        this.addSimpleChangeStatements(migrateBuilder);
        this.addComplexChangeStatements(migrateBuilder);
        this.addRecreateViewStatements(migrateBuilder);
    }

    private final void addDropViewStatements(XFunSpec.Builder migrateBuilder) {
        Iterable $this$forEach$iv = this.autoMigration.getSchemaDiff().getFromViews();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DatabaseViewBundle view = (DatabaseViewBundle)element$iv;
            boolean bl = false;
            this.addDatabaseExecuteSqlStatement(migrateBuilder, "DROP VIEW " + view.getViewName());
        }
    }

    private final void addRecreateViewStatements(XFunSpec.Builder migrateBuilder) {
        Iterable $this$forEach$iv = this.autoMigration.getSchemaDiff().getToViews();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DatabaseViewBundle view = (DatabaseViewBundle)element$iv;
            boolean bl = false;
            this.addDatabaseExecuteSqlStatement(migrateBuilder, view.createView());
        }
    }

    private final void addComplexChangeStatements(XFunSpec.Builder migrateBuilder) {
        List tablesToCheckForeignKeys = new ArrayList();
        Iterable $this$sortedBy$iv = this.complexChangedTables.values();
        boolean $i$f$sortedBy = false;
        Iterable $this$forEach$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                AutoMigration.ComplexChangedTable it = (AutoMigration.ComplexChangedTable)a;
                boolean bl = false;
                Comparable comparable = Boolean.valueOf(it.getNewVersionEntityBundle() instanceof FtsEntityBundle);
                it = (AutoMigration.ComplexChangedTable)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Boolean.valueOf(it.getNewVersionEntityBundle() instanceof FtsEntityBundle));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AutoMigration.ComplexChangedTable complexChangedTable = (AutoMigration.ComplexChangedTable)element$iv;
            boolean bl = false;
            String tableNameWithNewPrefix = complexChangedTable.component2();
            BaseEntityBundle oldEntityBundle = complexChangedTable.component3();
            BaseEntityBundle newEntityBundle = complexChangedTable.component4();
            Map<String, String> renamedColumnsMap = complexChangedTable.component5();
            if (oldEntityBundle instanceof FtsEntityBundle && !StringsKt.isBlank((CharSequence)((FtsEntityBundle)oldEntityBundle).getFtsOptions().getContentTable())) {
                this.addStatementsToMigrateFtsTable(migrateBuilder, oldEntityBundle, newEntityBundle, renamedColumnsMap);
                continue;
            }
            this.addStatementsToCreateNewTable(newEntityBundle, migrateBuilder);
            AutoMigrationWriter.addStatementsToContentTransfer$default(this, oldEntityBundle.getTableName(), tableNameWithNewPrefix, oldEntityBundle, newEntityBundle, renamedColumnsMap, migrateBuilder, false, 64, null);
            this.addStatementsToDropTableAndRenameTempTable(oldEntityBundle.getTableName(), newEntityBundle.getTableName(), tableNameWithNewPrefix, migrateBuilder);
            if (!(newEntityBundle instanceof EntityBundle)) continue;
            this.addStatementsToRecreateIndexes((EntityBundle)newEntityBundle, migrateBuilder);
            if (!(!((Collection)((EntityBundle)newEntityBundle).getForeignKeys()).isEmpty())) continue;
            tablesToCheckForeignKeys.add(((EntityBundle)newEntityBundle).getTableName());
        }
        $this$forEach$iv = tablesToCheckForeignKeys;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String tableName = (String)element$iv;
            boolean bl = false;
            Object[] objectArray = new Object[]{RoomMemberNames.INSTANCE.getDB_UTIL_FOREIGN_KEY_CHECK(), tableName};
            migrateBuilder.addStatement("%M(connection, %S)", objectArray);
        }
    }

    private final void addStatementsToMigrateFtsTable(XFunSpec.Builder migrateBuilder, BaseEntityBundle oldTable, BaseEntityBundle newTable, Map<String, String> renamedColumnsMap) {
        this.addDatabaseExecuteSqlStatement(migrateBuilder, "DROP TABLE `" + oldTable.getTableName() + "`");
        this.addDatabaseExecuteSqlStatement(migrateBuilder, newTable.createTable());
        Intrinsics.checkNotNull((Object)newTable, (String)"null cannot be cast to non-null type androidx.room.migration.bundle.FtsEntityBundle");
        String contentTable = ((FtsEntityBundle)newTable).getFtsOptions().getContentTable();
        String selectFromTable = ((CharSequence)contentTable).length() == 0 ? oldTable.getTableName() : contentTable;
        this.addStatementsToContentTransfer(selectFromTable, ((FtsEntityBundle)newTable).getTableName(), oldTable, newTable, renamedColumnsMap, migrateBuilder, true);
    }

    private final void addSimpleChangeStatements(XFunSpec.Builder migrateBuilder) {
        this.addDeleteTableStatements(migrateBuilder);
        this.addRenameTableStatements(migrateBuilder);
        this.addNewColumnStatements(migrateBuilder);
        this.addNewTableStatements(migrateBuilder);
    }

    private final void addStatementsToCreateNewTable(BaseEntityBundle newTable, XFunSpec.Builder migrateBuilder) {
        this.addDatabaseExecuteSqlStatement(migrateBuilder, newTable.createNewTable());
    }

    /*
     * WARNING - void declaration
     */
    private final void addStatementsToContentTransfer(String oldTableName, String tableNameWithNewPrefix, BaseEntityBundle oldEntityBundle, BaseEntityBundle newEntityBundle, Map<String, String> renamedColumnsMap, XFunSpec.Builder migrateBuilder, boolean isFtsTableContentTransfer) {
        void $this$addStatementsToContentTransfer_u24lambda_u2412;
        StringBuilder stringBuilder;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Iterable iterable = newEntityBundle.getFieldsByColumnName().keySet();
        boolean $i$f$filter = false;
        void var11_12 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(oldEntityBundle.getFieldsByColumnName().keySet().contains(it) || renamedColumnsMap.containsKey(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List newColumnSequence = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        List selectColumnSequence = new ArrayList();
        if (isFtsTableContentTransfer) {
            selectColumnSequence.addAll(newColumnSequence);
            selectColumnSequence.add("rowId");
            newColumnSequence.add("docid");
        } else {
            Iterable $this$forEach$iv = newColumnSequence;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String column = (String)element$iv;
                boolean bl = false;
                String string = renamedColumnsMap.get(column);
                if (string == null) {
                    string = column;
                }
                selectColumnSequence.add(string);
            }
        }
        StringBuilder $i$f$forEach = stringBuilder = new StringBuilder();
        XFunSpec.Builder builder = migrateBuilder;
        AutoMigrationWriter autoMigrationWriter = this;
        boolean bl = false;
        $this$addStatementsToContentTransfer_u24lambda_u2412.append("INSERT INTO `" + tableNameWithNewPrefix + "` (" + CollectionsKt.joinToString$default((Iterable)newColumnSequence, (CharSequence)",", null, null, (int)0, null, AutoMigrationWriter::addStatementsToContentTransfer$lambda$12$lambda$10, (int)30, null) + ") SELECT " + CollectionsKt.joinToString$default((Iterable)selectColumnSequence, (CharSequence)",", null, null, (int)0, null, AutoMigrationWriter::addStatementsToContentTransfer$lambda$12$lambda$11, (int)30, null) + " FROM `" + oldTableName + "`");
        Unit unit = Unit.INSTANCE;
        autoMigrationWriter.addDatabaseExecuteSqlStatement(builder, stringBuilder.toString());
    }

    static /* synthetic */ void addStatementsToContentTransfer$default(AutoMigrationWriter autoMigrationWriter, String string, String string2, BaseEntityBundle baseEntityBundle, BaseEntityBundle baseEntityBundle2, Map map, XFunSpec.Builder builder, boolean bl, int n, Object object) {
        if ((n & 0x40) != 0) {
            bl = false;
        }
        autoMigrationWriter.addStatementsToContentTransfer(string, string2, baseEntityBundle, baseEntityBundle2, map, builder, bl);
    }

    private final void addStatementsToDropTableAndRenameTempTable(String oldTableName, String newTableName, String tableNameWithNewPrefix, XFunSpec.Builder migrateBuilder) {
        this.addDatabaseExecuteSqlStatement(migrateBuilder, "DROP TABLE `" + oldTableName + "`");
        this.addDatabaseExecuteSqlStatement(migrateBuilder, "ALTER TABLE `" + tableNameWithNewPrefix + "` RENAME TO `" + newTableName + "`");
    }

    private final void addStatementsToRecreateIndexes(EntityBundle table, XFunSpec.Builder migrateBuilder) {
        Iterable $this$forEach$iv = table.getIndices();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IndexBundle index = (IndexBundle)element$iv;
            boolean bl = false;
            this.addDatabaseExecuteSqlStatement(migrateBuilder, index.getCreateSql(table.getTableName()));
        }
    }

    private final void addDeleteTableStatements(XFunSpec.Builder migrateBuilder) {
        Iterable $this$forEach$iv = this.deletedTables;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StringBuilder stringBuilder;
            String tableName = (String)element$iv;
            boolean bl = false;
            StringBuilder $this$addDeleteTableStatements_u24lambda_u2415_u24lambda_u2414 = stringBuilder = new StringBuilder();
            boolean bl2 = false;
            $this$addDeleteTableStatements_u24lambda_u2415_u24lambda_u2414.append("DROP TABLE `" + tableName + "`");
            String deleteTableSql = stringBuilder.toString();
            this.addDatabaseExecuteSqlStatement(migrateBuilder, deleteTableSql);
        }
    }

    private final void addRenameTableStatements(XFunSpec.Builder migrateBuilder) {
        Map<String, String> $this$forEach$iv = this.renamedTables;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            StringBuilder stringBuilder;
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> entry = element$iv = iterator.next();
            boolean bl = false;
            String oldName = entry.getKey();
            String newName = entry.getValue();
            StringBuilder $this$addRenameTableStatements_u24lambda_u2417_u24lambda_u2416 = stringBuilder = new StringBuilder();
            boolean bl2 = false;
            $this$addRenameTableStatements_u24lambda_u2417_u24lambda_u2416.append("ALTER TABLE `" + oldName + "` RENAME TO `" + newName + "`");
            String renameTableSql = stringBuilder.toString();
            this.addDatabaseExecuteSqlStatement(migrateBuilder, renameTableSql);
        }
    }

    private final void addNewColumnStatements(XFunSpec.Builder migrateBuilder) {
        Iterable $this$forEach$iv = this.addedColumns;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StringBuilder stringBuilder;
            AutoMigration.AddedColumn it = (AutoMigration.AddedColumn)element$iv;
            boolean bl = false;
            StringBuilder $this$addNewColumnStatements_u24lambda_u2420_u24lambda_u2419 = stringBuilder = new StringBuilder();
            boolean bl2 = false;
            $this$addNewColumnStatements_u24lambda_u2420_u24lambda_u2419.append("ALTER TABLE `" + it.getTableName() + "` ADD COLUMN `" + it.getFieldBundle().getColumnName() + "` " + it.getFieldBundle().getAffinity());
            if (it.getFieldBundle().isNonNull()) {
                $this$addNewColumnStatements_u24lambda_u2420_u24lambda_u2419.append(" NOT NULL");
            }
            String string = it.getFieldBundle().getDefaultValue();
            boolean bl3 = string != null ? ((CharSequence)string).length() > 0 : false;
            if (bl3) {
                v2 = $this$addNewColumnStatements_u24lambda_u2420_u24lambda_u2419.append(" DEFAULT " + it.getFieldBundle().getDefaultValue());
            } else {
                if (!(!it.getFieldBundle().isNonNull())) {
                    boolean bl4 = false;
                    String string2 = "A Non-Null field should always have a default value.";
                    throw new IllegalStateException(string2.toString());
                }
                v2 = $this$addNewColumnStatements_u24lambda_u2420_u24lambda_u2419.append(" DEFAULT NULL");
            }
            String addNewColumnSql = stringBuilder.toString();
            this.addDatabaseExecuteSqlStatement(migrateBuilder, addNewColumnSql);
        }
    }

    private final void addNewTableStatements(XFunSpec.Builder migrateBuilder) {
        Iterable $this$forEach$iv = this.addedTables;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AutoMigration.AddedTable addedTable = (AutoMigration.AddedTable)element$iv;
            boolean bl = false;
            this.addDatabaseExecuteSqlStatement(migrateBuilder, addedTable.getEntityBundle().createTable());
            if (!(addedTable.getEntityBundle() instanceof EntityBundle)) continue;
            this.addStatementsToRecreateIndexes((EntityBundle)addedTable.getEntityBundle(), migrateBuilder);
        }
    }

    private final void addDatabaseExecuteSqlStatement(XFunSpec.Builder migrateBuilder, String sql) {
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = new Object[]{sql};
        objectArray[0] = XCodeBlock.Companion.ofExtensionCall(SQLiteDriverMemberNames.INSTANCE.getCONNECTION_EXEC_SQL(), "connection", XCodeBlock.Companion.of("%S", objectArray2));
        migrateBuilder.addStatement("%L", objectArray);
    }

    private static final Unit createTypeSpecBuilder$lambda$0(AutoMigrationWriter this$0, XTypeSpec.Builder $this$applyTo, CodeLanguage language) {
        Intrinsics.checkNotNullParameter((Object)$this$applyTo, (String)"$this$applyTo");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        $this$applyTo.addOriginatingElement((XElement)this$0.dbElement);
        $this$applyTo.superclass((XTypeName)RoomTypeNames.INSTANCE.getMIGRATION());
        if (language == CodeLanguage.KOTLIN) {
            $this$applyTo.setVisibility(VisibilityModifier.INTERNAL);
        }
        if (this$0.autoMigration.getSpecClassName() != null) {
            XTypeSpec.Builder.addProperty$default((XTypeSpec.Builder)$this$applyTo, (String)"callback", (XTypeName)((XTypeName)RoomTypeNames.INSTANCE.getAUTO_MIGRATION_SPEC()), (VisibilityModifier)VisibilityModifier.PRIVATE, (boolean)false, !this$0.autoMigration.isSpecProvided() ? XCodeBlock.Companion.ofNewInstance$default((XCodeBlock.Companion)XCodeBlock.Companion, (XTypeName)((XTypeName)this$0.autoMigration.getSpecClassName()), null, (Object[])new Object[0], (int)2, null) : null, (int)8, null);
        }
        $this$applyTo.addFunction(this$0.createConstructor());
        $this$applyTo.addFunction(this$0.createMigrateMethod());
        return Unit.INSTANCE;
    }

    private static final CharSequence addStatementsToContentTransfer$lambda$12$lambda$10(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "`" + it + "`";
    }

    private static final CharSequence addStatementsToContentTransfer$lambda$12$lambda$11(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "`" + it + "`";
    }
}

