/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.vo;

import androidx.room.compiler.processing.XType;
import androidx.room.compiler.processing.XTypeElement;
import androidx.room.migration.bundle.FieldBundle;
import androidx.room.migration.bundle.FtsEntityBundle;
import androidx.room.migration.bundle.FtsOptionsBundle;
import androidx.room.migration.bundle.PrimaryKeyBundle;
import androidx.room.parser.FtsVersion;
import androidx.room.vo.Constructor;
import androidx.room.vo.EmbeddedProperty;
import androidx.room.vo.Entity;
import androidx.room.vo.FtsOptions;
import androidx.room.vo.PrimaryKey;
import androidx.room.vo.Property;
import androidx.room.vo.SchemaIdentityKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001Bg\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0016\u0010\u0017J\b\u0010+\u001a\u00020\u0005H\u0016J\u0006\u0010,\u001a\u00020\u0005J\u001a\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010-\u001a\u00020.H\u0002J\u0016\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\u0006\u00100\u001a\u00020\u0005H\u0002J \u00101\u001a\u00020\u00052\u0006\u00102\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u00103\u001a\u00020\u0005H\u0002J.\u00104\u001a\u00020\u00052\u0006\u00102\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u00103\u001a\u00020\u00052\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u00050\tH\u0002J\u0018\u00106\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u00102\u001a\u00020\u0005H\u0002J\b\u00107\u001a\u000208H\u0016R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001b\u0010\u001c\u001a\u00020\u00058VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b\u001d\u0010\u001eR!\u0010!\u001a\b\u0012\u0004\u0012\u00020\n0\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010 \u001a\u0004\b\"\u0010#R!\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00050\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010 \u001a\u0004\b&\u0010#R!\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00050\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b*\u0010 \u001a\u0004\b)\u0010#\u00a8\u00069"}, d2={"Landroidx/room/vo/FtsEntity;", "Landroidx/room/vo/Entity;", "element", "Landroidx/room/compiler/processing/XTypeElement;", "tableName", "", "type", "Landroidx/room/compiler/processing/XType;", "properties", "", "Landroidx/room/vo/Property;", "embeddedProperties", "Landroidx/room/vo/EmbeddedProperty;", "primaryKey", "Landroidx/room/vo/PrimaryKey;", "constructor", "Landroidx/room/vo/Constructor;", "shadowTableName", "ftsVersion", "Landroidx/room/parser/FtsVersion;", "ftsOptions", "Landroidx/room/vo/FtsOptions;", "<init>", "(Landroidx/room/compiler/processing/XTypeElement;Ljava/lang/String;Landroidx/room/compiler/processing/XType;Ljava/util/List;Ljava/util/List;Landroidx/room/vo/PrimaryKey;Landroidx/room/vo/Constructor;Ljava/lang/String;Landroidx/room/parser/FtsVersion;Landroidx/room/vo/FtsOptions;)V", "getFtsVersion", "()Landroidx/room/parser/FtsVersion;", "getFtsOptions", "()Landroidx/room/vo/FtsOptions;", "createTableQuery", "getCreateTableQuery", "()Ljava/lang/String;", "createTableQuery$delegate", "Lkotlin/Lazy;", "nonHiddenProperties", "getNonHiddenProperties", "()Ljava/util/List;", "nonHiddenProperties$delegate", "contentSyncTriggerNames", "getContentSyncTriggerNames", "contentSyncTriggerNames$delegate", "contentSyncTriggerCreateQueries", "getContentSyncTriggerCreateQueries", "contentSyncTriggerCreateQueries$delegate", "getIdKey", "getCreateTableQueryWithoutTokenizer", "includeTokenizer", "", "createSyncTriggers", "contentTable", "createBeforeTrigger", "triggerOp", "contentTableName", "createAfterTrigger", "columnNames", "createTriggerName", "toBundle", "Landroidx/room/migration/bundle/FtsEntityBundle;", "room-compiler"})
@SourceDebugExtension(value={"SMAP\nFtsEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FtsEntity.kt\nandroidx/room/vo/FtsEntity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,156:1\n1557#2:157\n1628#2,3:158\n1557#2:161\n1628#2,3:162\n1557#2:173\n1628#2,3:174\n827#2:177\n855#2,2:178\n11158#3:165\n11493#3,3:166\n11158#3:169\n11493#3,3:170\n11158#3:180\n11493#3,3:181\n11158#3:184\n11493#3,3:185\n*S KotlinDebug\n*F\n+ 1 FtsEntity.kt\nandroidx/room/vo/FtsEntity\n*L\n97#1:157\n97#1:158,3\n104#1:161\n104#1:162,3\n147#1:173\n147#1:174,3\n54#1:177\n54#1:178,2\n105#1:165\n105#1:166,3\n108#1:169\n108#1:170,3\n63#1:180\n63#1:181,3\n66#1:184\n66#1:185,3\n*E\n"})
public final class FtsEntity
extends Entity {
    @NotNull
    private final FtsVersion ftsVersion;
    @NotNull
    private final FtsOptions ftsOptions;
    @NotNull
    private final Lazy createTableQuery$delegate;
    @NotNull
    private final Lazy nonHiddenProperties$delegate;
    @NotNull
    private final Lazy contentSyncTriggerNames$delegate;
    @NotNull
    private final Lazy contentSyncTriggerCreateQueries$delegate;

    public FtsEntity(@NotNull XTypeElement element, @NotNull String tableName, @NotNull XType type, @NotNull List<Property> properties, @NotNull List<EmbeddedProperty> embeddedProperties, @NotNull PrimaryKey primaryKey, @Nullable Constructor constructor, @Nullable String shadowTableName, @NotNull FtsVersion ftsVersion, @NotNull FtsOptions ftsOptions) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        Intrinsics.checkNotNullParameter(embeddedProperties, (String)"embeddedProperties");
        Intrinsics.checkNotNullParameter((Object)primaryKey, (String)"primaryKey");
        Intrinsics.checkNotNullParameter((Object)((Object)ftsVersion), (String)"ftsVersion");
        Intrinsics.checkNotNullParameter((Object)ftsOptions, (String)"ftsOptions");
        super(element, tableName, type, properties, embeddedProperties, primaryKey, CollectionsKt.emptyList(), CollectionsKt.emptyList(), constructor, shadowTableName);
        this.ftsVersion = ftsVersion;
        this.ftsOptions = ftsOptions;
        this.createTableQuery$delegate = LazyKt.lazy(() -> FtsEntity.createTableQuery_delegate$lambda$0(this, tableName));
        this.nonHiddenProperties$delegate = LazyKt.lazy(() -> FtsEntity.nonHiddenProperties_delegate$lambda$2(properties, primaryKey, this));
        this.contentSyncTriggerNames$delegate = LazyKt.lazy(() -> FtsEntity.contentSyncTriggerNames_delegate$lambda$5(this, tableName));
        this.contentSyncTriggerCreateQueries$delegate = LazyKt.lazy(() -> FtsEntity.contentSyncTriggerCreateQueries_delegate$lambda$6(this));
    }

    @NotNull
    public final FtsVersion getFtsVersion() {
        return this.ftsVersion;
    }

    @NotNull
    public final FtsOptions getFtsOptions() {
        return this.ftsOptions;
    }

    @Override
    @NotNull
    public String getCreateTableQuery() {
        Lazy lazy = this.createTableQuery$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final List<Property> getNonHiddenProperties() {
        Lazy lazy = this.nonHiddenProperties$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    public final List<String> getContentSyncTriggerNames() {
        Lazy lazy = this.contentSyncTriggerNames$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    public final List<String> getContentSyncTriggerCreateQueries() {
        Lazy lazy = this.contentSyncTriggerCreateQueries$delegate;
        return (List)lazy.getValue();
    }

    @Override
    @NotNull
    public String getIdKey() {
        SchemaIdentityKey identityKey = new SchemaIdentityKey();
        identityKey.append(this.getTableName());
        identityKey.appendSorted(this.getProperties());
        identityKey.append(this.ftsVersion.name());
        identityKey.append(this.ftsOptions);
        String string = identityKey.hash();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"hash(...)");
        return string;
    }

    @NotNull
    public final String getCreateTableQueryWithoutTokenizer() {
        return this.createTableQuery(this.getTableName(), false);
    }

    /*
     * WARNING - void declaration
     */
    private final String createTableQuery(String tableName, boolean includeTokenizer) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getNonHiddenProperties();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Property property = (Property)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.databaseDefinition(false));
        }
        List definitions = CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)this.ftsOptions.databaseDefinition(includeTokenizer));
        return "CREATE VIRTUAL TABLE IF NOT EXISTS `" + tableName + "` USING " + this.ftsVersion.name() + "(" + CollectionsKt.joinToString$default((Iterable)definitions, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + ")";
    }

    static /* synthetic */ String createTableQuery$default(FtsEntity ftsEntity, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return ftsEntity.createTableQuery(string, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> createSyncTriggers(String contentTable) {
        String item$iv$iv;
        int n;
        Collection collection;
        String[] $this$mapTo$iv$iv;
        String[] $this$map$iv = (String[])this.getNonHiddenProperties();
        boolean $i$f$map = false;
        String[] stringArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object t : $this$mapTo$iv$iv) {
            void it;
            Property property = (Property)t;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getColumnName());
        }
        List contentColumnNames = (List)destination$iv$iv;
        $this$map$iv = new String[]{"UPDATE", "DELETE"};
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.length);
        $i$f$mapTo = false;
        int n2 = $this$mapTo$iv$iv.length;
        for (n = 0; n < n2; ++n) {
            void operation;
            String bl = item$iv$iv = $this$mapTo$iv$iv[n];
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(this.createBeforeTrigger((String)operation, this.getTableName(), contentTable));
        }
        $this$map$iv = new String[]{"UPDATE", "INSERT"};
        collection = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.length);
        $i$f$mapTo = false;
        int n3 = $this$mapTo$iv$iv.length;
        for (n = 0; n < n3; ++n) {
            String operation = item$iv$iv = $this$mapTo$iv$iv[n];
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(this.createAfterTrigger(operation, this.getTableName(), contentTable, contentColumnNames));
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
    }

    private final String createBeforeTrigger(String triggerOp, String tableName, String contentTableName) {
        return "CREATE TRIGGER IF NOT EXISTS " + this.createTriggerName(tableName, "BEFORE_" + triggerOp) + " BEFORE " + triggerOp + " ON `" + contentTableName + "` BEGIN DELETE FROM `" + tableName + "` WHERE `docid`=OLD.`rowid`; END";
    }

    private final String createAfterTrigger(String triggerOp, String tableName, String contentTableName, List<String> columnNames) {
        return "CREATE TRIGGER IF NOT EXISTS " + this.createTriggerName(tableName, "AFTER_" + triggerOp) + " AFTER " + triggerOp + " ON `" + contentTableName + "` BEGIN INSERT INTO `" + tableName + "`(" + CollectionsKt.joinToString$default((Iterable)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)"docid"), (Iterable)columnNames), (CharSequence)", ", null, null, (int)0, null, FtsEntity::createAfterTrigger$lambda$11, (int)30, null) + ") VALUES (" + CollectionsKt.joinToString$default((Iterable)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)"rowid"), (Iterable)columnNames), (CharSequence)", ", null, null, (int)0, null, FtsEntity::createAfterTrigger$lambda$12, (int)30, null) + "); END";
    }

    private final String createTriggerName(String tableName, String triggerOp) {
        return "room_fts_content_sync_" + tableName + "_" + triggerOp;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public FtsEntityBundle toBundle() {
        Collection<FieldBundle> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = this.getNonHiddenProperties();
        String string = FtsEntity.createTableQuery$default(this, "${TABLE_NAME}", false, 2, null);
        String string2 = this.getTableName();
        boolean $i$f$map = false;
        void var3_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Property property = (Property)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toBundle());
        }
        collection = (List)destination$iv$iv;
        List<String> list = this.getContentSyncTriggerCreateQueries();
        FtsOptionsBundle ftsOptionsBundle = this.ftsOptions.toBundle();
        String string3 = this.ftsVersion.name();
        List list2 = CollectionsKt.emptyList();
        List list3 = CollectionsKt.emptyList();
        PrimaryKeyBundle primaryKeyBundle = this.getPrimaryKey().toBundle();
        List list4 = collection;
        String string4 = string;
        String string5 = string2;
        return new FtsEntityBundle(string5, string4, list4, primaryKeyBundle, list3, list2, string3, ftsOptionsBundle, list);
    }

    private static final String createTableQuery_delegate$lambda$0(FtsEntity this$0, String $tableName) {
        return FtsEntity.createTableQuery$default(this$0, $tableName, false, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final List nonHiddenProperties_delegate$lambda$2(List $properties, PrimaryKey $primaryKey, FtsEntity this$0) {
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv = $properties;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Property it = (Property)element$iv$iv;
            boolean bl = false;
            if (!((Collection)$primaryKey.getProperties()).isEmpty() && Intrinsics.areEqual((Object)CollectionsKt.first((List)$primaryKey.getProperties()), (Object)it) || Intrinsics.areEqual((Object)this$0.ftsOptions.getLanguageIdColumnName(), (Object)it.getColumnName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final List contentSyncTriggerNames_delegate$lambda$5(FtsEntity this$0, String $tableName) {
        List list;
        if (this$0.ftsOptions.getContentEntity() != null) {
            String operation;
            Collection collection;
            String[] $this$mapTo$iv$iv;
            String[] $this$map$iv;
            String[] stringArray = new String[]{"UPDATE", "DELETE"};
            boolean $i$f$map = false;
            void var4_4 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            for (String item$iv$iv : $this$mapTo$iv$iv) {
                void var10_10 = item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this$0.createTriggerName($tableName, "BEFORE_" + operation));
            }
            $this$map$iv = new String[]{"UPDATE", "INSERT"};
            collection = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.length);
            $i$f$mapTo = false;
            int n = $this$mapTo$iv$iv.length;
            for (int i = 0; i < n; ++i) {
                String item$iv$iv;
                operation = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(this$0.createTriggerName($tableName, "AFTER_" + operation));
            }
            list = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private static final List contentSyncTriggerCreateQueries_delegate$lambda$6(FtsEntity this$0) {
        return this$0.ftsOptions.getContentEntity() != null ? this$0.createSyncTriggers(this$0.ftsOptions.getContentEntity().getTableName()) : CollectionsKt.emptyList();
    }

    private static final CharSequence createAfterTrigger$lambda$11(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "`" + it + "`";
    }

    private static final CharSequence createAfterTrigger$lambda$12(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "NEW.`" + it + "`";
    }
}

