/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.vo;

import androidx.room.compiler.processing.XType;
import androidx.room.compiler.processing.XTypeElement;
import androidx.room.migration.bundle.BaseEntityBundle;
import androidx.room.migration.bundle.EntityBundle;
import androidx.room.migration.bundle.FieldBundle;
import androidx.room.migration.bundle.ForeignKeyBundle;
import androidx.room.migration.bundle.IndexBundle;
import androidx.room.migration.bundle.PrimaryKeyBundle;
import androidx.room.vo.Constructor;
import androidx.room.vo.DataClass;
import androidx.room.vo.EmbeddedProperty;
import androidx.room.vo.EntityOrView;
import androidx.room.vo.ForeignKey;
import androidx.room.vo.ForeignKeyAction;
import androidx.room.vo.HasPropertiesKt;
import androidx.room.vo.HasSchemaIdentity;
import androidx.room.vo.Index;
import androidx.room.vo.PrimaryKey;
import androidx.room.vo.Property;
import androidx.room.vo.SchemaIdentityKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003Bs\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000b\u0012\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000b\u0012\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u0012\b\u0010\u0017\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\u0018\u0010\u0019J\b\u0010&\u001a\u00020\u0007H\u0016J\u0010\u0010\"\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bH\u0002J\n\u0010(\u001a\u0004\u0018\u00010\u0007H\u0002J\u000e\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0000J\b\u0010,\u001a\u00020-H\u0016J\u0014\u0010.\u001a\u00020*2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001fR\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001bR\u001b\u0010\"\u001a\u00020\u00078VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b#\u0010\u001b\u00a8\u00060"}, d2={"Landroidx/room/vo/Entity;", "Landroidx/room/vo/DataClass;", "Landroidx/room/vo/HasSchemaIdentity;", "Landroidx/room/vo/EntityOrView;", "element", "Landroidx/room/compiler/processing/XTypeElement;", "tableName", "", "type", "Landroidx/room/compiler/processing/XType;", "properties", "", "Landroidx/room/vo/Property;", "embeddedProperties", "Landroidx/room/vo/EmbeddedProperty;", "primaryKey", "Landroidx/room/vo/PrimaryKey;", "indices", "Landroidx/room/vo/Index;", "foreignKeys", "Landroidx/room/vo/ForeignKey;", "constructor", "Landroidx/room/vo/Constructor;", "shadowTableName", "<init>", "(Landroidx/room/compiler/processing/XTypeElement;Ljava/lang/String;Landroidx/room/compiler/processing/XType;Ljava/util/List;Ljava/util/List;Landroidx/room/vo/PrimaryKey;Ljava/util/List;Ljava/util/List;Landroidx/room/vo/Constructor;Ljava/lang/String;)V", "getTableName", "()Ljava/lang/String;", "getPrimaryKey", "()Landroidx/room/vo/PrimaryKey;", "getIndices", "()Ljava/util/List;", "getForeignKeys", "getShadowTableName", "createTableQuery", "getCreateTableQuery", "createTableQuery$delegate", "Lkotlin/Lazy;", "getIdKey", "createForeignKeyDefinitions", "createPrimaryKeyDefinition", "shouldBeDeletedAfter", "", "other", "toBundle", "Landroidx/room/migration/bundle/BaseEntityBundle;", "isUnique", "columns", "room-compiler"})
@SourceDebugExtension(value={"SMAP\nEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Entity.kt\nandroidx/room/vo/Entity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,112:1\n1557#2:113\n1628#2,3:114\n1557#2:117\n1628#2,3:118\n1755#2,3:121\n1557#2:124\n1628#2,3:125\n1557#2:128\n1628#2,3:129\n1557#2:132\n1628#2,3:133\n1755#2,3:136\n*S KotlinDebug\n*F\n+ 1 Entity.kt\nandroidx/room/vo/Entity\n*L\n57#1:113\n57#1:114,3\n67#1:117\n67#1:118,3\n80#1:121,3\n91#1:124\n91#1:125,3\n93#1:128\n93#1:129,3\n94#1:132\n94#1:133,3\n104#1:136,3\n*E\n"})
public class Entity
extends DataClass
implements HasSchemaIdentity,
EntityOrView {
    @NotNull
    private final String tableName;
    @NotNull
    private final PrimaryKey primaryKey;
    @NotNull
    private final List<Index> indices;
    @NotNull
    private final List<ForeignKey> foreignKeys;
    @Nullable
    private final String shadowTableName;
    @NotNull
    private final Lazy createTableQuery$delegate;

    public Entity(@NotNull XTypeElement element, @NotNull String tableName, @NotNull XType type, @NotNull List<Property> properties, @NotNull List<EmbeddedProperty> embeddedProperties, @NotNull PrimaryKey primaryKey, @NotNull List<Index> indices, @NotNull List<ForeignKey> foreignKeys, @Nullable Constructor constructor, @Nullable String shadowTableName) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        Intrinsics.checkNotNullParameter(embeddedProperties, (String)"embeddedProperties");
        Intrinsics.checkNotNullParameter((Object)primaryKey, (String)"primaryKey");
        Intrinsics.checkNotNullParameter(indices, (String)"indices");
        Intrinsics.checkNotNullParameter(foreignKeys, (String)"foreignKeys");
        super(element, type, properties, embeddedProperties, CollectionsKt.emptyList(), constructor);
        this.tableName = tableName;
        this.primaryKey = primaryKey;
        this.indices = indices;
        this.foreignKeys = foreignKeys;
        this.shadowTableName = shadowTableName;
        this.createTableQuery$delegate = LazyKt.lazy(() -> Entity.createTableQuery_delegate$lambda$0(this));
    }

    @Override
    @NotNull
    public String getTableName() {
        return this.tableName;
    }

    @NotNull
    public final PrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    @NotNull
    public final List<Index> getIndices() {
        return this.indices;
    }

    @NotNull
    public final List<ForeignKey> getForeignKeys() {
        return this.foreignKeys;
    }

    @Nullable
    public final String getShadowTableName() {
        return this.shadowTableName;
    }

    @NotNull
    public String getCreateTableQuery() {
        Lazy lazy = this.createTableQuery$delegate;
        return (String)lazy.getValue();
    }

    @Override
    @NotNull
    public String getIdKey() {
        SchemaIdentityKey identityKey = new SchemaIdentityKey();
        identityKey.append(this.getTableName());
        identityKey.append(this.primaryKey);
        identityKey.appendSorted(this.getProperties());
        identityKey.appendSorted(this.indices);
        identityKey.appendSorted(this.foreignKeys);
        String string = identityKey.hash();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"hash(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final String createTableQuery(String tableName) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getProperties();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Property property = (Property)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            boolean autoIncrement = this.primaryKey.getAutoGenerateId() && this.primaryKey.getProperties().contains(it);
            collection.add(it.databaseDefinition(autoIncrement));
        }
        List definitions = CollectionsKt.filterNotNull((Iterable)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)((List)destination$iv$iv), (Object)this.createPrimaryKeyDefinition()), (Iterable)this.createForeignKeyDefinitions()));
        return "CREATE TABLE IF NOT EXISTS `" + tableName + "` (" + CollectionsKt.joinToString$default((Iterable)definitions, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + ")";
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> createForeignKeyDefinitions() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.foreignKeys;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ForeignKey foreignKey = (ForeignKey)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.databaseDefinition());
        }
        return (List)destination$iv$iv;
    }

    private final String createPrimaryKeyDefinition() {
        String string;
        if (this.primaryKey.getProperties().isEmpty() || this.primaryKey.getAutoGenerateId()) {
            string = null;
        } else {
            String keys = CollectionsKt.joinToString$default((Iterable)HasPropertiesKt.getColumnNames(this.primaryKey), (CharSequence)", ", null, null, (int)0, null, Entity::createPrimaryKeyDefinition$lambda$3, (int)30, null);
            string = "PRIMARY KEY(" + keys + ")";
        }
        return string;
    }

    public final boolean shouldBeDeletedAfter(@NotNull Entity other) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            Iterable $this$any$iv = this.foreignKeys;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ForeignKey it = (ForeignKey)element$iv;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)it.getParentTable(), (Object)other.getTableName()) && (!it.getDeferred() && it.getOnDelete() == ForeignKeyAction.NO_ACTION || it.getOnDelete() == ForeignKeyAction.RESTRICT))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public BaseEntityBundle toBundle() {
        Collection<ForeignKeyBundle> collection;
        Collection<IndexBundle> collection2;
        HasSchemaIdentity it;
        Collection<FieldBundle> collection3;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterable iterable = this.getProperties();
        String string = this.createTableQuery("${TABLE_NAME}");
        String string2 = this.getTableName();
        boolean $i$f$map = false;
        void var3_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Property property = (Property)item$iv$iv;
            collection3 = destination$iv$iv;
            boolean bl = false;
            collection3.add(((Property)it).toBundle());
        }
        collection3 = (List)destination$iv$iv;
        $this$map$iv = this.indices;
        PrimaryKeyBundle primaryKeyBundle = this.primaryKey.toBundle();
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Index)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(((Index)it).toBundle());
        }
        collection2 = (List)destination$iv$iv;
        $this$map$iv = this.foreignKeys;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ForeignKey)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((ForeignKey)it).toBundle());
        }
        Collection<ForeignKeyBundle> collection4 = collection = (List)destination$iv$iv;
        Collection<IndexBundle> collection5 = collection2;
        PrimaryKeyBundle primaryKeyBundle2 = primaryKeyBundle;
        Collection<FieldBundle> collection6 = collection3;
        String string3 = string;
        String string4 = string2;
        return (BaseEntityBundle)new EntityBundle(string4, string3, collection6, primaryKeyBundle2, collection5, collection4);
    }

    public final boolean isUnique(@NotNull List<String> columns) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter(columns, (String)"columns");
            if (HasPropertiesKt.getColumnNames(this.primaryKey).size() == columns.size() && HasPropertiesKt.getColumnNames(this.primaryKey).containsAll((Collection)columns)) {
                bl = true;
            } else {
                Iterable $this$any$iv = this.indices;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Index index = (Index)element$iv;
                        boolean bl2 = false;
                        if (!(index.getUnique() && index.getProperties().size() == columns.size() && HasPropertiesKt.getColumnNames(index).containsAll((Collection)columns))) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
        }
        return bl;
    }

    private static final String createTableQuery_delegate$lambda$0(Entity this$0) {
        return this$0.createTableQuery(this$0.getTableName());
    }

    private static final CharSequence createPrimaryKeyDefinition$lambda$3(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "`" + it + "`";
    }
}

