/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.util;

import androidx.room.util.SchemaFileResolver;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.ServiceLoader;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Landroidx/room/util/SchemaFileResolver;", "", "readPath", "Ljava/io/InputStream;", "path", "Ljava/nio/file/Path;", "writePath", "Ljava/io/OutputStream;", "Companion", "room-compiler"})
public interface SchemaFileResolver {
    @NotNull
    public static final Companion Companion = androidx.room.util.SchemaFileResolver$Companion.$$INSTANCE;

    @Nullable
    public InputStream readPath(@NotNull Path var1) throws IOException;

    @NotNull
    public OutputStream writePath(@NotNull Path var1) throws IOException;

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\b\u0003*\u0001\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001b\u0010\u0004\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\r"}, d2={"Landroidx/room/util/SchemaFileResolver$Companion;", "", "<init>", "()V", "RESOLVER", "Landroidx/room/util/SchemaFileResolver;", "getRESOLVER", "()Landroidx/room/util/SchemaFileResolver;", "RESOLVER$delegate", "Lkotlin/Lazy;", "DEFAULT_RESOLVER", "androidx/room/util/SchemaFileResolver$Companion$DEFAULT_RESOLVER$1", "Landroidx/room/util/SchemaFileResolver$Companion$DEFAULT_RESOLVER$1;", "room-compiler"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final Lazy<SchemaFileResolver> RESOLVER$delegate;
        @NotNull
        private static final DEFAULT_RESOLVER.1 DEFAULT_RESOLVER;

        private Companion() {
        }

        @NotNull
        public final SchemaFileResolver getRESOLVER() {
            Lazy<SchemaFileResolver> lazy = RESOLVER$delegate;
            return (SchemaFileResolver)lazy.getValue();
        }

        private static final SchemaFileResolver RESOLVER_delegate$lambda$0() {
            ServiceLoader<SchemaFileResolver> serviceLoader = ServiceLoader.load(SchemaFileResolver.class);
            Intrinsics.checkNotNullExpressionValue(serviceLoader, (String)"load(...)");
            SchemaFileResolver schemaFileResolver = (SchemaFileResolver)CollectionsKt.firstOrNull((Iterable)serviceLoader);
            if (schemaFileResolver == null) {
                ServiceLoader<SchemaFileResolver> serviceLoader2 = ServiceLoader.load(SchemaFileResolver.class, SchemaFileResolver.class.getClassLoader());
                Intrinsics.checkNotNullExpressionValue(serviceLoader2, (String)"load(...)");
                schemaFileResolver = (SchemaFileResolver)CollectionsKt.firstOrNull((Iterable)serviceLoader2);
                if (schemaFileResolver == null) {
                    schemaFileResolver = DEFAULT_RESOLVER;
                }
            }
            return schemaFileResolver;
        }

        static {
            $$INSTANCE = new Companion();
            RESOLVER$delegate = LazyKt.lazy(Companion::RESOLVER_delegate$lambda$0);
            DEFAULT_RESOLVER = new SchemaFileResolver(){

                public InputStream readPath(Path path) {
                    InputStream inputStream;
                    Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    if (Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                        OpenOption[] openOptionArray = new OpenOption[]{};
                        InputStream inputStream2 = Files.newInputStream(path, Arrays.copyOf(openOptionArray, openOptionArray.length));
                        inputStream = inputStream2;
                        Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"newInputStream(...)");
                    } else {
                        inputStream = null;
                    }
                    return inputStream;
                }

                public OutputStream writePath(Path path) {
                    Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                    Path parent = path.getParent();
                    if (parent != null) {
                        LinkOption[] linkOptionArray = new LinkOption[]{};
                        if (!Files.exists(parent, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                            Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(parent, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
                        }
                    }
                    OpenOption[] openOptionArray = new OpenOption[]{};
                    OutputStream outputStream = Files.newOutputStream(path, Arrays.copyOf(openOptionArray, openOptionArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
                    return outputStream;
                }
            };
        }
    }
}

