/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.util;

import androidx.room.migration.bundle.BaseEntityBundle;
import androidx.room.migration.bundle.DatabaseBundle;
import androidx.room.migration.bundle.EntityBundle;
import androidx.room.migration.bundle.FieldBundle;
import androidx.room.migration.bundle.ForeignKeyBundle;
import androidx.room.migration.bundle.FtsEntityBundle;
import androidx.room.migration.bundle.IndexBundle;
import androidx.room.processor.ProcessorErrors;
import androidx.room.util.DiffException;
import androidx.room.util.SchemaDiffResult;
import androidx.room.vo.AutoMigration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0000\n\u0002\u0010%\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001BY\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\b\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\b\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0006\u0010\"\u001a\u00020#J\b\u0010$\u001a\u00020%H\u0002J\u0012\u0010&\u001a\u0004\u0018\u00010\u00172\u0006\u0010'\u001a\u00020\u0017H\u0002J\"\u0010(\u001a\u0004\u0018\u00010\u00062\u0006\u0010'\u001a\u00020\u00172\u0006\u0010)\u001a\u00020\u00172\u0006\u0010*\u001a\u00020+H\u0002J\u0018\u0010,\u001a\u00020-2\u0006\u0010'\u001a\u00020\u00172\u0006\u0010)\u001a\u00020\u0017H\u0002J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u0006H\u0002J$\u00101\u001a\u00020-2\f\u00102\u001a\b\u0012\u0004\u0012\u0002030\b2\f\u00104\u001a\b\u0012\u0004\u0012\u0002030\bH\u0002J$\u00105\u001a\u00020-2\f\u00102\u001a\b\u0012\u0004\u0012\u0002060\b2\f\u00104\u001a\b\u0012\u0004\u0012\u0002060\bH\u0002J\u0012\u00107\u001a\u0004\u0018\u00010\r2\u0006\u00108\u001a\u00020\u0006H\u0002J\u001a\u00109\u001a\u0004\u0018\u00010\t2\u0006\u0010:\u001a\u00020\u00062\u0006\u00108\u001a\u00020\u0006H\u0002J*\u0010;\u001a\u00020%2\u0006\u0010)\u001a\u00020\u00172\u0018\u0010<\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\b0\u0015H\u0002J\b\u0010=\u001a\u00020%H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001c0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Landroidx/room/util/SchemaDiffer;", "", "fromSchemaBundle", "Landroidx/room/migration/bundle/DatabaseBundle;", "toSchemaBundle", "className", "", "renameColumnEntries", "", "Landroidx/room/vo/AutoMigration$RenamedColumn;", "deleteColumnEntries", "Landroidx/room/vo/AutoMigration$DeletedColumn;", "renameTableEntries", "Landroidx/room/vo/AutoMigration$RenamedTable;", "deleteTableEntries", "Landroidx/room/vo/AutoMigration$DeletedTable;", "<init>", "(Landroidx/room/migration/bundle/DatabaseBundle;Landroidx/room/migration/bundle/DatabaseBundle;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "potentiallyDeletedTables", "", "contentTableToFtsEntities", "", "", "Landroidx/room/migration/bundle/BaseEntityBundle;", "addedTables", "Landroidx/room/vo/AutoMigration$AddedTable;", "renamedTables", "complexChangedTables", "Landroidx/room/vo/AutoMigration$ComplexChangedTable;", "deletedTables", "", "addedColumns", "Landroidx/room/vo/AutoMigration$AddedColumn;", "deletedColumns", "diffSchemas", "Landroidx/room/util/SchemaDiffResult;", "processContentTables", "", "detectTableLevelChanges", "fromTable", "detectColumnLevelChanges", "toTable", "fromColumn", "Landroidx/room/migration/bundle/FieldBundle;", "tableContainsComplexChanges", "", "diffError", "", "errorMsg", "isForeignKeyBundlesListEqual", "fromBundle", "Landroidx/room/migration/bundle/ForeignKeyBundle;", "toBundle", "isIndexBundlesListEqual", "Landroidx/room/migration/bundle/IndexBundle;", "isTableRenamed", "tableName", "isColumnRenamed", "columnName", "processAddedTableAndColumns", "processedTablesAndColumnsInNewVersion", "processDeletedColumns", "room-compiler"})
@SourceDebugExtension(value={"SMAP\nSchemaDiffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SchemaDiffer.kt\nandroidx/room/util/SchemaDiffer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,562:1\n1557#2:563\n1628#2,3:564\n1863#2:567\n1611#2,9:575\n1863#2:584\n1864#2:586\n1620#2:587\n1864#2:588\n1863#2,2:591\n1863#2:593\n774#2:594\n865#2,2:595\n1863#2,2:597\n1864#2:599\n1755#2,3:600\n1755#2,2:603\n1755#2,3:605\n1757#2:608\n1485#2:609\n1510#2,3:610\n1513#2,3:620\n1863#2,2:623\n1485#2:625\n1510#2,3:626\n1513#2,3:636\n1863#2,2:639\n774#2:641\n865#2,2:642\n774#2:644\n865#2,2:645\n295#2,2:647\n1863#2,2:656\n827#2:658\n855#2,2:659\n1863#2,2:661\n381#3,7:568\n381#3,7:613\n381#3,7:629\n487#3,7:649\n1#4:585\n216#5,2:589\n*S KotlinDebug\n*F\n+ 1 SchemaDiffer.kt\nandroidx/room/util/SchemaDiffer\n*L\n90#1:563\n90#1:564,3\n108#1:567\n124#1:575,9\n124#1:584\n124#1:586\n124#1:587\n108#1:588\n138#1:591,2\n162#1:593\n164#1:594\n164#1:595,2\n165#1:597,2\n162#1:599\n323#1:600,3\n373#1:603,2\n374#1:605,3\n373#1:608\n405#1:609\n405#1:610,3\n405#1:620,3\n407#1:623,2\n435#1:625\n435#1:626,3\n435#1:636,3\n437#1:639,2\n457#1:641\n457#1:642,2\n481#1:644\n481#1:645,2\n504#1:647,2\n523#1:656,2\n545#1:658\n545#1:659,2\n546#1:661,2\n118#1:568,7\n405#1:613,7\n435#1:629,7\n520#1:649,7\n124#1:585\n134#1:589,2\n*E\n"})
public final class SchemaDiffer {
    @NotNull
    private final DatabaseBundle fromSchemaBundle;
    @NotNull
    private final DatabaseBundle toSchemaBundle;
    @Nullable
    private final String className;
    @NotNull
    private final List<AutoMigration.RenamedColumn> renameColumnEntries;
    @NotNull
    private final List<AutoMigration.DeletedColumn> deleteColumnEntries;
    @NotNull
    private final List<AutoMigration.RenamedTable> renameTableEntries;
    @NotNull
    private final List<AutoMigration.DeletedTable> deleteTableEntries;
    @NotNull
    private final Set<String> potentiallyDeletedTables;
    @NotNull
    private final Map<String, List<BaseEntityBundle>> contentTableToFtsEntities;
    @NotNull
    private final Set<AutoMigration.AddedTable> addedTables;
    @NotNull
    private final Map<String, String> renamedTables;
    @NotNull
    private final Map<String, AutoMigration.ComplexChangedTable> complexChangedTables;
    @NotNull
    private final Set<String> deletedTables;
    @NotNull
    private final List<AutoMigration.AddedColumn> addedColumns;
    @NotNull
    private final List<AutoMigration.DeletedColumn> deletedColumns;

    /*
     * WARNING - void declaration
     */
    public SchemaDiffer(@NotNull DatabaseBundle fromSchemaBundle, @NotNull DatabaseBundle toSchemaBundle, @Nullable String className, @NotNull List<AutoMigration.RenamedColumn> renameColumnEntries, @NotNull List<AutoMigration.DeletedColumn> deleteColumnEntries, @NotNull List<AutoMigration.RenamedTable> renameTableEntries, @NotNull List<AutoMigration.DeletedTable> deleteTableEntries) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)fromSchemaBundle, (String)"fromSchemaBundle");
        Intrinsics.checkNotNullParameter((Object)toSchemaBundle, (String)"toSchemaBundle");
        Intrinsics.checkNotNullParameter(renameColumnEntries, (String)"renameColumnEntries");
        Intrinsics.checkNotNullParameter(deleteColumnEntries, (String)"deleteColumnEntries");
        Intrinsics.checkNotNullParameter(renameTableEntries, (String)"renameTableEntries");
        Intrinsics.checkNotNullParameter(deleteTableEntries, (String)"deleteTableEntries");
        this.fromSchemaBundle = fromSchemaBundle;
        this.toSchemaBundle = toSchemaBundle;
        this.className = className;
        this.renameColumnEntries = renameColumnEntries;
        this.deleteColumnEntries = deleteColumnEntries;
        this.renameTableEntries = renameTableEntries;
        this.deleteTableEntries = deleteTableEntries;
        this.potentiallyDeletedTables = new LinkedHashSet();
        this.contentTableToFtsEntities = new LinkedHashMap();
        this.addedTables = new LinkedHashSet();
        this.renamedTables = new LinkedHashMap();
        this.complexChangedTables = new LinkedHashMap();
        Iterable iterable = this.deleteTableEntries;
        SchemaDiffer schemaDiffer = this;
        boolean $i$f$map = false;
        void var10_11 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AutoMigration.DeletedTable deletedTable = (AutoMigration.DeletedTable)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getDeletedTableName());
        }
        schemaDiffer.deletedTables = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        this.addedColumns = new ArrayList();
        this.deletedColumns = this.deleteColumnEntries;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SchemaDiffResult diffSchemas() {
        Object element$iv;
        Map processedTablesAndColumnsInNewVersion = new LinkedHashMap();
        Object $this$forEach$iv = this.fromSchemaBundle.getEntitiesByTableName().values();
        boolean $i$f$forEach = false;
        Iterator<Object> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            void $this$mapNotNullTo$iv$iv;
            Iterable answer$iv;
            element$iv = iterator.next();
            BaseEntityBundle fromTable = (BaseEntityBundle)element$iv;
            boolean bl = false;
            BaseEntityBundle toTable = this.detectTableLevelChanges(fromTable);
            if (toTable == null) continue;
            if (fromTable instanceof FtsEntityBundle && ((CharSequence)((FtsEntityBundle)fromTable).getFtsOptions().getContentTable()).length() > 0) {
                Object object;
                void $this$getOrPut$iv;
                Map<String, List<BaseEntityBundle>> map = this.contentTableToFtsEntities;
                String key$iv = ((FtsEntityBundle)fromTable).getFtsOptions().getContentTable();
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl2 = false;
                    answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((List)object).add(fromTable);
            }
            Map fromColumns = fromTable.getFieldsByColumnName();
            Iterable $this$mapNotNull$iv = fromColumns.values();
            boolean $i$f$mapNotNull = false;
            answer$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl3 = false;
                FieldBundle fromColumn = (FieldBundle)element$iv$iv;
                boolean bl4 = false;
                if (this.detectColumnLevelChanges(fromTable, toTable, fromColumn) == null) continue;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List processedColumnsInNewVersion = (List)destination$iv$iv;
            processedTablesAndColumnsInNewVersion.put(toTable.getTableName(), processedColumnsInNewVersion);
        }
        $this$forEach$iv = this.toSchemaBundle.getEntitiesByTableName();
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Object toTable = element$iv = (Map.Entry)iterator.next();
            boolean bl = false;
            this.processAddedTableAndColumns((BaseEntityBundle)toTable.getValue(), processedTablesAndColumnsInNewVersion);
        }
        $this$forEach$iv = this.potentiallyDeletedTables;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.iterator();
        if (iterator.hasNext()) {
            element$iv = iterator.next();
            String tableName = (String)element$iv;
            boolean bl = false;
            this.diffError(ProcessorErrors.INSTANCE.deletedOrRenamedTableFound(this.className, tableName));
            throw new KotlinNothingValueException();
        }
        this.processDeletedColumns();
        this.processContentTables();
        return new SchemaDiffResult(this.addedColumns, this.deletedColumns, this.addedTables, this.renamedTables, this.complexChangedTables, CollectionsKt.toList((Iterable)this.deletedTables), this.fromSchemaBundle.getViews(), this.toSchemaBundle.getViews());
    }

    /*
     * WARNING - void declaration
     */
    private final void processContentTables() {
        Iterable $this$forEach$iv = this.renameTableEntries;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$forEach$iv2;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            AutoMigration.RenamedTable renamedTable = (AutoMigration.RenamedTable)element$iv;
            boolean bl = false;
            List<BaseEntityBundle> list = this.contentTableToFtsEntities.get(renamedTable.getOriginalTableName());
            if (list == null) continue;
            Iterable iterable = list;
            boolean $i$f$filter = false;
            Iterator iterator = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                BaseEntityBundle it = (BaseEntityBundle)element$iv$iv;
                boolean bl2 = false;
                if (!(!this.complexChangedTables.containsKey(it.getTableName()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                BaseEntityBundle ftsTable = (BaseEntityBundle)element$iv2;
                boolean bl3 = false;
                this.complexChangedTables.put(ftsTable.getTableName(), new AutoMigration.ComplexChangedTable(ftsTable.getTableName(), ftsTable.getNewTableName(), ftsTable, ftsTable, new LinkedHashMap()));
            }
        }
    }

    private final BaseEntityBundle detectTableLevelChanges(BaseEntityBundle fromTable) {
        AutoMigration.RenamedTable renamedTable = this.isTableRenamed(fromTable.getTableName());
        if (renamedTable != null) {
            BaseEntityBundle toTable = (BaseEntityBundle)this.toSchemaBundle.getEntitiesByTableName().get(renamedTable.getNewTableName());
            if (toTable != null) {
                boolean isComplexChangedTable = this.tableContainsComplexChanges(fromTable, toTable);
                boolean isFtsEntity = fromTable instanceof FtsEntityBundle;
                if (isComplexChangedTable || isFtsEntity) {
                    if (this.toSchemaBundle.getEntitiesByTableName().containsKey(toTable.getNewTableName())) {
                        this.diffError(ProcessorErrors.INSTANCE.tableWithConflictingPrefixFound(toTable.getNewTableName()));
                        throw new KotlinNothingValueException();
                    }
                    this.renamedTables.remove(renamedTable.getOriginalTableName());
                    this.complexChangedTables.put(renamedTable.getOriginalTableName(), new AutoMigration.ComplexChangedTable(toTable.getTableName(), toTable.getNewTableName(), fromTable, toTable, new LinkedHashMap()));
                } else {
                    this.renamedTables.put(fromTable.getTableName(), toTable.getTableName());
                }
            } else {
                String string = this.className;
                Intrinsics.checkNotNull((Object)string);
                this.diffError(ProcessorErrors.INSTANCE.tableRenameError(string, renamedTable.getOriginalTableName(), renamedTable.getNewTableName()));
                throw new KotlinNothingValueException();
            }
            return toTable;
        }
        BaseEntityBundle toTable = (BaseEntityBundle)this.toSchemaBundle.getEntitiesByTableName().get(fromTable.getTableName());
        boolean isDeletedTable = this.deletedTables.contains(fromTable.getTableName());
        if (toTable != null) {
            if (isDeletedTable) {
                this.diffError(ProcessorErrors.INSTANCE.deletedOrRenamedTableFound(this.className, toTable.getTableName()));
                throw new KotlinNothingValueException();
            }
            boolean isComplexChangedTable = this.tableContainsComplexChanges(fromTable, toTable);
            if (isComplexChangedTable) {
                this.complexChangedTables.put(fromTable.getTableName(), new AutoMigration.ComplexChangedTable(toTable.getTableName(), toTable.getNewTableName(), fromTable, toTable, new LinkedHashMap()));
            }
            return toTable;
        }
        if (!isDeletedTable) {
            this.potentiallyDeletedTables.add(fromTable.getTableName());
        }
        return null;
    }

    private final String detectColumnLevelChanges(BaseEntityBundle fromTable, BaseEntityBundle toTable, FieldBundle fromColumn) {
        boolean isColumnDeleted;
        block10: {
            AutoMigration.RenamedColumn renamedToColumn = this.isColumnRenamed(fromColumn.getColumnName(), fromTable.getTableName());
            if (renamedToColumn != null) {
                if (this.toSchemaBundle.getEntitiesByTableName().containsKey(toTable.getNewTableName())) {
                    this.diffError(ProcessorErrors.INSTANCE.tableWithConflictingPrefixFound(toTable.getNewTableName()));
                    throw new KotlinNothingValueException();
                }
                this.renamedTables.remove(fromTable.getTableName());
                Object object = this.complexChangedTables.get(fromTable.getTableName());
                if (object == null || (object = ((AutoMigration.ComplexChangedTable)object).getRenamedColumnsMap()) == null) {
                    object = new LinkedHashMap();
                }
                Object renamedColumnsMap = object;
                renamedColumnsMap.put(renamedToColumn.getNewColumnName(), fromColumn.getColumnName());
                this.complexChangedTables.put(fromTable.getTableName(), new AutoMigration.ComplexChangedTable(fromTable.getTableName(), toTable.getNewTableName(), fromTable, toTable, (Map<String, String>)renamedColumnsMap));
                return renamedToColumn.getNewColumnName();
            }
            FieldBundle match = (FieldBundle)toTable.getFieldsByColumnName().get(fromColumn.getColumnName());
            if (match != null) {
                boolean columnChanged;
                boolean bl = columnChanged = !match.isSchemaEqual(fromColumn);
                if (columnChanged && !this.complexChangedTables.containsKey(fromTable.getTableName())) {
                    if (this.toSchemaBundle.getEntitiesByTableName().containsKey(toTable.getNewTableName())) {
                        this.diffError(ProcessorErrors.INSTANCE.tableWithConflictingPrefixFound(toTable.getNewTableName()));
                        throw new KotlinNothingValueException();
                    }
                    this.renamedTables.remove(fromTable.getTableName());
                    this.complexChangedTables.put(fromTable.getTableName(), new AutoMigration.ComplexChangedTable(fromTable.getTableName(), toTable.getNewTableName(), fromTable, toTable, new LinkedHashMap()));
                }
                return match.getColumnName();
            }
            Iterable $this$any$iv = this.deletedColumns;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v2 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    AutoMigration.DeletedColumn it = (AutoMigration.DeletedColumn)element$iv;
                    boolean bl = false;
                    if (!(Intrinsics.areEqual((Object)it.getTableName(), (Object)fromTable.getTableName()) && Intrinsics.areEqual((Object)it.getColumnName(), (Object)fromColumn.getColumnName()))) continue;
                    v2 = true;
                    break block10;
                }
                v2 = isColumnDeleted = false;
            }
        }
        if (!isColumnDeleted) {
            ProcessorErrors processorErrors = ProcessorErrors.INSTANCE;
            String string = this.className;
            String string2 = fromTable.getTableName();
            String string3 = fromColumn.getColumnName();
            this.diffError(processorErrors.deletedOrRenamedColumnFound(string, string3, string2));
            throw new KotlinNothingValueException();
        }
        return null;
    }

    private final boolean tableContainsComplexChanges(BaseEntityBundle fromTable, BaseEntityBundle toTable) {
        if (!fromTable.getPrimaryKey().isSchemaEqual(toTable.getPrimaryKey())) {
            return true;
        }
        if (fromTable instanceof FtsEntityBundle && toTable instanceof FtsEntityBundle) {
            return !((FtsEntityBundle)fromTable).isSchemaEqual((FtsEntityBundle)toTable);
        }
        if (fromTable instanceof EntityBundle && toTable instanceof EntityBundle) {
            boolean bl;
            block12: {
                if (!this.isForeignKeyBundlesListEqual(((EntityBundle)fromTable).getForeignKeys(), ((EntityBundle)toTable).getForeignKeys())) {
                    return true;
                }
                if (!this.isIndexBundlesListEqual(((EntityBundle)fromTable).getIndices(), ((EntityBundle)toTable).getIndices())) {
                    return true;
                }
                Iterable $this$any$iv = ((EntityBundle)fromTable).getForeignKeys();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        boolean bl2;
                        block11: {
                            ForeignKeyBundle foreignKey = (ForeignKeyBundle)element$iv;
                            boolean bl3 = false;
                            Iterable $this$any$iv2 = this.renameTableEntries;
                            boolean $i$f$any2 = false;
                            if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                bl2 = false;
                            } else {
                                for (Object element$iv2 : $this$any$iv2) {
                                    AutoMigration.RenamedTable it = (AutoMigration.RenamedTable)element$iv2;
                                    boolean bl4 = false;
                                    if (!Intrinsics.areEqual((Object)it.getOriginalTableName(), (Object)foreignKey.getTable())) continue;
                                    bl2 = true;
                                    break block11;
                                }
                                bl2 = false;
                            }
                        }
                        if (!bl2) continue;
                        bl = true;
                        break block12;
                    }
                    bl = false;
                }
            }
            return bl;
        }
        return true;
    }

    private final Void diffError(String errorMsg) {
        throw new DiffException(errorMsg);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isForeignKeyBundlesListEqual(List<ForeignKeyBundle> fromBundle, List<ForeignKeyBundle> toBundle) {
        void $this$groupByTo$iv$iv;
        List set = CollectionsKt.plus((Collection)fromBundle, (Iterable)toBundle);
        Iterable $this$groupBy$iv = set;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            ForeignKeyBundle it = (ForeignKeyBundle)element$iv$iv;
            boolean bl = false;
            List key$iv$iv = it.getColumns();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Set matches = destination$iv$iv.entrySet();
        Iterable $this$forEach$iv = matches;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ForeignKeyBundle toForeignKeyBundle;
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            List bundles = (List)entry.getValue();
            if (bundles.size() < 2) {
                return false;
            }
            ForeignKeyBundle fromForeignKeyBundle = (ForeignKeyBundle)bundles.get(0);
            if (fromForeignKeyBundle.isSchemaEqual(toForeignKeyBundle = (ForeignKeyBundle)bundles.get(1))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isIndexBundlesListEqual(List<IndexBundle> fromBundle, List<IndexBundle> toBundle) {
        void $this$groupByTo$iv$iv;
        List set = CollectionsKt.plus((Collection)fromBundle, (Iterable)toBundle);
        Iterable $this$groupBy$iv = set;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            IndexBundle it = (IndexBundle)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getName();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Set matches = destination$iv$iv.entrySet();
        Iterable $this$forEach$iv = matches;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry bundlesWithSameName = (Map.Entry)element$iv;
            boolean bl = false;
            if (((List)bundlesWithSameName.getValue()).size() < 2) {
                return false;
            }
            if (((IndexBundle)((List)bundlesWithSameName.getValue()).get(0)).isSchemaEqual((IndexBundle)((List)bundlesWithSameName.getValue()).get(1))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final AutoMigration.RenamedTable isTableRenamed(String tableName) {
        void $this$filterTo$iv$iv;
        List<AutoMigration.RenamedTable> annotations = this.renameTableEntries;
        Iterable $this$filter$iv = annotations;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            AutoMigration.RenamedTable it = (AutoMigration.RenamedTable)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getOriginalTableName(), (Object)tableName)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List renamedTableAnnotations = (List)destination$iv$iv;
        if (renamedTableAnnotations.size() > 1) {
            this.diffError(ProcessorErrors.INSTANCE.conflictingRenameTableAnnotationsFound(CollectionsKt.joinToString$default((Iterable)renamedTableAnnotations, (CharSequence)",", null, null, (int)0, null, null, (int)62, null)));
            throw new KotlinNothingValueException();
        }
        return (AutoMigration.RenamedTable)CollectionsKt.firstOrNull((List)renamedTableAnnotations);
    }

    /*
     * WARNING - void declaration
     */
    private final AutoMigration.RenamedColumn isColumnRenamed(String columnName, String tableName) {
        void $this$filterTo$iv$iv;
        List<AutoMigration.RenamedColumn> annotations = this.renameColumnEntries;
        Iterable $this$filter$iv = annotations;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            AutoMigration.RenamedColumn it = (AutoMigration.RenamedColumn)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it.getOriginalColumnName(), (Object)columnName) && Intrinsics.areEqual((Object)it.getTableName(), (Object)tableName))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List renamedColumnAnnotations = (List)destination$iv$iv;
        if (renamedColumnAnnotations.size() > 1) {
            this.diffError(ProcessorErrors.INSTANCE.conflictingRenameColumnAnnotationsFound(CollectionsKt.joinToString$default((Iterable)renamedColumnAnnotations, (CharSequence)",", null, null, (int)0, null, null, (int)62, null)));
            throw new KotlinNothingValueException();
        }
        return (AutoMigration.RenamedColumn)CollectionsKt.firstOrNull((List)renamedColumnAnnotations);
    }

    private final void processAddedTableAndColumns(BaseEntityBundle toTable, Map<String, List<String>> processedTablesAndColumnsInNewVersion) {
        Map map;
        BaseEntityBundle fromTable;
        Object v0;
        block7: {
            Iterable $this$firstOrNull$iv = this.renameTableEntries;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                AutoMigration.RenamedTable it = (AutoMigration.RenamedTable)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getNewTableName(), (Object)toTable.getTableName())) continue;
                v0 = element$iv;
                break block7;
            }
            v0 = null;
        }
        AutoMigration.RenamedTable isRenamed = v0;
        BaseEntityBundle baseEntityBundle = fromTable = isRenamed != null ? (BaseEntityBundle)this.fromSchemaBundle.getEntitiesByTableName().get(isRenamed.getOriginalTableName()) : (BaseEntityBundle)this.fromSchemaBundle.getEntitiesByTableName().get(toTable.getTableName());
        if (fromTable == null) {
            this.addedTables.add(new AutoMigration.AddedTable(toTable));
            return;
        }
        Map fromColumns = fromTable.getFieldsByColumnName();
        List<String> list = processedTablesAndColumnsInNewVersion.get(toTable.getTableName());
        if (list != null) {
            List<String> processedColumns = list;
            boolean bl = false;
            Map $this$filterKeys$iv = toTable.getFieldsByColumnName();
            boolean $i$f$filterKeys = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
                String it = (String)entry$iv.getKey();
                boolean bl2 = false;
                if (!(!processedColumns.contains(it))) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            map = result$iv;
        } else {
            map = toTable.getFieldsByColumnName();
        }
        Map toColumns = map;
        Iterable $this$forEach$iv = toColumns.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FieldBundle toColumn = (FieldBundle)element$iv;
            boolean bl = false;
            FieldBundle match = (FieldBundle)fromColumns.get(toColumn.getColumnName());
            if (match != null) continue;
            if (toColumn.isNonNull() && toColumn.getDefaultValue() == null) {
                this.diffError(ProcessorErrors.INSTANCE.newNotNullColumnMustHaveDefaultValue(toColumn.getColumnName()));
                throw new KotlinNothingValueException();
            }
            if (this.complexChangedTables.containsKey(fromTable.getTableName())) continue;
            this.addedColumns.add(new AutoMigration.AddedColumn(toTable.getTableName(), toColumn));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void processDeletedColumns() {
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv = this.deletedColumns;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            AutoMigration.DeletedColumn it = (AutoMigration.DeletedColumn)element$iv$iv;
            boolean bl = false;
            if (this.complexChangedTables.containsKey(it.getTableName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AutoMigration.DeletedColumn deletedColumn = (AutoMigration.DeletedColumn)element$iv;
            boolean bl = false;
            BaseEntityBundle fromTableBundle = (BaseEntityBundle)MapsKt.getValue((Map)this.fromSchemaBundle.getEntitiesByTableName(), (Object)deletedColumn.getTableName());
            BaseEntityBundle toTableBundle = (BaseEntityBundle)MapsKt.getValue((Map)this.toSchemaBundle.getEntitiesByTableName(), (Object)deletedColumn.getTableName());
            this.complexChangedTables.put(deletedColumn.getTableName(), new AutoMigration.ComplexChangedTable(deletedColumn.getTableName(), fromTableBundle.getNewTableName(), fromTableBundle, toTableBundle, new LinkedHashMap()));
        }
    }
}

