/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.solver.binderprovider;

import androidx.room.compiler.processing.XRawType;
import androidx.room.compiler.processing.XType;
import androidx.room.ext.PagingTypeNames;
import androidx.room.parser.ParsedQuery;
import androidx.room.parser.Table;
import androidx.room.processor.Context;
import androidx.room.solver.QueryResultBinderProvider;
import androidx.room.solver.TypeAdapterExtras;
import androidx.room.solver.TypeAdapterStore;
import androidx.room.solver.query.result.ListQueryResultAdapter;
import androidx.room.solver.query.result.PositionalDataSourceQueryResultBinder;
import androidx.room.solver.query.result.QueryResultAdapter;
import androidx.room.solver.query.result.QueryResultBinder;
import androidx.room.solver.query.result.RowAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001d\u0010\b\u001a\u0004\u0018\u00010\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\u000e\u001a\u0004\u0018\u00010\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\r\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006\u001b"}, d2={"Landroidx/room/solver/binderprovider/DataSourceQueryResultBinderProvider;", "Landroidx/room/solver/QueryResultBinderProvider;", "context", "Landroidx/room/processor/Context;", "<init>", "(Landroidx/room/processor/Context;)V", "getContext", "()Landroidx/room/processor/Context;", "dataSourceType", "Landroidx/room/compiler/processing/XRawType;", "getDataSourceType", "()Landroidx/room/compiler/processing/XRawType;", "dataSourceType$delegate", "Lkotlin/Lazy;", "positionalDataSourceType", "getPositionalDataSourceType", "positionalDataSourceType$delegate", "provide", "Landroidx/room/solver/query/result/QueryResultBinder;", "declared", "Landroidx/room/compiler/processing/XType;", "query", "Landroidx/room/parser/ParsedQuery;", "extras", "Landroidx/room/solver/TypeAdapterExtras;", "matches", "", "room-compiler"})
@SourceDebugExtension(value={"SMAP\nDataSourceQueryResultBinderProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataSourceQueryResultBinderProvider.kt\nandroidx/room/solver/binderprovider/DataSourceQueryResultBinderProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n1557#2:83\n1628#2,3:84\n*S KotlinDebug\n*F\n+ 1 DataSourceQueryResultBinderProvider.kt\nandroidx/room/solver/binderprovider/DataSourceQueryResultBinderProvider\n*L\n56#1:83\n56#1:84,3\n*E\n"})
public final class DataSourceQueryResultBinderProvider
implements QueryResultBinderProvider {
    @NotNull
    private final Context context;
    @NotNull
    private final Lazy dataSourceType$delegate;
    @NotNull
    private final Lazy positionalDataSourceType$delegate;

    public DataSourceQueryResultBinderProvider(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.dataSourceType$delegate = LazyKt.lazy(() -> DataSourceQueryResultBinderProvider.dataSourceType_delegate$lambda$0(this));
        this.positionalDataSourceType$delegate = LazyKt.lazy(() -> DataSourceQueryResultBinderProvider.positionalDataSourceType_delegate$lambda$1(this));
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    private final XRawType getDataSourceType() {
        Lazy lazy = this.dataSourceType$delegate;
        return (XRawType)lazy.getValue();
    }

    private final XRawType getPositionalDataSourceType() {
        Lazy lazy = this.positionalDataSourceType$delegate;
        return (XRawType)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public QueryResultBinder provide(@NotNull XType declared, @NotNull ParsedQuery query, @NotNull TypeAdapterExtras extras) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        ListQueryResultAdapter listAdapter;
        Object object;
        ListQueryResultAdapter listQueryResultAdapter;
        Intrinsics.checkNotNullParameter((Object)declared, (String)"declared");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)extras, (String)"extras");
        if (query.getTables().isEmpty()) {
            this.context.getLogger().e("Observable query return type (LiveData, Flowable, DataSource, DataSourceFactory etc) can only be used with SELECT queries that directly or indirectly (via @Relation, for example) access at least one table. For @RawQuery, you should specify the list of tables to be observed via the observedEntities property.", new Object[0]);
        }
        XType typeArg = (XType)CollectionsKt.last((List)declared.getTypeArguments());
        RowAdapter rowAdapter = TypeAdapterStore.findRowAdapter$default(this.context.getTypeAdapterStore(), typeArg, query, null, 4, null);
        if (rowAdapter != null) {
            RowAdapter it = rowAdapter;
            boolean bl = false;
            listQueryResultAdapter = new ListQueryResultAdapter(typeArg, it);
        } else {
            listQueryResultAdapter = null;
        }
        if ((object = (listAdapter = listQueryResultAdapter)) == null || (object = ((QueryResultAdapter)object).accessedTableNames()) == null) {
            object = CollectionsKt.emptyList();
        }
        Iterable iterable = query.getTables();
        Collection collection = (Collection)object;
        boolean $i$f$map = false;
        void bl = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Table table = (Table)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl2 = false;
            collection2.add(it.getName());
        }
        Set tableNames = CollectionsKt.toSet((Iterable)CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv)));
        return new PositionalDataSourceQueryResultBinder(listAdapter, tableNames);
    }

    @Override
    public boolean matches(@NotNull XType declared) {
        Intrinsics.checkNotNullParameter((Object)declared, (String)"declared");
        if (this.getDataSourceType() == null || this.getPositionalDataSourceType() == null) {
            return false;
        }
        if (declared.getTypeArguments().isEmpty()) {
            return false;
        }
        XRawType xRawType = this.getDataSourceType();
        Intrinsics.checkNotNull((Object)xRawType);
        boolean isDataSource = xRawType.isAssignableFrom(declared);
        if (!isDataSource) {
            return false;
        }
        XRawType xRawType2 = this.getPositionalDataSourceType();
        Intrinsics.checkNotNull((Object)xRawType2);
        boolean isPositional = xRawType2.isAssignableFrom(declared);
        if (!isPositional) {
            this.context.getLogger().e("For now, Room only supports PositionalDataSource class.", new Object[0]);
        }
        return true;
    }

    private static final XRawType dataSourceType_delegate$lambda$0(DataSourceQueryResultBinderProvider this$0) {
        XType xType = this$0.context.getProcessingEnv().findType(PagingTypeNames.INSTANCE.getDATA_SOURCE().getCanonicalName());
        return xType != null ? xType.getRawType() : null;
    }

    private static final XRawType positionalDataSourceType_delegate$lambda$1(DataSourceQueryResultBinderProvider this$0) {
        XType xType = this$0.context.getProcessingEnv().findType(PagingTypeNames.INSTANCE.getPOSITIONAL_DATA_SOURCE().getCanonicalName());
        return xType != null ? xType.getRawType() : null;
    }
}

