/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.processor;

import androidx.room.Upsert;
import androidx.room.compiler.processing.XAnnotation;
import androidx.room.compiler.processing.XElement;
import androidx.room.compiler.processing.XMethodElement;
import androidx.room.compiler.processing.XType;
import androidx.room.preconditions.Checks;
import androidx.room.processor.Context;
import androidx.room.processor.ProcessorErrors;
import androidx.room.processor.ShortcutFunctionProcessor;
import androidx.room.solver.shortcut.binder.InsertOrUpsertFunctionBinder;
import androidx.room.vo.DataClass;
import androidx.room.vo.Entity;
import androidx.room.vo.HasPropertiesKt;
import androidx.room.vo.Property;
import androidx.room.vo.ShortcutEntity;
import androidx.room.vo.ShortcutQueryParameter;
import androidx.room.vo.UpsertFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0011\u001a\u00020\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0013"}, d2={"Landroidx/room/processor/UpsertFunctionProcessor;", "", "baseContext", "Landroidx/room/processor/Context;", "containing", "Landroidx/room/compiler/processing/XType;", "executableElement", "Landroidx/room/compiler/processing/XMethodElement;", "<init>", "(Landroidx/room/processor/Context;Landroidx/room/compiler/processing/XType;Landroidx/room/compiler/processing/XMethodElement;)V", "getContaining", "()Landroidx/room/compiler/processing/XType;", "getExecutableElement", "()Landroidx/room/compiler/processing/XMethodElement;", "context", "getContext", "()Landroidx/room/processor/Context;", "process", "Landroidx/room/vo/UpsertFunction;", "room-compiler"})
@SourceDebugExtension(value={"SMAP\nUpsertFunctionProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UpsertFunctionProcessor.kt\nandroidx/room/processor/UpsertFunctionProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,99:1\n1755#2,3:100\n774#2:103\n865#2,2:104\n1557#2:106\n1628#2,3:107\n*S KotlinDebug\n*F\n+ 1 UpsertFunctionProcessor.kt\nandroidx/room/processor/UpsertFunctionProcessor\n*L\n51#1:100,3\n66#1:103\n66#1:104,2\n76#1:106\n76#1:107,3\n*E\n"})
public final class UpsertFunctionProcessor {
    @NotNull
    private final XType containing;
    @NotNull
    private final XMethodElement executableElement;
    @NotNull
    private final Context context;

    public UpsertFunctionProcessor(@NotNull Context baseContext, @NotNull XType containing, @NotNull XMethodElement executableElement) {
        Intrinsics.checkNotNullParameter((Object)baseContext, (String)"baseContext");
        Intrinsics.checkNotNullParameter((Object)containing, (String)"containing");
        Intrinsics.checkNotNullParameter((Object)executableElement, (String)"executableElement");
        this.containing = containing;
        this.executableElement = executableElement;
        this.context = Context.fork$default(baseContext, (XElement)this.executableElement, null, null, 6, null);
    }

    @NotNull
    public final XType getContaining() {
        return this.containing;
    }

    @NotNull
    public final XMethodElement getExecutableElement() {
        return this.executableElement;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final UpsertFunction process() {
        ShortcutFunctionProcessor delegate = new ShortcutFunctionProcessor(this.context, this.containing, this.executableElement);
        XAnnotation annotation = delegate.extractAnnotation(Reflection.getOrCreateKotlinClass(Upsert.class), ProcessorErrors.INSTANCE.getMISSING_UPSERT_ANNOTATION());
        XType returnType = delegate.extractReturnType();
        this.context.getChecker().notUnbound(returnType, (XElement)this.executableElement, "Cannot use unbound generics in upsert functions. It must be bound to a type through base Dao class.", new Object[0]);
        XAnnotation xAnnotation = annotation;
        Pair<Map<String, ShortcutEntity>, List<ShortcutQueryParameter>> pair = delegate.extractParams(xAnnotation != null && (xAnnotation = xAnnotation.get("entity")) != null ? xAnnotation.asType() : null, "Function annotated with @Upsert but does not have any parameters to insert or update.", (Function2<? super Entity, ? super DataClass, Unit>)((Function2)(arg_0, arg_1) -> UpsertFunctionProcessor.process$lambda$3(this, arg_0, arg_1)));
        Map entities = (Map)pair.component1();
        List params = (List)pair.component2();
        InsertOrUpsertFunctionBinder functionBinder = delegate.findUpsertFunctionBinder(returnType, params);
        this.context.getChecker().check(functionBinder.getAdapter() != null, (XElement)this.executableElement, "Not sure how to handle upsert function's return type.", new Object[0]);
        XMethodElement xMethodElement = this.executableElement;
        return new UpsertFunction(xMethodElement, entities, returnType, params, functionBinder);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit process$lambda$3(UpsertFunctionProcessor this$0, Entity entity, DataClass pojo) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Property it;
        void $this$filterTo$iv$iv;
        Object element$iv2;
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Intrinsics.checkNotNullParameter((Object)pojo, (String)"pojo");
            Iterable $this$any$iv = entity.getPrimaryKey().getProperties();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv2 : $this$any$iv) {
                    Property it2 = (Property)element$iv2;
                    boolean bl2 = false;
                    if (!(HasPropertiesKt.findPropertyByColumnName(pojo, it2.getColumnName()) == null)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        boolean missingPrimaryKeys = bl;
        this$0.context.getChecker().check(entity.getPrimaryKey().getAutoGenerateId() || !missingPrimaryKeys, (XElement)this$0.executableElement, ProcessorErrors.INSTANCE.missingPrimaryKeysInPartialEntityForUpsert(pojo.getTypeName().toString(this$0.context.getCodeLanguage()), entity.getPrimaryKey().getProperties().getColumnNames$room_compiler()), new Object[0]);
        Iterable $this$filter$iv = CollectionsKt.minus((Iterable)entity.getProperties(), (Iterable)entity.getPrimaryKey().getProperties());
        boolean $i$f$filter = false;
        element$iv2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Property)element$iv$iv;
            boolean bl3 = false;
            if (!(it.getNonNull() && it.getDefaultValue() == null && HasPropertiesKt.findPropertyByColumnName(pojo, it.getColumnName()) == null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List missingRequiredFields = (List)destination$iv$iv;
        $this$filter$iv = missingRequiredFields;
        String string = pojo.getTypeName().toString(this$0.context.getCodeLanguage());
        ProcessorErrors processorErrors = ProcessorErrors.INSTANCE;
        XElement xElement = (XElement)this$0.executableElement;
        boolean bl4 = missingRequiredFields.isEmpty();
        Checks checks = this$0.context.getChecker();
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Property)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl5 = false;
            collection.add(it.getColumnName());
        }
        collection = (List)destination$iv$iv;
        checks.check(bl4, xElement, processorErrors.missingRequiredColumnsInPartialEntity(string, (List<String>)collection), new Object[0]);
        return Unit.INSTANCE;
    }
}

