/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.processor;

import androidx.room.Entity;
import androidx.room.PrimaryKey;
import androidx.room.compiler.processing.XAnnotation;
import androidx.room.compiler.processing.XAnnotationValue;
import androidx.room.compiler.processing.XElement;
import androidx.room.compiler.processing.XFieldElement;
import androidx.room.compiler.processing.XType;
import androidx.room.compiler.processing.XTypeElement;
import androidx.room.ext.Xtype_extKt;
import androidx.room.log.RLog;
import androidx.room.parser.SQLTypeAffinity;
import androidx.room.parser.SqlParser;
import androidx.room.preconditions.Checks;
import androidx.room.processor.Context;
import androidx.room.processor.DataClassProcessor;
import androidx.room.processor.EntityProcessor;
import androidx.room.processor.ForeignKeyInput;
import androidx.room.processor.IndexInput;
import androidx.room.processor.ProcessorErrors;
import androidx.room.processor.PropertyProcessor;
import androidx.room.processor.cache.Cache;
import androidx.room.vo.Constructor;
import androidx.room.vo.DataClass;
import androidx.room.vo.EmbeddedProperty;
import androidx.room.vo.ForeignKey;
import androidx.room.vo.ForeignKeyAction;
import androidx.room.vo.HasPropertiesKt;
import androidx.room.vo.Index;
import androidx.room.vo.Properties;
import androidx.room.vo.Property;
import androidx.room.vo.Warning;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B3\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0018\b\u0002\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0002J,\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0017H\u0002J$\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00172\u0006\u0010 \u001a\u00020!H\u0002J$\u0010\"\u001a\u00020\u001a2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u00172\f\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u0017H\u0002J\u001c\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00172\f\u0010(\u001a\b\u0012\u0004\u0012\u00020$0\u0017H\u0002J$\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00172\u0006\u0010*\u001a\u00020\u00052\f\u0010+\u001a\b\u0012\u0004\u0012\u00020$0\u0017H\u0002J\u001c\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00172\f\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u0017H\u0002J\u001e\u0010-\u001a\u00020\u001a2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00172\u0006\u0010*\u001a\u00020\u0005H\u0002J$\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00172\f\u00100\u001a\b\u0012\u0004\u0012\u0002010\u00172\u0006\u0010 \u001a\u00020!H\u0002J(\u00102\u001a\b\u0012\u0004\u0012\u0002010\u00172\b\u00103\u001a\u0004\u0018\u0001042\u0006\u00105\u001a\u00020\b2\u0006\u00106\u001a\u000207H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u00068"}, d2={"Landroidx/room/processor/TableEntityProcessor;", "Landroidx/room/processor/EntityProcessor;", "baseContext", "Landroidx/room/processor/Context;", "element", "Landroidx/room/compiler/processing/XTypeElement;", "referenceStack", "Ljava/util/LinkedHashSet;", "", "Lkotlin/collections/LinkedHashSet;", "<init>", "(Landroidx/room/processor/Context;Landroidx/room/compiler/processing/XTypeElement;Ljava/util/LinkedHashSet;)V", "getElement", "()Landroidx/room/compiler/processing/XTypeElement;", "context", "getContext", "()Landroidx/room/processor/Context;", "process", "Landroidx/room/vo/Entity;", "doProcess", "checkIndicesForForeignKeys", "", "entityForeignKeys", "", "Landroidx/room/vo/ForeignKey;", "primaryKey", "Landroidx/room/vo/PrimaryKey;", "indices", "Landroidx/room/vo/Index;", "validateAndCreateForeignKeyReferences", "foreignKeyInputs", "Landroidx/room/processor/ForeignKeyInput;", "dataClass", "Landroidx/room/vo/DataClass;", "findAndValidatePrimaryKey", "properties", "Landroidx/room/vo/Property;", "embeddedProperties", "Landroidx/room/vo/EmbeddedProperty;", "collectPrimaryKeysFromPrimaryKeyAnnotations", "fields", "collectPrimaryKeysFromEntityAnnotations", "typeElement", "availableProperties", "collectPrimaryKeysFromEmbeddedProperties", "choosePrimaryKey", "candidates", "validateAndCreateIndices", "inputs", "Landroidx/room/processor/IndexInput;", "loadSuperIndices", "typeMirror", "Landroidx/room/compiler/processing/XType;", "tableName", "inherit", "", "room-compiler"})
@SourceDebugExtension(value={"SMAP\nTableEntityProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TableEntityProcessor.kt\nandroidx/room/processor/TableEntityProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,624:1\n774#2:625\n865#2,2:626\n1611#2,9:628\n1863#2:637\n1864#2:639\n1620#2:640\n1863#2,2:641\n1863#2:643\n1557#2:644\n1628#2,3:645\n1755#2,3:648\n1864#2:651\n1557#2:652\n1628#2,2:653\n1611#2,9:655\n1863#2:664\n1864#2:666\n1620#2:667\n1630#2:668\n827#2:669\n855#2,2:670\n1863#2:672\n1863#2,2:673\n1864#2:675\n1611#2,9:676\n1863#2:685\n1864#2:687\n1620#2:688\n1611#2,9:689\n1863#2:698\n295#2,2:699\n1557#2:701\n1628#2,3:702\n1864#2:706\n1620#2:707\n827#2:708\n855#2,2:709\n1611#2,9:711\n1863#2:720\n1864#2:722\n1620#2:723\n774#2:724\n865#2,2:725\n1863#2,2:727\n1557#2:729\n1628#2,3:730\n1611#2,9:733\n1863#2:742\n1611#2,9:743\n1863#2:752\n1864#2:754\n1620#2:755\n1864#2:757\n1620#2:758\n1485#2:759\n1510#2,3:760\n1513#2,3:770\n1863#2,2:782\n1557#2:784\n1628#2,3:785\n1734#2,3:788\n1#3:638\n1#3:665\n1#3:686\n1#3:705\n1#3:721\n1#3:753\n1#3:756\n381#4,7:763\n535#4:773\n520#4,6:774\n216#5,2:780\n*S KotlinDebug\n*F\n+ 1 TableEntityProcessor.kt\nandroidx/room/processor/TableEntityProcessor\n*L\n118#1:625\n118#1:626,2\n119#1:628,9\n119#1:637\n119#1:639\n119#1:640\n173#1:641,2\n207#1:643\n208#1:644\n208#1:645,3\n211#1:648,3\n207#1:651\n236#1:652\n236#1:653,2\n278#1:655,9\n278#1:664\n278#1:666\n278#1:667\n236#1:668\n325#1:669\n325#1:670,2\n326#1:672\n327#1:673,2\n326#1:675\n371#1:676,9\n371#1:685\n371#1:687\n371#1:688\n413#1:689,9\n413#1:698\n415#1:699,2\n421#1:701\n421#1:702,3\n413#1:706\n413#1:707\n441#1:708\n441#1:709,2\n452#1:711,9\n452#1:720\n452#1:722\n452#1:723\n479#1:724\n479#1:725,2\n482#1:727,2\n501#1:729\n501#1:730,3\n514#1:733,9\n514#1:742\n521#1:743,9\n521#1:752\n521#1:754\n521#1:755\n514#1:757\n514#1:758\n554#1:759\n554#1:760,3\n554#1:770,3\n559#1:782,2\n601#1:784\n601#1:785,3\n205#1:788,3\n119#1:638\n278#1:665\n371#1:686\n413#1:705\n452#1:721\n521#1:753\n514#1:756\n554#1:763,7\n555#1:773\n555#1:774,6\n556#1:780,2\n*E\n"})
public final class TableEntityProcessor
implements EntityProcessor {
    @NotNull
    private final XTypeElement element;
    @NotNull
    private final LinkedHashSet<String> referenceStack;
    @NotNull
    private final Context context;

    public TableEntityProcessor(@NotNull Context baseContext, @NotNull XTypeElement element, @NotNull LinkedHashSet<String> referenceStack) {
        Intrinsics.checkNotNullParameter((Object)baseContext, (String)"baseContext");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(referenceStack, (String)"referenceStack");
        this.element = element;
        this.referenceStack = referenceStack;
        this.context = Context.fork$default(baseContext, (XElement)this.element, null, null, 6, null);
    }

    public /* synthetic */ TableEntityProcessor(Context context, XTypeElement xTypeElement, LinkedHashSet linkedHashSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            linkedHashSet = new LinkedHashSet<String>();
        }
        this(context, xTypeElement, linkedHashSet);
    }

    @NotNull
    public final XTypeElement getElement() {
        return this.element;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @Override
    @NotNull
    public androidx.room.vo.Entity process() {
        return this.context.getCache().getEntities().get(new Cache.EntityKey((XElement)this.element), (Function0<androidx.room.vo.Entity>)((Function0)() -> TableEntityProcessor.process$lambda$0(this)));
    }

    /*
     * WARNING - void declaration
     */
    private final androidx.room.vo.Entity doProcess() {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Object it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        if (!this.element.validate()) {
            this.context.reportMissingTypeReference(this.element.getQualifiedName());
            XTypeElement xTypeElement = this.element;
            String string = this.element.getName();
            XType xType = this.element.getType();
            List list = CollectionsKt.emptyList();
            List list2 = CollectionsKt.emptyList();
            List list3 = CollectionsKt.emptyList();
            androidx.room.vo.PrimaryKey primaryKey = androidx.room.vo.PrimaryKey.Companion.getMISSING();
            List list4 = CollectionsKt.emptyList();
            return new androidx.room.vo.Entity(xTypeElement, string, xType, list, list2, primaryKey, list3, list4, null, null);
        }
        this.context.getChecker().hasAnnotation((XElement)this.element, (KClass<? extends Annotation>)Reflection.getOrCreateKotlinClass(Entity.class), "Entity class must be annotated with @Entity", new Object[0]);
        XAnnotation annotation = this.element.getAnnotation(Reflection.getOrCreateKotlinClass(Entity.class));
        String tableName = null;
        List<IndexInput> entityIndices = null;
        List<ForeignKeyInput> foreignKeyInputs = null;
        boolean inheritSuperIndices = false;
        if (annotation != null) {
            tableName = EntityProcessor.Companion.extractTableName(this.element, annotation);
            entityIndices = EntityProcessor.Companion.extractIndices(annotation, tableName);
            XAnnotationValue xAnnotationValue = annotation.get("inheritSuperIndices");
            inheritSuperIndices = xAnnotationValue != null ? xAnnotationValue.asBoolean() : false;
            foreignKeyInputs = EntityProcessor.Companion.extractForeignKeys(annotation);
        } else {
            tableName = this.element.getName();
            foreignKeyInputs = CollectionsKt.emptyList();
            entityIndices = CollectionsKt.emptyList();
            inheritSuperIndices = false;
        }
        this.context.getChecker().notBlank(tableName, (XElement)this.element, "Entity table name cannot be blank. If you don't want to set it, just remove the tableName property.", new Object[0]);
        this.context.getChecker().check(!StringsKt.startsWith((String)tableName, (String)"sqlite_", (boolean)true), (XElement)this.element, "Entity table name cannot start with \"sqlite_\".", new Object[0]);
        DataClass pojo = DataClassProcessor.Companion.createFor(this.context, this.element, PropertyProcessor.BindingScope.TWO_WAY, null, this.referenceStack).process();
        this.context.getChecker().check(pojo.getRelations().isEmpty(), (XElement)this.element, "Entities cannot have relations.", new Object[0]);
        Iterable iterable = pojo.getProperties();
        boolean $i$f$filter = false;
        void var10_19 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Property)element$iv$iv;
            boolean bl = false;
            if (!((Property)it).getIndexed()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        it = $this$forEach$iv$iv$iv.iterator();
        while (it.hasNext()) {
            IndexInput indexInput;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = it.next();
            boolean bl = false;
            Property it2 = (Property)element$iv$iv;
            boolean bl2 = false;
            if (it2.getParent() != null) {
                it2.setIndexed(false);
                this.context.getLogger().w(Warning.INDEX_FROM_EMBEDDED_PROPERTY_IS_DROPPED, (XElement)it2.getElement(), ProcessorErrors.INSTANCE.droppedEmbeddedPropertyIndex(it2.getPath(), this.element.getQualifiedName()), new Object[0]);
                indexInput = null;
            } else if (!Intrinsics.areEqual((Object)it2.getElement().getEnclosingElement(), (Object)this.element) && !inheritSuperIndices) {
                it2.setIndexed(false);
                this.context.getLogger().w(Warning.INDEX_FROM_PARENT_PROPERTY_IS_DROPPED, ProcessorErrors.INSTANCE.droppedSuperClassPropertyIndex(it2.getColumnName(), this.element.getQualifiedName(), it2.getElement().getEnclosingElement().asClassName().toString(this.context.getCodeLanguage())), new Object[0]);
                indexInput = null;
            } else {
                indexInput = new IndexInput(EntityProcessor.Companion.createIndexName(CollectionsKt.listOf((Object)it2.getColumnName()), tableName), false, CollectionsKt.listOf((Object)it2.getColumnName()), CollectionsKt.emptyList());
            }
            if (indexInput == null) continue;
            IndexInput it$iv$iv = indexInput;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List propertyIndices = (List)destination$iv$iv;
        List<IndexInput> superIndices = this.loadSuperIndices(this.element.getSuperClass(), tableName, inheritSuperIndices);
        List indexInputs = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)entityIndices, (Iterable)propertyIndices), (Iterable)superIndices);
        List<Index> indices = this.validateAndCreateIndices(indexInputs, pojo);
        androidx.room.vo.PrimaryKey primaryKey = this.findAndValidatePrimaryKey(pojo.getProperties(), pojo.getEmbeddedProperties());
        Object object = (Property)CollectionsKt.firstOrNull((List)primaryKey.getProperties());
        if (object == null || (object = object.getAffinity()) == null) {
            object = SQLTypeAffinity.TEXT;
        }
        Object affinity = object;
        Checks checks = this.context.getChecker();
        boolean bl = !primaryKey.getAutoGenerateId() || affinity == SQLTypeAffinity.INTEGER;
        Property property = (Property)CollectionsKt.firstOrNull((List)primaryKey.getProperties());
        if (property == null || (property = property.getElement()) == null) {
            property = this.element;
        }
        checks.check(bl, (XElement)property, "If a primary key is annotated with autoGenerate, its type must be int, Integer, long or Long.", new Object[0]);
        List<ForeignKey> entityForeignKeys = this.validateAndCreateForeignKeyReferences(foreignKeyInputs, pojo);
        this.checkIndicesForForeignKeys(entityForeignKeys, primaryKey, indices);
        this.context.getChecker().check(SqlParser.Companion.isValidIdentifier(tableName), (XElement)this.element, "Invalid table name. Room does not allow using ` or \" in table names", new Object[0]);
        Iterable $this$forEach$iv = pojo.getProperties();
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            Property it3 = (Property)element$iv;
            boolean bl4 = false;
            this.context.getChecker().check(SqlParser.Companion.isValidIdentifier(it3.getColumnName()), (XElement)it3.getElement(), "Invalid column name. Room does not allow using ` or \" in column names", new Object[0]);
        }
        XTypeElement xTypeElement = this.element;
        XType xType = pojo.getType();
        Properties properties = pojo.getProperties();
        List<EmbeddedProperty> list = pojo.getEmbeddedProperties();
        Constructor constructor = pojo.getConstructor();
        androidx.room.vo.Entity entity = new androidx.room.vo.Entity(xTypeElement, tableName, xType, properties, list, primaryKey, indices, entityForeignKeys, constructor, null);
        return entity;
    }

    /*
     * Unable to fully structure code
     */
    private final void checkIndicesForForeignKeys(List<ForeignKey> entityForeignKeys, androidx.room.vo.PrimaryKey primaryKey, List<Index> indices) {
        $this$forEach$iv = entityForeignKeys;
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            block8: {
                fKey = (ForeignKey)element$iv;
                $i$a$-forEach-TableEntityProcessor$checkIndicesForForeignKeys$1 = false;
                $this$map$iv = fKey.getChildProperties();
                $i$f$map = false;
                var12_14 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var17_22 = (Property)item$iv$iv;
                    var18_23 = destination$iv$iv;
                    $i$a$-map-TableEntityProcessor$checkIndicesForForeignKeys$1$columnNames$1 = false;
                    var18_23.add(it.getColumnName());
                }
                columnNames = (List)destination$iv$iv;
                if (TableEntityProcessor.checkIndicesForForeignKeys$covers(columnNames, primaryKey.getProperties())) ** GOTO lbl-1000
                $this$any$iv = indices;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v0 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        index = (Index)element$iv;
                        $i$a$-any-TableEntityProcessor$checkIndicesForForeignKeys$1$exists$1 = false;
                        if (!TableEntityProcessor.checkIndicesForForeignKeys$covers(columnNames, index.getProperties())) continue;
                        v0 = true;
                        break block8;
                    }
                    v0 = false;
                }
            }
            if (v0) lbl-1000:
            // 2 sources

            {
                v1 = true;
            } else {
                v1 = false;
            }
            if (exists = v1) continue;
            if (columnNames.size() == 1) {
                this.context.getLogger().w(Warning.MISSING_INDEX_ON_FOREIGN_KEY_CHILD, (XElement)this.element, ProcessorErrors.INSTANCE.foreignKeyMissingIndexInChildColumn((String)columnNames.get(0)), new Object[0]);
                continue;
            }
            this.context.getLogger().w(Warning.MISSING_INDEX_ON_FOREIGN_KEY_CHILD, (XElement)this.element, ProcessorErrors.INSTANCE.foreignKeyMissingIndexInChildColumns(columnNames), new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<ForeignKey> validateAndCreateForeignKeyReferences(List<ForeignKeyInput> foreignKeyInputs, DataClass dataClass) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = foreignKeyInputs;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ForeignKey foreignKey;
            void it;
            ForeignKeyInput foreignKeyInput = (ForeignKeyInput)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (it.getOnUpdate() == null) {
                this.context.getLogger().e((XElement)this.element, "Invalid foreign key action. It must be one of the constants defined in ForeignKey.Action", new Object[0]);
                foreignKey = null;
            } else if (it.getOnDelete() == null) {
                this.context.getLogger().e((XElement)this.element, "Invalid foreign key action. It must be one of the constants defined in ForeignKey.Action", new Object[0]);
                foreignKey = null;
            } else if (it.getChildColumns().isEmpty()) {
                this.context.getLogger().e((XElement)this.element, "Must specify at least 1 column name for the child", new Object[0]);
                foreignKey = null;
            } else if (it.getParentColumns().isEmpty()) {
                this.context.getLogger().e((XElement)this.element, "Must specify at least 1 column name for the parent", new Object[0]);
                foreignKey = null;
            } else if (it.getChildColumns().size() != it.getParentColumns().size()) {
                this.context.getLogger().e((XElement)this.element, ProcessorErrors.INSTANCE.foreignKeyColumnNumberMismatch(it.getChildColumns(), it.getParentColumns()), new Object[0]);
                foreignKey = null;
            } else {
                XTypeElement parentElement = it.getParent().getTypeElement();
                if (parentElement == null) {
                    this.context.getLogger().e((XElement)this.element, "Cannot find parent entity class.", new Object[0]);
                    foreignKey = null;
                } else {
                    XAnnotation parentAnnotation = parentElement.getAnnotation(Reflection.getOrCreateKotlinClass(Entity.class));
                    if (parentAnnotation == null) {
                        this.context.getLogger().e((XElement)this.element, ProcessorErrors.INSTANCE.foreignKeyNotAnEntity(parentElement.getQualifiedName()), new Object[0]);
                        foreignKey = null;
                    } else {
                        void $this$mapNotNullTo$iv$iv;
                        String tableName = EntityProcessor.Companion.extractTableName(parentElement, parentAnnotation);
                        Iterable $this$mapNotNull$iv = it.getChildColumns();
                        boolean $i$f$mapNotNull = false;
                        Object object = $this$mapNotNull$iv;
                        Collection destination$iv$iv2 = new ArrayList();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        boolean $i$f$forEach = false;
                        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            Property it$iv$iv;
                            Object element$iv$iv$iv;
                            Object element$iv$iv = element$iv$iv$iv = iterator.next();
                            boolean bl2 = false;
                            String columnName = (String)element$iv$iv;
                            boolean bl3 = false;
                            Property property = HasPropertiesKt.findPropertyByColumnName(dataClass, columnName);
                            if (property == null) {
                                this.context.getLogger().e((XElement)dataClass.getElement(), ProcessorErrors.INSTANCE.foreignKeyChildColumnDoesNotExist(columnName, HasPropertiesKt.getColumnNames(dataClass)), new Object[0]);
                            }
                            if (property == null) continue;
                            boolean bl4 = false;
                            destination$iv$iv2.add(it$iv$iv);
                        }
                        List properties = (List)destination$iv$iv2;
                        if (properties.size() != it.getChildColumns().size()) {
                            foreignKey = null;
                        } else {
                            List<String> list = it.getParentColumns();
                            ForeignKeyAction foreignKeyAction = it.getOnDelete();
                            object = it.getOnUpdate();
                            boolean bl5 = it.getDeferred();
                            foreignKey = new ForeignKey(tableName, list, properties, foreignKeyAction, (ForeignKeyAction)((Object)object), bl5);
                        }
                    }
                }
            }
            collection.add(foreignKey);
        }
        return CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final androidx.room.vo.PrimaryKey findAndValidatePrimaryKey(List<Property> properties, List<EmbeddedProperty> embeddedProperties) {
        void $this$forEach$iv;
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv;
        List candidates = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)this.collectPrimaryKeysFromEntityAnnotations(this.element, properties), (Iterable)this.collectPrimaryKeysFromPrimaryKeyAnnotations(properties)), (Iterable)this.collectPrimaryKeysFromEmbeddedProperties(embeddedProperties));
        this.context.getChecker().check(!((Collection)candidates).isEmpty(), (XElement)this.element, "An entity must have at least 1 property annotated with @PrimaryKey", new Object[0]);
        Set verifiedProperties = new LinkedHashSet();
        Iterable iterable = candidates;
        boolean $i$f$filterNot = false;
        Iterator iterator = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            androidx.room.vo.PrimaryKey it = (androidx.room.vo.PrimaryKey)element$iv$iv;
            boolean bl = false;
            if (it.getAutoGenerateId()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            androidx.room.vo.PrimaryKey candidate = (androidx.room.vo.PrimaryKey)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = candidate.getProperties();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Property property = (Property)element$iv2;
                boolean bl2 = false;
                if (candidate.getProperties().size() <= 1 && (candidate.getProperties().size() != 1 || property.getAffinity() == SQLTypeAffinity.INTEGER)) continue;
                if (!verifiedProperties.contains(property)) {
                    this.context.getChecker().check(property.getNonNull(), (XElement)property.getElement(), ProcessorErrors.INSTANCE.primaryKeyNull(property.getPath()), new Object[0]);
                    verifiedProperties.add(property);
                }
                EmbeddedProperty parent = property.getParent();
                while (parent != null) {
                    Property parentProperty = parent.getProperty();
                    if (!verifiedProperties.contains(parentProperty)) {
                        this.context.getChecker().check(parentProperty.getNonNull(), (XElement)parentProperty.getElement(), ProcessorErrors.INSTANCE.primaryKeyNull(parentProperty.getPath()), new Object[0]);
                        verifiedProperties.add(parentProperty);
                    }
                    parent = parentProperty.getParent();
                }
            }
        }
        if (candidates.size() == 1) {
            return (androidx.room.vo.PrimaryKey)CollectionsKt.first((List)candidates);
        }
        return this.choosePrimaryKey(candidates, this.element);
    }

    /*
     * WARNING - void declaration
     */
    private final List<androidx.room.vo.PrimaryKey> collectPrimaryKeysFromPrimaryKeyAnnotations(List<Property> fields) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = fields;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            androidx.room.vo.PrimaryKey primaryKey;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Property field = (Property)element$iv$iv;
            boolean bl2 = false;
            if (field.getElement().getAnnotation(Reflection.getOrCreateKotlinClass(PrimaryKey.class)) == null) {
                primaryKey = null;
            } else if (field.getParent() != null) {
                XFieldElement grandParentField = field.getParent().getMRootParent().getProperty().getElement();
                Context.fork$default(this.context, (XElement)grandParentField, null, null, 6, null).getLogger().w(Warning.PRIMARY_KEY_FROM_EMBEDDED_IS_DROPPED, (XElement)grandParentField, ProcessorErrors.INSTANCE.embeddedPrimaryKeyIsDropped(this.element.getQualifiedName(), field.getName()), new Object[0]);
                primaryKey = null;
            } else {
                XAnnotation primaryKeyAnnotation;
                XAnnotationValue xAnnotationValue = primaryKeyAnnotation.get("autoGenerate");
                primaryKey = new androidx.room.vo.PrimaryKey((XElement)field.getElement().getEnclosingElement(), new Properties(field), xAnnotationValue != null ? xAnnotationValue.asBoolean() : false);
            }
            if (primaryKey == null) continue;
            androidx.room.vo.PrimaryKey it$iv$iv = primaryKey;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<androidx.room.vo.PrimaryKey> collectPrimaryKeysFromEntityAnnotations(XTypeElement typeElement, List<Property> availableProperties) {
        List<androidx.room.vo.PrimaryKey> list;
        XType mySuper;
        Object myPkeys;
        Object primaryKeyColumns;
        block15: {
            Object object;
            block14: {
                List list2;
                object = typeElement.getAnnotation(Reflection.getOrCreateKotlinClass(Entity.class));
                if (object == null) break block14;
                XAnnotation it = object;
                boolean bl = false;
                Object object2 = it.get("primaryKeys");
                if (object2 == null || (object2 = object2.asStringList()) == null) {
                    object2 = CollectionsKt.emptyList();
                }
                if ((primaryKeyColumns = object2).isEmpty()) {
                    list2 = CollectionsKt.emptyList();
                } else {
                    void $this$mapNotNullTo$iv$iv;
                    Iterable $this$mapNotNull$iv = (Iterable)primaryKeyColumns;
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        Property it$iv$iv;
                        Collection<String> collection;
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        Object v3;
                        Iterable $this$firstOrNull$iv;
                        String pKeyColumnName;
                        block13: {
                            Object element$iv$iv$iv;
                            Object element$iv$iv = element$iv$iv$iv = iterator.next();
                            boolean bl2 = false;
                            pKeyColumnName = (String)element$iv$iv;
                            boolean bl3 = false;
                            $this$firstOrNull$iv = availableProperties;
                            boolean $i$f$firstOrNull = false;
                            for (Object element$iv : $this$firstOrNull$iv) {
                                Property it2 = (Property)element$iv;
                                boolean bl4 = false;
                                if (!Intrinsics.areEqual((Object)it2.getColumnName(), (Object)pKeyColumnName)) continue;
                                v3 = element$iv;
                                break block13;
                            }
                            v3 = null;
                        }
                        Property property = v3;
                        $this$firstOrNull$iv = availableProperties;
                        String string = pKeyColumnName;
                        ProcessorErrors processorErrors = ProcessorErrors.INSTANCE;
                        XElement xElement = (XElement)typeElement;
                        boolean bl5 = property != null;
                        Checks checks = this.context.getChecker();
                        boolean $i$f$map = false;
                        Iterator iterator2 = $this$map$iv;
                        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void it3;
                            Property property2 = (Property)item$iv$iv;
                            collection = destination$iv$iv2;
                            boolean bl6 = false;
                            collection.add(it3.getColumnName());
                        }
                        collection = (List)destination$iv$iv2;
                        checks.check(bl5, xElement, processorErrors.primaryKeyColumnDoesNotExist(string, (List<String>)collection), new Object[0]);
                        if (property == null) continue;
                        boolean bl7 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    List properties = (List)destination$iv$iv;
                    list2 = CollectionsKt.listOf((Object)new androidx.room.vo.PrimaryKey((XElement)typeElement, new Properties(properties), false));
                }
                object = list2;
                if (list2 != null) break block15;
            }
            object = myPkeys = CollectionsKt.emptyList();
        }
        if ((mySuper = typeElement.getSuperClass()) != null && Xtype_extKt.isNotNone(mySuper) && Xtype_extKt.isNotError(mySuper)) {
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv = availableProperties;
            boolean $i$f$filterNot = false;
            primaryKeyColumns = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                Property it = (Property)element$iv$iv;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it.getElement().getEnclosingElement(), (Object)typeElement)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List remainingProperties = (List)destination$iv$iv;
            XTypeElement xTypeElement = mySuper.getTypeElement();
            Intrinsics.checkNotNull((Object)xTypeElement);
            list = this.collectPrimaryKeysFromEntityAnnotations(xTypeElement, remainingProperties);
        } else {
            list = CollectionsKt.emptyList();
        }
        List<androidx.room.vo.PrimaryKey> superPKeys = list;
        return CollectionsKt.plus((Collection)superPKeys, (Iterable)((Iterable)myPkeys));
    }

    /*
     * WARNING - void declaration
     */
    private final List<androidx.room.vo.PrimaryKey> collectPrimaryKeysFromEmbeddedProperties(List<EmbeddedProperty> embeddedProperties) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = embeddedProperties;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            androidx.room.vo.PrimaryKey primaryKey;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            EmbeddedProperty embeddedProperty = (EmbeddedProperty)element$iv$iv;
            boolean bl2 = false;
            if (embeddedProperty.getProperty().getElement().getAnnotation(Reflection.getOrCreateKotlinClass(PrimaryKey.class)) != null) {
                XAnnotation it;
                boolean bl3 = false;
                XAnnotationValue xAnnotationValue = it.get("autoGenerate");
                boolean autoGenerate = xAnnotationValue != null ? xAnnotationValue.asBoolean() : false;
                this.context.getChecker().check(!autoGenerate || embeddedProperty.getDataClass().getProperties().size() == 1, (XElement)embeddedProperty.getProperty().getElement(), "When @PrimaryKey annotation is used on a property annotated with @Embedded, the embedded class should have only 1 property.", new Object[0]);
                primaryKey = new androidx.room.vo.PrimaryKey((XElement)embeddedProperty.getProperty().getElement().getEnclosingElement(), embeddedProperty.getDataClass().getProperties(), autoGenerate);
            } else {
                primaryKey = null;
            }
            if (primaryKey == null) continue;
            androidx.room.vo.PrimaryKey it$iv$iv = primaryKey;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final androidx.room.vo.PrimaryKey choosePrimaryKey(List<androidx.room.vo.PrimaryKey> candidates, XTypeElement typeElement) {
        androidx.room.vo.PrimaryKey primaryKey;
        androidx.room.vo.PrimaryKey candidate;
        Iterator $this$filterTo$iv$iv;
        Iterable $this$filter$iv = candidates;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            candidate = (androidx.room.vo.PrimaryKey)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)candidate.getDeclaredIn(), (Object)typeElement)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List myPKeys = (List)destination$iv$iv;
        if (myPKeys.size() == 1) {
            Iterable $this$forEach$iv = CollectionsKt.minus((Iterable)candidates, (Iterable)myPKeys);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                androidx.room.vo.PrimaryKey it = (androidx.room.vo.PrimaryKey)element$iv;
                boolean bl = false;
                this.context.getLogger().d((XElement)this.element, it.toHumanReadableString() + " is overridden by " + ((androidx.room.vo.PrimaryKey)CollectionsKt.first((List)myPKeys)).toHumanReadableString(), new Object[0]);
            }
            primaryKey = (androidx.room.vo.PrimaryKey)CollectionsKt.first((List)myPKeys);
        } else if (myPKeys.isEmpty()) {
            mySuper = typeElement.getSuperClass();
            if (mySuper != null && Xtype_extKt.isNotNone(mySuper) && Xtype_extKt.isNotError(mySuper)) {
                XTypeElement xTypeElement = mySuper.getTypeElement();
                Intrinsics.checkNotNull((Object)xTypeElement);
                return this.choosePrimaryKey(candidates, xTypeElement);
            }
            primaryKey = androidx.room.vo.PrimaryKey.Companion.getMISSING();
        } else {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            mySuper = myPKeys;
            ProcessorErrors processorErrors = ProcessorErrors.INSTANCE;
            XElement xElement = (XElement)this.element;
            RLog rLog = this.context.getLogger();
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                candidate = (androidx.room.vo.PrimaryKey)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(p0.toHumanReadableString());
            }
            collection = (List)destination$iv$iv;
            rLog.e(xElement, processorErrors.multiplePrimaryKeyAnnotations((List<String>)collection), new Object[0]);
            primaryKey = androidx.room.vo.PrimaryKey.Companion.getMISSING();
        }
        return primaryKey;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Index> validateAndCreateIndices(List<IndexInput> inputs, DataClass dataClass) {
        Iterable $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Object $this$filter$iv;
        Object it;
        void $this$groupByTo$iv$iv;
        Object $this$groupBy$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = inputs;
        boolean $i$f$mapNotNull = false;
        Iterator iterator = $this$mapNotNull$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator<Object> $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean bl = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Index it$iv$iv;
            void $this$mapNotNullTo$iv$iv2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl2 = false;
            IndexInput input = (IndexInput)element$iv$iv;
            boolean bl22 = false;
            this.context.getChecker().check(!((Collection)input.getColumnNames()).isEmpty(), (XElement)this.element, "List of columns in an index cannot be empty", new Object[0]);
            Iterable $this$mapNotNull$iv2 = input.getColumnNames();
            boolean $i$f$mapNotNull2 = false;
            Iterable iterable = $this$mapNotNull$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo2 = false;
            void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv2;
            boolean $i$f$forEach2 = false;
            Iterator iterator3 = $this$forEach$iv$iv$iv2.iterator();
            while (iterator3.hasNext()) {
                Property it$iv$iv2;
                Object element$iv$iv$iv2;
                Object element$iv$iv2 = element$iv$iv$iv2 = iterator3.next();
                boolean bl3 = false;
                String columnName = (String)element$iv$iv2;
                boolean bl32 = false;
                Property property = HasPropertiesKt.findPropertyByColumnName(dataClass, columnName);
                this.context.getChecker().check(property != null, (XElement)this.element, ProcessorErrors.INSTANCE.indexColumnDoesNotExist(columnName, HasPropertiesKt.getColumnNames(dataClass)), new Object[0]);
                if (property == null) continue;
                boolean bl4 = false;
                destination$iv$iv2.add(it$iv$iv2);
            }
            List properties = (List)destination$iv$iv2;
            if (!((Collection)input.getOrders()).isEmpty()) {
                this.context.getChecker().check(input.getColumnNames().size() == input.getOrders().size(), (XElement)this.element, "The number of entries in @Index#orders() should be equal to the amount of columns defined in the @Index value.", new Object[0]);
            }
            if ((properties.isEmpty() ? null : new Index(input.getName(), input.getUnique(), new Properties(properties), input.getOrders())) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List indices = (List)destination$iv$iv;
        $this$mapNotNull$iv = indices;
        boolean $i$f$groupBy = false;
        $this$mapNotNullTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object t : $this$groupByTo$iv$iv) {
            Object object;
            it = (Index)t;
            boolean bl4 = false;
            String key$iv$iv = ((Index)it).getName();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl6 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(t);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$filter = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        for (Map.Entry entry : $this$filterTo$iv$iv.entrySet()) {
            it = entry;
            boolean bl5 = false;
            if (!(((List)it.getValue()).size() > 1)) continue;
            destination$iv$iv.put(entry.getKey(), entry.getValue());
        }
        $this$filter$iv = destination$iv$iv;
        boolean $i$f$forEach3 = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it2 = element$iv = (Map.Entry)iterator.next();
            boolean bl6 = false;
            this.context.getLogger().e((XElement)this.element, ProcessorErrors.INSTANCE.duplicateIndexInEntity((String)it2.getKey()), new Object[0]);
        }
        $this$forEach$iv = dataClass.getEmbeddedProperties();
        boolean $i$f$forEach = false;
        for (Map.Entry element$iv : $this$forEach$iv) {
            EmbeddedProperty embedded = (EmbeddedProperty)((Object)element$iv);
            boolean bl7 = false;
            XTypeElement xTypeElement = embedded.getDataClass().getElement();
            if (xTypeElement.getAnnotation(Reflection.getOrCreateKotlinClass(Entity.class)) == null) continue;
            boolean bl72 = false;
            List<IndexInput> subIndices = EntityProcessor.Companion.extractIndices((XAnnotation)it, "");
            if (!(!((Collection)subIndices).isEmpty())) continue;
            this.context.getLogger().w(Warning.INDEX_FROM_EMBEDDED_ENTITY_IS_DROPPED, (XElement)embedded.getProperty().getElement(), ProcessorErrors.INSTANCE.droppedEmbeddedIndex(embedded.getDataClass().getTypeName().toString(this.context.getCodeLanguage()), embedded.getProperty().getPath(), this.element.getQualifiedName()), new Object[0]);
        }
        return indices;
    }

    /*
     * WARNING - void declaration
     */
    private final List<IndexInput> loadSuperIndices(XType typeMirror, String tableName, boolean inherit) {
        Object object;
        XTypeElement parentTypeElement;
        block11: {
            block10: {
                List list;
                if (typeMirror == null || typeMirror.isNone() || typeMirror.isError()) {
                    return CollectionsKt.emptyList();
                }
                parentTypeElement = typeMirror.getTypeElement();
                if (parentTypeElement == null) {
                    return CollectionsKt.emptyList();
                }
                object = parentTypeElement.getAnnotation(Reflection.getOrCreateKotlinClass(Entity.class));
                if (object == null) break block10;
                XAnnotation annotation = object;
                boolean bl = false;
                List<IndexInput> indices = EntityProcessor.Companion.extractIndices(annotation, "super");
                if (indices.isEmpty()) {
                    list = CollectionsKt.emptyList();
                } else if (inherit) {
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = indices;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        IndexInput indexInput = (IndexInput)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl2 = false;
                        collection.add(new IndexInput(EntityProcessor.Companion.createIndexName(it.getColumnNames(), tableName), it.getUnique(), it.getColumnNames(), it.getOrders()));
                    }
                    list = (List)destination$iv$iv;
                } else {
                    this.context.getLogger().w(Warning.INDEX_FROM_PARENT_IS_DROPPED, (XElement)parentTypeElement, ProcessorErrors.INSTANCE.droppedSuperClassIndex(this.element.getQualifiedName(), parentTypeElement.getQualifiedName()), new Object[0]);
                    list = CollectionsKt.emptyList();
                }
                object = list;
                if (list != null) break block11;
            }
            object = CollectionsKt.emptyList();
        }
        Object myIndices = object;
        return CollectionsKt.plus((Collection)((Collection)myIndices), (Iterable)this.loadSuperIndices(parentTypeElement.getSuperClass(), tableName, inherit));
    }

    private static final androidx.room.vo.Entity process$lambda$0(TableEntityProcessor this$0) {
        return this$0.doProcess();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean checkIndicesForForeignKeys$covers(List<String> columnNames, List<Property> properties) {
        IndexedValue it;
        if (properties.size() < columnNames.size()) return false;
        Iterable $this$all$iv = CollectionsKt.withIndex((Iterable)columnNames);
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            it = (IndexedValue)element$iv;
            boolean bl = false;
        } while (Intrinsics.areEqual((Object)properties.get(it.getIndex()).getColumnName(), (Object)it.getValue()));
        return false;
    }
}

