/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.processor;

import androidx.room.compiler.processing.XAnnotation;
import androidx.room.compiler.processing.XElement;
import androidx.room.compiler.processing.XExecutableParameterElement;
import androidx.room.compiler.processing.XMethodElement;
import androidx.room.compiler.processing.XType;
import androidx.room.compiler.processing.XTypeElement;
import androidx.room.ext.Xelement_extKt;
import androidx.room.preconditions.Checks;
import androidx.room.processor.Context;
import androidx.room.processor.DataClassProcessor;
import androidx.room.processor.EntityProcessorKt;
import androidx.room.processor.FunctionProcessorDelegate;
import androidx.room.processor.FunctionProcessorDelegateKt;
import androidx.room.processor.ProcessorErrors;
import androidx.room.processor.PropertyProcessor;
import androidx.room.processor.ShortcutParameterProcessor;
import androidx.room.solver.shortcut.binder.DeleteOrUpdateFunctionBinder;
import androidx.room.solver.shortcut.binder.InsertOrUpsertFunctionBinder;
import androidx.room.vo.DataClass;
import androidx.room.vo.Entity;
import androidx.room.vo.HasPropertiesKt;
import androidx.room.vo.Property;
import androidx.room.vo.ShortcutEntity;
import androidx.room.vo.ShortcutQueryParameter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ(\u0010\u0013\u001a\u0004\u0018\u00010\u0014\"\b\b\u0000\u0010\u0015*\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00150\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u0005JP\u0010\u001c\u001a \u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001f0\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0 0\u001d2\b\u0010\"\u001a\u0004\u0018\u00010\u00052\u0006\u0010#\u001a\u00020\u001a2\u0018\u0010$\u001a\u0014\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020(0%JD\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010*\u001a\u00020&2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020!0 2\u0018\u0010$\u001a\u0014\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020(0%H\u0002J\"\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001f0\u001e2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002J!\u0010-\u001a\u0004\u0018\u00010&2\u0006\u0010.\u001a\u00020/2\f\u00100\u001a\b\u0012\u0004\u0012\u00020(01H\u0082\bJ\u001c\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u00052\f\u0010+\u001a\b\u0012\u0004\u0012\u00020!0 J\u001c\u00105\u001a\u0002032\u0006\u00104\u001a\u00020\u00052\f\u0010+\u001a\b\u0012\u0004\u0012\u00020!0 J\u000e\u00106\u001a\u0002072\u0006\u00104\u001a\u00020\u0005R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Landroidx/room/processor/ShortcutFunctionProcessor;", "", "baseContext", "Landroidx/room/processor/Context;", "containing", "Landroidx/room/compiler/processing/XType;", "executableElement", "Landroidx/room/compiler/processing/XMethodElement;", "<init>", "(Landroidx/room/processor/Context;Landroidx/room/compiler/processing/XType;Landroidx/room/compiler/processing/XMethodElement;)V", "getContaining", "()Landroidx/room/compiler/processing/XType;", "getExecutableElement", "()Landroidx/room/compiler/processing/XMethodElement;", "context", "getContext", "()Landroidx/room/processor/Context;", "delegate", "Landroidx/room/processor/FunctionProcessorDelegate;", "extractAnnotation", "Landroidx/room/compiler/processing/XAnnotation;", "T", "", "klass", "Lkotlin/reflect/KClass;", "errorMsg", "", "extractReturnType", "extractParams", "Lkotlin/Pair;", "", "Landroidx/room/vo/ShortcutEntity;", "", "Landroidx/room/vo/ShortcutQueryParameter;", "targetEntityType", "missingParamError", "onValidatePartialEntity", "Lkotlin/Function2;", "Landroidx/room/vo/Entity;", "Landroidx/room/vo/DataClass;", "", "extractPartialEntities", "targetEntity", "params", "extractEntities", "processEntity", "element", "Landroidx/room/compiler/processing/XTypeElement;", "onInvalid", "Lkotlin/Function0;", "findInsertFunctionBinder", "Landroidx/room/solver/shortcut/binder/InsertOrUpsertFunctionBinder;", "returnType", "findUpsertFunctionBinder", "findDeleteOrUpdateFunctionBinder", "Landroidx/room/solver/shortcut/binder/DeleteOrUpdateFunctionBinder;", "room-compiler"})
@SourceDebugExtension(value={"SMAP\nShortcutFunctionProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShortcutFunctionProcessor.kt\nandroidx/room/processor/ShortcutFunctionProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,242:1\n226#1,6:247\n226#1,6:276\n1557#2:243\n1628#2,3:244\n774#2:253\n865#2,2:254\n1216#2,2:256\n1246#2,2:258\n774#2:260\n865#2,2:261\n1863#2,2:263\n1249#2:265\n1611#2,9:266\n1863#2:275\n1864#2:283\n1620#2:284\n1#3:282\n*S KotlinDebug\n*F\n+ 1 ShortcutFunctionProcessor.kt\nandroidx/room/processor/ShortcutFunctionProcessor\n*L\n95#1:247,6\n210#1:276,6\n75#1:243\n75#1:244,3\n112#1:253\n112#1:254,2\n129#1:256,2\n129#1:258,2\n158#1:260\n158#1:261,2\n162#1:263,2\n129#1:265\n200#1:266,9\n200#1:275\n200#1:283\n200#1:284\n200#1:282\n*E\n"})
public final class ShortcutFunctionProcessor {
    @NotNull
    private final XType containing;
    @NotNull
    private final XMethodElement executableElement;
    @NotNull
    private final Context context;
    @NotNull
    private final FunctionProcessorDelegate delegate;

    public ShortcutFunctionProcessor(@NotNull Context baseContext, @NotNull XType containing, @NotNull XMethodElement executableElement) {
        Intrinsics.checkNotNullParameter((Object)baseContext, (String)"baseContext");
        Intrinsics.checkNotNullParameter((Object)containing, (String)"containing");
        Intrinsics.checkNotNullParameter((Object)executableElement, (String)"executableElement");
        this.containing = containing;
        this.executableElement = executableElement;
        this.context = Context.fork$default(baseContext, (XElement)this.executableElement, null, null, 6, null);
        this.delegate = FunctionProcessorDelegate.Companion.createFor(this.context, this.containing, this.executableElement);
    }

    @NotNull
    public final XType getContaining() {
        return this.containing;
    }

    @NotNull
    public final XMethodElement getExecutableElement() {
        return this.executableElement;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @Nullable
    public final <T extends Annotation> XAnnotation extractAnnotation(@NotNull KClass<T> klass, @NotNull String errorMsg) {
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        Intrinsics.checkNotNullParameter((Object)errorMsg, (String)"errorMsg");
        XAnnotation annotation = this.executableElement.getAnnotation(klass);
        this.context.getChecker().check(annotation != null, (XElement)this.executableElement, errorMsg, new Object[0]);
        return annotation;
    }

    @NotNull
    public final XType extractReturnType() {
        XType returnType = this.delegate.extractReturnType();
        boolean returnsDeferredType = FunctionProcessorDelegateKt.returnsDeferredType(this.delegate);
        boolean isSuspendFunction = this.delegate.getExecutableElement().isSuspendFunction();
        Checks checks = this.context.getChecker();
        boolean bl = !isSuspendFunction || !returnsDeferredType;
        XElement xElement = (XElement)this.executableElement;
        String string = returnType.getRawType().getTypeName().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        checks.check(bl, xElement, ProcessorErrors.INSTANCE.suspendReturnsDeferredType(string), new Object[0]);
        if (!(isSuspendFunction || returnsDeferredType || this.context.isAndroidOnlyTarget())) {
            this.context.getLogger().e((XElement)this.executableElement, "Only suspend functions are allowed in DAOs declared in source sets targeting non-Android platforms.", new Object[0]);
        }
        return returnType;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    public final Pair<Map<String, ShortcutEntity>, List<ShortcutQueryParameter>> extractParams(@Nullable XType targetEntityType, @NotNull String missingParamError, @NotNull Function2<? super Entity, ? super DataClass, Unit> onValidatePartialEntity) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Object this_$iv;
        Entity entity;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)missingParamError, (String)"missingParamError");
        Intrinsics.checkNotNullParameter(onValidatePartialEntity, (String)"onValidatePartialEntity");
        Iterable $this$map$iv = this.delegate.extractParams();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            XExecutableParameterElement xExecutableParameterElement = (XExecutableParameterElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ShortcutParameterProcessor(this.context, this.containing, (XExecutableParameterElement)it).process());
        }
        List params = (List)destination$iv$iv;
        this.context.getChecker().check(!((Collection)params).isEmpty(), (XElement)this.executableElement, missingParamError, new Object[0]);
        if (targetEntityType != null && !targetEntityType.isTypeOf(Reflection.getOrCreateKotlinClass(Object.class))) {
            XTypeElement targetTypeElement = targetEntityType.getTypeElement();
            if (targetTypeElement == null) {
                this.context.getLogger().e((XElement)this.executableElement, "Target entity declared in @Insert, @Update or @Delete must be annotated with @Entity.", new Object[0]);
                entity = null;
            } else {
                this_$iv = this;
                boolean $i$f$processEntity = false;
                if (!Xelement_extKt.isEntityElement((XElement)targetTypeElement)) {
                    boolean bl = false;
                    this.context.getLogger().e((XElement)this.executableElement, "Target entity declared in @Insert, @Update or @Delete must be annotated with @Entity.", new Object[0]);
                    return TuplesKt.to((Object)MapsKt.emptyMap(), (Object)CollectionsKt.emptyList());
                }
                entity = EntityProcessorKt.EntityProcessor$default(((ShortcutFunctionProcessor)this_$iv).context, targetTypeElement, null, 4, null).process();
            }
        } else {
            entity = null;
        }
        Entity targetEntity = entity;
        this_$iv = params;
        boolean $i$f$filter = false;
        void bl = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ShortcutQueryParameter it = (ShortcutQueryParameter)element$iv$iv;
            boolean bl2 = false;
            if (!(it.getPojoType() != null)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List it = (List)destination$iv$iv2;
        boolean bl3 = false;
        Map<String, ShortcutEntity> entities = targetEntity != null ? this.extractPartialEntities(targetEntity, it, onValidatePartialEntity) : this.extractEntities(it);
        return new Pair(entities, (Object)params);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, ShortcutEntity> extractPartialEntities(Entity targetEntity, List<ShortcutQueryParameter> params, Function2<? super Entity, ? super DataClass, Unit> onValidatePartialEntity) {
        void $this$associateByTo$iv$iv;
        Iterable $this$associateBy$iv = params;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            ShortcutEntity shortcutEntity;
            void param;
            ShortcutQueryParameter shortcutQueryParameter = (ShortcutQueryParameter)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            ShortcutQueryParameter it = (ShortcutQueryParameter)element$iv$iv;
            String string = it.getName();
            boolean bl2 = false;
            XType xType = targetEntity.getType();
            XType xType2 = param.getPojoType();
            Intrinsics.checkNotNull((Object)xType2);
            if (xType.isSameType(xType2)) {
                shortcutEntity = new ShortcutEntity(targetEntity, null);
            } else {
                DataClass dataClass;
                XTypeElement pojoTypeElement = param.getPojoType().getTypeElement();
                if (pojoTypeElement == null) {
                    this.context.getLogger().e((XElement)targetEntity.getElement(), ProcessorErrors.INSTANCE.shortcutFunctionArgumentMustBeAClass(param.getPojoType().asTypeName().toString(this.context.getCodeLanguage())), new Object[0]);
                    dataClass = null;
                } else {
                    void $this$forEach$iv;
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv;
                    DataClass dataClass2;
                    DataClass pojo = dataClass2 = DataClassProcessor.Companion.createFor$default(DataClassProcessor.Companion, this.context, pojoTypeElement, PropertyProcessor.BindingScope.BIND_TO_STMT, null, null, 16, null).process();
                    boolean bl3 = false;
                    Iterable iterable2 = pojo.getProperties();
                    boolean $i$f$filter = false;
                    Iterator iterator = $this$filter$iv;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                        Property it2 = (Property)element$iv$iv2;
                        boolean bl4 = false;
                        boolean bl5 = HasPropertiesKt.findPropertyByColumnName(targetEntity, it2.getColumnName()) == null;
                        if (!bl5) continue;
                        destination$iv$iv2.add(element$iv$iv2);
                    }
                    $this$filter$iv = (List)destination$iv$iv2;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Property it3 = (Property)element$iv;
                        boolean bl6 = false;
                        this.context.getLogger().e((XElement)it3.getElement(), ProcessorErrors.INSTANCE.cannotFindAsEntityProperty(targetEntity.getTypeName().toString(this.context.getCodeLanguage())), new Object[0]);
                    }
                    if (!((Collection)pojo.getRelations()).isEmpty()) {
                        this.context.getLogger().e((XElement)pojo.getElement(), "Partial entities cannot have relations.", new Object[0]);
                    }
                    if (pojo.getProperties().isEmpty()) {
                        this.context.getLogger().e((XElement)this.executableElement, ProcessorErrors.INSTANCE.noColumnsInPartialEntity(pojo.getTypeName().toString(this.context.getCodeLanguage())), new Object[0]);
                    }
                    onValidatePartialEntity.invoke((Object)targetEntity, (Object)pojo);
                    dataClass = dataClass2;
                }
                DataClass pojo = dataClass;
                shortcutEntity = new ShortcutEntity(targetEntity, pojo);
            }
            ShortcutEntity shortcutEntity2 = shortcutEntity;
            map.put(string, shortcutEntity2);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, ShortcutEntity> extractEntities(List<ShortcutQueryParameter> params) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = params;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            XTypeElement entityTypeElement;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ShortcutQueryParameter it = (ShortcutQueryParameter)element$iv$iv;
            boolean bl2 = false;
            XType xType = it.getPojoType();
            Object object = entityTypeElement = xType != null ? xType.getTypeElement() : null;
            if (entityTypeElement == null) {
                this.context.getLogger().e((XElement)it.getElement(), "Type of the parameter must be a class annotated with @Entity or a collection/array of it.", new Object[0]);
                pair = null;
            } else {
                ShortcutFunctionProcessor this_$iv = this;
                boolean $i$f$processEntity = false;
                if (!Xelement_extKt.isEntityElement((XElement)entityTypeElement)) {
                    boolean bl3 = false;
                    this.context.getLogger().e((XElement)it.getElement(), "Type of the parameter must be a class annotated with @Entity or a collection/array of it.", new Object[0]);
                    pair = null;
                } else {
                    Entity entity = EntityProcessorKt.EntityProcessor$default(this_$iv.context, entityTypeElement, null, 4, null).process();
                    String string = it.getName();
                    Entity entity2 = entity;
                    Intrinsics.checkNotNull((Object)entity2);
                    pair = TuplesKt.to((Object)string, (Object)new ShortcutEntity(entity2, null));
                }
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    private final Entity processEntity(XTypeElement element, Function0<Unit> onInvalid) {
        Entity entity;
        boolean $i$f$processEntity = false;
        if (Xelement_extKt.isEntityElement((XElement)element)) {
            entity = EntityProcessorKt.EntityProcessor$default(this.context, element, null, 4, null).process();
        } else {
            onInvalid.invoke();
            entity = null;
        }
        return entity;
    }

    @NotNull
    public final InsertOrUpsertFunctionBinder findInsertFunctionBinder(@NotNull XType returnType, @NotNull List<ShortcutQueryParameter> params) {
        Intrinsics.checkNotNullParameter((Object)returnType, (String)"returnType");
        Intrinsics.checkNotNullParameter(params, (String)"params");
        return this.delegate.findInsertFunctionBinder(returnType, params);
    }

    @NotNull
    public final InsertOrUpsertFunctionBinder findUpsertFunctionBinder(@NotNull XType returnType, @NotNull List<ShortcutQueryParameter> params) {
        Intrinsics.checkNotNullParameter((Object)returnType, (String)"returnType");
        Intrinsics.checkNotNullParameter(params, (String)"params");
        return this.delegate.findUpsertFunctionBinder(returnType, params);
    }

    @NotNull
    public final DeleteOrUpdateFunctionBinder findDeleteOrUpdateFunctionBinder(@NotNull XType returnType) {
        Intrinsics.checkNotNullParameter((Object)returnType, (String)"returnType");
        return this.delegate.findDeleteOrUpdateFunctionBinder(returnType);
    }
}

