/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.processor;

import androidx.room.MapInfo;
import androidx.room.RawQuery;
import androidx.room.Transaction;
import androidx.room.compiler.codegen.XTypeName;
import androidx.room.compiler.processing.XAnnotation;
import androidx.room.compiler.processing.XElement;
import androidx.room.compiler.processing.XMethodElement;
import androidx.room.compiler.processing.XNullability;
import androidx.room.compiler.processing.XProcessingEnv;
import androidx.room.compiler.processing.XType;
import androidx.room.compiler.processing.XTypeElement;
import androidx.room.compiler.processing.XVariableElement;
import androidx.room.ext.RoomTypeNames;
import androidx.room.ext.SupportDbTypeNames;
import androidx.room.ext.Xelement_extKt;
import androidx.room.parser.ParsedQuery;
import androidx.room.parser.SqlParser;
import androidx.room.preconditions.Checks;
import androidx.room.processor.Context;
import androidx.room.processor.DataClassProcessor;
import androidx.room.processor.EntityProcessorKt;
import androidx.room.processor.FunctionProcessorDelegate;
import androidx.room.processor.FunctionProcessorDelegateKt;
import androidx.room.processor.ProcessorErrors;
import androidx.room.processor.PropertyProcessor;
import androidx.room.solver.TypeAdapterExtras;
import androidx.room.solver.query.result.QueryResultBinder;
import androidx.room.vo.DataClass;
import androidx.room.vo.Entity;
import androidx.room.vo.RawQueryFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\u0018\u0010\u0016\u001a\u0004\u0018\u00010\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Landroidx/room/processor/RawQueryFunctionProcessor;", "", "baseContext", "Landroidx/room/processor/Context;", "containing", "Landroidx/room/compiler/processing/XType;", "executableElement", "Landroidx/room/compiler/processing/XMethodElement;", "<init>", "(Landroidx/room/processor/Context;Landroidx/room/compiler/processing/XType;Landroidx/room/compiler/processing/XMethodElement;)V", "getContaining", "()Landroidx/room/compiler/processing/XType;", "getExecutableElement", "()Landroidx/room/compiler/processing/XMethodElement;", "context", "getContext", "()Landroidx/room/processor/Context;", "process", "Landroidx/room/vo/RawQueryFunction;", "processObservedTables", "", "", "findRuntimeQueryParameter", "Landroidx/room/vo/RawQueryFunction$RuntimeQueryParameter;", "extractParams", "", "Landroidx/room/compiler/processing/XVariableElement;", "room-compiler"})
@SourceDebugExtension(value={"SMAP\nRawQueryFunctionProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RawQueryFunctionProcessor.kt\nandroidx/room/processor/RawQueryFunctionProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,199:1\n1611#2,9:200\n1863#2:209\n1864#2:211\n1620#2:212\n1368#2:213\n1454#2,5:214\n1#3:210\n*S KotlinDebug\n*F\n+ 1 RawQueryFunctionProcessor.kt\nandroidx/room/processor/RawQueryFunctionProcessor\n*L\n118#1:200,9\n118#1:209\n118#1:211\n118#1:212\n125#1:213\n125#1:214,5\n118#1:210\n*E\n"})
public final class RawQueryFunctionProcessor {
    @NotNull
    private final XType containing;
    @NotNull
    private final XMethodElement executableElement;
    @NotNull
    private final Context context;

    public RawQueryFunctionProcessor(@NotNull Context baseContext, @NotNull XType containing, @NotNull XMethodElement executableElement) {
        Intrinsics.checkNotNullParameter((Object)baseContext, (String)"baseContext");
        Intrinsics.checkNotNullParameter((Object)containing, (String)"containing");
        Intrinsics.checkNotNullParameter((Object)executableElement, (String)"executableElement");
        this.containing = containing;
        this.executableElement = executableElement;
        this.context = Context.fork$default(baseContext, (XElement)this.executableElement, null, null, 6, null);
    }

    @NotNull
    public final XType getContaining() {
        return this.containing;
    }

    @NotNull
    public final XMethodElement getExecutableElement() {
        return this.executableElement;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final RawQueryFunction process() {
        FunctionProcessorDelegate delegate = FunctionProcessorDelegate.Companion.createFor(this.context, this.containing, this.executableElement);
        XType returnType = delegate.extractReturnType();
        this.context.getChecker().check(this.executableElement.hasAnnotation(Reflection.getOrCreateKotlinClass(RawQuery.class)), (XElement)this.executableElement, ProcessorErrors.INSTANCE.getMISSING_RAWQUERY_ANNOTATION(), new Object[0]);
        this.context.getChecker().notUnbound(returnType, (XElement)this.executableElement, "Cannot use unbound generics in query functions. It must be bound to a type through base Dao class.", new Object[0]);
        boolean returnsDeferredType = FunctionProcessorDelegateKt.returnsDeferredType(delegate);
        boolean isSuspendFunction = delegate.getExecutableElement().isSuspendFunction();
        Checks checks = this.context.getChecker();
        boolean bl = !isSuspendFunction || !returnsDeferredType;
        XElement xElement = (XElement)this.executableElement;
        String string = returnType.getRawType().getTypeName().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        checks.check(bl, xElement, ProcessorErrors.INSTANCE.suspendReturnsDeferredType(string), new Object[0]);
        if (!(isSuspendFunction || returnsDeferredType || this.context.isAndroidOnlyTarget())) {
            this.context.getLogger().e((XElement)this.executableElement, "Only suspend functions are allowed in DAOs declared in source sets targeting non-Android platforms.", new Object[0]);
        }
        Set<String> observedTableNames = this.processObservedTables();
        ParsedQuery query = SqlParser.Companion.rawQueryForTables(observedTableNames);
        QueryResultBinder resultBinder = delegate.findResultBinder(returnType, query, (Function1<? super TypeAdapterExtras, Unit>)((Function1)arg_0 -> RawQueryFunctionProcessor.process$lambda$0(delegate, this, arg_0)));
        RawQueryFunction.RuntimeQueryParameter runtimeQueryParam = this.findRuntimeQueryParameter(delegate.extractParams());
        boolean inTransaction = this.executableElement.hasAnnotation(Reflection.getOrCreateKotlinClass(Transaction.class));
        XMethodElement xMethodElement = this.executableElement;
        RawQueryFunction rawQueryFunction = new RawQueryFunction(xMethodElement, returnType, inTransaction, observedTableNames, runtimeQueryParam, resultBinder);
        this.context.getChecker().check(rawQueryFunction.getReturnsValue(), (XElement)this.executableElement, "RawQuery functions must return a non-void type.", new Object[0]);
        return rawQueryFunction;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> processObservedTables() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        XAnnotation annotation = this.executableElement.getAnnotation(Reflection.getOrCreateKotlinClass(RawQuery.class));
        Object object = annotation;
        if (object == null || (object = object.get("observedEntities")) == null || (object = object.asTypeList()) == null) {
            object = CollectionsKt.emptyList();
        }
        Object observedEntities = object;
        Iterable $this$mapNotNull$iv = (Iterable)observedEntities;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            XTypeElement it$iv$iv;
            XTypeElement xTypeElement;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl5 = false;
            XType it = (XType)element$iv$iv;
            boolean bl2 = false;
            XTypeElement typeElement = xTypeElement = it.getTypeElement();
            boolean bl3 = false;
            if (typeElement == null) {
                this.context.getLogger().e((XElement)this.executableElement, "The class must be either @Entity or @DatabaseView.", new Object[0]);
            }
            if (xTypeElement == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$mapNotNullTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list;
            XTypeElement it = (XTypeElement)element$iv$iv;
            boolean bl = false;
            if (Xelement_extKt.isEntityElement((XElement)it)) {
                Entity entity = EntityProcessorKt.EntityProcessor$default(this.context, it, null, 4, null).process();
                Object[] bl5 = new String[]{entity.getTableName()};
                list = CollectionsKt.arrayListOf((Object[])bl5);
            } else {
                DataClass pojo = DataClassProcessor.Companion.createFor$default(DataClassProcessor.Companion, this.context, it, PropertyProcessor.BindingScope.READ_FROM_STMT, null, null, 16, null).process();
                List tableNames = pojo.accessedTableNames();
                if (tableNames.isEmpty()) {
                    this.context.getLogger().e((XElement)this.executableElement, ProcessorErrors.INSTANCE.rawQueryBadEntity(it.getType().asTypeName().toString(this.context.getCodeLanguage())), new Object[0]);
                }
                list = tableNames;
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private final RawQueryFunction.RuntimeQueryParameter findRuntimeQueryParameter(List<? extends XVariableElement> extractParams) {
        if (extractParams.size() == 1 && !this.executableElement.isVarArgs()) {
            boolean isString;
            XType param = ((XVariableElement)CollectionsKt.first(extractParams)).asMemberOf(this.containing);
            XProcessingEnv processingEnv = this.context.getProcessingEnv();
            if (param.getNullability() == XNullability.NULLABLE) {
                this.context.getLogger().e((XElement)CollectionsKt.first(extractParams), ProcessorErrors.INSTANCE.parameterCannotBeNullable(((XVariableElement)CollectionsKt.first(extractParams)).getName()), new Object[0]);
            }
            XType xType = processingEnv.findType((XTypeName)RoomTypeNames.INSTANCE.getRAW_QUERY());
            if (xType != null) {
                XType rawQueryType = xType;
                boolean bl = false;
                if (rawQueryType.isAssignableFrom(param)) {
                    return new RawQueryFunction.RuntimeQueryParameter(extractParams.get(0).getName(), rawQueryType.asTypeName());
                }
            }
            XType xType2 = processingEnv.findType((XTypeName)SupportDbTypeNames.INSTANCE.getQUERY());
            if (xType2 != null) {
                XType supportQueryType = xType2;
                boolean bl = false;
                if (supportQueryType.isAssignableFrom(param)) {
                    return new RawQueryFunction.RuntimeQueryParameter(extractParams.get(0).getName(), supportQueryType.asTypeName());
                }
            }
            if (isString = processingEnv.requireType(Reflection.getOrCreateKotlinClass(String.class)).isAssignableFrom(param)) {
                this.context.getLogger().e((XElement)this.executableElement, ProcessorErrors.INSTANCE.getRAW_QUERY_STRING_PARAMETER_REMOVED(), new Object[0]);
                return null;
            }
        }
        this.context.getLogger().e((XElement)this.executableElement, "RawQuery functions should have 1 and only 1 parameter with type SupportSQLiteQuery", new Object[0]);
        return null;
    }

    private static final Unit process$lambda$0(FunctionProcessorDelegate $delegate, RawQueryFunctionProcessor this$0, TypeAdapterExtras $this$findResultBinder) {
        Intrinsics.checkNotNullParameter((Object)$this$findResultBinder, (String)"$this$findResultBinder");
        XAnnotation annotation = $delegate.getExecutableElement().getAnnotation(Reflection.getOrCreateKotlinClass(MapInfo.class));
        if (annotation != null) {
            Object object;
            Object keyColumn;
            Object object2 = annotation.get("keyColumn");
            if (object2 == null || (object2 = object2.asString()) == null) {
                object2 = keyColumn = "";
            }
            if ((object = annotation.get("valueColumn")) == null || (object = object.asString()) == null) {
                object = "";
            }
            Object valueColumn = object;
            this$0.context.getChecker().check(((CharSequence)keyColumn).length() > 0 || ((CharSequence)valueColumn).length() > 0, (XElement)this$0.executableElement, "To use the @MapInfo annotation, you must provide either the key column name, value column name, or both.", new Object[0]);
            $this$findResultBinder.putData(Reflection.getOrCreateKotlinClass(androidx.room.vo.MapInfo.class), new androidx.room.vo.MapInfo((String)keyColumn, (String)valueColumn));
        }
        return Unit.INSTANCE;
    }
}

