/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.processor;

import androidx.room.compiler.processing.XElement;
import androidx.room.compiler.processing.XExecutableParameterElement;
import androidx.room.compiler.processing.XType;
import androidx.room.parser.Section;
import androidx.room.processor.Context;
import androidx.room.solver.query.parameter.QueryParameterAdapter;
import androidx.room.vo.QueryParameter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0006\u0010\u0015\u001a\u00020\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0017"}, d2={"Landroidx/room/processor/QueryParameterProcessor;", "", "baseContext", "Landroidx/room/processor/Context;", "containing", "Landroidx/room/compiler/processing/XType;", "element", "Landroidx/room/compiler/processing/XExecutableParameterElement;", "sqlName", "", "bindVarSection", "Landroidx/room/parser/Section$BindVar;", "<init>", "(Landroidx/room/processor/Context;Landroidx/room/compiler/processing/XType;Landroidx/room/compiler/processing/XExecutableParameterElement;Ljava/lang/String;Landroidx/room/parser/Section$BindVar;)V", "getContaining", "()Landroidx/room/compiler/processing/XType;", "getElement", "()Landroidx/room/compiler/processing/XExecutableParameterElement;", "context", "getContext", "()Landroidx/room/processor/Context;", "process", "Landroidx/room/vo/QueryParameter;", "room-compiler"})
public final class QueryParameterProcessor {
    @NotNull
    private final XType containing;
    @NotNull
    private final XExecutableParameterElement element;
    @NotNull
    private final String sqlName;
    @Nullable
    private final Section.BindVar bindVarSection;
    @NotNull
    private final Context context;

    public QueryParameterProcessor(@NotNull Context baseContext, @NotNull XType containing, @NotNull XExecutableParameterElement element, @NotNull String sqlName, @Nullable Section.BindVar bindVarSection) {
        Intrinsics.checkNotNullParameter((Object)baseContext, (String)"baseContext");
        Intrinsics.checkNotNullParameter((Object)containing, (String)"containing");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)sqlName, (String)"sqlName");
        this.containing = containing;
        this.element = element;
        this.sqlName = sqlName;
        this.bindVarSection = bindVarSection;
        this.context = Context.fork$default(baseContext, (XElement)this.element, null, null, 6, null);
    }

    @NotNull
    public final XType getContaining() {
        return this.containing;
    }

    @NotNull
    public final XExecutableParameterElement getElement() {
        return this.element;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final QueryParameter process() {
        XType asMember = this.element.asMemberOf(this.containing);
        Section.BindVar bindVar = this.bindVarSection;
        QueryParameterAdapter parameterAdapter = this.context.getTypeAdapterStore().findQueryParameterAdapter(asMember, bindVar != null ? bindVar.isMultiple() : false);
        this.context.getChecker().check(parameterAdapter != null, (XElement)this.element, "Query function parameters should either be a type that can be converted into a database column or a List / Array that contains such type. You can consider adding a Type Adapter for this.", new Object[0]);
        String name = this.element.getName();
        this.context.getChecker().check(!StringsKt.startsWith$default((String)name, (String)"_", (boolean)false, (int)2, null), (XElement)this.element, "Query/Insert function parameters cannot start with underscore (_).", new Object[0]);
        return new QueryParameter(name, this.sqlName, asMember, parameterAdapter);
    }
}

