/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.processor;

import androidx.room.Query;
import androidx.room.compiler.processing.XAnnotation;
import androidx.room.compiler.processing.XElement;
import androidx.room.compiler.processing.XMethodElement;
import androidx.room.compiler.processing.XType;
import androidx.room.log.RLog;
import androidx.room.parser.ParsedQuery;
import androidx.room.processor.Context;
import androidx.room.processor.InternalQueryProcessor;
import androidx.room.processor.ProcessorErrors;
import androidx.room.solver.query.result.QueryResultAdapter;
import androidx.room.verifier.DatabaseVerifier;
import androidx.room.vo.QueryFunction;
import androidx.room.vo.ReadQueryFunction;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u0015\u001a\u00020\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0017"}, d2={"Landroidx/room/processor/QueryFunctionProcessor;", "", "baseContext", "Landroidx/room/processor/Context;", "containing", "Landroidx/room/compiler/processing/XType;", "executableElement", "Landroidx/room/compiler/processing/XMethodElement;", "dbVerifier", "Landroidx/room/verifier/DatabaseVerifier;", "<init>", "(Landroidx/room/processor/Context;Landroidx/room/compiler/processing/XType;Landroidx/room/compiler/processing/XMethodElement;Landroidx/room/verifier/DatabaseVerifier;)V", "getContaining", "()Landroidx/room/compiler/processing/XType;", "getExecutableElement", "()Landroidx/room/compiler/processing/XMethodElement;", "getDbVerifier", "()Landroidx/room/verifier/DatabaseVerifier;", "context", "getContext", "()Landroidx/room/processor/Context;", "process", "Landroidx/room/vo/QueryFunction;", "room-compiler"})
public final class QueryFunctionProcessor {
    @NotNull
    private final XType containing;
    @NotNull
    private final XMethodElement executableElement;
    @Nullable
    private final DatabaseVerifier dbVerifier;
    @NotNull
    private final Context context;

    public QueryFunctionProcessor(@NotNull Context baseContext, @NotNull XType containing, @NotNull XMethodElement executableElement, @Nullable DatabaseVerifier dbVerifier) {
        Intrinsics.checkNotNullParameter((Object)baseContext, (String)"baseContext");
        Intrinsics.checkNotNullParameter((Object)containing, (String)"containing");
        Intrinsics.checkNotNullParameter((Object)executableElement, (String)"executableElement");
        this.containing = containing;
        this.executableElement = executableElement;
        this.dbVerifier = dbVerifier;
        this.context = Context.fork$default(baseContext, (XElement)this.executableElement, null, null, 6, null);
    }

    public /* synthetic */ QueryFunctionProcessor(Context context, XType xType, XMethodElement xMethodElement, DatabaseVerifier databaseVerifier, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            databaseVerifier = null;
        }
        this(context, xType, xMethodElement, databaseVerifier);
    }

    @NotNull
    public final XType getContaining() {
        return this.containing;
    }

    @NotNull
    public final XMethodElement getExecutableElement() {
        return this.executableElement;
    }

    @Nullable
    public final DatabaseVerifier getDbVerifier() {
        return this.dbVerifier;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final QueryFunction process() {
        QueryFunction finalResult;
        RLog.CollectingMessager logs;
        QueryFunction initialResult;
        block8: {
            QueryFunction queryFunction;
            block5: {
                Object finalQuery;
                Object object;
                ParsedQuery originalQuery;
                block7: {
                    block6: {
                        XAnnotation annotation = this.executableElement.getAnnotation(Reflection.getOrCreateKotlinClass(Query.class));
                        this.context.getChecker().check(annotation != null, (XElement)this.executableElement, ProcessorErrors.INSTANCE.getMISSING_QUERY_ANNOTATION(), new Object[0]);
                        Pair pair = this.context.collectLogs(arg_0 -> QueryFunctionProcessor.process$lambda$0(this, annotation, arg_0));
                        initialResult = (QueryFunction)pair.component1();
                        logs = (RLog.CollectingMessager)((Object)pair.component2());
                        if (!(initialResult instanceof ReadQueryFunction)) break block5;
                        QueryResultAdapter resultAdapter = ((ReadQueryFunction)initialResult).getQueryResultBinder().getAdapter();
                        originalQuery = initialResult.getQuery();
                        object = resultAdapter;
                        if (object == null) break block6;
                        QueryResultAdapter it = object;
                        boolean bl = false;
                        ParsedQuery parsedQuery = this.context.getQueryRewriter().rewrite(originalQuery, resultAdapter);
                        object = parsedQuery;
                        if (parsedQuery != null) break block7;
                    }
                    object = originalQuery;
                }
                if (!Intrinsics.areEqual((Object)(finalQuery = object), (Object)originalQuery)) {
                    Context context = this.context;
                    XMethodElement xMethodElement = this.executableElement;
                    DatabaseVerifier databaseVerifier = this.dbVerifier;
                    XType xType = this.containing;
                    return new InternalQueryProcessor(context, xMethodElement, xType, databaseVerifier).processQuery(((ParsedQuery)finalQuery).getOriginal());
                }
                queryFunction = (ReadQueryFunction)initialResult;
                break block8;
            }
            queryFunction = finalResult = initialResult;
        }
        if (Intrinsics.areEqual((Object)finalResult, (Object)initialResult)) {
            RLog.CollectingMessager.writeTo$default(logs, this.context, null, 2, null);
        }
        return finalResult;
    }

    private static final QueryFunction process$lambda$0(QueryFunctionProcessor this$0, XAnnotation $annotation, Context it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        XMethodElement xMethodElement = this$0.executableElement;
        DatabaseVerifier databaseVerifier = this$0.dbVerifier;
        XType xType = this$0.containing;
        XAnnotation xAnnotation = $annotation;
        return new InternalQueryProcessor(it, xMethodElement, xType, databaseVerifier).processQuery(xAnnotation != null ? xAnnotation.getAsString("value") : null);
    }
}

