/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.processor;

import androidx.room.ColumnInfo;
import androidx.room.compiler.codegen.CodeLanguage;
import androidx.room.compiler.processing.XAnnotation;
import androidx.room.compiler.processing.XElement;
import androidx.room.compiler.processing.XFieldElement;
import androidx.room.compiler.processing.XType;
import androidx.room.compiler.processing.XTypeElement;
import androidx.room.parser.Collate;
import androidx.room.parser.SQLTypeAffinity;
import androidx.room.processor.Context;
import androidx.room.processor.PropertyProcessorKt;
import androidx.room.solver.types.ColumnTypeAdapter;
import androidx.room.vo.EmbeddedProperty;
import androidx.room.vo.Property;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001+Bi\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00126\u0010\f\u001a2\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u00140\r\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0006\u0010$\u001a\u00020\u000eJ&\u0010%\u001a\u0004\u0018\u00010\u00122\b\u0010&\u001a\u0004\u0018\u00010\u00122\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020*H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eRA\u0010\f\u001a2\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u00140\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u0006,"}, d2={"Landroidx/room/processor/PropertyProcessor;", "", "baseContext", "Landroidx/room/processor/Context;", "containing", "Landroidx/room/compiler/processing/XType;", "element", "Landroidx/room/compiler/processing/XFieldElement;", "bindingScope", "Landroidx/room/processor/PropertyProcessor$BindingScope;", "propertyParent", "Landroidx/room/vo/EmbeddedProperty;", "onBindingError", "Lkotlin/Function2;", "Landroidx/room/vo/Property;", "Lkotlin/ParameterName;", "name", "property", "", "errorMsg", "", "<init>", "(Landroidx/room/processor/Context;Landroidx/room/compiler/processing/XType;Landroidx/room/compiler/processing/XFieldElement;Landroidx/room/processor/PropertyProcessor$BindingScope;Landroidx/room/vo/EmbeddedProperty;Lkotlin/jvm/functions/Function2;)V", "getContaining", "()Landroidx/room/compiler/processing/XType;", "getElement", "()Landroidx/room/compiler/processing/XFieldElement;", "getBindingScope", "()Landroidx/room/processor/PropertyProcessor$BindingScope;", "getPropertyParent", "()Landroidx/room/vo/EmbeddedProperty;", "getOnBindingError", "()Lkotlin/jvm/functions/Function2;", "context", "getContext", "()Landroidx/room/processor/Context;", "process", "extractDefaultValue", "value", "affinity", "Landroidx/room/parser/SQLTypeAffinity;", "propertyNonNull", "", "BindingScope", "room-compiler"})
public final class PropertyProcessor {
    @NotNull
    private final XType containing;
    @NotNull
    private final XFieldElement element;
    @NotNull
    private final BindingScope bindingScope;
    @Nullable
    private final EmbeddedProperty propertyParent;
    @NotNull
    private final Function2<Property, String, Unit> onBindingError;
    @NotNull
    private final Context context;

    public PropertyProcessor(@NotNull Context baseContext, @NotNull XType containing, @NotNull XFieldElement element, @NotNull BindingScope bindingScope, @Nullable EmbeddedProperty propertyParent, @NotNull Function2<? super Property, ? super String, Unit> onBindingError) {
        Intrinsics.checkNotNullParameter((Object)baseContext, (String)"baseContext");
        Intrinsics.checkNotNullParameter((Object)containing, (String)"containing");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)((Object)bindingScope), (String)"bindingScope");
        Intrinsics.checkNotNullParameter(onBindingError, (String)"onBindingError");
        this.containing = containing;
        this.element = element;
        this.bindingScope = bindingScope;
        this.propertyParent = propertyParent;
        this.onBindingError = onBindingError;
        this.context = Context.fork$default(baseContext, (XElement)this.element, null, null, 6, null);
    }

    @NotNull
    public final XType getContaining() {
        return this.containing;
    }

    @NotNull
    public final XFieldElement getElement() {
        return this.element;
    }

    @NotNull
    public final BindingScope getBindingScope() {
        return this.bindingScope;
    }

    @Nullable
    public final EmbeddedProperty getPropertyParent() {
        return this.propertyParent;
    }

    @NotNull
    public final Function2<Property, String, Unit> getOnBindingError() {
        return this.onBindingError;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final Property process() {
        SQLTypeAffinity affinityInt22;
        XType member = this.element.asMemberOf(this.containing);
        XAnnotation columnInfoAnnotation = this.element.getAnnotation(Reflection.getOrCreateKotlinClass(ColumnInfo.class));
        String elementName = this.element.getName();
        XAnnotation xAnnotation = columnInfoAnnotation;
        String annotationColumnName = xAnnotation != null && (xAnnotation = xAnnotation.get("name")) != null ? xAnnotation.asString() : null;
        String rawCName = annotationColumnName != null && !Intrinsics.areEqual((Object)annotationColumnName, (Object)"[field-name]") ? annotationColumnName : elementName;
        Object object = this.propertyParent;
        if (object == null || (object = ((EmbeddedProperty)object).getPrefix()) == null) {
            object = "";
        }
        String columnName = (String)object + rawCName;
        try {
            XAnnotation xAnnotation2 = columnInfoAnnotation;
            int affinityInt22 = xAnnotation2 != null && (xAnnotation2 = xAnnotation2.get("typeAffinity")) != null ? xAnnotation2.asInt() : 1;
            affinityInt22 = SQLTypeAffinity.Companion.fromAnnotationValue(affinityInt22);
        }
        catch (NumberFormatException ex) {
            affinityInt22 = null;
        }
        SQLTypeAffinity affinity = affinityInt22;
        this.context.getChecker().notBlank(columnName, (XElement)this.element, "Column name cannot be blank. If you don't want to set it, just remove the @ColumnInfo annotation or use @ColumnInfo.INHERIT_PROPERTY_NAME.", new Object[0]);
        this.context.getChecker().notUnbound(member, (XElement)this.element, "Cannot use unbound properties in entities.", new Object[0]);
        ColumnTypeAdapter adapter = this.context.getTypeAdapterStore().findColumnTypeAdapter(member, affinity, false);
        Object object2 = adapter;
        if (object2 == null || (object2 = object2.getTypeAffinity()) == null) {
            object2 = affinity;
        }
        Object adapterAffinity = object2;
        boolean nonNull = Property.Companion.calcNonNull(member, this.propertyParent);
        XAnnotation xAnnotation3 = columnInfoAnnotation;
        int collateInt = xAnnotation3 != null && (xAnnotation3 = xAnnotation3.get("collate")) != null ? xAnnotation3.asInt() : 1;
        XFieldElement xFieldElement = this.element;
        Collate collate = Collate.Companion.fromAnnotationValue(collateInt);
        XAnnotation xAnnotation4 = columnInfoAnnotation;
        String string = this.extractDefaultValue(xAnnotation4 != null && (xAnnotation4 = xAnnotation4.get("defaultValue")) != null ? xAnnotation4.asString() : null, (SQLTypeAffinity)((Object)adapterAffinity), nonNull);
        EmbeddedProperty embeddedProperty = this.propertyParent;
        XAnnotation xAnnotation5 = columnInfoAnnotation;
        boolean bl = xAnnotation5 != null && (xAnnotation5 = xAnnotation5.get("index")) != null ? xAnnotation5.asBoolean() : false;
        Property property = new Property(xFieldElement, elementName, member, affinity, collate, columnName, string, embeddedProperty, bl, nonNull);
        XTypeElement xTypeElement = member.getTypeElement();
        boolean bl2 = xTypeElement != null ? xTypeElement.isValueClass() : false;
        if (bl2 && this.context.getCodeLanguage() != CodeLanguage.KOTLIN) {
            this.onBindingError.invoke((Object)property, (Object)"Kotlin value classes are only supported in Room using KSP and generating Kotlin (room.generateKotlin=true).");
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.bindingScope.ordinal()]) {
            case 1: {
                property.setStatementBinder(adapter);
                property.setStatementValueReader(adapter);
                property.setAffinity((SQLTypeAffinity)((Object)adapterAffinity));
                if (adapter != null) break;
                this.onBindingError.invoke((Object)property, (Object)"Cannot figure out how to save this property into database. You can consider adding a type converter for it.");
                break;
            }
            case 2: {
                property.setStatementBinder(this.context.getTypeAdapterStore().findStatementValueBinder(property.getType(), property.getAffinity()));
                if (property.getStatementBinder() != null) break;
                this.onBindingError.invoke((Object)property, (Object)"Cannot figure out how to bind this property into a statement.");
                break;
            }
            case 3: {
                property.setStatementValueReader(this.context.getTypeAdapterStore().findStatementValueReader(property.getType(), property.getAffinity()));
                if (property.getStatementValueReader() != null) break;
                this.onBindingError.invoke((Object)property, (Object)"Cannot figure out how to read this property from a statement.");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return property;
    }

    private final String extractDefaultValue(String value, SQLTypeAffinity affinity, boolean propertyNonNull) {
        String defaultValue;
        if (value == null) {
            return null;
        }
        String string = ((Object)StringsKt.trim((CharSequence)value)).toString();
        Locale locale = Locale.ENGLISH;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String trimmed = string2;
        if (affinity == SQLTypeAffinity.TEXT) {
            if (Intrinsics.areEqual((Object)value, (Object)"[value-unspecified]")) {
                v2 = null;
            } else if (StringsKt.startsWith$default((String)trimmed, (String)"(", (boolean)false, (int)2, null) || PropertyProcessorKt.getSQLITE_VALUE_CONSTANTS().contains(trimmed)) {
                v2 = value;
            } else {
                char[] cArray = new char[]{'\''};
                v2 = "'" + StringsKt.trim((String)value, (char[])cArray) + "'";
            }
        } else {
            v2 = defaultValue = Intrinsics.areEqual((Object)value, (Object)"[value-unspecified]") || Intrinsics.areEqual((Object)trimmed, (Object)"") ? null : value;
        }
        if (Intrinsics.areEqual((Object)trimmed, (Object)"null") && propertyNonNull) {
            this.context.getLogger().e((XElement)this.element, "Use of NULL as the default value of a non-null property", new Object[0]);
        }
        return defaultValue;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/room/processor/PropertyProcessor$BindingScope;", "", "<init>", "(Ljava/lang/String;I)V", "TWO_WAY", "BIND_TO_STMT", "READ_FROM_STMT", "room-compiler"})
    public static final class BindingScope
    extends Enum<BindingScope> {
        public static final /* enum */ BindingScope TWO_WAY = new BindingScope();
        public static final /* enum */ BindingScope BIND_TO_STMT = new BindingScope();
        public static final /* enum */ BindingScope READ_FROM_STMT = new BindingScope();
        private static final /* synthetic */ BindingScope[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static BindingScope[] values() {
            return (BindingScope[])$VALUES.clone();
        }

        public static BindingScope valueOf(String value) {
            return Enum.valueOf(BindingScope.class, value);
        }

        @NotNull
        public static EnumEntries<BindingScope> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = bindingScopeArray = new BindingScope[]{BindingScope.TWO_WAY, BindingScope.BIND_TO_STMT, BindingScope.READ_FROM_STMT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BindingScope.values().length];
            try {
                nArray[BindingScope.TWO_WAY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BindingScope.BIND_TO_STMT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BindingScope.READ_FROM_STMT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

