/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.processor;

import androidx.room.MapInfo;
import androidx.room.SkipQueryVerification;
import androidx.room.Transaction;
import androidx.room.compiler.processing.XAnnotation;
import androidx.room.compiler.processing.XElement;
import androidx.room.compiler.processing.XMethodElement;
import androidx.room.compiler.processing.XType;
import androidx.room.ext.Xtype_extKt;
import androidx.room.log.RLog;
import androidx.room.parser.ParsedQuery;
import androidx.room.parser.QueryType;
import androidx.room.parser.Section;
import androidx.room.parser.SqlParser;
import androidx.room.parser.Table;
import androidx.room.preconditions.Checks;
import androidx.room.processor.Context;
import androidx.room.processor.FunctionProcessorDelegate;
import androidx.room.processor.FunctionProcessorDelegateKt;
import androidx.room.processor.ProcessorErrors;
import androidx.room.solver.TypeAdapterExtras;
import androidx.room.solver.prepared.binder.PreparedQueryResultBinder;
import androidx.room.solver.query.result.DataClassRowAdapter;
import androidx.room.solver.query.result.QueryMappedRowAdapter;
import androidx.room.solver.query.result.QueryResultAdapter;
import androidx.room.solver.query.result.QueryResultBinder;
import androidx.room.solver.query.result.RowAdapter;
import androidx.room.verifier.ColumnInfo;
import androidx.room.verifier.DatabaseVerificationErrors;
import androidx.room.verifier.DatabaseVerifier;
import androidx.room.verifier.QueryResultInfo;
import androidx.room.vo.QueryFunction;
import androidx.room.vo.QueryParameter;
import androidx.room.vo.ReadQueryFunction;
import androidx.room.vo.Warning;
import androidx.room.vo.WriteQueryFunction;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 *2\u00020\u0001:\u0001*B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0015H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J \u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J \u0010#\u001a\u00020\u00152\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J(\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020)H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006+"}, d2={"Landroidx/room/processor/InternalQueryProcessor;", "", "context", "Landroidx/room/processor/Context;", "executableElement", "Landroidx/room/compiler/processing/XMethodElement;", "containing", "Landroidx/room/compiler/processing/XType;", "dbVerifier", "Landroidx/room/verifier/DatabaseVerifier;", "<init>", "(Landroidx/room/processor/Context;Landroidx/room/compiler/processing/XMethodElement;Landroidx/room/compiler/processing/XType;Landroidx/room/verifier/DatabaseVerifier;)V", "getContext", "()Landroidx/room/processor/Context;", "getExecutableElement", "()Landroidx/room/compiler/processing/XMethodElement;", "getContaining", "()Landroidx/room/compiler/processing/XType;", "getDbVerifier", "()Landroidx/room/verifier/DatabaseVerifier;", "processQuery", "Landroidx/room/vo/QueryFunction;", "input", "", "processQueryFunction", "queryFunction", "validateQuery", "", "query", "Landroidx/room/parser/ParsedQuery;", "getPreparedQueryFunction", "Landroidx/room/vo/WriteQueryFunction;", "delegate", "Landroidx/room/processor/FunctionProcessorDelegate;", "returnType", "getQueryFunction", "processMapInfo", "mapInfoAnnotation", "Landroidx/room/compiler/processing/XAnnotation;", "queryExecutableElement", "adapterExtras", "Landroidx/room/solver/TypeAdapterExtras;", "Companion", "room-compiler"})
@SourceDebugExtension(value={"SMAP\nQueryFunctionProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QueryFunctionProcessor.kt\nandroidx/room/processor/InternalQueryProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,389:1\n774#2:390\n865#2,2:391\n1557#2:393\n1628#2,3:394\n827#2:397\n855#2:398\n1755#2,3:399\n856#2:402\n1557#2:403\n1628#2,3:404\n1755#2,3:407\n2632#2,3:410\n1368#2:413\n1454#2,5:414\n1557#2:419\n1628#2,3:420\n808#2,11:423\n774#2:434\n865#2,2:435\n1187#2,2:437\n1261#2,4:439\n1557#2:443\n1628#2,3:444\n1187#2,2:448\n1261#2,4:450\n1755#2,3:454\n1557#2:457\n1628#2,3:458\n1557#2:461\n1628#2,3:462\n1#3:447\n*S KotlinDebug\n*F\n+ 1 QueryFunctionProcessor.kt\nandroidx/room/processor/InternalQueryProcessor\n*L\n175#1:390\n175#1:391,2\n175#1:393\n175#1:394,3\n185#1:397\n185#1:398\n186#1:399,3\n185#1:402\n188#1:403\n188#1:404,3\n262#1:407,3\n279#1:410,3\n283#1:413\n283#1:414,5\n284#1:419\n284#1:420,3\n287#1:423,11\n290#1:434\n290#1:435,2\n291#1:437,2\n291#1:439,4\n298#1:443\n298#1:444,3\n337#1:448,2\n337#1:450,4\n342#1:454,3\n366#1:457\n366#1:458,3\n376#1:461\n376#1:462,3\n*E\n"})
final class InternalQueryProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final XMethodElement executableElement;
    @NotNull
    private final XType containing;
    @Nullable
    private final DatabaseVerifier dbVerifier;
    @NotNull
    private static final QueryType[] PREPARED_TYPES;

    public InternalQueryProcessor(@NotNull Context context, @NotNull XMethodElement executableElement, @NotNull XType containing, @Nullable DatabaseVerifier dbVerifier) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)executableElement, (String)"executableElement");
        Intrinsics.checkNotNullParameter((Object)containing, (String)"containing");
        this.context = context;
        this.executableElement = executableElement;
        this.containing = containing;
        this.dbVerifier = dbVerifier;
    }

    public /* synthetic */ InternalQueryProcessor(Context context, XMethodElement xMethodElement, XType xType, DatabaseVerifier databaseVerifier, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            databaseVerifier = null;
        }
        this(context, xMethodElement, xType, databaseVerifier);
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final XMethodElement getExecutableElement() {
        return this.executableElement;
    }

    @NotNull
    public final XType getContaining() {
        return this.containing;
    }

    @Nullable
    public final DatabaseVerifier getDbVerifier() {
        return this.dbVerifier;
    }

    @NotNull
    public final QueryFunction processQuery(@Nullable String input) {
        ParsedQuery parsedQuery;
        FunctionProcessorDelegate delegate = FunctionProcessorDelegate.Companion.createFor(this.context, this.containing, this.executableElement);
        XType returnType = delegate.extractReturnType();
        boolean returnsDeferredType = FunctionProcessorDelegateKt.returnsDeferredType(delegate);
        boolean isSuspendFunction = delegate.getExecutableElement().isSuspendFunction();
        Checks checks = this.context.getChecker();
        boolean bl = !isSuspendFunction || !returnsDeferredType;
        XElement xElement = (XElement)this.executableElement;
        String string = returnType.getRawType().getTypeName().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        checks.check(bl, xElement, ProcessorErrors.INSTANCE.suspendReturnsDeferredType(string), new Object[0]);
        if (!(isSuspendFunction || returnsDeferredType || this.context.isAndroidOnlyTarget())) {
            this.context.getLogger().e((XElement)this.executableElement, "Only suspend functions are allowed in DAOs declared in source sets targeting non-Android platforms.", new Object[0]);
            parsedQuery = ParsedQuery.Companion.getMISSING();
        } else if (input != null) {
            ParsedQuery query = SqlParser.Companion.parse(input);
            this.context.getChecker().check(query.getErrors().isEmpty(), (XElement)this.executableElement, CollectionsKt.joinToString$default((Iterable)query.getErrors(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), new Object[0]);
            this.validateQuery(query);
            Object[] objectArray = new Object[]{this.executableElement};
            this.context.getChecker().check(Xtype_extKt.isNotError(returnType), (XElement)this.executableElement, "Cannot resolve return type for %s", objectArray);
            parsedQuery = query;
        } else {
            parsedQuery = ParsedQuery.Companion.getMISSING();
        }
        ParsedQuery query = parsedQuery;
        this.context.getChecker().notUnbound(returnType, (XElement)this.executableElement, "Cannot use unbound generics in query functions. It must be bound to a type through base Dao class.", new Object[0]);
        boolean isPreparedQuery = ArraysKt.contains((Object[])PREPARED_TYPES, (Object)((Object)query.getType()));
        QueryFunction queryFunction = isPreparedQuery ? (QueryFunction)this.getPreparedQueryFunction(delegate, returnType, query) : this.getQueryFunction(delegate, returnType, query);
        return this.processQueryFunction(queryFunction);
    }

    /*
     * WARNING - void declaration
     */
    private final QueryFunction processQueryFunction(QueryFunction queryFunction) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Pair it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = queryFunction.getSectionToParamMapping();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Pair)element$iv$iv;
            boolean bl = false;
            if (!(it.getSecond() == null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv2 = (List)destination$iv$iv;
        boolean $i$f$map22 = false;
        $this$filterTo$iv$iv = $this$map$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            it = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Section.BindVar)it.getFirst()).getText());
        }
        List missing = (List)destination$iv$iv;
        if (!((Collection)missing).isEmpty()) {
            this.context.getLogger().e((XElement)this.executableElement, ProcessorErrors.INSTANCE.missingParameterForBindVariable(missing), new Object[0]);
        }
        Iterable $i$f$map22 = queryFunction.getParameters();
        boolean $i$f$filterNot = false;
        destination$iv$iv = $this$filterNot$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            boolean bl;
            block9: {
                QueryParameter param = (QueryParameter)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$any$iv = queryFunction.getSectionToParamMapping();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Pair it2 = (Pair)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it2.getSecond(), (Object)param)) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            }
            if (bl) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv2;
        boolean $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            QueryParameter param = (QueryParameter)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(p0.getSqlName());
        }
        List unused = (List)destination$iv$iv2;
        if (!((Collection)unused).isEmpty()) {
            this.context.getLogger().e((XElement)this.executableElement, ProcessorErrors.INSTANCE.unusedQueryFunctionParameter(unused), new Object[0]);
        }
        return queryFunction;
    }

    private final void validateQuery(ParsedQuery query) {
        boolean skipQueryVerification = this.executableElement.hasAnnotation(Reflection.getOrCreateKotlinClass(SkipQueryVerification.class));
        if (skipQueryVerification) {
            return;
        }
        DatabaseVerifier databaseVerifier = this.dbVerifier;
        query.setResultInfo(databaseVerifier != null ? databaseVerifier.analyze(query.getOriginal()) : null);
        QueryResultInfo queryResultInfo = query.getResultInfo();
        if ((queryResultInfo != null ? queryResultInfo.getError() : null) != null) {
            RLog rLog = this.context.getLogger();
            XElement xElement = (XElement)this.executableElement;
            QueryResultInfo queryResultInfo2 = query.getResultInfo();
            Intrinsics.checkNotNull((Object)queryResultInfo2);
            SQLException sQLException = queryResultInfo2.getError();
            Intrinsics.checkNotNull((Object)sQLException);
            rLog.e(xElement, DatabaseVerificationErrors.INSTANCE.cannotVerifyQuery(sQLException), new Object[0]);
        }
    }

    private final WriteQueryFunction getPreparedQueryFunction(FunctionProcessorDelegate delegate, XType returnType, ParsedQuery query) {
        PreparedQueryResultBinder resultBinder = delegate.findPreparedResultBinder(returnType, query);
        this.context.getChecker().check(resultBinder.getAdapter() != null, (XElement)this.executableElement, ProcessorErrors.INSTANCE.cannotFindPreparedQueryResultAdapter(returnType.asTypeName().toString(this.context.getCodeLanguage()), query.getType()), new Object[0]);
        List<QueryParameter> parameters = delegate.extractQueryParams(query);
        return new WriteQueryFunction(this.executableElement, query, returnType, parameters, resultBinder);
    }

    /*
     * WARNING - void declaration
     */
    private final QueryFunction getQueryFunction(FunctionProcessorDelegate delegate, XType returnType, ParsedQuery query) {
        QueryResultBinder resultBinder = delegate.findResultBinder(returnType, query, (Function1<? super TypeAdapterExtras, Unit>)((Function1)arg_0 -> InternalQueryProcessor.getQueryFunction$lambda$5(delegate, this, query, arg_0)));
        this.context.getChecker().check(resultBinder.getAdapter() != null, (XElement)this.executableElement, ProcessorErrors.INSTANCE.cannotFindQueryResultAdapter(returnType.asTypeName().toString(this.context.getCodeLanguage())), new Object[0]);
        boolean inTransaction = this.executableElement.hasAnnotation(Reflection.getOrCreateKotlinClass(Transaction.class));
        if (query.getType() == QueryType.SELECT && !inTransaction) {
            boolean hasRelations;
            Object object = resultBinder.getAdapter();
            if (object != null && (object = ((QueryResultAdapter)object).getRowAdapters()) != null) {
                boolean bl;
                block21: {
                    Iterable $this$any$iv = (Iterable)object;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            RowAdapter adapter = (RowAdapter)element$iv;
                            boolean bl2 = false;
                            if (!(adapter instanceof DataClassRowAdapter && !((Collection)((DataClassRowAdapter)adapter).getRelationCollectors()).isEmpty())) continue;
                            bl = true;
                            break block21;
                        }
                        bl = false;
                    }
                }
                v2 = bl;
            } else {
                v2 = hasRelations = false;
            }
            if (hasRelations) {
                this.context.getLogger().w(Warning.RELATION_QUERY_WITHOUT_TRANSACTION, (XElement)this.executableElement, "The return value includes a data class with a @Relation. It is usually desired to annotate this function with @Transaction to avoid possibility of inconsistent results between the data class and its relations. See https://developer.android.com/reference/androidx/room/Transaction.html for details.", new Object[0]);
            }
        }
        QueryResultInfo queryResultInfo = query.getResultInfo();
        if (queryResultInfo != null) {
            QueryResultInfo queryResultInfo2 = queryResultInfo;
            boolean bl = false;
            Object object = resultBinder.getAdapter();
            if (object != null) {
                Object mappings;
                if ((object = ((QueryResultAdapter)object).getMappings()) != null && !(mappings = object).isEmpty()) {
                    boolean bl3;
                    block22: {
                        Iterable $this$none$iv = (Iterable)mappings;
                        boolean $i$f$none = false;
                        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                            bl3 = true;
                        } else {
                            for (Object element$iv : $this$none$iv) {
                                QueryMappedRowAdapter.Mapping it = (QueryMappedRowAdapter.Mapping)element$iv;
                                boolean bl4 = false;
                                if (!(it instanceof DataClassRowAdapter.DataClassMapping)) continue;
                                bl3 = false;
                                break block22;
                            }
                            bl3 = true;
                        }
                    }
                    if (!bl3) {
                        void $this$associateTo$iv$iv;
                        void $this$associate$iv;
                        void $this$filterTo$iv$iv;
                        Iterable $this$filter$iv;
                        void $this$filterIsInstanceTo$iv$iv;
                        Object object2;
                        void $this$mapTo$iv$iv;
                        void $this$flatMapTo$iv$iv;
                        Iterable $this$flatMap$iv = (Iterable)mappings;
                        boolean $i$f$flatMap = false;
                        Iterable element$iv = $this$flatMap$iv;
                        Iterable destination$iv$iv = new ArrayList();
                        boolean $i$f$flatMapTo = false;
                        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                            QueryMappedRowAdapter.Mapping it = (QueryMappedRowAdapter.Mapping)element$iv$iv;
                            boolean bl5 = false;
                            Iterable list$iv$iv = it.getUsedColumns();
                            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                        }
                        List usedColumns = (List)destination$iv$iv;
                        Iterable $this$map$iv = queryResultInfo2.getColumns();
                        boolean $i$f$map = false;
                        destination$iv$iv = $this$map$iv;
                        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo22 = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            ColumnInfo bl5 = (ColumnInfo)item$iv$iv;
                            object2 = destination$iv$iv2;
                            boolean bl6 = false;
                            object2.add(it.getName());
                        }
                        List columnNames = (List)destination$iv$iv2;
                        List unusedColumns = CollectionsKt.minus((Iterable)columnNames, (Iterable)usedColumns);
                        Iterable $this$filterIsInstance$iv = (Iterable)mappings;
                        boolean $i$f$filterIsInstance22 = false;
                        Iterable $i$f$mapTo22 = $this$filterIsInstance$iv;
                        Collection destination$iv$iv3 = new ArrayList();
                        boolean $i$f$filterIsInstanceTo = false;
                        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                            if (!(element$iv$iv instanceof DataClassRowAdapter.DataClassMapping)) continue;
                            destination$iv$iv3.add(element$iv$iv);
                        }
                        List dataClassMappings = (List)destination$iv$iv3;
                        Iterable $i$f$filterIsInstance22 = dataClassMappings;
                        boolean $i$f$filter = false;
                        destination$iv$iv3 = $this$filter$iv;
                        Collection destination$iv$iv4 = new ArrayList();
                        boolean $i$f$filterTo = false;
                        for (Object element$iv$iv : $this$filterTo$iv$iv) {
                            DataClassRowAdapter.DataClassMapping it = (DataClassRowAdapter.DataClassMapping)element$iv$iv;
                            boolean bl7 = false;
                            boolean bl8 = !((Collection)it.getUnusedFields()).isEmpty();
                            if (!bl8) continue;
                            destination$iv$iv4.add(element$iv$iv);
                        }
                        $this$filter$iv = (List)destination$iv$iv4;
                        boolean $i$f$associate2 = false;
                        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                        destination$iv$iv4 = $this$associate$iv;
                        Object destination$iv$iv5 = new LinkedHashMap(capacity$iv);
                        boolean $i$f$associateTo = false;
                        for (Object element$iv$iv : $this$associateTo$iv$iv) {
                            Map bl7 = destination$iv$iv5;
                            DataClassRowAdapter.DataClassMapping it = (DataClassRowAdapter.DataClassMapping)element$iv$iv;
                            boolean bl9 = false;
                            it = TuplesKt.to((Object)it.getDataClass().getTypeName().toString(this.context.getCodeLanguage()), it.getUnusedFields());
                            bl7.put(it.getFirst(), it.getSecond());
                        }
                        Map pojoUnusedFields = destination$iv$iv5;
                        if (!((Collection)unusedColumns).isEmpty() || !pojoUnusedFields.isEmpty()) {
                            void $this$mapTo$iv$iv2;
                            void $this$map$iv2;
                            Iterable $i$f$associate2 = dataClassMappings;
                            object2 = ProcessorErrors.INSTANCE;
                            boolean $i$f$map2 = false;
                            $this$associateTo$iv$iv = $this$map$iv2;
                            destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                            boolean $i$f$mapTo = false;
                            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                                void it;
                                DataClassRowAdapter.DataClassMapping bl7 = (DataClassRowAdapter.DataClassMapping)item$iv$iv;
                                Object object3 = destination$iv$iv5;
                                boolean bl10 = false;
                                object3.add(it.getDataClass().getTypeName().toString(this.context.getCodeLanguage()));
                            }
                            String warningMsg = ((ProcessorErrors)object2).queryPropertyDataClassMismatch((List)destination$iv$iv5, unusedColumns, columnNames, pojoUnusedFields);
                            this.context.getLogger().w(Warning.QUERY_MISMATCH, (XElement)this.executableElement, warningMsg, new Object[0]);
                        }
                    }
                }
            }
        }
        List<QueryParameter> parameters = delegate.extractQueryParams(query);
        return new ReadQueryFunction(this.executableElement, query, returnType, parameters, inTransaction, resultBinder);
    }

    /*
     * WARNING - void declaration
     */
    private final void processMapInfo(XAnnotation mapInfoAnnotation, ParsedQuery query, XMethodElement queryExecutableElement, TypeAdapterExtras adapterExtras) {
        List<ColumnInfo> resultColumns;
        void $this$associateTo$iv$iv;
        String string;
        Object object;
        Object valueColumn;
        Object object2;
        String keyTable;
        Object object3;
        Object keyColumn;
        Object object4 = mapInfoAnnotation.get("keyColumn");
        if (object4 == null || (object4 = object4.asString()) == null) {
            object4 = keyColumn = "";
        }
        if ((object3 = mapInfoAnnotation.get("keyTable")) != null && (object3 = object3.asString()) != null) {
            CharSequence charSequence;
            CharSequence charSequence2 = (CharSequence)object3;
            if (charSequence2.length() == 0) {
                boolean bl = false;
                charSequence = null;
            } else {
                charSequence = charSequence2;
            }
            v3 = (String)charSequence;
        } else {
            v3 = keyTable = null;
        }
        if ((object2 = mapInfoAnnotation.get("valueColumn")) == null || (object2 = object2.asString()) == null) {
            object2 = valueColumn = "";
        }
        if ((object = mapInfoAnnotation.get("valueTable")) != null && (object = object.asString()) != null) {
            CharSequence charSequence;
            CharSequence charSequence3 = (CharSequence)object;
            if (charSequence3.length() == 0) {
                boolean bl = false;
                charSequence = null;
            } else {
                charSequence = charSequence3;
            }
            string = (String)charSequence;
        } else {
            string = null;
        }
        String valueTable = string;
        Iterable $this$associate$iv = query.getTables();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            Table it = (Table)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getName(), (Object)it.getAlias());
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map resultTableAliases = destination$iv$iv;
        this.context.getChecker().check(((CharSequence)keyColumn).length() > 0 || ((CharSequence)valueColumn).length() > 0, (XElement)queryExecutableElement, "To use the @MapInfo annotation, you must provide either the key column name, value column name, or both.", new Object[0]);
        QueryResultInfo queryResultInfo = query.getResultInfo();
        List<ColumnInfo> list = resultColumns = queryResultInfo != null ? queryResultInfo.getColumns() : null;
        if (resultColumns != null) {
            this.context.getChecker().check(((CharSequence)keyColumn).length() == 0 || InternalQueryProcessor.processMapInfo$contains(resultColumns, resultTableAliases, (String)keyColumn, keyTable), (XElement)queryExecutableElement, (Function0<String>)((Function0)() -> InternalQueryProcessor.processMapInfo$lambda$20(keyTable, (String)keyColumn, resultColumns)));
            this.context.getChecker().check(((CharSequence)valueColumn).length() == 0 || InternalQueryProcessor.processMapInfo$contains(resultColumns, resultTableAliases, (String)valueColumn, valueTable), (XElement)queryExecutableElement, (Function0<String>)((Function0)() -> InternalQueryProcessor.processMapInfo$lambda$22(valueTable, (String)valueColumn, resultColumns)));
        }
        adapterExtras.putData(Reflection.getOrCreateKotlinClass(androidx.room.vo.MapInfo.class), new androidx.room.vo.MapInfo((String)keyColumn, (String)valueColumn));
    }

    private static final Unit getQueryFunction$lambda$5(FunctionProcessorDelegate $delegate, InternalQueryProcessor this$0, ParsedQuery $query, TypeAdapterExtras $this$findResultBinder) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$this$findResultBinder, (String)"$this$findResultBinder");
            XAnnotation xAnnotation = $delegate.getExecutableElement().getAnnotation(Reflection.getOrCreateKotlinClass(MapInfo.class));
            if (xAnnotation == null) break block0;
            XAnnotation it = xAnnotation;
            boolean bl = false;
            this$0.processMapInfo(it, $query, $delegate.getExecutableElement(), $this$findResultBinder);
        }
        return Unit.INSTANCE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean processMapInfo$contains(List<ColumnInfo> $this$processMapInfo_u24contains, Map<String, String> resultTableAliases, String columnName, String tableName) {
        boolean bl;
        Iterable $this$any$iv = $this$processMapInfo_u24contains;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            String resultTableAlias;
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            ColumnInfo resultColumn = (ColumnInfo)element$iv;
            boolean bl2 = false;
            if (resultColumn.getOriginTable() != null) {
                String it;
                boolean bl3 = false;
                v0 = resultTableAliases.get(it);
                if (v0 == null) {
                    v0 = it;
                }
            } else {
                v0 = resultTableAlias = null;
            }
            if (Intrinsics.areEqual((Object)resultColumn.getName(), (Object)columnName)) {
                if (tableName == null) return true;
                if (Intrinsics.areEqual((Object)resultTableAlias, (Object)tableName)) return true;
                if (Intrinsics.areEqual((Object)resultColumn.getOriginTable(), (Object)tableName)) {
                    return true;
                }
                boolean bl4 = false;
                if (bl4) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static final String processMapInfo$lambda$20(String $keyTable, String $keyColumn, List $resultColumns) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String string = $keyTable;
        Iterable iterable = $resultColumns;
        String string2 = (String)(string != null ? string + "." : "") + $keyColumn;
        ProcessorErrors processorErrors = ProcessorErrors.INSTANCE;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ColumnInfo columnInfo = (ColumnInfo)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        collection = (List)destination$iv$iv;
        String string3 = MapInfo.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getSimpleName(...)");
        return processorErrors.cannotMapSpecifiedColumn(string2, (List<String>)collection, string3);
    }

    /*
     * WARNING - void declaration
     */
    private static final String processMapInfo$lambda$22(String $valueTable, String $valueColumn, List $resultColumns) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String string = $valueTable;
        Iterable iterable = $resultColumns;
        String string2 = (String)(string != null ? string + "." : "") + $valueColumn;
        ProcessorErrors processorErrors = ProcessorErrors.INSTANCE;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ColumnInfo columnInfo = (ColumnInfo)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        collection = (List)destination$iv$iv;
        String string3 = MapInfo.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getSimpleName(...)");
        return processorErrors.cannotMapSpecifiedColumn(string2, (List<String>)collection, string3);
    }

    static {
        QueryType[] queryTypeArray = new QueryType[]{QueryType.INSERT, QueryType.DELETE, QueryType.UPDATE};
        PREPARED_TYPES = queryTypeArray;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\n"}, d2={"Landroidx/room/processor/InternalQueryProcessor$Companion;", "", "<init>", "()V", "PREPARED_TYPES", "", "Landroidx/room/parser/QueryType;", "getPREPARED_TYPES", "()[Landroidx/room/parser/QueryType;", "[Landroidx/room/parser/QueryType;", "room-compiler"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final QueryType[] getPREPARED_TYPES() {
            return PREPARED_TYPES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

