/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.processor;

import androidx.room.Entity;
import androidx.room.Fts3;
import androidx.room.Fts4;
import androidx.room.FtsOptions;
import androidx.room.PrimaryKey;
import androidx.room.compiler.processing.XAnnotation;
import androidx.room.compiler.processing.XAnnotationValue;
import androidx.room.compiler.processing.XElement;
import androidx.room.compiler.processing.XType;
import androidx.room.compiler.processing.XTypeElement;
import androidx.room.parser.FtsVersion;
import androidx.room.parser.SQLTypeAffinity;
import androidx.room.preconditions.Checks;
import androidx.room.processor.Context;
import androidx.room.processor.DataClassProcessor;
import androidx.room.processor.EntityProcessor;
import androidx.room.processor.EntityProcessorKt;
import androidx.room.processor.ProcessorErrors;
import androidx.room.processor.PropertyProcessor;
import androidx.room.processor.cache.Cache;
import androidx.room.vo.Constructor;
import androidx.room.vo.DataClass;
import androidx.room.vo.EmbeddedProperty;
import androidx.room.vo.FtsEntity;
import androidx.room.vo.FtsOptions;
import androidx.room.vo.HasPropertiesKt;
import androidx.room.vo.LanguageId;
import androidx.room.vo.Properties;
import androidx.room.vo.Property;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B3\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0018\b\u0002\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0014\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J \u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u00172\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0012H\u0002J\u001e\u0010&\u001a\u00020'2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010(\u001a\u00020\bH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006)"}, d2={"Landroidx/room/processor/FtsTableEntityProcessor;", "Landroidx/room/processor/EntityProcessor;", "baseContext", "Landroidx/room/processor/Context;", "element", "Landroidx/room/compiler/processing/XTypeElement;", "referenceStack", "Ljava/util/LinkedHashSet;", "", "Lkotlin/collections/LinkedHashSet;", "<init>", "(Landroidx/room/processor/Context;Landroidx/room/compiler/processing/XTypeElement;Ljava/util/LinkedHashSet;)V", "getElement", "()Landroidx/room/compiler/processing/XTypeElement;", "context", "getContext", "()Landroidx/room/processor/Context;", "process", "Landroidx/room/vo/FtsEntity;", "doProcess", "getFts3Options", "Landroidx/room/vo/FtsOptions;", "annotation", "Landroidx/room/compiler/processing/XAnnotation;", "getFts4Options", "getContentEntity", "Landroidx/room/vo/Entity;", "entityType", "Landroidx/room/compiler/processing/XType;", "findAndValidatePrimaryKey", "Landroidx/room/vo/PrimaryKey;", "entityAnnotation", "properties", "", "Landroidx/room/vo/Property;", "validateExternalContentEntity", "", "ftsEntity", "findAndValidateLanguageId", "Landroidx/room/vo/LanguageId;", "languageIdColumnName", "room-compiler"})
@SourceDebugExtension(value={"SMAP\nFtsTableEntityProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FtsTableEntityProcessor.kt\nandroidx/room/processor/FtsTableEntityProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,345:1\n1734#2,3:346\n1611#2,9:350\n1863#2:359\n295#2,2:360\n1557#2:362\n1628#2,3:363\n1864#2:367\n1620#2:368\n1611#2,9:369\n1863#2:378\n1864#2:380\n1620#2:381\n295#2,2:382\n827#2:384\n855#2:385\n1755#2,3:386\n856#2:389\n1863#2,2:390\n295#2,2:392\n1#3:349\n1#3:366\n1#3:379\n*S KotlinDebug\n*F\n+ 1 FtsTableEntityProcessor.kt\nandroidx/room/processor/FtsTableEntityProcessor\n*L\n147#1:346,3\n232#1:350,9\n232#1:359\n233#1:360,2\n239#1:362\n239#1:363,3\n232#1:367\n232#1:368\n252#1:369,9\n252#1:378\n252#1:380\n252#1:381\n266#1:382,2\n303#1:384\n303#1:385\n304#1:386,3\n303#1:389\n308#1:390,2\n328#1:392,2\n232#1:366\n252#1:379\n*E\n"})
public final class FtsTableEntityProcessor
implements EntityProcessor {
    @NotNull
    private final XTypeElement element;
    @NotNull
    private final LinkedHashSet<String> referenceStack;
    @NotNull
    private final Context context;

    public FtsTableEntityProcessor(@NotNull Context baseContext, @NotNull XTypeElement element, @NotNull LinkedHashSet<String> referenceStack) {
        Intrinsics.checkNotNullParameter((Object)baseContext, (String)"baseContext");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(referenceStack, (String)"referenceStack");
        this.element = element;
        this.referenceStack = referenceStack;
        this.context = Context.fork$default(baseContext, (XElement)this.element, null, null, 6, null);
    }

    public /* synthetic */ FtsTableEntityProcessor(Context context, XTypeElement xTypeElement, LinkedHashSet linkedHashSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            linkedHashSet = new LinkedHashSet<String>();
        }
        this(context, xTypeElement, linkedHashSet);
    }

    @NotNull
    public final XTypeElement getElement() {
        return this.element;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @Override
    @NotNull
    public FtsEntity process() {
        androidx.room.vo.Entity entity = this.context.getCache().getEntities().get(new Cache.EntityKey((XElement)this.element), (Function0<androidx.room.vo.Entity>)((Function0)() -> FtsTableEntityProcessor.process$lambda$0(this)));
        Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type androidx.room.vo.FtsEntity");
        return (FtsEntity)entity;
    }

    /*
     * WARNING - void declaration
     */
    private final FtsEntity doProcess() {
        boolean bl;
        Checks checks;
        androidx.room.vo.PrimaryKey primaryKey;
        Object shadowTableName;
        FtsOptions ftsOptions;
        FtsVersion ftsVersion;
        DataClass pojo;
        String tableName;
        block6: {
            void $this$all$iv;
            if (!this.element.validate()) {
                this.context.reportMissingTypeReference(this.element.getQualifiedName());
                return new FtsEntity(this.element, this.element.getName(), this.element.getType(), (List<Property>)CollectionsKt.emptyList(), (List<EmbeddedProperty>)CollectionsKt.emptyList(), androidx.room.vo.PrimaryKey.Companion.getMISSING(), null, null, FtsVersion.FTS3, new FtsOptions("simple", CollectionsKt.emptyList(), null, "", FtsOptions.MatchInfo.FTS3, CollectionsKt.emptyList(), CollectionsKt.emptyList(), FtsOptions.Order.ASC));
            }
            this.context.getChecker().hasAnnotation((XElement)this.element, (KClass<? extends Annotation>)Reflection.getOrCreateKotlinClass(Entity.class), "Entity class must be annotated with @Entity", new Object[0]);
            XAnnotation entityAnnotation = this.element.getAnnotation(Reflection.getOrCreateKotlinClass(Entity.class));
            tableName = null;
            if (entityAnnotation != null) {
                tableName = EntityProcessor.Companion.extractTableName(this.element, entityAnnotation);
                this.context.getChecker().check(EntityProcessor.Companion.extractIndices(entityAnnotation, tableName).isEmpty(), (XElement)this.element, "Indices not allowed in FTS Entity.", new Object[0]);
                this.context.getChecker().check(EntityProcessor.Companion.extractForeignKeys(entityAnnotation).isEmpty(), (XElement)this.element, "Foreign Keys not allowed in FTS Entity.", new Object[0]);
            } else {
                tableName = this.element.getName();
            }
            pojo = DataClassProcessor.Companion.createFor(this.context, this.element, PropertyProcessor.BindingScope.TWO_WAY, null, this.referenceStack).process();
            this.context.getChecker().check(pojo.getRelations().isEmpty(), (XElement)this.element, "Entities cannot have relations.", new Object[0]);
            Pair pair = this.element.hasAnnotation(Reflection.getOrCreateKotlinClass(Fts3.class)) ? TuplesKt.to((Object)((Object)FtsVersion.FTS3), (Object)this.getFts3Options(this.element.requireAnnotation(Reflection.getOrCreateKotlinClass(Fts3.class)))) : TuplesKt.to((Object)((Object)FtsVersion.FTS4), (Object)this.getFts4Options(this.element.requireAnnotation(Reflection.getOrCreateKotlinClass(Fts4.class))));
            ftsVersion = (FtsVersion)((Object)pair.component1());
            ftsOptions = (FtsOptions)pair.component2();
            shadowTableName = ftsOptions.getContentEntity() != null ? ftsOptions.getContentEntity().getTableName() : tableName + "_content";
            primaryKey = this.findAndValidatePrimaryKey(entityAnnotation, pojo.getProperties());
            this.findAndValidateLanguageId(pojo.getProperties(), ftsOptions.getLanguageIdColumnName());
            List missingNotIndexed = CollectionsKt.minus((Iterable)ftsOptions.getNotIndexedColumns(), (Iterable)HasPropertiesKt.getColumnNames(pojo));
            this.context.getChecker().check(missingNotIndexed.isEmpty(), (XElement)this.element, ProcessorErrors.INSTANCE.missingNotIndexedProperty(missingNotIndexed), new Object[0]);
            Iterable iterable = ftsOptions.getPrefixSizes();
            checks = this.context.getChecker();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    int it = ((Number)element$iv).intValue();
                    boolean bl2 = false;
                    if (it > 0) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        boolean bl3 = bl;
        checks.check(bl3, (XElement)this.element, "Prefix sizes to index must non-zero positive values.", new Object[0]);
        XTypeElement xTypeElement = this.element;
        XType xType = pojo.getType();
        Properties properties = pojo.getProperties();
        List<EmbeddedProperty> list = pojo.getEmbeddedProperties();
        Constructor constructor = pojo.getConstructor();
        FtsEntity entity = new FtsEntity(xTypeElement, tableName, xType, (List<Property>)properties, list, primaryKey, constructor, (String)shadowTableName, ftsVersion, ftsOptions);
        this.validateExternalContentEntity(entity);
        return entity;
    }

    private final FtsOptions getFts3Options(XAnnotation annotation) {
        Object object;
        Object object2 = annotation.get("tokenizer");
        if (object2 == null || (object2 = object2.asString()) == null) {
            object2 = "simple";
        }
        if ((object = annotation.get("tokenizerArgs")) == null || (object = object.asStringList()) == null) {
            object = CollectionsKt.emptyList();
        }
        return new FtsOptions((String)object2, (List<String>)object, null, "", FtsOptions.MatchInfo.FTS4, CollectionsKt.emptyList(), CollectionsKt.emptyList(), FtsOptions.Order.ASC);
    }

    private final FtsOptions getFts4Options(XAnnotation annotation) {
        XAnnotationValue xAnnotationValue;
        Object object;
        Object object2;
        XAnnotationValue xAnnotationValue2;
        Object object3;
        androidx.room.vo.Entity entity;
        Object object4;
        Object object5;
        block14: {
            block13: {
                FtsOptions.MatchInfo matchInfo;
                XAnnotationValue it;
                Object object6;
                Object object7;
                androidx.room.vo.Entity entity2;
                Object object8;
                block12: {
                    block11: {
                        XAnnotationValue xAnnotationValue3 = annotation.get("contentEntity");
                        androidx.room.vo.Entity contentEntity = this.getContentEntity((XType)(xAnnotationValue3 != null ? xAnnotationValue3.asType() : null));
                        object5 = annotation.get("tokenizer");
                        if (object5 == null || (object5 = object5.asString()) == null) {
                            object5 = "simple";
                        }
                        if ((object4 = annotation.get("tokenizerArgs")) == null || (object4 = object4.asStringList()) == null) {
                            object4 = CollectionsKt.emptyList();
                        }
                        entity = contentEntity;
                        object3 = annotation.get("languageId");
                        if (object3 == null || (object3 = object3.asString()) == null) {
                            object3 = "";
                        }
                        if ((xAnnotationValue2 = annotation.get("matchInfo")) == null || (xAnnotationValue2 = xAnnotationValue2.asEnum()) == null) break block11;
                        XAnnotationValue xAnnotationValue4 = xAnnotationValue2;
                        object8 = object3;
                        entity2 = entity;
                        object7 = object4;
                        object6 = object5;
                        boolean bl = false;
                        matchInfo = FtsOptions.MatchInfo.valueOf((String)it.getName());
                        object5 = object6;
                        object4 = object7;
                        entity = entity2;
                        object3 = object8;
                        FtsOptions.MatchInfo matchInfo2 = matchInfo;
                        xAnnotationValue2 = matchInfo2;
                        if (matchInfo2 != null) break block12;
                    }
                    xAnnotationValue2 = FtsOptions.MatchInfo.FTS4;
                }
                if ((object2 = annotation.get("notIndexed")) == null || (object2 = object2.asStringList()) == null) {
                    object2 = CollectionsKt.emptyList();
                }
                if ((object = annotation.get("prefix")) == null || (object = object.asIntList()) == null) {
                    object = CollectionsKt.emptyList();
                }
                if ((xAnnotationValue = annotation.get("order")) == null || (xAnnotationValue = xAnnotationValue.asEnum()) == null) break block13;
                it = xAnnotationValue;
                Object object9 = object;
                Object object10 = object2;
                matchInfo = xAnnotationValue2;
                object8 = object3;
                entity2 = entity;
                object7 = object4;
                object6 = object5;
                boolean bl = false;
                FtsOptions.Order order = FtsOptions.Order.valueOf((String)it.getName());
                object5 = object6;
                object4 = object7;
                entity = entity2;
                object3 = object8;
                xAnnotationValue2 = matchInfo;
                object2 = object10;
                object = object9;
                FtsOptions.Order order2 = order;
                xAnnotationValue = order2;
                if (order2 != null) break block14;
            }
            xAnnotationValue = FtsOptions.Order.ASC;
        }
        XAnnotationValue xAnnotationValue5 = xAnnotationValue;
        Object object11 = object;
        Object object12 = object2;
        XAnnotationValue xAnnotationValue6 = xAnnotationValue2;
        Object object13 = object3;
        androidx.room.vo.Entity entity3 = entity;
        Object object14 = object4;
        Object object15 = object5;
        return new FtsOptions((String)object15, (List<String>)object14, entity3, (String)object13, (FtsOptions.MatchInfo)xAnnotationValue6, (List<String>)object12, (List<Integer>)object11, (FtsOptions.Order)xAnnotationValue5);
    }

    private final androidx.room.vo.Entity getContentEntity(XType entityType) {
        if (entityType == null) {
            this.context.getLogger().e((XElement)this.element, "Cannot find external content entity class.", new Object[0]);
            return null;
        }
        XType defaultType = this.context.getProcessingEnv().requireType(Reflection.getOrCreateKotlinClass(Object.class));
        if (entityType.isSameType(defaultType)) {
            return null;
        }
        XTypeElement contentEntityElement = entityType.getTypeElement();
        if (contentEntityElement == null) {
            this.context.getLogger().e((XElement)this.element, "Cannot find external content entity class.", new Object[0]);
            return null;
        }
        if (!contentEntityElement.hasAnnotation(Reflection.getOrCreateKotlinClass(Entity.class))) {
            this.context.getLogger().e((XElement)contentEntityElement, ProcessorErrors.INSTANCE.externalContentNotAnEntity(contentEntityElement.asClassName().getCanonicalName()), new Object[0]);
            return null;
        }
        return EntityProcessorKt.EntityProcessor(this.context, contentEntityElement, this.referenceStack).process();
    }

    /*
     * WARNING - void declaration
     */
    private final androidx.room.vo.PrimaryKey findAndValidatePrimaryKey(XAnnotation entityAnnotation, List<Property> properties) {
        Iterable $this$mapNotNullTo$iv$iv;
        List list;
        Iterator $this$forEach$iv$iv$iv;
        Iterable $this$mapNotNull$iv;
        Object object = entityAnnotation;
        if (object != null && (object = object.get("primaryKeys")) != null && (object = object.asStringList()) != null) {
            void $this$mapNotNullTo$iv$iv2;
            $this$mapNotNull$iv = (Iterable)object;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                androidx.room.vo.PrimaryKey primaryKey;
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Object v1;
                Iterable $this$firstOrNull$iv;
                String pkColumnName;
                block13: {
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    pkColumnName = (String)element$iv$iv;
                    boolean bl2 = false;
                    $this$firstOrNull$iv = properties;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Property it = (Property)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getColumnName(), (Object)pkColumnName)) continue;
                        v1 = element$iv;
                        break block13;
                    }
                    v1 = null;
                }
                Property property = v1;
                $this$firstOrNull$iv = properties;
                String string = pkColumnName;
                ProcessorErrors processorErrors = ProcessorErrors.INSTANCE;
                XElement xElement = (XElement)this.element;
                boolean bl = property != null;
                Checks checks = this.context.getChecker();
                boolean $i$f$map = false;
                Iterator iterator2 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Property property2 = (Property)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl4 = false;
                    collection.add(it.getColumnName());
                }
                collection = (List)destination$iv$iv2;
                checks.check(bl, xElement, processorErrors.primaryKeyColumnDoesNotExist(string, (List<String>)collection), new Object[0]);
                if (property != null) {
                    Property pkProperty;
                    boolean bl5 = false;
                    primaryKey = new androidx.room.vo.PrimaryKey((XElement)pkProperty.getElement().getEnclosingElement(), new Properties(pkProperty), true);
                } else {
                    primaryKey = null;
                }
                if (primaryKey == null) continue;
                androidx.room.vo.PrimaryKey it$iv$iv = primaryKey;
                boolean bl6 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        List keysFromEntityAnnotation = list;
        Iterable $this$mapNotNull$iv2 = properties;
        boolean $i$f$mapNotNull2 = false;
        $this$mapNotNull$iv = $this$mapNotNull$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        $this$forEach$iv$iv$iv = $this$forEach$iv$iv$iv2.iterator();
        while ($this$forEach$iv$iv$iv.hasNext()) {
            androidx.room.vo.PrimaryKey it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv.next();
            boolean bl = false;
            Property property = (Property)element$iv$iv;
            boolean bl7 = false;
            if ((property.getElement().hasAnnotation(Reflection.getOrCreateKotlinClass(PrimaryKey.class)) ? new androidx.room.vo.PrimaryKey((XElement)property.getElement().getEnclosingElement(), new Properties(property), true) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl8 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List keysFromPrimaryKeyAnnotations = (List)destination$iv$iv;
        List primaryKeys = CollectionsKt.plus((Collection)keysFromEntityAnnotation, (Iterable)keysFromPrimaryKeyAnnotations);
        if (primaryKeys.isEmpty()) {
            Object v4;
            block14: {
                void $this$firstOrNull$iv;
                $this$mapNotNullTo$iv$iv = properties;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Property it = (Property)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getColumnName(), (Object)"rowid")) continue;
                    v4 = element$iv;
                    break block14;
                }
                v4 = null;
            }
            Property $i$f$mapNotNull2 = v4;
            if ($i$f$mapNotNull2 != null) {
                Property it = $i$f$mapNotNull2;
                boolean bl = false;
                this.context.getChecker().check(it.getElement().hasAnnotation(Reflection.getOrCreateKotlinClass(PrimaryKey.class)), (XElement)it.getElement(), "The property with column name 'rowid' in an FTS entity must be annotated with @PrimaryKey.", new Object[0]);
            }
            return androidx.room.vo.PrimaryKey.Companion.getMISSING();
        }
        this.context.getChecker().check(primaryKeys.size() == 1, (XElement)this.element, "An FTS entity can only have a single primary key.", new Object[0]);
        androidx.room.vo.PrimaryKey primaryKey = (androidx.room.vo.PrimaryKey)CollectionsKt.first((List)primaryKeys);
        Checks checks = this.context.getChecker();
        boolean bl = Intrinsics.areEqual((Object)CollectionsKt.first(HasPropertiesKt.getColumnNames(primaryKey)), (Object)"rowid");
        XElement xElement = primaryKey.getDeclaredIn();
        if (xElement == null) {
            xElement = (XElement)this.element;
        }
        checks.check(bl, xElement, "The single primary key property in an FTS entity must either be named 'rowid' or must be annotated with @ColumnInfo(name = \"rowid\")", new Object[0]);
        Checks checks2 = this.context.getChecker();
        boolean bl9 = ((Property)CollectionsKt.first((List)primaryKey.getProperties())).getAffinity() == SQLTypeAffinity.INTEGER;
        XElement xElement2 = primaryKey.getDeclaredIn();
        if (xElement2 == null) {
            xElement2 = (XElement)this.element;
        }
        checks2.check(bl9, xElement2, "The single @PrimaryKey annotated property in an FTS entity must be of INTEGER affinity.", new Object[0]);
        return primaryKey;
    }

    /*
     * WARNING - void declaration
     */
    private final void validateExternalContentEntity(FtsEntity ftsEntity) {
        void $this$filterNotTo$iv$iv;
        androidx.room.vo.Entity contentEntity = ftsEntity.getFtsOptions().getContentEntity();
        if (contentEntity == null) {
            return;
        }
        Iterable $this$filterNot$iv = ftsEntity.getNonHiddenProperties();
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            boolean bl;
            block6: {
                Property it = (Property)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$any$iv = contentEntity.getProperties();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Property contentProperty = (Property)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)contentProperty.getColumnName(), (Object)it.getColumnName())) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            if (bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Property it = (Property)element$iv;
            boolean bl = false;
            this.context.getLogger().e((XElement)it.getElement(), ProcessorErrors.INSTANCE.missingFtsContentProperty(this.element.getQualifiedName(), it.getColumnName(), contentEntity.getElement().getQualifiedName()), new Object[0]);
        }
    }

    private final LanguageId findAndValidateLanguageId(List<Property> properties, String languageIdColumnName) {
        Object v0;
        block3: {
            if (((CharSequence)languageIdColumnName).length() == 0) {
                return LanguageId.Companion.getMISSING();
            }
            Iterable $this$firstOrNull$iv = properties;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Property it = (Property)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getColumnName(), (Object)languageIdColumnName)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        Property languageIdProperty = v0;
        if (languageIdProperty == null) {
            this.context.getLogger().e((XElement)this.element, ProcessorErrors.INSTANCE.missingLanguageIdProperty(languageIdColumnName), new Object[0]);
            return LanguageId.Companion.getMISSING();
        }
        this.context.getChecker().check(languageIdProperty.getAffinity() == SQLTypeAffinity.INTEGER, (XElement)languageIdProperty.getElement(), "The 'languageid' property must be of INTEGER affinity.", new Object[0]);
        return new LanguageId((XElement)languageIdProperty.getElement(), languageIdProperty);
    }

    private static final androidx.room.vo.Entity process$lambda$0(FtsTableEntityProcessor this$0) {
        return this$0.doProcess();
    }
}

