/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.processor;

import androidx.room.Index;
import androidx.room.compiler.processing.XAnnotation;
import androidx.room.compiler.processing.XAnnotationValue;
import androidx.room.compiler.processing.XEnumEntry;
import androidx.room.compiler.processing.XTypeElement;
import androidx.room.processor.EntityOrViewProcessor;
import androidx.room.processor.ForeignKeyInput;
import androidx.room.processor.IndexInput;
import androidx.room.vo.Entity;
import androidx.room.vo.ForeignKeyAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004J\b\u0010\u0002\u001a\u00020\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0005\u00c0\u0006\u0001"}, d2={"Landroidx/room/processor/EntityProcessor;", "Landroidx/room/processor/EntityOrViewProcessor;", "process", "Landroidx/room/vo/Entity;", "Companion", "room-compiler"})
public interface EntityProcessor
extends EntityOrViewProcessor {
    @NotNull
    public static final Companion Companion = androidx.room.processor.EntityProcessor$Companion.$$INSTANCE;

    @Override
    @NotNull
    public Entity process();

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0005J\u001c\u0010\u000e\u001a\u00020\u00052\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b2\u0006\u0010\r\u001a\u00020\u0005J\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000b2\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u0012"}, d2={"Landroidx/room/processor/EntityProcessor$Companion;", "", "<init>", "()V", "extractTableName", "", "element", "Landroidx/room/compiler/processing/XTypeElement;", "annotation", "Landroidx/room/compiler/processing/XAnnotation;", "extractIndices", "", "Landroidx/room/processor/IndexInput;", "tableName", "createIndexName", "columnNames", "extractForeignKeys", "Landroidx/room/processor/ForeignKeyInput;", "room-compiler"})
    @SourceDebugExtension(value={"SMAP\nEntityProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EntityProcessor.kt\nandroidx/room/processor/EntityProcessor$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,116:1\n1557#2:117\n1628#2,2:118\n1557#2:120\n1628#2,3:121\n1630#2:124\n1557#2:125\n1628#2,3:126\n*S KotlinDebug\n*F\n+ 1 EntityProcessor.kt\nandroidx/room/processor/EntityProcessor$Companion\n*L\n43#1:117\n43#1:118,2\n48#1:120\n48#1:121,3\n43#1:124\n67#1:125\n67#1:126,3\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @NotNull
        public final String extractTableName(@NotNull XTypeElement element, @NotNull XAnnotation annotation) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            XAnnotationValue xAnnotationValue = annotation.get("tableName");
            String tableName = xAnnotationValue != null ? xAnnotationValue.asString() : null;
            return tableName == null || Intrinsics.areEqual((Object)tableName, (Object)"") ? element.getName() : tableName;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<IndexInput> extractIndices(@NotNull XAnnotation annotation, @NotNull String tableName) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
            Object object = annotation.get("indices");
            if (object == null || (object = object.asAnnotationList()) == null) {
                object = CollectionsKt.emptyList();
            }
            Object indicesAnnotations = object;
            Iterable $this$map$iv = (Iterable)indicesAnnotations;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void $this$mapTo$iv$iv2;
                Object object2;
                Object columns;
                Object object3;
                Object nameValue;
                void indexAnnotation;
                XAnnotation xAnnotation = (XAnnotation)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                XAnnotationValue xAnnotationValue = indexAnnotation.get("unique");
                boolean unique = xAnnotationValue != null ? xAnnotationValue.asBoolean() : false;
                Object object4 = indexAnnotation.get("name");
                if (object4 == null || (object4 = object4.asString()) == null) {
                    object4 = nameValue = "";
                }
                if ((object3 = indexAnnotation.get("value")) == null || (object3 = object3.asStringList()) == null) {
                    object3 = columns = CollectionsKt.emptyList();
                }
                if ((object2 = indexAnnotation.get("orders")) == null || (object2 = object2.asEnumList()) == null) {
                    object2 = CollectionsKt.emptyList();
                }
                Iterable $this$map$iv2 = (Iterable)object2;
                boolean $i$f$map2 = false;
                Iterable iterable2 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void it;
                    XEnumEntry xEnumEntry = (XEnumEntry)item$iv$iv2;
                    Collection collection2 = destination$iv$iv2;
                    boolean bl2 = false;
                    collection2.add(Index.Order.valueOf((String)it.getName()));
                }
                List orders = (List)destination$iv$iv2;
                Object name = Intrinsics.areEqual((Object)nameValue, (Object)"") ? $$INSTANCE.createIndexName((List<String>)columns, tableName) : nameValue;
                collection.add(new IndexInput((String)name, unique, (List<String>)columns, orders));
            }
            return (List)destination$iv$iv;
        }

        @NotNull
        public final String createIndexName(@NotNull List<String> columnNames, @NotNull String tableName) {
            Intrinsics.checkNotNullParameter(columnNames, (String)"columnNames");
            Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
            return "index_" + tableName + "_" + CollectionsKt.joinToString$default((Iterable)columnNames, (CharSequence)"_", null, null, (int)0, null, null, (int)62, null);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<ForeignKeyInput> extractForeignKeys(@NotNull XAnnotation annotation) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            Object object = annotation.get("foreignKeys");
            if (object == null || (object = object.asAnnotationList()) == null) {
                object = CollectionsKt.emptyList();
            }
            Object foreignKeyAnnotations = object;
            Iterable $this$map$iv = (Iterable)foreignKeyAnnotations;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void foreignKeyAnnotation;
                XAnnotation xAnnotation = (XAnnotation)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                XAnnotationValue xAnnotationValue = foreignKeyAnnotation.get("onDelete");
                XAnnotationValue xAnnotationValue2 = foreignKeyAnnotation.get("onUpdate");
                XAnnotationValue xAnnotationValue3 = foreignKeyAnnotation.get("deferred");
                collection.add(new ForeignKeyInput(foreignKeyAnnotation.getAsType("entity"), foreignKeyAnnotation.getAsStringList("parentColumns"), foreignKeyAnnotation.getAsStringList("childColumns"), ForeignKeyAction.Companion.fromAnnotationValue(xAnnotationValue != null ? xAnnotationValue.asInt() : 1), ForeignKeyAction.Companion.fromAnnotationValue(xAnnotationValue2 != null ? xAnnotationValue2.asInt() : 1), xAnnotationValue3 != null ? xAnnotationValue3.asBoolean() : false));
            }
            return (List)destination$iv$iv;
        }

        static {
            $$INSTANCE = new Companion();
        }
    }
}

