/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.processor;

import androidx.room.Delete;
import androidx.room.compiler.processing.XAnnotation;
import androidx.room.compiler.processing.XElement;
import androidx.room.compiler.processing.XMethodElement;
import androidx.room.compiler.processing.XType;
import androidx.room.processor.Context;
import androidx.room.processor.ProcessorErrors;
import androidx.room.processor.ShortcutFunctionProcessor;
import androidx.room.solver.shortcut.binder.DeleteOrUpdateFunctionBinder;
import androidx.room.vo.DataClass;
import androidx.room.vo.DeleteFunction;
import androidx.room.vo.Entity;
import androidx.room.vo.ShortcutEntity;
import androidx.room.vo.ShortcutQueryParameter;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0011\u001a\u00020\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0013"}, d2={"Landroidx/room/processor/DeleteFunctionProcessor;", "", "baseContext", "Landroidx/room/processor/Context;", "containing", "Landroidx/room/compiler/processing/XType;", "executableElement", "Landroidx/room/compiler/processing/XMethodElement;", "<init>", "(Landroidx/room/processor/Context;Landroidx/room/compiler/processing/XType;Landroidx/room/compiler/processing/XMethodElement;)V", "getContaining", "()Landroidx/room/compiler/processing/XType;", "getExecutableElement", "()Landroidx/room/compiler/processing/XMethodElement;", "context", "getContext", "()Landroidx/room/processor/Context;", "process", "Landroidx/room/vo/DeleteFunction;", "room-compiler"})
public final class DeleteFunctionProcessor {
    @NotNull
    private final XType containing;
    @NotNull
    private final XMethodElement executableElement;
    @NotNull
    private final Context context;

    public DeleteFunctionProcessor(@NotNull Context baseContext, @NotNull XType containing, @NotNull XMethodElement executableElement) {
        Intrinsics.checkNotNullParameter((Object)baseContext, (String)"baseContext");
        Intrinsics.checkNotNullParameter((Object)containing, (String)"containing");
        Intrinsics.checkNotNullParameter((Object)executableElement, (String)"executableElement");
        this.containing = containing;
        this.executableElement = executableElement;
        this.context = Context.fork$default(baseContext, (XElement)this.executableElement, null, null, 6, null);
    }

    @NotNull
    public final XType getContaining() {
        return this.containing;
    }

    @NotNull
    public final XMethodElement getExecutableElement() {
        return this.executableElement;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final DeleteFunction process() {
        ShortcutFunctionProcessor delegate = new ShortcutFunctionProcessor(this.context, this.containing, this.executableElement);
        XAnnotation annotation = delegate.extractAnnotation(Reflection.getOrCreateKotlinClass(Delete.class), ProcessorErrors.INSTANCE.getMISSING_DELETE_ANNOTATION());
        XType returnType = delegate.extractReturnType();
        DeleteOrUpdateFunctionBinder functionBinder = delegate.findDeleteOrUpdateFunctionBinder(returnType);
        this.context.getChecker().check(functionBinder.getAdapter() != null, (XElement)this.executableElement, "Not sure how to handle delete function's return type. Currently the supported return types are void, int or Int.", new Object[0]);
        XAnnotation xAnnotation = annotation;
        Pair<Map<String, ShortcutEntity>, List<ShortcutQueryParameter>> pair = delegate.extractParams(xAnnotation != null && (xAnnotation = xAnnotation.get("entity")) != null ? xAnnotation.asType() : null, "Function annotated with @Delete but does not have any parameters to delete.", (Function2<? super Entity, ? super DataClass, Unit>)((Function2)DeleteFunctionProcessor::process$lambda$0));
        Map entities = (Map)pair.component1();
        List params = (List)pair.component2();
        return new DeleteFunction(delegate.getExecutableElement(), entities, params, functionBinder);
    }

    private static final Unit process$lambda$0(Entity entity, DataClass dataClass) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)dataClass, (String)"<unused var>");
        return Unit.INSTANCE;
    }
}

