/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.processor;

import androidx.room.DatabaseView;
import androidx.room.compiler.processing.XAnnotation;
import androidx.room.compiler.processing.XElement;
import androidx.room.compiler.processing.XTypeElement;
import androidx.room.parser.ParsedQuery;
import androidx.room.parser.QueryType;
import androidx.room.parser.SqlParser;
import androidx.room.processor.Context;
import androidx.room.processor.DataClassProcessor;
import androidx.room.processor.EntityOrViewProcessor;
import androidx.room.processor.PropertyProcessor;
import androidx.room.vo.DataClass;
import java.lang.annotation.Annotation;
import java.util.LinkedHashSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0018\b\u0002\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0014"}, d2={"Landroidx/room/processor/DatabaseViewProcessor;", "Landroidx/room/processor/EntityOrViewProcessor;", "baseContext", "Landroidx/room/processor/Context;", "element", "Landroidx/room/compiler/processing/XTypeElement;", "referenceStack", "Ljava/util/LinkedHashSet;", "", "Lkotlin/collections/LinkedHashSet;", "<init>", "(Landroidx/room/processor/Context;Landroidx/room/compiler/processing/XTypeElement;Ljava/util/LinkedHashSet;)V", "getElement", "()Landroidx/room/compiler/processing/XTypeElement;", "context", "getContext", "()Landroidx/room/processor/Context;", "process", "Landroidx/room/vo/DatabaseView;", "Companion", "room-compiler"})
public final class DatabaseViewProcessor
implements EntityOrViewProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final XTypeElement element;
    @NotNull
    private final LinkedHashSet<String> referenceStack;
    @NotNull
    private final Context context;

    public DatabaseViewProcessor(@NotNull Context baseContext, @NotNull XTypeElement element, @NotNull LinkedHashSet<String> referenceStack) {
        Intrinsics.checkNotNullParameter((Object)baseContext, (String)"baseContext");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(referenceStack, (String)"referenceStack");
        this.element = element;
        this.referenceStack = referenceStack;
        this.context = Context.fork$default(baseContext, (XElement)this.element, null, null, 6, null);
    }

    public /* synthetic */ DatabaseViewProcessor(Context context, XTypeElement xTypeElement, LinkedHashSet linkedHashSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            linkedHashSet = new LinkedHashSet<String>();
        }
        this(context, xTypeElement, linkedHashSet);
    }

    @NotNull
    public final XTypeElement getElement() {
        return this.element;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @Override
    @NotNull
    public androidx.room.vo.DatabaseView process() {
        ParsedQuery parsedQuery;
        String viewName;
        this.context.getChecker().hasAnnotation((XElement)this.element, (KClass<? extends Annotation>)Reflection.getOrCreateKotlinClass(DatabaseView.class), "View class must be annotated with @DatabaseView", new Object[0]);
        XAnnotation annotation = this.element.getAnnotation(Reflection.getOrCreateKotlinClass(DatabaseView.class));
        String string = viewName = annotation != null ? Companion.extractViewName(this.element, annotation) : this.element.getName();
        if (annotation != null) {
            ParsedQuery parsedQuery2;
            String viewSql = annotation.getAsString("value");
            ParsedQuery it = parsedQuery2 = SqlParser.Companion.parse(viewSql);
            boolean bl = false;
            this.context.getChecker().check(it.getErrors().isEmpty(), (XElement)this.element, CollectionsKt.joinToString$default((Iterable)it.getErrors(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), new Object[0]);
            this.context.getChecker().check(it.getType() == QueryType.SELECT, (XElement)this.element, "Query for @DatabaseView must be a SELECT.", new Object[0]);
            this.context.getChecker().check(it.getBindSections().isEmpty(), (XElement)this.element, "Query for @DatabaseView cannot take any arguments.", new Object[0]);
            parsedQuery = parsedQuery2;
        } else {
            parsedQuery = ParsedQuery.Companion.getMISSING();
        }
        ParsedQuery query = parsedQuery;
        this.context.getChecker().notBlank(viewName, (XElement)this.element, "View name cannot be blank. If you don't want to set it, just remove the viewName property.", new Object[0]);
        this.context.getChecker().check(!StringsKt.startsWith((String)viewName, (String)"sqlite_", (boolean)true), (XElement)this.element, "View name cannot start with \"sqlite_\".", new Object[0]);
        DataClass pojo = DataClassProcessor.Companion.createFor(this.context, this.element, PropertyProcessor.BindingScope.READ_FROM_STMT, null, this.referenceStack).process();
        return new androidx.room.vo.DatabaseView(this.element, viewName, query, pojo.getType(), pojo.getProperties(), pojo.getEmbeddedProperties(), pojo.getConstructor());
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Landroidx/room/processor/DatabaseViewProcessor$Companion;", "", "<init>", "()V", "extractViewName", "", "element", "Landroidx/room/compiler/processing/XTypeElement;", "annotation", "Landroidx/room/compiler/processing/XAnnotation;", "room-compiler"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String extractViewName(@NotNull XTypeElement element, @NotNull XAnnotation annotation) {
            Object viewName;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            Object object = annotation.get("viewName");
            if (object == null || (object = object.asString()) == null) {
                object = "";
            }
            return Intrinsics.areEqual((Object)(viewName = object), (Object)"") ? element.getName() : viewName;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

