/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.processor;

import androidx.room.ConstructedBy;
import androidx.room.Database;
import androidx.room.SkipQueryVerification;
import androidx.room.compiler.codegen.XClassName;
import androidx.room.compiler.codegen.XTypeName;
import androidx.room.compiler.processing.XAnnotation;
import androidx.room.compiler.processing.XAnnotationValue;
import androidx.room.compiler.processing.XElement;
import androidx.room.compiler.processing.XMethodElement;
import androidx.room.compiler.processing.XType;
import androidx.room.compiler.processing.XTypeElement;
import androidx.room.ext.RoomTypeNames;
import androidx.room.log.RLog;
import androidx.room.migration.bundle.DatabaseBundle;
import androidx.room.migration.bundle.SchemaBundle;
import androidx.room.parser.Table;
import androidx.room.processor.AutoMigrationProcessor;
import androidx.room.processor.Context;
import androidx.room.processor.DaoProcessor;
import androidx.room.processor.DatabaseViewProcessor;
import androidx.room.processor.EntityProcessorKt;
import androidx.room.processor.ProcessorErrors;
import androidx.room.util.SchemaFileResolver;
import androidx.room.verifier.DatabaseVerificationErrors;
import androidx.room.verifier.DatabaseVerifier;
import androidx.room.verifier.QueryResultInfo;
import androidx.room.vo.AutoMigration;
import androidx.room.vo.Dao;
import androidx.room.vo.DaoFunction;
import androidx.room.vo.DataClass;
import androidx.room.vo.DatabaseConstructor;
import androidx.room.vo.DatabaseView;
import androidx.room.vo.DeleteOrUpdateShortcutFunction;
import androidx.room.vo.Entity;
import androidx.room.vo.ForeignKey;
import androidx.room.vo.FtsEntity;
import androidx.room.vo.HasPropertiesKt;
import androidx.room.vo.Index;
import androidx.room.vo.InsertOrUpsertShortcutFunction;
import androidx.room.vo.Property;
import androidx.room.vo.ShortcutEntity;
import androidx.room.vo.Warning;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0013\u001a\u00020\u0012H\u0002J&\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u001e\u0010 \u001a\u00020!2\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u0015H\u0002J\u001e\u0010$\u001a\u00020!2\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u0015H\u0002J,\u0010%\u001a\u00020!2\u0006\u0010&\u001a\u00020\u00052\f\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u00152\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u0015H\u0002J,\u0010)\u001a\u00020!2\u0006\u0010&\u001a\u00020\u00052\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u00152\f\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\u0015H\u0002J\u001e\u0010,\u001a\u00020!2\u0006\u0010&\u001a\u00020\u00052\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u0015H\u0002J\u001e\u0010-\u001a\b\u0012\u0004\u0012\u00020#0\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u001c\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020+0/2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J$\u00100\u001a\u00020!2\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020+0/2\u0006\u00102\u001a\u000203H\u0002J\u001a\u00104\u001a\b\u0012\u0004\u0012\u00020+0\u00152\f\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\u0015J\u0012\u00105\u001a\u0004\u0018\u0001062\u0006\u0010\u0004\u001a\u00020\u0005H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\r\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u000e\u0010\t\u00a8\u00067"}, d2={"Landroidx/room/processor/DatabaseProcessor;", "", "baseContext", "Landroidx/room/processor/Context;", "element", "Landroidx/room/compiler/processing/XTypeElement;", "<init>", "(Landroidx/room/processor/Context;Landroidx/room/compiler/processing/XTypeElement;)V", "getElement", "()Landroidx/room/compiler/processing/XTypeElement;", "context", "getContext", "()Landroidx/room/processor/Context;", "roomDatabaseTypeElement", "getRoomDatabaseTypeElement", "roomDatabaseTypeElement$delegate", "Lkotlin/Lazy;", "process", "Landroidx/room/vo/Database;", "doProcess", "processAutoMigrations", "", "Landroidx/room/vo/AutoMigration;", "dbAnnotation", "Landroidx/room/compiler/processing/XAnnotation;", "latestDbSchema", "Landroidx/room/migration/bundle/DatabaseBundle;", "getSchemaBundle", "version", "", "schemaFolderPath", "Ljava/nio/file/Path;", "validateForeignKeys", "", "entities", "Landroidx/room/vo/Entity;", "validateUniqueIndices", "validateUniqueDaoClasses", "dbElement", "daoFunctions", "Landroidx/room/vo/DaoFunction;", "validateUniqueTableAndViewNames", "views", "Landroidx/room/vo/DatabaseView;", "validateExternalContentFts", "processEntities", "processDatabaseViews", "", "verifyDatabaseViews", "map", "dbVerifier", "Landroidx/room/verifier/DatabaseVerifier;", "resolveDatabaseViews", "processConstructorObject", "Landroidx/room/vo/DatabaseConstructor;", "room-compiler"})
@SourceDebugExtension(value={"SMAP\nDatabaseProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseProcessor.kt\nandroidx/room/processor/DatabaseProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,613:1\n1755#2,3:614\n1755#2,3:617\n1611#2,9:620\n1863#2:629\n1864#2:631\n1620#2:632\n1202#2,2:634\n1230#2,4:636\n1863#2:640\n1863#2:641\n1611#2,9:642\n1863#2:651\n1864#2:653\n1620#2:654\n1557#2:655\n1628#2,3:656\n1864#2:659\n1864#2:660\n1368#2:661\n1454#2,2:662\n1557#2:664\n1628#2,3:665\n1456#2,3:668\n1485#2:671\n1510#2,3:672\n1513#2,3:682\n1663#2,8:693\n1557#2:701\n1628#2,3:702\n1557#2:706\n1628#2,3:707\n1485#2:710\n1510#2,3:711\n1513#2,3:721\n1557#2:725\n1628#2,3:726\n1863#2,2:729\n1863#2:732\n1863#2:733\n1864#2:736\n1863#2:737\n1864#2:740\n1864#2:741\n1557#2:742\n1628#2,3:743\n1557#2:746\n1628#2,3:747\n1485#2:750\n1510#2,3:751\n1513#2,3:761\n1557#2:772\n1628#2,3:773\n1863#2,2:776\n827#2:779\n855#2,2:780\n1863#2,2:782\n1611#2,9:784\n1863#2:793\n1864#2:795\n1620#2:796\n1611#2,9:797\n1863#2:806\n1864#2:808\n1620#2:809\n1557#2:810\n1628#2,3:811\n1557#2:814\n1628#2,3:815\n774#2:818\n865#2:819\n1734#2,3:820\n866#2:823\n1863#2,2:824\n1557#2:826\n1628#2,3:827\n1755#2,3:830\n2632#2,3:833\n1#3:630\n1#3:633\n1#3:652\n1#3:794\n1#3:807\n381#4,7:675\n535#4:685\n520#4,6:686\n381#4,7:714\n381#4,7:754\n535#4:764\n520#4,6:765\n216#5:692\n217#5:705\n216#5:724\n217#5:731\n216#5,2:734\n216#5,2:738\n216#5:771\n217#5:778\n*S KotlinDebug\n*F\n+ 1 DatabaseProcessor.kt\nandroidx/room/processor/DatabaseProcessor\n*L\n126#1:614,3\n129#1:617,3\n178#1:620,9\n178#1:629\n178#1:631\n178#1:632\n240#1:634,2\n240#1:636,4\n241#1:640\n242#1:641\n255#1:642,9\n255#1:651\n255#1:653\n255#1:654\n280#1:655\n280#1:656,3\n242#1:659\n241#1:660\n291#1:661\n291#1:662,2\n293#1:664\n293#1:665,3\n291#1:668,3\n295#1:671\n295#1:672,3\n295#1:682,3\n299#1:693,8\n304#1:701\n304#1:702,3\n318#1:706\n318#1:707,3\n320#1:710\n320#1:711,3\n320#1:721,3\n326#1:725\n326#1:726,3\n328#1:729,2\n353#1:732\n354#1:733\n354#1:736\n359#1:737\n359#1:740\n353#1:741\n373#1:742\n373#1:743,3\n381#1:746\n381#1:747,3\n389#1:750\n389#1:751,3\n389#1:761,3\n395#1:772\n395#1:773,3\n399#1:776,2\n408#1:779\n408#1:780,2\n412#1:782,2\n430#1:784,9\n430#1:793\n430#1:795\n430#1:796\n449#1:797,9\n449#1:806\n449#1:808\n449#1:809\n495#1:810\n495#1:811,3\n499#1:814\n499#1:815,3\n517#1:818\n517#1:819\n517#1:820,3\n517#1:823\n518#1:824,2\n529#1:826\n529#1:827,3\n606#1:830,3\n496#1:833,3\n178#1:630\n255#1:652\n430#1:794\n449#1:807\n295#1:675,7\n296#1:685\n296#1:686,6\n320#1:714,7\n389#1:754,7\n390#1:764\n390#1:765,6\n297#1:692\n297#1:705\n321#1:724\n321#1:731\n355#1:734,2\n360#1:738,2\n391#1:771\n391#1:778\n*E\n"})
public final class DatabaseProcessor {
    @NotNull
    private final XTypeElement element;
    @NotNull
    private final Context context;
    @NotNull
    private final Lazy roomDatabaseTypeElement$delegate;

    public DatabaseProcessor(@NotNull Context baseContext, @NotNull XTypeElement element) {
        Intrinsics.checkNotNullParameter((Object)baseContext, (String)"baseContext");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.element = element;
        this.context = Context.fork$default(baseContext, (XElement)this.element, null, null, 6, null);
        this.roomDatabaseTypeElement$delegate = LazyKt.lazy(() -> DatabaseProcessor.roomDatabaseTypeElement_delegate$lambda$0(this));
    }

    @NotNull
    public final XTypeElement getElement() {
        return this.element;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    private final XTypeElement getRoomDatabaseTypeElement() {
        Lazy lazy = this.roomDatabaseTypeElement$delegate;
        return (XTypeElement)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final androidx.room.vo.Database process() {
        try {
            androidx.room.vo.Database database = this.doProcess();
            return database;
        }
        finally {
            block3: {
                DatabaseVerifier databaseVerifier = this.context.getDatabaseVerifier();
                if (databaseVerifier == null) break block3;
                databaseVerifier.closeConnection(this.context);
            }
        }
    }

    private final androidx.room.vo.Database doProcess() {
        boolean bl;
        boolean hasForeignKeys;
        List daoFunctions;
        List<DatabaseView> views;
        List<Entity> entities;
        XAnnotation dbAnnotation;
        block8: {
            boolean bl2;
            block7: {
                DatabaseVerifier dbVerifier;
                dbAnnotation = this.element.requireAnnotation(Reflection.getOrCreateKotlinClass(Database.class));
                entities = this.processEntities(dbAnnotation, this.element);
                Map<XTypeElement, DatabaseView> viewsMap = this.processDatabaseViews(dbAnnotation);
                this.validateForeignKeys(this.element, entities);
                this.validateExternalContentFts(this.element, entities);
                boolean extendsRoomDb = this.getRoomDatabaseTypeElement().getType().isAssignableFrom(this.element.getType());
                this.context.getChecker().check(extendsRoomDb, (XElement)this.element, ProcessorErrors.INSTANCE.getDB_MUST_EXTEND_ROOM_DB(), new Object[0]);
                views = this.resolveDatabaseViews(CollectionsKt.toList((Iterable)viewsMap.values()));
                DatabaseVerifier databaseVerifier = dbVerifier = this.element.hasAnnotation(Reflection.getOrCreateKotlinClass(SkipQueryVerification.class)) ? null : DatabaseVerifier.Companion.create(this.context, (XElement)this.element, entities, views);
                if (dbVerifier != null) {
                    this.context.attachDatabaseVerifier(dbVerifier);
                    this.verifyDatabaseViews(viewsMap, dbVerifier);
                }
                this.validateUniqueTableAndViewNames(this.element, entities, views);
                XType declaredType = this.element.getType();
                daoFunctions = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.filter((Sequence)this.element.getAllMethods(), DatabaseProcessor::doProcess$lambda$1), DatabaseProcessor::doProcess$lambda$2), arg_0 -> DatabaseProcessor.doProcess$lambda$3(this, declaredType, dbVerifier, arg_0)));
                this.validateUniqueDaoClasses(this.element, daoFunctions, entities);
                this.validateUniqueIndices(this.element, entities);
                Iterable $this$any$iv = entities;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Entity it = (Entity)element$iv;
                        boolean bl3 = false;
                        boolean bl4 = !((Collection)it.getForeignKeys()).isEmpty();
                        if (!bl4) continue;
                        bl2 = true;
                        break block7;
                    }
                    bl2 = false;
                }
            }
            hasForeignKeys = bl2;
            Iterable $this$any$iv = this.getRoomDatabaseTypeElement().getDeclaredMethods();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    XMethodElement it = (XMethodElement)element$iv;
                    boolean bl5 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)"clearAllTables")) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        boolean hasClearAllTables = bl;
        int version = dbAnnotation.getAsInt("version");
        this.context.getChecker().check(version > 0, (XElement)this.element, "Database version must be greater than 0", new Object[0]);
        DatabaseConstructor constructorObject = this.processConstructorObject(this.element);
        XAnnotationValue xAnnotationValue = dbAnnotation.get("exportSchema");
        boolean exportSchema = xAnnotationValue != null ? xAnnotationValue.asBoolean() : true;
        XTypeElement xTypeElement = this.element;
        XType xType = this.element.getType();
        androidx.room.vo.Database database = new androidx.room.vo.Database(xTypeElement, xType, entities, views, daoFunctions, version, exportSchema, hasForeignKeys, hasClearAllTables, constructorObject);
        database.setAutoMigrations(this.processAutoMigrations(this.element, dbAnnotation, database.getBundle()));
        return database;
    }

    /*
     * Unable to fully structure code
     */
    private final List<AutoMigration> processAutoMigrations(XTypeElement element, XAnnotation dbAnnotation, DatabaseBundle latestDbSchema) {
        v0 = dbAnnotation.get("autoMigrations");
        if (v0 == null || (v0 = v0.asAnnotationList()) == null) {
            v0 = CollectionsKt.emptyList();
        }
        if ((autoMigrationList = v0).isEmpty()) {
            return CollectionsKt.emptyList();
        }
        v1 = dbAnnotation.get("exportSchema");
        v2 = exportSchemaEnabled = v1 != null ? v1.asBoolean() : true;
        if (!exportSchemaEnabled) {
            this.context.getLogger().e((XElement)element, "Cannot create auto migrations when exportSchema is false.", new Object[0]);
            return CollectionsKt.emptyList();
        }
        schemaInFolderPath = this.context.getSchemaInFolderPath();
        if (schemaInFolderPath == null) {
            this.context.getLogger().e((XElement)element, "Schema import directory was not provided to the annotation processor so Room cannot read older schemas. To generate auto migrations, you must provide `room.schemaLocation` annotation processor arguments by applying the Room Gradle plugin (id 'androidx.room') AND set exportSchema to true.", new Object[0]);
            return CollectionsKt.emptyList();
        }
        $this$mapNotNull$iv = (Iterable)autoMigrationList;
        $i$f$mapNotNull = false;
        var9_9 = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        var14_14 = $this$forEach$iv$iv$iv.iterator();
        while (var14_14.hasNext()) {
            block8: {
                block9: {
                    block7: {
                        element$iv$iv = element$iv$iv$iv = var14_14.next();
                        $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                        autoMigrationAnnotation = (XAnnotation)element$iv$iv;
                        $i$a$-mapNotNull-DatabaseProcessor$processAutoMigrations$1 = false;
                        var20_21 = new String[]{element.asClassName().getCanonicalName()};
                        databaseSchemaInFolderPath = Path.of(schemaInFolderPath, var20_21);
                        fromVersion = autoMigrationAnnotation.getAsInt("from");
                        toVersion = autoMigrationAnnotation.getAsInt("to");
                        Intrinsics.checkNotNull((Object)databaseSchemaInFolderPath);
                        if (this.getSchemaBundle(fromVersion, databaseSchemaInFolderPath) != null) break block7;
                        v3 = null;
                        break block8;
                    }
                    if (toVersion != latestDbSchema.getVersion()) break block9;
                    v4 = latestDbSchema;
                    ** GOTO lbl-1000
                }
                v4 = this.getSchemaBundle(toVersion, databaseSchemaInFolderPath);
                if (v4 == null) {
                    v3 = null;
                } else lbl-1000:
                // 2 sources

                {
                    toSchemaBundle = v4;
                    v5 = autoMigrationAnnotation.get("spec");
                    v3 = new AutoMigrationProcessor(this.context, (XType)(v5 != null ? v5.asType() : null), fromSchemaBundle, toSchemaBundle).process();
                }
            }
            if (v3 == null) continue;
            it$iv$iv = v3;
            $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final DatabaseBundle getSchemaBundle(int version, Path schemaFolderPath) {
        Closeable bundle;
        Closeable closeable;
        InputStream inputStream;
        try {
            SchemaFileResolver schemaFileResolver = SchemaFileResolver.Companion.getRESOLVER();
            Path path = schemaFolderPath.resolve(version + ".json");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            inputStream = schemaFileResolver.readPath(path);
        }
        catch (IOException e) {
            inputStream = null;
        }
        InputStream schemaStream = inputStream;
        if (schemaStream == null) {
            this.context.getLogger().e((XElement)this.element, ProcessorErrors.INSTANCE.autoMigrationSchemasNotFound(version, ((Object)schemaFolderPath).toString()), new Object[0]);
            return null;
        }
        try {
            SchemaBundle schemaBundle;
            closeable = schemaStream;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                schemaBundle = SchemaBundle.Companion.deserialize(schemaStream);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            closeable = schemaBundle;
        }
        catch (FileNotFoundException ex) {
            this.context.getLogger().e((XElement)this.element, ProcessorErrors.INSTANCE.autoMigrationSchemasNotFound(version, ((Object)schemaFolderPath).toString()), new Object[0]);
            closeable = null;
        }
        catch (Throwable th) {
            RLog rLog = this.context.getLogger();
            String string = th.getMessage();
            if (string == null) {
                string = "";
            }
            rLog.e("Unable to read schema file: " + string, new Object[0]);
            this.context.getLogger().e((XElement)this.element, ProcessorErrors.INSTANCE.invalidAutoMigrationSchema(version, ((Object)schemaFolderPath).toString()), new Object[0]);
            closeable = null;
        }
        Closeable closeable2 = bundle = closeable;
        return closeable2 != null ? closeable2.getDatabase() : null;
    }

    /*
     * WARNING - void declaration
     */
    private final void validateForeignKeys(XTypeElement element, List<? extends Entity> entities) {
        void $this$associateByTo$iv$iv;
        Iterable $this$associateBy$iv = entities;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            Entity entity = (Entity)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getTableName(), element$iv$iv);
        }
        Map byTableName = destination$iv$iv;
        Iterable $this$forEach$iv = entities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Entity entity = (Entity)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = entity.getForeignKeys();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                void $this$mapNotNullTo$iv$iv;
                ForeignKey foreignKey = (ForeignKey)element$iv2;
                boolean bl2 = false;
                Entity parent = (Entity)byTableName.get(foreignKey.getParentTable());
                if (parent == null) {
                    this.context.getLogger().e((XElement)element, ProcessorErrors.INSTANCE.foreignKeyMissingParentEntityInDatabase(foreignKey.getParentTable(), entity.getElement().getQualifiedName()), new Object[0]);
                    continue;
                }
                Iterable $this$mapNotNull$iv = foreignKey.getParentColumns();
                boolean $i$f$mapNotNull = false;
                Object object = $this$mapNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach3 = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Property it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl3 = false;
                    String columnName = (String)element$iv$iv;
                    boolean bl4 = false;
                    Property parentField = HasPropertiesKt.findPropertyByColumnName(parent, columnName);
                    if (parentField == null) {
                        this.context.getLogger().e((XElement)entity.getElement(), ProcessorErrors.INSTANCE.foreignKeyParentColumnDoesNotExist(parent.getElement().getQualifiedName(), columnName, HasPropertiesKt.getColumnNames(parent)), new Object[0]);
                    }
                    if (parentField == null) continue;
                    boolean bl5 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                List parentFields = (List)destination$iv$iv2;
                if (parentFields.size() != foreignKey.getParentColumns().size() || parent.isUnique(foreignKey.getParentColumns())) continue;
                ProcessorErrors processorErrors = ProcessorErrors.INSTANCE;
                String string = parent.getElement().getQualifiedName();
                object = entity.getElement().getQualifiedName();
                List<String> list = foreignKey.getParentColumns();
                $this$forEach$iv$iv$iv = foreignKey.getChildProperties();
                XElement xElement = (XElement)parent.getElement();
                RLog rLog = this.context.getLogger();
                boolean $i$f$map = false;
                iterator = $this$map$iv;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Property bl4 = (Property)item$iv$iv;
                    collection = destination$iv$iv3;
                    boolean bl6 = false;
                    collection.add(it.getColumnName());
                }
                collection = (List)destination$iv$iv3;
                List list2 = collection;
                rLog.e(xElement, processorErrors.foreignKeyMissingIndexInParent(string, list, (String)object, list2), new Object[0]);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void validateUniqueIndices(XTypeElement element, List<? extends Entity> entities) {
        void $this$filterTo$iv$iv;
        Object it;
        Object $this$groupByTo$iv$iv;
        Iterable list$iv$iv;
        Object object;
        Index index;
        Object element$iv$iv2;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = entities;
        boolean $i$f$flatMap = false;
        Object object2 = $this$flatMap$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv2 : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            Entity entity = (Entity)element$iv$iv2;
            boolean bl = false;
            Iterable $this$map$iv = entity.getIndices();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                index = (Index)item$iv$iv;
                object = destination$iv$iv2;
                boolean bl2 = false;
                object.add(new Pair((Object)it2.getName(), (Object)entity));
            }
            list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$flatMapTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator<Object> iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object3;
            element$iv$iv2 = iterator.next();
            it = (Pair)element$iv$iv2;
            boolean bl = false;
            String key$iv$iv = (String)it.getFirst();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl3 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object3 = answer$iv$iv$iv;
            } else {
                object3 = value$iv$iv$iv;
            }
            list$iv$iv = (List)object3;
            list$iv$iv.add(element$iv$iv2);
        }
        Object $this$filter$iv = destination$iv$iv;
        boolean $i$f$filter = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            it = element$iv$iv2 = (Map.Entry)iterator.next();
            boolean bl = false;
            if (!(((List)it.getValue()).size() > 1)) continue;
            destination$iv$iv.put(element$iv$iv2.getKey(), element$iv$iv2.getValue());
        }
        Object $this$forEach$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        object2 = $this$forEach$iv.entrySet().iterator();
        while (object2.hasNext()) {
            Collection<CallSite> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Map.Entry element$iv;
            Map.Entry it3 = element$iv = (Map.Entry)object2.next();
            boolean bl = false;
            Iterable $this$distinctBy$iv = (Iterable)it3.getValue();
            boolean $i$f$distinctBy = false;
            HashSet<XTypeName> set$iv = new HashSet<XTypeName>();
            ArrayList list$iv = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv) {
                Pair it4 = (Pair)e$iv;
                boolean bl4 = false;
                XTypeName key$iv = ((Entity)it4.getSecond()).getTypeName();
                if (!set$iv.add(key$iv)) continue;
                list$iv.add(e$iv);
            }
            if (((List)list$iv).size() <= 1) continue;
            $this$distinctBy$iv = (Iterable)it3.getValue();
            String string = (String)it3.getKey();
            ProcessorErrors processorErrors = ProcessorErrors.INSTANCE;
            index = (XElement)element;
            object = this.context.getLogger();
            boolean $i$f$map = false;
            set$iv = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it5;
                Pair bl4 = (Pair)item$iv$iv;
                collection = destination$iv$iv3;
                boolean bl5 = false;
                collection.add((CallSite)((Object)(((Entity)it5.getSecond()).getTypeName().toString(this.context.getCodeLanguage()) + " > " + it5.getFirst())));
            }
            collection = (List)destination$iv$iv3;
            ((RLog)object).e((XElement)index, processorErrors.duplicateIndexInDatabase(string, (List<String>)collection), new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void validateUniqueDaoClasses(XTypeElement dbElement, List<DaoFunction> daoFunctions, List<? extends Entity> entities) {
        Iterator<Map.Entry<String, ShortcutEntity>> iterator;
        void $this$forEach$iv;
        Object list$iv$iv;
        Object $this$getOrPut$iv$iv$iv;
        Object element$iv$iv;
        Iterator $this$groupByTo$iv$iv;
        Object $this$groupBy$iv;
        DaoFunction it;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = entities;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Entity entity = (Entity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((DataClass)((Object)it)).getTypeName());
        }
        Set entityTypeNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        $this$map$iv = daoFunctions;
        boolean $i$f$groupBy = false;
        $this$mapTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator2 = $this$groupByTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object object;
            element$iv$iv = iterator2.next();
            it = (DaoFunction)element$iv$iv;
            boolean bl3 = false;
            XClassName key$iv$iv = it.getDao().getTypeName();
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        $this$groupByTo$iv$iv = $this$forEach$iv.entrySet().iterator();
        while ($this$groupByTo$iv$iv.hasNext()) {
            Collection<String> collection;
            Iterator $this$mapTo$iv$iv2;
            void $this$map$iv2;
            Map.Entry element$iv;
            Map.Entry it2 = element$iv = $this$groupByTo$iv$iv.next();
            boolean bl = false;
            if (((List)it2.getValue()).size() <= 1) continue;
            element$iv$iv = (Iterable)it2.getValue();
            list$iv$iv = ((XClassName)it2.getKey()).toString(this.context.getCodeLanguage());
            ProcessorErrors bl3 = ProcessorErrors.INSTANCE;
            boolean $i$f$map2 = false;
            $this$getOrPut$iv$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            Iterator answer$iv$iv$iv = $this$mapTo$iv$iv2.iterator();
            while (answer$iv$iv$iv.hasNext()) {
                void it3;
                Object item$iv$iv = answer$iv$iv$iv.next();
                iterator = (DaoFunction)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl4 = false;
                collection.add(it3.getElement().getName());
            }
            collection = (List)destination$iv$iv2;
            String error = bl3.duplicateDao((String)list$iv$iv, (List<String>)collection);
            Iterable $this$forEach$iv2 = (Iterable)it2.getValue();
            boolean $i$f$forEach2 = false;
            $this$mapTo$iv$iv2 = $this$forEach$iv2.iterator();
            while ($this$mapTo$iv$iv2.hasNext()) {
                Object element$iv2 = $this$mapTo$iv$iv2.next();
                DaoFunction daoFunction = (DaoFunction)element$iv2;
                boolean bl5 = false;
                this.context.getLogger().e((XElement)daoFunction.getElement(), "Dao function has conflicts.", new Object[0]);
            }
            this.context.getLogger().e((XElement)dbElement, error, new Object[0]);
        }
        Function3 check = (arg_0, arg_1, arg_2) -> DatabaseProcessor.validateUniqueDaoClasses$lambda$26(entityTypeNames, this, dbElement, arg_0, arg_1, arg_2);
        Iterable $this$forEach$iv3 = daoFunctions;
        boolean $i$f$forEach3 = false;
        for (Object element$iv : $this$forEach$iv3) {
            Map.Entry<String, ShortcutEntity> it4;
            Map.Entry<String, ShortcutEntity> element$iv3;
            boolean $i$f$forEach4;
            Map<String, ShortcutEntity> $this$forEach$iv4;
            Object function;
            DaoFunction daoFunction = (DaoFunction)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv5 = daoFunction.getDao().getMDeleteOrUpdateShortcutFunctions();
            boolean $i$f$forEach5 = false;
            for (Object element$iv4 : $this$forEach$iv5) {
                function = (DeleteOrUpdateShortcutFunction)element$iv4;
                boolean bl6 = false;
                $this$forEach$iv4 = ((DeleteOrUpdateShortcutFunction)function).getEntities();
                $i$f$forEach4 = false;
                iterator = $this$forEach$iv4.entrySet().iterator();
                while (iterator.hasNext()) {
                    it4 = element$iv3 = (Map.Entry<String, ShortcutEntity>)iterator.next();
                    boolean bl7 = false;
                    check.invoke((Object)((DeleteOrUpdateShortcutFunction)function).getElement(), (Object)daoFunction.getDao(), (Object)((ShortcutEntity)it4.getValue()).getEntityTypeName());
                }
            }
            $this$forEach$iv5 = daoFunction.getDao().getMInsertOrUpsertShortcutFunctions();
            $i$f$forEach5 = false;
            for (Object element$iv4 : $this$forEach$iv5) {
                function = (InsertOrUpsertShortcutFunction)element$iv4;
                boolean bl8 = false;
                $this$forEach$iv4 = ((InsertOrUpsertShortcutFunction)function).getEntities();
                $i$f$forEach4 = false;
                iterator = $this$forEach$iv4.entrySet().iterator();
                while (iterator.hasNext()) {
                    it4 = element$iv3 = iterator.next();
                    boolean bl9 = false;
                    check.invoke((Object)((InsertOrUpsertShortcutFunction)function).getElement(), (Object)daoFunction.getDao(), (Object)it4.getValue().getEntityTypeName());
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void validateUniqueTableAndViewNames(XTypeElement dbElement, List<? extends Entity> entities, List<DatabaseView> views) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Object $this$filter$iv;
        String key$iv$iv;
        Object element$iv$iv2;
        void $this$groupByTo$iv$iv;
        Object $this$groupBy$iv;
        void $this$mapTo$iv$iv;
        Collection collection;
        Object item$iv$iv2;
        void $this$mapTo$iv$iv2;
        Iterable $this$map$iv = entities;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
            void it;
            Entity entity = (Entity)item$iv$iv2;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getTableName();
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            collection.add(new Triple((Object)string2, (Object)it.getTypeName().toString(this.context.getCodeLanguage()), (Object)it.getElement()));
        }
        List entitiesInfo = (List)destination$iv$iv;
        Iterable $this$map$iv2 = views;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Object destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
            void it;
            DatabaseView bl = (DatabaseView)item$iv$iv3;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            String string = it.getViewName();
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string3 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            collection.add(new Triple((Object)string3, (Object)it.getTypeName().toString(this.context.getCodeLanguage()), (Object)it.getElement()));
        }
        List viewsInfo = (List)destination$iv$iv2;
        $this$map$iv2 = CollectionsKt.plus((Collection)entitiesInfo, (Iterable)viewsInfo);
        boolean $i$f$groupBy = false;
        $this$mapTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv2 : $this$groupByTo$iv$iv) {
            Object object;
            String name;
            Triple it = (Triple)element$iv$iv2;
            boolean bl = false;
            key$iv$iv = name = (String)it.component1();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv2;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl3 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv2);
        }
        $this$groupBy$iv = destination$iv$iv2;
        boolean $i$f$filter = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        item$iv$iv2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (item$iv$iv2.hasNext()) {
            Object it = element$iv$iv2 = (Map.Entry)item$iv$iv2.next();
            boolean bl = false;
            if (!(((List)it.getValue()).size() > 1)) continue;
            destination$iv$iv2.put(element$iv$iv2.getKey(), element$iv$iv2.getValue());
        }
        $this$filter$iv = destination$iv$iv2;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Collection<String> collection2;
            void $this$mapTo$iv$iv3;
            void $this$map$iv3;
            Map.Entry element$iv;
            Map.Entry byName = element$iv = iterator.next();
            boolean bl = false;
            element$iv$iv2 = (Iterable)byName.getValue();
            String string = (String)byName.getKey();
            ProcessorErrors processorErrors = ProcessorErrors.INSTANCE;
            boolean $i$f$map3 = false;
            key$iv$iv = $this$map$iv3;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv4 : $this$mapTo$iv$iv3) {
                Triple triple = (Triple)item$iv$iv4;
                collection2 = destination$iv$iv3;
                boolean bl4 = false;
                String typeName = (String)triple.component2();
                collection2.add(typeName);
            }
            collection2 = (List)destination$iv$iv3;
            String error = processorErrors.duplicateTableNames(string, (List<String>)collection2);
            Iterable $this$forEach$iv2 = (Iterable)byName.getValue();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Triple triple = (Triple)element$iv2;
                boolean bl5 = false;
                XTypeElement element = (XTypeElement)triple.component3();
                this.context.getLogger().e((XElement)element, error, new Object[0]);
            }
            this.context.getLogger().e((XElement)dbElement, error, new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void validateExternalContentFts(XTypeElement dbElement, List<? extends Entity> entities) {
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv = CollectionsKt.filterIsInstance((Iterable)entities, FtsEntity.class);
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            FtsEntity it = (FtsEntity)element$iv$iv;
            boolean bl = false;
            if (it.getFtsOptions().getContentEntity() == null || entities.contains(it.getFtsOptions().getContentEntity())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FtsEntity it = (FtsEntity)element$iv;
            boolean bl = false;
            RLog rLog = this.context.getLogger();
            XElement xElement = (XElement)dbElement;
            String string = it.getElement().getQualifiedName();
            Entity entity = it.getFtsOptions().getContentEntity();
            Intrinsics.checkNotNull((Object)entity);
            rLog.e(xElement, ProcessorErrors.INSTANCE.missingExternalContentEntity(string, entity.getElement().getQualifiedName()), new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Entity> processEntities(XAnnotation dbAnnotation, XTypeElement element) {
        void $this$mapNotNullTo$iv$iv;
        Object object = dbAnnotation.get("entities");
        if (object == null || (object = object.asTypeList()) == null) {
            object = CollectionsKt.emptyList();
        }
        Object entityList = object;
        this.context.getChecker().check(!((Collection)entityList).isEmpty(), (XElement)element, "@Database annotation must specify list of entities", new Object[0]);
        Iterable $this$mapNotNull$iv = (Iterable)entityList;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Entity entity;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            XType it = (XType)element$iv$iv;
            boolean bl2 = false;
            XTypeElement typeElement = it.getTypeElement();
            if (typeElement == null) {
                this.context.getLogger().e((XElement)element, ProcessorErrors.INSTANCE.invalidEntityTypeInDatabaseAnnotation(it.asTypeName().toString(this.context.getCodeLanguage())), new Object[0]);
                entity = null;
            } else {
                entity = EntityProcessorKt.EntityProcessor$default(this.context, typeElement, null, 4, null).process();
            }
            if (entity == null) continue;
            Entity it$iv$iv = entity;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<XTypeElement, DatabaseView> processDatabaseViews(XAnnotation dbAnnotation) {
        void $this$mapNotNullTo$iv$iv;
        Object object = dbAnnotation.get("views");
        if (object == null || (object = object.asTypeList()) == null) {
            object = CollectionsKt.emptyList();
        }
        Object viewList = object;
        Iterable $this$mapNotNull$iv = (Iterable)viewList;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            XType it = (XType)element$iv$iv;
            boolean bl2 = false;
            XTypeElement viewElement = it.getTypeElement();
            if (viewElement == null) {
                this.context.getLogger().e((XElement)this.element, ProcessorErrors.INSTANCE.invalidViewTypeInDatabaseAnnotation(it.asTypeName().toString(this.context.getCodeLanguage())), new Object[0]);
                pair = null;
            } else {
                pair = TuplesKt.to((Object)viewElement, (Object)new DatabaseViewProcessor(this.context, viewElement, null, 4, null).process());
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    private final void verifyDatabaseViews(Map<XTypeElement, DatabaseView> map, DatabaseVerifier dbVerifier) {
        for (Map.Entry<XTypeElement, DatabaseView> entry : map.entrySet()) {
            XTypeElement viewElement = entry.getKey();
            DatabaseView view = entry.getValue();
            if (viewElement.hasAnnotation(Reflection.getOrCreateKotlinClass(SkipQueryVerification.class))) continue;
            view.getQuery().setResultInfo(dbVerifier.analyze(view.getQuery().getOriginal()));
            QueryResultInfo queryResultInfo = view.getQuery().getResultInfo();
            if ((queryResultInfo != null ? queryResultInfo.getError() : null) == null) continue;
            RLog rLog = this.context.getLogger();
            XElement xElement = (XElement)viewElement;
            QueryResultInfo queryResultInfo2 = view.getQuery().getResultInfo();
            Intrinsics.checkNotNull((Object)queryResultInfo2);
            SQLException sQLException = queryResultInfo2.getError();
            Intrinsics.checkNotNull((Object)sQLException);
            rLog.e(xElement, DatabaseVerificationErrors.INSTANCE.cannotVerifyQuery(sQLException), new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<DatabaseView> resolveDatabaseViews(@NotNull List<DatabaseView> views) {
        Collection collection;
        Object object;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(views, (String)"views");
        if (views.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$map$iv = views;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Set<String> destination$iv$iv = (Set<String>)((Object)new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10)));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Iterator<Object> it;
            DatabaseView databaseView = (DatabaseView)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(((DatabaseView)((Object)it)).getViewName());
        }
        List viewNames = (List)((Object)destination$iv$iv);
        for (DatabaseView view : views) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            $this$mapTo$iv$iv = view.getQuery().getTables();
            object = view.getTables();
            boolean $i$f$map2 = false;
            void $i$f$mapTo2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                Table table = (Table)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                String name = table.component1();
                collection.add(name);
            }
            object.addAll((List)destination$iv$iv2);
        }
        List unresolvedViews = CollectionsKt.toMutableList((Collection)views);
        Map resolvedViews = new LinkedHashMap();
        List result = new ArrayList();
        do {
            Collection<String> collection2;
            void $this$mapTo$iv$iv3;
            void $this$map$iv3;
            Iterable $this$forEach$iv;
            DatabaseView view;
            Iterator $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Set tables;
            for (Map.Entry $this$mapTo$iv$iv2 : resolvedViews.entrySet()) {
                String viewName = (String)$this$mapTo$iv$iv2.getKey();
                tables = (Set)$this$mapTo$iv$iv2.getValue();
                for (DatabaseView view2 : unresolvedViews) {
                    if (!view2.getTables().removeIf(arg_0 -> DatabaseProcessor.resolveDatabaseViews$lambda$47(arg_0 -> DatabaseProcessor.resolveDatabaseViews$lambda$46(viewName, arg_0), arg_0))) continue;
                    view2.getTables().addAll(tables);
                }
            }
            int countNewlyResolved = 0;
            Iterable $this$mapTo$iv$iv2 = unresolvedViews;
            boolean $i$f$filter = false;
            tables = $this$filter$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                boolean bl;
                Object element$iv$iv;
                block13: {
                    element$iv$iv = iterator.next();
                    view = (DatabaseView)element$iv$iv;
                    boolean bl2 = false;
                    Iterable $this$all$iv = view.getTables();
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            String it = (String)element$iv;
                            boolean bl3 = false;
                            if (DatabaseProcessor.resolveDatabaseViews$isTable(viewNames, it)) continue;
                            bl = false;
                            break block13;
                        }
                        bl = true;
                    }
                }
                if (!bl) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv3;
            boolean $i$f$forEach = false;
            $this$filterTo$iv$iv = $this$forEach$iv.iterator();
            while ($this$filterTo$iv$iv.hasNext()) {
                Object element$iv = $this$filterTo$iv$iv.next();
                DatabaseView view3 = (DatabaseView)element$iv;
                boolean bl = false;
                resolvedViews.put(view3.getViewName(), view3.getTables());
                unresolvedViews.remove(view3);
                result.add(view3);
                ++countNewlyResolved;
            }
            if (countNewlyResolved != 0) continue;
            $this$forEach$iv = unresolvedViews;
            ProcessorErrors processorErrors = ProcessorErrors.INSTANCE;
            collection = (XElement)this.element;
            object = this.context.getLogger();
            boolean $i$f$map3 = false;
            $this$filterTo$iv$iv = $this$map$iv3;
            destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo4 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                void it;
                view = (DatabaseView)item$iv$iv;
                collection2 = destination$iv$iv3;
                boolean bl = false;
                collection2.add(it.getViewName());
            }
            collection2 = (List)destination$iv$iv3;
            ((RLog)object).e((XElement)collection, processorErrors.viewCircularReferenceDetected((List<String>)collection2), new Object[0]);
            break;
        } while (!((Collection)unresolvedViews).isEmpty());
        return result;
    }

    private final DatabaseConstructor processConstructorObject(XTypeElement element) {
        boolean bl;
        XTypeElement typeElement;
        block7: {
            XAnnotation annotation = element.getAnnotation(Reflection.getOrCreateKotlinClass(ConstructedBy.class));
            if (annotation == null) {
                this.context.getChecker().check(this.context.isJvmOnlyTarget(), (XElement)element, "The @Database class must be annotated with @ConstructedBy since the source is targeting non-Android platforms.", new Object[0]);
                return null;
            }
            XType type = annotation.getAsType("value");
            typeElement = type.getTypeElement();
            if (typeElement == null) {
                this.context.getLogger().e((XElement)element, "The @ConstructedBy 'value' must be a valid class.", new Object[0]);
                return null;
            }
            this.context.getChecker().check(typeElement.isKotlinObject(), (XElement)typeElement, "The @ConstructedBy definition must be an 'object' declaration.", new Object[0]);
            this.context.getChecker().check(typeElement.isExpect(), (XElement)typeElement, "The @ConstructedBy definition must be an 'expect' declaration.", new Object[0]);
            XTypeName[] xTypeNameArray = new XTypeName[]{element.asClassName()};
            XTypeName expectedSuperInterfaceTypeName = RoomTypeNames.INSTANCE.getROOM_DB_CONSTRUCTOR().parametrizedBy(xTypeNameArray);
            XType superInterface = (XType)CollectionsKt.singleOrNull((List)typeElement.getSuperInterfaces());
            if (superInterface == null || !Intrinsics.areEqual((Object)superInterface.asTypeName().getRawTypeName(), (Object)RoomTypeNames.INSTANCE.getROOM_DB_CONSTRUCTOR())) {
                this.context.getLogger().e((XElement)typeElement, ProcessorErrors.INSTANCE.invalidConstructedBySuperInterface(expectedSuperInterfaceTypeName.toString(this.context.getCodeLanguage())), new Object[0]);
                return null;
            }
            XType typeArg = (XType)CollectionsKt.singleOrNull((List)superInterface.getTypeArguments());
            if (typeArg == null || !Intrinsics.areEqual((Object)typeArg.asTypeName().getRawTypeName(), (Object)element.asClassName())) {
                this.context.getLogger().e((XElement)typeElement, ProcessorErrors.INSTANCE.invalidConstructedBySuperInterface(expectedSuperInterfaceTypeName.toString(this.context.getCodeLanguage())), new Object[0]);
                return null;
            }
            XMethodElement initializeExecutableElement = (XMethodElement)CollectionsKt.single((List)this.context.getProcessingEnv().requireTypeElement((XTypeName)RoomTypeNames.INSTANCE.getROOM_DB_CONSTRUCTOR()).getDeclaredMethods());
            Iterable $this$any$iv = typeElement.getDeclaredMethods();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    XMethodElement it = (XMethodElement)element$iv;
                    boolean bl2 = false;
                    if (!it.overrides(initializeExecutableElement, typeElement)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        boolean isInitOverridden = bl;
        return new DatabaseConstructor(typeElement, isInitOverridden);
    }

    private static final XTypeElement roomDatabaseTypeElement_delegate$lambda$0(DatabaseProcessor this$0) {
        return this$0.context.getProcessingEnv().requireTypeElement((XTypeName)RoomTypeNames.INSTANCE.getROOM_DB());
    }

    private static final boolean doProcess$lambda$1(XMethodElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isAbstract();
    }

    private static final boolean doProcess$lambda$2(XMethodElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getEnclosingElement().asClassName(), (Object)RoomTypeNames.INSTANCE.getROOM_DB());
    }

    private static final DaoFunction doProcess$lambda$3(DatabaseProcessor this$0, XType $declaredType, DatabaseVerifier $dbVerifier, XMethodElement executable) {
        DaoFunction daoFunction;
        Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
        XType daoType = executable.getReturnType();
        XTypeElement daoElement = daoType.getTypeElement();
        if (daoElement == null) {
            this$0.context.getLogger().e((XElement)executable, "Abstract database functions must return a @Dao annotated class or interface.", new Object[0]);
            daoFunction = null;
        } else {
            if (executable.hasAnnotation(Reflection.getOrCreateKotlinClass(JvmName.class))) {
                this$0.context.getLogger().w(Warning.JVM_NAME_ON_OVERRIDDEN_FUNCTION, (XElement)executable, "Using @JvmName annotation on a function or accessor that will be overridden by Room is not supported. If this is important for your use case, please file a bug at https://issuetracker.google.com/issues/new?component=413107 with details.", new Object[0]);
            }
            Dao dao = new DaoProcessor(this$0.context, daoElement, $declaredType, $dbVerifier).process();
            daoFunction = new DaoFunction(executable, dao);
        }
        return daoFunction;
    }

    private static final Unit validateUniqueDaoClasses$lambda$26(Set<? extends XTypeName> entityTypeNames, DatabaseProcessor this$0, XTypeElement $dbElement, XElement element, Dao dao, XTypeName typeName) {
        block1: {
            XTypeName xTypeName = typeName;
            if (xTypeName == null) break block1;
            XTypeName it = xTypeName;
            boolean bl = false;
            if (!entityTypeNames.contains(typeName)) {
                this$0.context.getLogger().e(element, ProcessorErrors.INSTANCE.shortcutEntityIsNotInDatabase($dbElement.getQualifiedName(), dao.getTypeName().toString(this$0.context.getCodeLanguage()), typeName.toString(this$0.context.getCodeLanguage())), new Object[0]);
            }
        }
        return Unit.INSTANCE;
    }

    private static final boolean resolveDatabaseViews$isTable(List<String> viewNames, String name) {
        boolean bl;
        block3: {
            Iterable $this$none$iv = viewNames;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.equals((String)it, (String)name, (boolean)true)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final boolean resolveDatabaseViews$lambda$46(String $viewName, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.equals((String)it, (String)$viewName, (boolean)true);
    }

    private static final boolean resolveDatabaseViews$lambda$47(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

