/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.processor;

import androidx.room.DeleteColumn;
import androidx.room.DeleteTable;
import androidx.room.ProvidedAutoMigrationSpec;
import androidx.room.RenameColumn;
import androidx.room.RenameTable;
import androidx.room.compiler.codegen.XTypeName;
import androidx.room.compiler.processing.XAnnotation;
import androidx.room.compiler.processing.XConstructorElement;
import androidx.room.compiler.processing.XElement;
import androidx.room.compiler.processing.XType;
import androidx.room.compiler.processing.XTypeElement;
import androidx.room.ext.RoomTypeNames;
import androidx.room.migration.bundle.DatabaseBundle;
import androidx.room.processor.Context;
import androidx.room.processor.ProcessorErrors;
import androidx.room.util.DiffException;
import androidx.room.util.SchemaDiffResult;
import androidx.room.util.SchemaDiffer;
import androidx.room.vo.AutoMigration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010\u00a8\u0006\u0014"}, d2={"Landroidx/room/processor/AutoMigrationProcessor;", "", "context", "Landroidx/room/processor/Context;", "spec", "Landroidx/room/compiler/processing/XType;", "fromSchemaBundle", "Landroidx/room/migration/bundle/DatabaseBundle;", "toSchemaBundle", "<init>", "(Landroidx/room/processor/Context;Landroidx/room/compiler/processing/XType;Landroidx/room/migration/bundle/DatabaseBundle;Landroidx/room/migration/bundle/DatabaseBundle;)V", "getContext", "()Landroidx/room/processor/Context;", "getSpec", "()Landroidx/room/compiler/processing/XType;", "getFromSchemaBundle", "()Landroidx/room/migration/bundle/DatabaseBundle;", "getToSchemaBundle", "process", "Landroidx/room/vo/AutoMigration;", "room-compiler"})
@SourceDebugExtension(value={"SMAP\nAutoMigrationProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AutoMigrationProcessor.kt\nandroidx/room/processor/AutoMigrationProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,173:1\n1755#2,3:174\n1557#2:177\n1628#2,3:178\n1557#2:181\n1628#2,3:182\n1557#2:185\n1628#2,3:186\n1557#2:189\n1628#2,3:190\n*S KotlinDebug\n*F\n+ 1 AutoMigrationProcessor.kt\nandroidx/room/processor/AutoMigrationProcessor\n*L\n68#1:174,3\n111#1:177\n111#1:178,3\n121#1:181\n121#1:182,3\n128#1:185\n128#1:186,3\n138#1:189\n138#1:190,3\n*E\n"})
public final class AutoMigrationProcessor {
    @NotNull
    private final Context context;
    @Nullable
    private final XType spec;
    @NotNull
    private final DatabaseBundle fromSchemaBundle;
    @NotNull
    private final DatabaseBundle toSchemaBundle;

    public AutoMigrationProcessor(@NotNull Context context, @Nullable XType spec, @NotNull DatabaseBundle fromSchemaBundle, @NotNull DatabaseBundle toSchemaBundle) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fromSchemaBundle, (String)"fromSchemaBundle");
        Intrinsics.checkNotNullParameter((Object)toSchemaBundle, (String)"toSchemaBundle");
        this.context = context;
        this.spec = spec;
        this.fromSchemaBundle = fromSchemaBundle;
        this.toSchemaBundle = toSchemaBundle;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @Nullable
    public final XType getSpec() {
        return this.spec;
    }

    @NotNull
    public final DatabaseBundle getFromSchemaBundle() {
        return this.fromSchemaBundle;
    }

    @NotNull
    public final DatabaseBundle getToSchemaBundle() {
        return this.toSchemaBundle;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public final AutoMigration process() {
        block26: {
            block24: {
                block25: {
                    block23: {
                        if (this.spec == null || this.spec.isTypeOf(Reflection.getOrCreateKotlinClass(Object.class))) break block24;
                        typeElement = this.spec.getTypeElement();
                        if (typeElement == null) {
                            this.context.getLogger().e("The AutoMigration spec type must be a class.", new Object[0]);
                            return null;
                        }
                        if (typeElement.isInterface() || typeElement.isAbstract()) {
                            this.context.getLogger().e((XElement)typeElement, "The AutoMigration spec type must be a class.", new Object[0]);
                            return null;
                        }
                        isSpecProvided = typeElement.hasAnnotation(Reflection.getOrCreateKotlinClass(ProvidedAutoMigrationSpec.class));
                        if (isSpecProvided) break block25;
                        constructors = typeElement.getConstructors();
                        v0 = this.context.getChecker();
                        if (constructors.isEmpty()) ** GOTO lbl-1000
                        var5_6 = constructors;
                        var23_7 = v0;
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            v1 = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                it = (XConstructorElement)element$iv;
                                $i$a$-any-AutoMigrationProcessor$process$1 = false;
                                if (!it.getParameters().isEmpty()) continue;
                                v1 = true;
                                break block23;
                            }
                            v1 = false;
                        }
                    }
                    var24_22 = v1;
                    v0 = var23_7;
                    if (var24_22) lbl-1000:
                    // 2 sources

                    {
                        v2 = true;
                    } else {
                        v2 = false;
                    }
                    v0.check(v2, (XElement)typeElement, "Classes that are used as AutoMigrationSpec implementations must have no-argument public constructors.", new Object[0]);
                }
                this.context.getChecker().check(typeElement.getEnclosingTypeElement() == null || typeElement.isStatic() != false, (XElement)typeElement, "An inner class AutoMigrationSpec must be static.", new Object[0]);
                implementsMigrationSpec = this.context.getProcessingEnv().requireType((XTypeName)RoomTypeNames.INSTANCE.getAUTO_MIGRATION_SPEC()).isAssignableFrom(this.spec);
                if (!implementsMigrationSpec) {
                    this.context.getLogger().e((XElement)typeElement, ProcessorErrors.INSTANCE.autoMigrationElementMustImplementSpec(typeElement.asClassName().getCanonicalName()), new Object[0]);
                    return null;
                }
                v3 = TuplesKt.to((Object)typeElement, (Object)isSpecProvided);
                break block26;
            }
            v3 = TuplesKt.to(null, (Object)false);
        }
        var1_23 = v3;
        specElement = (XTypeElement)var1_23.component1();
        isSpecProvided = (Boolean)var1_23.component2();
        if (this.toSchemaBundle.getVersion() <= this.fromSchemaBundle.getVersion()) {
            this.context.getLogger().e(ProcessorErrors.INSTANCE.autoMigrationToVersionMustBeGreaterThanFrom(this.toSchemaBundle.getVersion(), this.fromSchemaBundle.getVersion()), new Object[0]);
            return null;
        }
        v4 /* !! */  = specElement;
        specClassName = v4 /* !! */  != null && (v4 /* !! */  = v4 /* !! */ .asClassName()) != null && (v4 /* !! */  = v4 /* !! */ .getSimpleNames()) != null ? (String)CollectionsKt.first((List)v4 /* !! */ ) : null;
        v5 = specElement;
        if (v5 != null) {
            element = v5;
            $i$a$-let-AutoMigrationProcessor$process$deleteColumnEntries$1 = false;
            $this$map$iv = element.getAnnotations(Reflection.getOrCreateKotlinClass(DeleteColumn.class));
            $i$f$map = false;
            var12_31 = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                var17_49 = (XAnnotation)item$iv$iv;
                var18_51 = destination$iv$iv;
                $i$a$-map-AutoMigrationProcessor$process$deleteColumnEntries$1$1 = false;
                var18_51.add(new AutoMigration.DeletedColumn(it.getAsString("tableName"), it.getAsString("columnName")));
            }
            v6 = (List)destination$iv$iv;
        } else {
            v6 = CollectionsKt.emptyList();
        }
        deleteColumnEntries = v6;
        v7 = specElement;
        if (v7 != null) {
            element = v7;
            $i$a$-let-AutoMigrationProcessor$process$deleteTableEntries$1 = false;
            $this$map$iv = element.getAnnotations(Reflection.getOrCreateKotlinClass(DeleteTable.class));
            $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                var18_51 = (XAnnotation)item$iv$iv;
                $i$a$-map-AutoMigrationProcessor$process$deleteColumnEntries$1$1 = destination$iv$iv;
                $i$a$-map-AutoMigrationProcessor$process$deleteTableEntries$1$1 = false;
                $i$a$-map-AutoMigrationProcessor$process$deleteColumnEntries$1$1.add(new AutoMigration.DeletedTable(it.getAsString("tableName")));
            }
            v8 = (List)destination$iv$iv;
        } else {
            v8 = CollectionsKt.emptyList();
        }
        deleteTableEntries = v8;
        v9 = specElement;
        if (v9 != null) {
            element = v9;
            $i$a$-let-AutoMigrationProcessor$process$renameTableEntries$1 = false;
            $this$map$iv = element.getAnnotations(Reflection.getOrCreateKotlinClass(RenameTable.class));
            $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (E item$iv$iv : $this$mapTo$iv$iv) {
                $i$a$-map-AutoMigrationProcessor$process$deleteColumnEntries$1$1 = (XAnnotation)item$iv$iv;
                $i$a$-map-AutoMigrationProcessor$process$deleteTableEntries$1$1 = destination$iv$iv;
                $i$a$-map-AutoMigrationProcessor$process$renameTableEntries$1$1 = false;
                $i$a$-map-AutoMigrationProcessor$process$deleteTableEntries$1$1.add(new AutoMigration.RenamedTable(it.getAsString("fromTableName"), it.getAsString("toTableName")));
            }
            v10 = (List)destination$iv$iv;
        } else {
            v10 = CollectionsKt.emptyList();
        }
        renameTableEntries = v10;
        v11 = specElement;
        if (v11 != null) {
            element = v11;
            $i$a$-let-AutoMigrationProcessor$process$renameColumnEntries$1 = false;
            $this$map$iv = element.getAnnotations(Reflection.getOrCreateKotlinClass(RenameColumn.class));
            $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (E item$iv$iv : $this$mapTo$iv$iv) {
                $i$a$-map-AutoMigrationProcessor$process$deleteTableEntries$1$1 = (XAnnotation)item$iv$iv;
                var21_60 = destination$iv$iv;
                $i$a$-map-AutoMigrationProcessor$process$renameColumnEntries$1$1 = false;
                var21_60.add(new AutoMigration.RenamedColumn(it.getAsString("tableName"), it.getAsString("fromColumnName"), it.getAsString("toColumnName")));
            }
            v12 = (List)destination$iv$iv;
        } else {
            v12 = CollectionsKt.emptyList();
        }
        renameColumnEntries = v12;
        try {
            var10_20 /* !! */  = this.fromSchemaBundle;
            element = this.toSchemaBundle;
            var10_20 /* !! */  = new SchemaDiffer(var10_20 /* !! */ , element, specClassName, renameColumnEntries, deleteColumnEntries, renameTableEntries, deleteTableEntries).diffSchemas();
        }
        catch (DiffException ex) {
            this.context.getLogger().e(ex.getErrorMessage(), new Object[0]);
            return null;
        }
        schemaDiff /* !! */  = var10_20 /* !! */ ;
        var10_21 = this.fromSchemaBundle.getVersion();
        var11_30 = this.toSchemaBundle.getVersion();
        return new AutoMigration(var10_21, var11_30, specElement, (SchemaDiffResult)schemaDiff /* !! */ , isSpecProvided);
    }
}

