/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.preconditions;

import androidx.room.compiler.processing.XElement;
import androidx.room.compiler.processing.XType;
import androidx.room.compiler.processing.XTypeKt;
import androidx.room.log.RLog;
import java.lang.annotation.Annotation;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J7\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u000e\"\u00020\u0001\u00a2\u0006\u0002\u0010\u000fJ$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u0011J?\u0010\u0012\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u000e\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u00142\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u000e\"\u00020\u0001\u00a2\u0006\u0002\u0010\u0016J7\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u000e\"\u00020\u0001\u00a2\u0006\u0002\u0010\u001aJ9\u0010\u001b\u001a\u00020\u00072\b\u0010\u001c\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\f2\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u000e\"\u00020\u0001\u00a2\u0006\u0002\u0010\u001eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Landroidx/room/preconditions/Checks;", "", "logger", "Landroidx/room/log/RLog;", "<init>", "(Landroidx/room/log/RLog;)V", "check", "", "predicate", "element", "Landroidx/room/compiler/processing/XElement;", "errorMsg", "", "args", "", "(ZLandroidx/room/compiler/processing/XElement;Ljava/lang/String;[Ljava/lang/Object;)Z", "errorMsgProducer", "Lkotlin/Function0;", "hasAnnotation", "annotation", "Lkotlin/reflect/KClass;", "", "(Landroidx/room/compiler/processing/XElement;Lkotlin/reflect/KClass;Ljava/lang/String;[Ljava/lang/Object;)Z", "notUnbound", "type", "Landroidx/room/compiler/processing/XType;", "(Landroidx/room/compiler/processing/XType;Landroidx/room/compiler/processing/XElement;Ljava/lang/String;[Ljava/lang/Object;)Z", "notBlank", "value", "msg", "(Ljava/lang/String;Landroidx/room/compiler/processing/XElement;Ljava/lang/String;[Ljava/lang/Object;)Z", "room-compiler"})
@SourceDebugExtension(value={"SMAP\nChecks.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Checks.kt\nandroidx/room/preconditions/Checks\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,93:1\n1755#2,3:94\n*S KotlinDebug\n*F\n+ 1 Checks.kt\nandroidx/room/preconditions/Checks\n*L\n68#1:94,3\n*E\n"})
public final class Checks {
    @NotNull
    private final RLog logger;

    public Checks(@NotNull RLog logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
    }

    public final boolean check(boolean predicate, @NotNull XElement element, @NotNull String errorMsg, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)errorMsg, (String)"errorMsg");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        if (!predicate) {
            Object[] objectArray = new Object[]{args};
            this.logger.e(element, errorMsg, objectArray);
        }
        return predicate;
    }

    public final boolean check(boolean predicate, @NotNull XElement element, @NotNull Function0<String> errorMsgProducer) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(errorMsgProducer, (String)"errorMsgProducer");
        if (!predicate) {
            this.logger.e(element, (String)errorMsgProducer.invoke(), new Object[0]);
        }
        return predicate;
    }

    public final boolean hasAnnotation(@NotNull XElement element, @NotNull KClass<? extends Annotation> annotation, @NotNull String errorMsg, Object ... args) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(annotation, (String)"annotation");
        Intrinsics.checkNotNullParameter((Object)errorMsg, (String)"errorMsg");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        if (!element.hasAnnotation(annotation)) {
            Object[] objectArray = new Object[]{args};
            this.logger.e(element, errorMsg, objectArray);
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    public final boolean notUnbound(@NotNull XType type, @NotNull XElement element, @NotNull String errorMsg, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)errorMsg, (String)"errorMsg");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Object[] objectArray = new Object[]{args};
        boolean failed = this.check(!XTypeKt.isTypeVariable((XType)type), element, errorMsg, objectArray);
        if (!((Collection)type.getTypeArguments()).isEmpty()) {
            boolean bl;
            block4: {
                Iterable $this$any$iv = type.getTypeArguments();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        XType it = (XType)element$iv;
                        boolean bl2 = false;
                        Object[] objectArray2 = new Object[]{args};
                        if (!this.notUnbound(it, element, errorMsg, objectArray2)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            boolean nestedFailure = bl;
            return !failed && !nestedFailure;
        }
        return !failed;
    }

    public final boolean notBlank(@Nullable String value, @NotNull XElement element, @NotNull String msg, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Object[] objectArray = new Object[]{args};
        return this.check(value != null && !StringsKt.isBlank((CharSequence)value), element, msg, objectArray);
    }
}

