/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.parser;

import androidx.room.parser.BindParameterNode;
import androidx.room.parser.ParserErrors;
import androidx.room.parser.QueryType;
import androidx.room.parser.Section;
import androidx.room.parser.Table;
import androidx.room.verifier.QueryResultInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 D2\u00020\u0001:\u0001DBK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000e\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007H\u0002J\u000e\u00100\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007H\u0002J\t\u00107\u001a\u00020\u0003H\u00c6\u0003J\t\u00108\u001a\u00020\u0005H\u00c6\u0003J\u000f\u00109\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\u000f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u00c6\u0003J\u0010\u0010;\u001a\u0004\u0018\u00010\rH\u00c6\u0003\u00a2\u0006\u0002\u0010\u001aJ\u000f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007H\u00c6\u0003J^\u0010=\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007H\u00c6\u0001\u00a2\u0006\u0002\u0010>J\u0013\u0010?\u001a\u00020\r2\b\u0010@\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010A\u001a\u00020BH\u00d6\u0001J\t\u0010C\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0015\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\n\n\u0002\u0010\u001b\u001a\u0004\b\u0019\u0010\u001aR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0016R\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R+\u0010#\u001a\u0012\u0012\u0004\u0012\u00020%0$j\b\u0012\u0004\u0012\u00020%`&8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010*\u001a\u0004\b'\u0010(R!\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b.\u0010*\u001a\u0004\b-\u0010\u0016R!\u00101\u001a\b\u0012\u0004\u0012\u00020\u00030\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b3\u0010*\u001a\u0004\b2\u0010\u0016R\u001b\u00104\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b6\u0010*\u001a\u0004\b5\u0010\u0012\u00a8\u0006E"}, d2={"Landroidx/room/parser/ParsedQuery;", "", "original", "", "type", "Landroidx/room/parser/QueryType;", "inputs", "", "Landroidx/room/parser/BindParameterNode;", "tables", "", "Landroidx/room/parser/Table;", "hasTopStarProjection", "", "syntaxErrors", "<init>", "(Ljava/lang/String;Landroidx/room/parser/QueryType;Ljava/util/List;Ljava/util/Set;Ljava/lang/Boolean;Ljava/util/List;)V", "getOriginal", "()Ljava/lang/String;", "getType", "()Landroidx/room/parser/QueryType;", "getInputs", "()Ljava/util/List;", "getTables", "()Ljava/util/Set;", "getHasTopStarProjection", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "getSyntaxErrors", "resultInfo", "Landroidx/room/verifier/QueryResultInfo;", "getResultInfo", "()Landroidx/room/verifier/QueryResultInfo;", "setResultInfo", "(Landroidx/room/verifier/QueryResultInfo;)V", "sections", "Ljava/util/ArrayList;", "Landroidx/room/parser/Section;", "Lkotlin/collections/ArrayList;", "getSections", "()Ljava/util/ArrayList;", "sections$delegate", "Lkotlin/Lazy;", "bindSections", "Landroidx/room/parser/Section$BindVar;", "getBindSections", "bindSections$delegate", "unnamedVariableErrors", "unknownQueryTypeErrors", "errors", "getErrors", "errors$delegate", "queryWithReplacedBindParams", "getQueryWithReplacedBindParams", "queryWithReplacedBindParams$delegate", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "(Ljava/lang/String;Landroidx/room/parser/QueryType;Ljava/util/List;Ljava/util/Set;Ljava/lang/Boolean;Ljava/util/List;)Landroidx/room/parser/ParsedQuery;", "equals", "other", "hashCode", "", "toString", "Companion", "room-compiler"})
@SourceDebugExtension(value={"SMAP\nParsedQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParsedQuery.kt\nandroidx/room/parser/ParsedQuery\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,147:1\n1755#2,3:148\n774#2:151\n865#2,2:152\n1557#2:154\n1628#2,3:155\n1485#2:158\n1510#2,3:159\n1513#2,3:169\n1872#2,2:172\n1863#2,2:174\n1874#2:176\n808#2,11:177\n381#3,7:162\n*S KotlinDebug\n*F\n+ 1 ParsedQuery.kt\nandroidx/room/parser/ParsedQuery\n*L\n108#1:148,3\n115#1:151\n115#1:152,2\n116#1:154\n116#1:155,3\n82#1:158\n82#1:159,3\n82#1:169,3\n84#1:172,2\n86#1:174,2\n84#1:176\n104#1:177,11\n82#1:162,7\n*E\n"})
public final class ParsedQuery {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String original;
    @NotNull
    private final QueryType type;
    @NotNull
    private final List<BindParameterNode> inputs;
    @NotNull
    private final Set<Table> tables;
    @Nullable
    private final Boolean hasTopStarProjection;
    @NotNull
    private final List<String> syntaxErrors;
    @Nullable
    private QueryResultInfo resultInfo;
    @NotNull
    private final Lazy sections$delegate;
    @NotNull
    private final Lazy bindSections$delegate;
    @NotNull
    private final Lazy errors$delegate;
    @NotNull
    private final Lazy queryWithReplacedBindParams$delegate;
    @NotNull
    private static final Regex STARTS_WITH_NUMBER = new Regex("^\\?[0-9]");
    @NotNull
    private static final ParsedQuery MISSING = new ParsedQuery("missing query", QueryType.UNKNOWN, CollectionsKt.emptyList(), SetsKt.emptySet(), null, CollectionsKt.emptyList());

    public ParsedQuery(@NotNull String original, @NotNull QueryType type, @NotNull List<BindParameterNode> inputs, @NotNull Set<Table> tables, @Nullable Boolean hasTopStarProjection, @NotNull List<String> syntaxErrors) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter(inputs, (String)"inputs");
        Intrinsics.checkNotNullParameter(tables, (String)"tables");
        Intrinsics.checkNotNullParameter(syntaxErrors, (String)"syntaxErrors");
        this.original = original;
        this.type = type;
        this.inputs = inputs;
        this.tables = tables;
        this.hasTopStarProjection = hasTopStarProjection;
        this.syntaxErrors = syntaxErrors;
        this.sections$delegate = LazyKt.lazy(() -> ParsedQuery.sections_delegate$lambda$3(this));
        this.bindSections$delegate = LazyKt.lazy(() -> ParsedQuery.bindSections_delegate$lambda$4(this));
        this.errors$delegate = LazyKt.lazy(() -> ParsedQuery.errors_delegate$lambda$8(this));
        this.queryWithReplacedBindParams$delegate = LazyKt.lazy(() -> ParsedQuery.queryWithReplacedBindParams_delegate$lambda$10(this));
    }

    @NotNull
    public final String getOriginal() {
        return this.original;
    }

    @NotNull
    public final QueryType getType() {
        return this.type;
    }

    @NotNull
    public final List<BindParameterNode> getInputs() {
        return this.inputs;
    }

    @NotNull
    public final Set<Table> getTables() {
        return this.tables;
    }

    @Nullable
    public final Boolean getHasTopStarProjection() {
        return this.hasTopStarProjection;
    }

    @NotNull
    public final List<String> getSyntaxErrors() {
        return this.syntaxErrors;
    }

    @Nullable
    public final QueryResultInfo getResultInfo() {
        return this.resultInfo;
    }

    public final void setResultInfo(@Nullable QueryResultInfo queryResultInfo) {
        this.resultInfo = queryResultInfo;
    }

    @NotNull
    public final ArrayList<Section> getSections() {
        Lazy lazy = this.sections$delegate;
        return (ArrayList)lazy.getValue();
    }

    @NotNull
    public final List<Section.BindVar> getBindSections() {
        Lazy lazy = this.bindSections$delegate;
        return (List)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> unnamedVariableErrors() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        BindParameterNode it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        List list;
        boolean bl;
        Object[] $this$any$iv;
        block7: {
            $this$any$iv = (String[])this.inputs;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object t : $this$any$iv) {
                    BindParameterNode it2 = (BindParameterNode)t;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it2.getText(), (Object)"?")) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        if (bl) {
            $this$any$iv = new String[]{ParserErrors.INSTANCE.getANONYMOUS_BIND_ARGUMENT()};
            list = CollectionsKt.arrayListOf((Object[])$this$any$iv);
        } else {
            list = CollectionsKt.emptyList();
        }
        List anonymousBindError = list;
        $this$any$iv = this.inputs;
        Collection collection = anonymousBindError;
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection collection2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (BindParameterNode)element$iv$iv;
            boolean bl3 = false;
            String string = it.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (!STARTS_WITH_NUMBER.matches((CharSequence)string)) continue;
            collection2.add(element$iv$iv);
        }
        $this$filter$iv = (List)collection2;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        Collection collection3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (BindParameterNode)item$iv$iv;
            Collection collection4 = collection3;
            boolean bl4 = false;
            String string = it.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            collection4.add(ParserErrors.INSTANCE.cannotUseVariableIndices(string, it.getSymbol().getCharPositionInLine()));
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)((List)collection3));
    }

    private final List<String> unknownQueryTypeErrors() {
        return QueryType.Companion.getSUPPORTED().contains((Object)this.type) ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)ParserErrors.INSTANCE.invalidQueryType(this.type));
    }

    @NotNull
    public final List<String> getErrors() {
        Lazy lazy = this.errors$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    public final String getQueryWithReplacedBindParams() {
        Lazy lazy = this.queryWithReplacedBindParams$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final String component1() {
        return this.original;
    }

    @NotNull
    public final QueryType component2() {
        return this.type;
    }

    @NotNull
    public final List<BindParameterNode> component3() {
        return this.inputs;
    }

    @NotNull
    public final Set<Table> component4() {
        return this.tables;
    }

    @Nullable
    public final Boolean component5() {
        return this.hasTopStarProjection;
    }

    @NotNull
    public final List<String> component6() {
        return this.syntaxErrors;
    }

    @NotNull
    public final ParsedQuery copy(@NotNull String original, @NotNull QueryType type, @NotNull List<BindParameterNode> inputs, @NotNull Set<Table> tables, @Nullable Boolean hasTopStarProjection, @NotNull List<String> syntaxErrors) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter(inputs, (String)"inputs");
        Intrinsics.checkNotNullParameter(tables, (String)"tables");
        Intrinsics.checkNotNullParameter(syntaxErrors, (String)"syntaxErrors");
        return new ParsedQuery(original, type, inputs, tables, hasTopStarProjection, syntaxErrors);
    }

    public static /* synthetic */ ParsedQuery copy$default(ParsedQuery parsedQuery, String string, QueryType queryType, List list, Set set, Boolean bl, List list2, int n, Object object) {
        if ((n & 1) != 0) {
            string = parsedQuery.original;
        }
        if ((n & 2) != 0) {
            queryType = parsedQuery.type;
        }
        if ((n & 4) != 0) {
            list = parsedQuery.inputs;
        }
        if ((n & 8) != 0) {
            set = parsedQuery.tables;
        }
        if ((n & 0x10) != 0) {
            bl = parsedQuery.hasTopStarProjection;
        }
        if ((n & 0x20) != 0) {
            list2 = parsedQuery.syntaxErrors;
        }
        return parsedQuery.copy(string, queryType, list, set, bl, list2);
    }

    @NotNull
    public String toString() {
        return "ParsedQuery(original=" + this.original + ", type=" + this.type + ", inputs=" + this.inputs + ", tables=" + this.tables + ", hasTopStarProjection=" + this.hasTopStarProjection + ", syntaxErrors=" + this.syntaxErrors + ")";
    }

    public int hashCode() {
        int result = this.original.hashCode();
        result = result * 31 + this.type.hashCode();
        result = result * 31 + ((Object)this.inputs).hashCode();
        result = result * 31 + ((Object)this.tables).hashCode();
        result = result * 31 + (this.hasTopStarProjection == null ? 0 : ((Object)this.hasTopStarProjection).hashCode());
        result = result * 31 + ((Object)this.syntaxErrors).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ParsedQuery)) {
            return false;
        }
        ParsedQuery parsedQuery = (ParsedQuery)other;
        if (!Intrinsics.areEqual((Object)this.original, (Object)parsedQuery.original)) {
            return false;
        }
        if (this.type != parsedQuery.type) {
            return false;
        }
        if (!Intrinsics.areEqual(this.inputs, parsedQuery.inputs)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.tables, parsedQuery.tables)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.hasTopStarProjection, (Object)parsedQuery.hasTopStarProjection)) {
            return false;
        }
        return Intrinsics.areEqual(this.syntaxErrors, parsedQuery.syntaxErrors);
    }

    /*
     * WARNING - void declaration
     */
    private static final ArrayList sections_delegate$lambda$3(ParsedQuery this$0) {
        Object list$iv$iv;
        void $this$groupByTo$iv$iv;
        List lines = StringsKt.lines((CharSequence)this$0.original);
        Iterable $this$groupBy$iv = this$0.inputs;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            BindParameterNode it = (BindParameterNode)element$iv$iv;
            boolean bl = false;
            Integer key$iv$iv = it.getSymbol().getLine();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map inputsByLine = destination$iv$iv;
        ArrayList<Section> sections = new ArrayList<Section>();
        Iterable $this$forEachIndexed$iv = lines;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void line;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            list$iv$iv = (String)item$iv;
            int index = n;
            boolean bl = false;
            int charInLine = 0;
            List list = (List)inputsByLine.get(index + 1);
            if (list != null) {
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    BindParameterNode bindVar = (BindParameterNode)element$iv;
                    boolean bl3 = false;
                    if (charInLine < bindVar.getSymbol().getCharPositionInLine()) {
                        String string = line.substring(charInLine, bindVar.getSymbol().getCharPositionInLine());
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        sections.add(Section.Companion.text(string));
                    }
                    String string = bindVar.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    sections.add(Section.Companion.bindVar(string, bindVar.isMultiple()));
                    charInLine = bindVar.getSymbol().getCharPositionInLine() + bindVar.getSymbol().getText().length();
                }
            }
            if (charInLine < line.length()) {
                String string = line.substring(charInLine);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                sections.add(Section.Companion.text(string));
            }
            if (index + 1 >= lines.size()) continue;
            sections.add(Section.Companion.newline());
        }
        return sections;
    }

    /*
     * WARNING - void declaration
     */
    private static final List bindSections_delegate$lambda$4(ParsedQuery this$0) {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = this$0.getSections();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof Section.BindVar)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final List errors_delegate$lambda$8(ParsedQuery this$0) {
        return !((Collection)this$0.syntaxErrors).isEmpty() ? this$0.syntaxErrors : CollectionsKt.plus((Collection)this$0.unnamedVariableErrors(), (Iterable)this$0.unknownQueryTypeErrors());
    }

    private static final CharSequence queryWithReplacedBindParams_delegate$lambda$10$lambda$9(Section it) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Section section = it;
        if (section instanceof Section.Text) {
            charSequence = ((Section.Text)it).getText();
        } else if (section instanceof Section.BindVar) {
            charSequence = "?";
        } else if (section instanceof Section.NewLine) {
            charSequence = "\n";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return charSequence;
    }

    private static final String queryWithReplacedBindParams_delegate$lambda$10(ParsedQuery this$0) {
        return CollectionsKt.joinToString$default((Iterable)this$0.getSections(), (CharSequence)"", null, null, (int)0, null, ParsedQuery::queryWithReplacedBindParams_delegate$lambda$10$lambda$9, (int)30, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Landroidx/room/parser/ParsedQuery$Companion;", "", "<init>", "()V", "STARTS_WITH_NUMBER", "Lkotlin/text/Regex;", "getSTARTS_WITH_NUMBER", "()Lkotlin/text/Regex;", "MISSING", "Landroidx/room/parser/ParsedQuery;", "getMISSING", "()Landroidx/room/parser/ParsedQuery;", "room-compiler"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Regex getSTARTS_WITH_NUMBER() {
            return STARTS_WITH_NUMBER;
        }

        @NotNull
        public final ParsedQuery getMISSING() {
            return MISSING;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

