/*
 * Decompiled with CFR 0.152.
 */
package androidx.room;

import androidx.room.DatabaseProcessingStep;
import androidx.room.compiler.processing.XProcessingEnv;
import androidx.room.compiler.processing.XProcessingEnvConfig;
import androidx.room.compiler.processing.XRoundEnv;
import androidx.room.compiler.processing.javac.JavacBasicAnnotationProcessor;
import androidx.room.processor.Context;
import androidx.room.processor.ProcessorErrors;
import androidx.room.util.SimpleJavaVersion;
import androidx.room.verifier.DatabaseVerifier;
import androidx.room.vo.Warning;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.SourceVersion;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\b\u0010\f\u001a\u00020\u0005H\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Landroidx/room/RoomProcessor;", "Landroidx/room/compiler/processing/javac/JavacBasicAnnotationProcessor;", "<init>", "()V", "jdkVersionHasBugReported", "", "processingSteps", "", "Landroidx/room/DatabaseProcessingStep;", "getSupportedOptions", "", "", "functionParametersVisibleInClassFiles", "getSupportedSourceVersion", "Ljavax/lang/model/SourceVersion;", "postRound", "", "env", "Landroidx/room/compiler/processing/XProcessingEnv;", "round", "Landroidx/room/compiler/processing/XRoundEnv;", "room-compiler"})
public final class RoomProcessor
extends JavacBasicAnnotationProcessor {
    private boolean jdkVersionHasBugReported;

    public RoomProcessor() {
        super(RoomProcessor::_init_$lambda$0);
    }

    @NotNull
    public List<DatabaseProcessingStep> processingSteps() {
        return CollectionsKt.listOf((Object)new DatabaseProcessingStep());
    }

    @NotNull
    public Set<String> getSupportedOptions() {
        Set supportedOptions = CollectionsKt.toMutableSet((Iterable)Context.Companion.getARG_OPTIONS());
        if (Context.BooleanProcessorOptions.INCREMENTAL.getValue(this.getXProcessingEnv())) {
            if (this.functionParametersVisibleInClassFiles()) {
                supportedOptions.add("org.gradle.annotation.processing.isolating");
            } else if (!this.jdkVersionHasBugReported) {
                new Context(this.getXProcessingEnv()).getLogger().w(Warning.JDK_VERSION_HAS_BUG, ProcessorErrors.INSTANCE.getJDK_VERSION_HAS_BUG(), new Object[0]);
                this.jdkVersionHasBugReported = true;
            }
        }
        return supportedOptions;
    }

    private final boolean functionParametersVisibleInClassFiles() {
        boolean bl;
        boolean isEmbeddedJdk;
        SimpleJavaVersion simpleJavaVersion = SimpleJavaVersion.Companion.getCurrentVersion();
        if (simpleJavaVersion == null) {
            return false;
        }
        SimpleJavaVersion currentJavaVersion = simpleJavaVersion;
        if (currentJavaVersion.compareTo(SimpleJavaVersion.Companion.getVERSION_11_0_0()) >= 0) {
            return true;
        }
        String string = System.getProperty("java.vendor");
        boolean bl2 = isEmbeddedJdk = string != null ? StringsKt.contains((CharSequence)string, (CharSequence)"JetBrains", (boolean)true) : false;
        if (isEmbeddedJdk && currentJavaVersion.compareTo(SimpleJavaVersion.Companion.getVERSION_1_8_0_202()) > 0) {
            bl = true;
        } else if (isEmbeddedJdk && Intrinsics.areEqual((Object)currentJavaVersion, (Object)SimpleJavaVersion.Companion.getVERSION_1_8_0_202())) {
            String string2 = System.getProperty("java.runtime.version");
            if (string2 != null) {
                String it = string2;
                boolean bl3 = false;
                bl = !Intrinsics.areEqual((Object)it, (Object)"1.8.0_202-release-1483-b39-5396753");
            } else {
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public SourceVersion getSupportedSourceVersion() {
        SourceVersion sourceVersion = SourceVersion.latest();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)sourceVersion), (String)"latest(...)");
        return sourceVersion;
    }

    public void postRound(@NotNull XProcessingEnv env, @NotNull XRoundEnv round) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)round, (String)"round");
        if (round.isProcessingOver()) {
            DatabaseVerifier.Companion.cleanup();
        }
    }

    private static final XProcessingEnvConfig _init_$lambda$0(Map options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        return DatabaseProcessingStep.Companion.getEnvConfig$room_compiler(options);
    }
}

