/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.streamsharing;

import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.core.impl.ForwardingCameraInfo;
import androidx.camera.core.impl.utils.TransformUtils;
import java.util.UUID;
import org.jspecify.annotations.NonNull;

public class VirtualCameraInfo
extends ForwardingCameraInfo {
    private final String mVirtualCameraId;
    private int mVirtualCameraRotationDegrees;

    VirtualCameraInfo(@NonNull CameraInfoInternal cameraInfoInternal) {
        super(cameraInfoInternal);
        this.mVirtualCameraId = "virtual-" + cameraInfoInternal.getCameraId() + "-" + UUID.randomUUID().toString();
    }

    @Override
    public @NonNull String getCameraId() {
        return this.mVirtualCameraId;
    }

    void setVirtualCameraRotationDegrees(int virtualCameraRotationDegrees) {
        this.mVirtualCameraRotationDegrees = virtualCameraRotationDegrees;
    }

    @Override
    public int getSensorRotationDegrees() {
        return this.getSensorRotationDegrees(0);
    }

    @Override
    public int getSensorRotationDegrees(int relativeRotation) {
        return TransformUtils.within360(super.getSensorRotationDegrees(relativeRotation) - this.mVirtualCameraRotationDegrees);
    }
}

