/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.streamsharing;

import androidx.camera.core.imagecapture.CameraCapturePipeline;
import androidx.camera.core.impl.CameraControlInternal;
import androidx.camera.core.impl.CaptureConfig;
import androidx.camera.core.impl.ForwardingCameraControl;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.FutureChain;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.camera.core.streamsharing.StreamSharing;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.NonNull;

public class VirtualCameraControl
extends ForwardingCameraControl {
    private static final int DEFAULT_JPEG_QUALITY = 100;
    private static final int DEFAULT_ROTATION_DEGREES = 0;
    private final StreamSharing.Control mStreamSharingControl;

    VirtualCameraControl(@NonNull CameraControlInternal parent, @NonNull StreamSharing.Control streamSharingControl) {
        super(parent);
        this.mStreamSharingControl = streamSharingControl;
    }

    @Override
    public @NonNull ListenableFuture<List<Void>> submitStillCaptureRequests(@NonNull List<CaptureConfig> captureConfigs, int captureMode, int flashType) {
        Preconditions.checkArgument((captureConfigs.size() == 1 ? 1 : 0) != 0, (Object)"Only support one capture config.");
        ListenableFuture<CameraCapturePipeline> capturePipeline = this.getCameraCapturePipelineAsync(captureMode, 1);
        FutureChain captureFuture = FutureChain.from(capturePipeline).transformAsync(v -> ((CameraCapturePipeline)capturePipeline.get()).invokePreCapture(), CameraXExecutors.directExecutor()).transformAsync(v -> this.mStreamSharingControl.jpegSnapshot(this.getJpegQuality((CaptureConfig)captureConfigs.get(0)), this.getRotationDegrees((CaptureConfig)captureConfigs.get(0))), CameraXExecutors.directExecutor()).transformAsync(v -> ((CameraCapturePipeline)capturePipeline.get()).invokePostCapture(), CameraXExecutors.directExecutor());
        return Futures.allAsList(Collections.singletonList(captureFuture));
    }

    private int getJpegQuality(@NonNull CaptureConfig captureConfig) {
        return Objects.requireNonNull(captureConfig.getImplementationOptions().retrieveOption(CaptureConfig.OPTION_JPEG_QUALITY, 100));
    }

    private int getRotationDegrees(@NonNull CaptureConfig captureConfig) {
        return Objects.requireNonNull(captureConfig.getImplementationOptions().retrieveOption(CaptureConfig.OPTION_ROTATION, 0));
    }
}

