/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.streamsharing;

import androidx.camera.core.impl.CameraCaptureMetaData;
import androidx.camera.core.impl.CameraCaptureResult;
import androidx.camera.core.impl.TagBundle;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class VirtualCameraCaptureResult
implements CameraCaptureResult {
    private static final long INVALID_TIMESTAMP = -1L;
    private final @Nullable CameraCaptureResult mBaseCameraCaptureResult;
    private final @NonNull TagBundle mTagBundle;
    private final long mTimestamp;

    public VirtualCameraCaptureResult(@NonNull TagBundle tagBundle, @Nullable CameraCaptureResult baseCameraCaptureResult) {
        this(baseCameraCaptureResult, tagBundle, -1L);
    }

    public VirtualCameraCaptureResult(@NonNull TagBundle tagBundle, long timestamp) {
        this(null, tagBundle, timestamp);
    }

    private VirtualCameraCaptureResult(@Nullable CameraCaptureResult baseCameraCaptureResult, @NonNull TagBundle tagBundle, long timestamp) {
        this.mBaseCameraCaptureResult = baseCameraCaptureResult;
        this.mTagBundle = tagBundle;
        this.mTimestamp = timestamp;
    }

    @Override
    public @NonNull TagBundle getTagBundle() {
        return this.mTagBundle;
    }

    @Override
    public @NonNull CameraCaptureMetaData.AfMode getAfMode() {
        return this.mBaseCameraCaptureResult != null ? this.mBaseCameraCaptureResult.getAfMode() : CameraCaptureMetaData.AfMode.UNKNOWN;
    }

    @Override
    public @NonNull CameraCaptureMetaData.AfState getAfState() {
        return this.mBaseCameraCaptureResult != null ? this.mBaseCameraCaptureResult.getAfState() : CameraCaptureMetaData.AfState.UNKNOWN;
    }

    @Override
    public @NonNull CameraCaptureMetaData.AeState getAeState() {
        return this.mBaseCameraCaptureResult != null ? this.mBaseCameraCaptureResult.getAeState() : CameraCaptureMetaData.AeState.UNKNOWN;
    }

    @Override
    public @NonNull CameraCaptureMetaData.AwbState getAwbState() {
        return this.mBaseCameraCaptureResult != null ? this.mBaseCameraCaptureResult.getAwbState() : CameraCaptureMetaData.AwbState.UNKNOWN;
    }

    @Override
    public @NonNull CameraCaptureMetaData.FlashState getFlashState() {
        return this.mBaseCameraCaptureResult != null ? this.mBaseCameraCaptureResult.getFlashState() : CameraCaptureMetaData.FlashState.UNKNOWN;
    }

    @Override
    public @NonNull CameraCaptureMetaData.AeMode getAeMode() {
        return this.mBaseCameraCaptureResult != null ? this.mBaseCameraCaptureResult.getAeMode() : CameraCaptureMetaData.AeMode.UNKNOWN;
    }

    @Override
    public @NonNull CameraCaptureMetaData.AwbMode getAwbMode() {
        return this.mBaseCameraCaptureResult != null ? this.mBaseCameraCaptureResult.getAwbMode() : CameraCaptureMetaData.AwbMode.UNKNOWN;
    }

    @Override
    public long getTimestamp() {
        if (this.mBaseCameraCaptureResult != null) {
            return this.mBaseCameraCaptureResult.getTimestamp();
        }
        if (this.mTimestamp != -1L) {
            return this.mTimestamp;
        }
        throw new IllegalStateException("No timestamp is available.");
    }
}

