/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.streamsharing;

import android.graphics.Rect;
import android.util.Range;
import android.util.Size;
import androidx.annotation.IntRange;
import androidx.annotation.MainThread;
import androidx.annotation.VisibleForTesting;
import androidx.camera.core.DynamicRange;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.Logger;
import androidx.camera.core.Preview;
import androidx.camera.core.UseCase;
import androidx.camera.core.impl.CameraCaptureCallback;
import androidx.camera.core.impl.CameraCaptureResult;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.impl.DeferrableSurface;
import androidx.camera.core.impl.ImageInputConfig;
import androidx.camera.core.impl.ImageOutputConfig;
import androidx.camera.core.impl.MutableConfig;
import androidx.camera.core.impl.SessionConfig;
import androidx.camera.core.impl.StreamSpec;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.impl.UseCaseConfigFactory;
import androidx.camera.core.impl.utils.Threads;
import androidx.camera.core.impl.utils.TransformUtils;
import androidx.camera.core.processing.SurfaceEdge;
import androidx.camera.core.processing.concurrent.DualOutConfig;
import androidx.camera.core.processing.util.OutConfig;
import androidx.camera.core.streamsharing.DynamicRangeUtils;
import androidx.camera.core.streamsharing.PreferredChildSize;
import androidx.camera.core.streamsharing.ResolutionsMerger;
import androidx.camera.core.streamsharing.StreamSharing;
import androidx.camera.core.streamsharing.VirtualCamera;
import androidx.camera.core.streamsharing.VirtualCameraCaptureResult;
import androidx.core.util.Preconditions;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

class VirtualCameraAdapter
implements UseCase.StateChangeCallback {
    private static final String TAG = "VirtualCameraAdapter";
    final @NonNull Set<UseCase> mChildren;
    final @NonNull Map<UseCase, SurfaceEdge> mChildrenEdges = new HashMap<UseCase, SurfaceEdge>();
    private final @NonNull Map<UseCase, VirtualCamera> mChildrenVirtualCameras = new HashMap<UseCase, VirtualCamera>();
    final @NonNull Map<UseCase, Boolean> mChildrenActiveState = new HashMap<UseCase, Boolean>();
    private final @NonNull UseCaseConfigFactory mUseCaseConfigFactory;
    private final @NonNull CameraInternal mParentCamera;
    private final @Nullable CameraInternal mSecondaryParentCamera;
    private final @NonNull CameraCaptureCallback mParentMetadataCallback = this.createCameraCaptureCallback();
    private final @NonNull Set<UseCaseConfig<?>> mChildrenConfigs;
    private final @NonNull Map<UseCase, UseCaseConfig<?>> mChildrenConfigsMap;
    private final @NonNull ResolutionsMerger mResolutionsMerger;
    private @Nullable ResolutionsMerger mSecondaryResolutionsMerger;

    VirtualCameraAdapter(@NonNull CameraInternal parentCamera, @Nullable CameraInternal secondaryParentCamera, @NonNull Set<UseCase> children, @NonNull UseCaseConfigFactory useCaseConfigFactory, @NonNull StreamSharing.Control streamSharingControl) {
        this.mParentCamera = parentCamera;
        this.mSecondaryParentCamera = secondaryParentCamera;
        this.mUseCaseConfigFactory = useCaseConfigFactory;
        this.mChildren = children;
        this.mChildrenConfigsMap = VirtualCameraAdapter.toChildrenConfigsMap(parentCamera, children, useCaseConfigFactory);
        this.mChildrenConfigs = new HashSet(this.mChildrenConfigsMap.values());
        this.mResolutionsMerger = new ResolutionsMerger(parentCamera, this.mChildrenConfigs);
        if (this.mSecondaryParentCamera != null) {
            this.mSecondaryResolutionsMerger = new ResolutionsMerger(this.mSecondaryParentCamera, this.mChildrenConfigs);
        }
        for (UseCase child : children) {
            this.mChildrenActiveState.put(child, false);
            this.mChildrenVirtualCameras.put(child, new VirtualCamera(parentCamera, this, streamSharingControl));
        }
    }

    void mergeChildrenConfigs(@NonNull MutableConfig mutableConfig) {
        List<Size> mergedResolutions = this.mResolutionsMerger.getMergedResolutions(mutableConfig);
        mutableConfig.insertOption(ImageOutputConfig.OPTION_CUSTOM_ORDERED_RESOLUTIONS, mergedResolutions);
        mutableConfig.insertOption(UseCaseConfig.OPTION_SURFACE_OCCUPANCY_PRIORITY, VirtualCameraAdapter.getHighestSurfacePriority(this.mChildrenConfigs));
        DynamicRange dynamicRange = DynamicRangeUtils.resolveDynamicRange(this.mChildrenConfigs);
        if (dynamicRange == null) {
            throw new IllegalArgumentException("Failed to merge child dynamic ranges, can not find a dynamic range that satisfies all children.");
        }
        mutableConfig.insertOption(ImageInputConfig.OPTION_INPUT_DYNAMIC_RANGE, dynamicRange);
        mutableConfig.insertOption(UseCaseConfig.OPTION_TARGET_FRAME_RATE, VirtualCameraAdapter.resolveTargetFrameRate(this.mChildrenConfigs));
        for (UseCase useCase : this.mChildren) {
            if (useCase.getCurrentConfig().getVideoStabilizationMode() != 0) {
                mutableConfig.insertOption(UseCaseConfig.OPTION_VIDEO_STABILIZATION_MODE, useCase.getCurrentConfig().getVideoStabilizationMode());
            }
            if (useCase.getCurrentConfig().getPreviewStabilizationMode() == 0) continue;
            mutableConfig.insertOption(UseCaseConfig.OPTION_PREVIEW_STABILIZATION_MODE, useCase.getCurrentConfig().getPreviewStabilizationMode());
        }
    }

    void bindChildren() {
        for (UseCase useCase : this.mChildren) {
            useCase.bindToCamera(Objects.requireNonNull(this.mChildrenVirtualCameras.get(useCase)), null, null, useCase.getDefaultConfig(true, this.mUseCaseConfigFactory));
        }
    }

    void unbindChildren() {
        for (UseCase useCase : this.mChildren) {
            useCase.unbindFromCamera(Objects.requireNonNull(this.mChildrenVirtualCameras.get(useCase)));
        }
    }

    void notifySessionStart() {
        for (UseCase useCase : this.mChildren) {
            useCase.onSessionStart();
        }
    }

    void notifySessionStop() {
        for (UseCase useCase : this.mChildren) {
            useCase.onSessionStop();
        }
    }

    void notifyCameraControlReady() {
        for (UseCase useCase : this.mChildren) {
            useCase.onCameraControlReady();
        }
    }

    @NonNull Set<UseCase> getChildren() {
        return this.mChildren;
    }

    @NonNull Map<UseCase, OutConfig> getChildrenOutConfigs(@NonNull SurfaceEdge sharingInputEdge, int parentTargetRotation, boolean isViewportSet) {
        HashMap<UseCase, OutConfig> outConfigs = new HashMap<UseCase, OutConfig>();
        for (UseCase useCase : this.mChildren) {
            OutConfig outConfig = this.calculateOutConfig(useCase, this.mResolutionsMerger, this.mParentCamera, sharingInputEdge, parentTargetRotation, isViewportSet);
            outConfigs.put(useCase, outConfig);
        }
        return outConfigs;
    }

    @NonNull Map<UseCase, Size> getSelectedChildSizes(@NonNull SurfaceEdge sharingInputEdge, boolean isViewportSet) {
        HashMap<UseCase, Size> selectedChildSizes = new HashMap<UseCase, Size>();
        for (UseCase useCase : this.mChildren) {
            PreferredChildSize preferredChildSize = this.mResolutionsMerger.getPreferredChildSize(Objects.requireNonNull(this.mChildrenConfigsMap.get(useCase)), sharingInputEdge.getCropRect(), TransformUtils.getRotationDegrees(sharingInputEdge.getSensorToBufferTransform()), isViewportSet);
            selectedChildSizes.put(useCase, preferredChildSize.getOriginalSelectedChildSize());
            Logger.d(TAG, "Selected child size: " + preferredChildSize.getOriginalSelectedChildSize() + ", useCase: " + useCase);
        }
        return selectedChildSizes;
    }

    @NonNull Map<UseCase, DualOutConfig> getChildrenOutConfigs(@NonNull SurfaceEdge primaryInputEdge, @NonNull SurfaceEdge secondaryInputEdge, int parentTargetRotation, boolean isViewportSet) {
        HashMap<UseCase, DualOutConfig> outConfigs = new HashMap<UseCase, DualOutConfig>();
        for (UseCase useCase : this.mChildren) {
            OutConfig primaryOutConfig = this.calculateOutConfig(useCase, this.mResolutionsMerger, this.mParentCamera, primaryInputEdge, parentTargetRotation, isViewportSet);
            OutConfig secondaryOutConfig = this.calculateOutConfig(useCase, Objects.requireNonNull(this.mSecondaryResolutionsMerger), Objects.requireNonNull(this.mSecondaryParentCamera), secondaryInputEdge, parentTargetRotation, isViewportSet);
            outConfigs.put(useCase, DualOutConfig.of(primaryOutConfig, secondaryOutConfig));
        }
        return outConfigs;
    }

    private @NonNull OutConfig calculateOutConfig(@NonNull UseCase useCase, @NonNull ResolutionsMerger resolutionsMerger, @NonNull CameraInternal cameraInternal, @Nullable SurfaceEdge cameraInputEdge, int parentTargetRotation, boolean isViewportSet) {
        int parentRotationDegrees = cameraInternal.getCameraInfo().getSensorRotationDegrees(parentTargetRotation);
        boolean parentIsMirrored = TransformUtils.isMirrored(cameraInputEdge.getSensorToBufferTransform());
        PreferredChildSize preferredChildSize = resolutionsMerger.getPreferredChildSize(Objects.requireNonNull(this.mChildrenConfigsMap.get(useCase)), cameraInputEdge.getCropRect(), TransformUtils.getRotationDegrees(cameraInputEdge.getSensorToBufferTransform()), isViewportSet);
        Rect cropRectBeforeScaling = preferredChildSize.getCropRectBeforeScaling();
        Size childSizeToScale = preferredChildSize.getChildSizeToScale();
        int childRotationDegrees = this.getChildRotationDegrees(useCase, this.mParentCamera);
        Objects.requireNonNull(this.mChildrenVirtualCameras.get(useCase)).setRotationDegrees(childRotationDegrees);
        int childParentDelta = TransformUtils.within360(cameraInputEdge.getRotationDegrees() + childRotationDegrees - parentRotationDegrees);
        return OutConfig.of(VirtualCameraAdapter.getChildTargetType(useCase), VirtualCameraAdapter.getChildFormat(useCase), cropRectBeforeScaling, TransformUtils.rotateSize(childSizeToScale, childParentDelta), childParentDelta, useCase.isMirroringRequired(cameraInternal) ^ parentIsMirrored);
    }

    void setChildrenEdges(@NonNull Map<UseCase, SurfaceEdge> childrenEdges, @NonNull Map<UseCase, @NonNull Size> selectedChildSizes) {
        this.mChildrenEdges.clear();
        this.mChildrenEdges.putAll(childrenEdges);
        for (Map.Entry<UseCase, SurfaceEdge> entry : this.mChildrenEdges.entrySet()) {
            UseCase useCase = entry.getKey();
            SurfaceEdge surfaceEdge = entry.getValue();
            useCase.setViewPortCropRect(surfaceEdge.getCropRect());
            useCase.setSensorToBufferTransformMatrix(surfaceEdge.getSensorToBufferTransform());
            StreamSpec streamSpec = VirtualCameraAdapter.getChildStreamSpec(useCase, surfaceEdge.getStreamSpec(), selectedChildSizes);
            useCase.updateSuggestedStreamSpec(streamSpec, null);
            useCase.notifyState();
        }
    }

    void resetChildren() {
        Threads.checkMainThread();
        for (UseCase useCase : this.mChildren) {
            this.onUseCaseReset(useCase);
        }
    }

    @NonNull CameraCaptureCallback getParentMetadataCallback() {
        return this.mParentMetadataCallback;
    }

    @Override
    @MainThread
    public void onUseCaseActive(@NonNull UseCase useCase) {
        Threads.checkMainThread();
        if (this.isUseCaseActive(useCase)) {
            return;
        }
        this.mChildrenActiveState.put(useCase, true);
        DeferrableSurface childSurface = VirtualCameraAdapter.getChildSurface(useCase);
        if (childSurface != null) {
            VirtualCameraAdapter.forceSetProvider(this.getUseCaseEdge(useCase), childSurface, useCase.getSessionConfig());
        }
    }

    @Override
    @MainThread
    public void onUseCaseInactive(@NonNull UseCase useCase) {
        Threads.checkMainThread();
        if (!this.isUseCaseActive(useCase)) {
            return;
        }
        this.mChildrenActiveState.put(useCase, false);
        this.getUseCaseEdge(useCase).disconnect();
    }

    @Override
    @MainThread
    public void onUseCaseUpdated(@NonNull UseCase useCase) {
        Threads.checkMainThread();
        if (!this.isUseCaseActive(useCase)) {
            return;
        }
        SurfaceEdge edge = this.getUseCaseEdge(useCase);
        DeferrableSurface childSurface = VirtualCameraAdapter.getChildSurface(useCase);
        if (childSurface != null) {
            VirtualCameraAdapter.forceSetProvider(edge, childSurface, useCase.getSessionConfig());
        } else {
            edge.disconnect();
        }
    }

    @Override
    @MainThread
    public void onUseCaseReset(@NonNull UseCase useCase) {
        Threads.checkMainThread();
        SurfaceEdge edge = this.getUseCaseEdge(useCase);
        if (!this.isUseCaseActive(useCase)) {
            return;
        }
        DeferrableSurface childSurface = VirtualCameraAdapter.getChildSurface(useCase);
        if (childSurface != null) {
            VirtualCameraAdapter.forceSetProvider(edge, childSurface, useCase.getSessionConfig());
        }
    }

    @IntRange(from=0L, to=359L)
    private int getChildRotationDegrees(@NonNull UseCase child, @NonNull CameraInternal cameraInternal) {
        int childTargetRotation = ((ImageOutputConfig)((Object)child.getCurrentConfig())).getTargetRotation(0);
        return cameraInternal.getCameraInfo().getSensorRotationDegrees(childTargetRotation);
    }

    private static @NonNull StreamSpec getChildStreamSpec(@NonNull UseCase useCase, @NonNull StreamSpec baseStreamSpec, @NonNull Map<UseCase, Size> selectedChildSizes) {
        StreamSpec.Builder builder = baseStreamSpec.toBuilder();
        Size selectedChildSize = selectedChildSizes.get(useCase);
        if (selectedChildSize != null) {
            builder.setOriginalConfiguredResolution(selectedChildSize);
        }
        return builder.build();
    }

    private static int getChildFormat(@NonNull UseCase useCase) {
        return useCase instanceof ImageCapture ? 256 : 34;
    }

    private static int getChildTargetType(@NonNull UseCase useCase) {
        if (useCase instanceof Preview) {
            return 1;
        }
        if (useCase instanceof ImageCapture) {
            return 4;
        }
        return 2;
    }

    private static @NonNull Map<UseCase, UseCaseConfig<?>> toChildrenConfigsMap(@NonNull CameraInternal parentCamera, @NonNull Set<UseCase> children, @NonNull UseCaseConfigFactory useCaseConfigFactory) {
        HashMap result = new HashMap();
        for (UseCase useCase : children) {
            UseCaseConfig<?> config = useCase.mergeConfigs(parentCamera.getCameraInfoInternal(), null, useCase.getDefaultConfig(true, useCaseConfigFactory));
            result.put(useCase, config);
        }
        return result;
    }

    private static int getHighestSurfacePriority(Set<UseCaseConfig<?>> childrenConfigs) {
        int highestPriority = 0;
        for (UseCaseConfig<?> childConfig : childrenConfigs) {
            highestPriority = Math.max(highestPriority, childConfig.getSurfaceOccupancyPriority(0));
        }
        return highestPriority;
    }

    private @NonNull SurfaceEdge getUseCaseEdge(@NonNull UseCase useCase) {
        return Objects.requireNonNull(this.mChildrenEdges.get(useCase));
    }

    private boolean isUseCaseActive(@NonNull UseCase useCase) {
        return Objects.requireNonNull(this.mChildrenActiveState.get(useCase));
    }

    private static void forceSetProvider(@NonNull SurfaceEdge edge, @NonNull DeferrableSurface childSurface, @NonNull SessionConfig childSessionConfig) {
        block2: {
            edge.invalidate();
            try {
                edge.setProvider(childSurface);
            }
            catch (DeferrableSurface.SurfaceClosedException e) {
                if (childSessionConfig.getErrorListener() == null) break block2;
                childSessionConfig.getErrorListener().onError(childSessionConfig, SessionConfig.SessionError.SESSION_ERROR_SURFACE_NEEDS_RESET);
            }
        }
    }

    @VisibleForTesting
    static @Nullable DeferrableSurface getChildSurface(@NonNull UseCase child) {
        List<DeferrableSurface> surfaces = child instanceof ImageCapture ? child.getSessionConfig().getSurfaces() : child.getSessionConfig().getRepeatingCaptureConfig().getSurfaces();
        Preconditions.checkState((surfaces.size() <= 1 ? 1 : 0) != 0);
        if (surfaces.size() == 1) {
            return surfaces.get(0);
        }
        return null;
    }

    CameraCaptureCallback createCameraCaptureCallback() {
        return new VirtualCameraCaptureCallback(this);
    }

    static void sendCameraCaptureResultToChild(@NonNull CameraCaptureResult cameraCaptureResult, @NonNull SessionConfig sessionConfig, int captureConfigId) {
        for (CameraCaptureCallback callback : sessionConfig.getRepeatingCameraCaptureCallbacks()) {
            callback.onCaptureCompleted(captureConfigId, new VirtualCameraCaptureResult(sessionConfig.getRepeatingCaptureConfig().getTagBundle(), cameraCaptureResult));
        }
    }

    private static @NonNull Range<Integer> resolveTargetFrameRate(@NonNull Set<UseCaseConfig<?>> useCaseConfigs) {
        Range resolvedTargetFrameRate = StreamSpec.FRAME_RATE_RANGE_UNSPECIFIED;
        for (UseCaseConfig<?> useCaseConfig : useCaseConfigs) {
            Range<Integer> targetFrameRate = Objects.requireNonNull(useCaseConfig.getTargetFrameRate(resolvedTargetFrameRate));
            if (StreamSpec.FRAME_RATE_RANGE_UNSPECIFIED.equals(resolvedTargetFrameRate)) {
                resolvedTargetFrameRate = targetFrameRate;
                continue;
            }
            try {
                resolvedTargetFrameRate = resolvedTargetFrameRate.intersect(targetFrameRate);
            }
            catch (IllegalArgumentException e) {
                Logger.d(TAG, "No intersected frame rate can be found from the target frame rate settings of the UseCases! Resolved: " + resolvedTargetFrameRate + " <<>> " + targetFrameRate);
                return resolvedTargetFrameRate.extend(targetFrameRate);
            }
        }
        return resolvedTargetFrameRate;
    }

    static class VirtualCameraCaptureCallback
    extends CameraCaptureCallback {
        private final WeakReference<VirtualCameraAdapter> mVirtualCameraAdapterRef;

        VirtualCameraCaptureCallback(VirtualCameraAdapter virtualCameraAdapter) {
            this.mVirtualCameraAdapterRef = new WeakReference<VirtualCameraAdapter>(virtualCameraAdapter);
        }

        @Override
        public void onCaptureCompleted(int captureConfigId, @NonNull CameraCaptureResult cameraCaptureResult) {
            VirtualCameraAdapter virtualCameraAdapter = (VirtualCameraAdapter)this.mVirtualCameraAdapterRef.get();
            if (virtualCameraAdapter != null) {
                for (UseCase child : virtualCameraAdapter.mChildren) {
                    VirtualCameraAdapter.sendCameraCaptureResultToChild(cameraCaptureResult, child.getSessionConfig(), captureConfigId);
                }
            }
        }
    }
}

