/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.streamsharing;

import androidx.annotation.RestrictTo;
import androidx.camera.core.impl.CaptureConfig;
import androidx.camera.core.impl.MutableConfig;
import androidx.camera.core.impl.MutableOptionsBundle;
import androidx.camera.core.impl.OptionsBundle;
import androidx.camera.core.impl.SessionConfig;
import androidx.camera.core.impl.StreamUseCase;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.impl.UseCaseConfigFactory;
import androidx.camera.core.internal.TargetConfig;
import androidx.camera.core.streamsharing.StreamSharing;
import androidx.camera.core.streamsharing.StreamSharingConfig;
import java.util.UUID;
import org.jspecify.annotations.NonNull;

class StreamSharingBuilder
implements UseCaseConfig.Builder<StreamSharing, StreamSharingConfig, StreamSharingBuilder> {
    private static final String UNSUPPORTED_MESSAGE = "Operation not supported by StreamSharingBuilder.";
    private final MutableOptionsBundle mMutableConfig;

    StreamSharingBuilder() {
        this(MutableOptionsBundle.create());
    }

    StreamSharingBuilder(@NonNull MutableOptionsBundle mutableConfig) {
        this.mMutableConfig = mutableConfig;
        Class oldConfigClass = mutableConfig.retrieveOption(TargetConfig.OPTION_TARGET_CLASS, null);
        if (oldConfigClass != null && !oldConfigClass.equals(StreamSharing.class)) {
            throw new IllegalArgumentException("Invalid target class configuration for " + this + ": " + oldConfigClass);
        }
        this.setCaptureType(UseCaseConfigFactory.CaptureType.STREAM_SHARING);
        this.setTargetClass((Class)StreamSharing.class);
    }

    @Override
    public @NonNull MutableConfig getMutableConfig() {
        return this.mMutableConfig;
    }

    @Override
    public @NonNull StreamSharing build() {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public @NonNull StreamSharingBuilder setDefaultSessionConfig(@NonNull SessionConfig sessionConfig) {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public @NonNull StreamSharingBuilder setDefaultCaptureConfig(@NonNull CaptureConfig captureConfig) {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public @NonNull StreamSharingBuilder setSessionOptionUnpacker(@NonNull SessionConfig.OptionUnpacker optionUnpacker) {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public @NonNull StreamSharingBuilder setCaptureOptionUnpacker(@NonNull CaptureConfig.OptionUnpacker optionUnpacker) {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public @NonNull StreamSharingBuilder setSurfaceOccupancyPriority(int priority) {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public @NonNull StreamSharingBuilder setZslDisabled(boolean disabled) {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public @NonNull StreamSharingBuilder setHighResolutionDisabled(boolean disabled) {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public @NonNull StreamSharingConfig getUseCaseConfig() {
        return new StreamSharingConfig(OptionsBundle.from(this.mMutableConfig));
    }

    @Override
    public @NonNull StreamSharingBuilder setTargetClass(@NonNull Class<StreamSharing> targetClass) {
        this.getMutableConfig().insertOption(TargetConfig.OPTION_TARGET_CLASS, targetClass);
        if (null == this.getMutableConfig().retrieveOption(TargetConfig.OPTION_TARGET_NAME, null)) {
            String targetName = targetClass.getCanonicalName() + "-" + UUID.randomUUID();
            this.setTargetName(targetName);
        }
        return this;
    }

    @Override
    public @NonNull StreamSharingBuilder setTargetName(@NonNull String targetName) {
        this.getMutableConfig().insertOption(TargetConfig.OPTION_TARGET_NAME, targetName);
        return this;
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public @NonNull StreamSharingBuilder setCaptureType(@NonNull UseCaseConfigFactory.CaptureType captureType) {
        this.getMutableConfig().insertOption(UseCaseConfig.OPTION_CAPTURE_TYPE, captureType);
        return this;
    }

    @Override
    public @NonNull StreamSharingBuilder setStreamUseCase(@NonNull StreamUseCase streamUseCase) {
        this.getMutableConfig().insertOption(UseCaseConfig.OPTION_STREAM_USE_CASE, streamUseCase);
        return this;
    }
}

