/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.streamsharing;

import android.graphics.Rect;
import android.graphics.RectF;
import android.util.Pair;
import android.util.Rational;
import android.util.Size;
import androidx.annotation.VisibleForTesting;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.impl.ImageOutputConfig;
import androidx.camera.core.impl.MutableConfig;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.impl.utils.AspectRatioUtil;
import androidx.camera.core.impl.utils.CompareSizesByArea;
import androidx.camera.core.impl.utils.TransformUtils;
import androidx.camera.core.internal.SupportedOutputSizesSorter;
import androidx.camera.core.resolutionselector.ResolutionSelector;
import androidx.camera.core.streamsharing.PreferredChildSize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jspecify.annotations.NonNull;

public class ResolutionsMerger {
    private static final String TAG = "ResolutionsMerger";
    private static final double SAME_AREA_WIDTH_HEIGHT_RATIO = Math.sqrt(2.3703703703703702);
    private final @NonNull Size mSensorSize;
    private final @NonNull Rational mSensorAspectRatio;
    private final @NonNull Rational mFallbackAspectRatio;
    private final @NonNull Set<UseCaseConfig<?>> mChildrenConfigs;
    private final @NonNull SupportedOutputSizesSorter mSizeSorter;
    private final @NonNull CameraInfoInternal mCameraInfo;
    private final @NonNull Map<UseCaseConfig<?>, List<Size>> mChildSizesCache = new HashMap();

    ResolutionsMerger(@NonNull CameraInternal cameraInternal, @NonNull Set<UseCaseConfig<?>> childrenConfigs) {
        this(TransformUtils.rectToSize(cameraInternal.getCameraInfoInternal().getSensorRect()), cameraInternal.getCameraInfoInternal(), childrenConfigs);
    }

    private ResolutionsMerger(@NonNull Size sensorSize, @NonNull CameraInfoInternal cameraInfo, @NonNull Set<UseCaseConfig<?>> childrenConfigs) {
        this(sensorSize, cameraInfo, childrenConfigs, new SupportedOutputSizesSorter(cameraInfo, sensorSize));
    }

    @VisibleForTesting
    ResolutionsMerger(@NonNull Size sensorSize, @NonNull CameraInfoInternal cameraInfo, @NonNull Set<UseCaseConfig<?>> childrenConfigs, @NonNull SupportedOutputSizesSorter supportedOutputSizesSorter) {
        this.mSensorSize = sensorSize;
        this.mSensorAspectRatio = ResolutionsMerger.getSensorAspectRatio(sensorSize);
        this.mFallbackAspectRatio = ResolutionsMerger.getFallbackAspectRatio(this.mSensorAspectRatio);
        this.mCameraInfo = cameraInfo;
        this.mChildrenConfigs = childrenConfigs;
        this.mSizeSorter = supportedOutputSizesSorter;
    }

    @NonNull List<Size> getMergedResolutions(@NonNull MutableConfig parentConfig) {
        List parentSupportedSizesMap;
        List<Size> candidateSizes = this.getCameraSupportedResolutions();
        if (this.shouldIncludeHighResolutions()) {
            candidateSizes = new ArrayList<Size>(candidateSizes);
            candidateSizes.addAll(this.getCameraSupportedHighResolutions());
        }
        if ((parentSupportedSizesMap = (List)parentConfig.retrieveOption(ImageOutputConfig.OPTION_SUPPORTED_RESOLUTIONS, null)) != null) {
            candidateSizes = ResolutionsMerger.getSupportedPrivResolutions(parentSupportedSizesMap);
        }
        return this.selectParentResolutions(candidateSizes);
    }

    @NonNull PreferredChildSize getPreferredChildSize(@NonNull UseCaseConfig<?> childConfig, @NonNull Rect parentCropRect, int sensorToBufferRotationDegrees, boolean isViewportSet) {
        boolean isWidthHeightRevertedForComputation = false;
        if (TransformUtils.is90or270(sensorToBufferRotationDegrees)) {
            parentCropRect = ResolutionsMerger.reverseRect(parentCropRect);
            isWidthHeightRevertedForComputation = true;
        }
        PreferredChildSize preferredChildSize = this.getPreferredChildSizeInternal(parentCropRect, childConfig, isViewportSet);
        if (isWidthHeightRevertedForComputation) {
            preferredChildSize = new PreferredChildSize(ResolutionsMerger.reverseRect(preferredChildSize.getCropRectBeforeScaling()), TransformUtils.reverseSize(preferredChildSize.getChildSizeToScale()), preferredChildSize.getOriginalSelectedChildSize());
        }
        return preferredChildSize;
    }

    private @NonNull PreferredChildSize getPreferredChildSizeInternal(@NonNull Rect parentCropRect, @NonNull UseCaseConfig<?> childConfig, boolean isViewportSet) {
        Size childSizeToScale;
        Size selectedChildSize;
        Rect cropRectBeforeScaling;
        if (isViewportSet) {
            cropRectBeforeScaling = parentCropRect;
            Size viewPortSize = TransformUtils.rectToSize(parentCropRect);
            Pair<Size, Size> pair = this.getPreferredChildSizeForViewport(viewPortSize, childConfig);
            selectedChildSize = (Size)pair.first;
            childSizeToScale = (Size)pair.second;
        } else {
            Size parentSize = TransformUtils.rectToSize(parentCropRect);
            childSizeToScale = selectedChildSize = this.getPreferredChildSize(parentSize, childConfig);
            cropRectBeforeScaling = ResolutionsMerger.getCropRectOfReferenceAspectRatio(parentSize, childSizeToScale);
        }
        return new PreferredChildSize(cropRectBeforeScaling, childSizeToScale, selectedChildSize);
    }

    @VisibleForTesting
    @NonNull Size getPreferredChildSize(@NonNull Size parentSize, @NonNull UseCaseConfig<?> childConfig) {
        List<Size> candidateChildSizes = this.getSortedChildSizes(childConfig);
        for (Size childSize : candidateChildSizes) {
            if (this.isDoubleCropping(parentSize, childSize) || ResolutionsMerger.hasUpscaling(childSize, parentSize)) continue;
            return childSize;
        }
        for (Size childSize : candidateChildSizes) {
            if (ResolutionsMerger.hasUpscaling(childSize, parentSize)) continue;
            return childSize;
        }
        return parentSize;
    }

    @VisibleForTesting
    @NonNull Pair<Size, Size> getPreferredChildSizeForViewport(@NonNull Size parentSize, @NonNull UseCaseConfig<?> childConfig) {
        List<Size> candidateChildSizes = this.getSortedChildSizes(childConfig);
        for (Size childSize : candidateChildSizes) {
            Size childSizeToCrop = TransformUtils.rectToSize(ResolutionsMerger.getCropRectOfReferenceAspectRatio(childSize, parentSize));
            if (ResolutionsMerger.hasUpscaling(childSizeToCrop, parentSize)) continue;
            return Pair.create((Object)childSize, (Object)childSizeToCrop);
        }
        return Pair.create((Object)parentSize, (Object)parentSize);
    }

    private @NonNull List<Size> getCameraSupportedResolutions() {
        return this.mCameraInfo.getSupportedResolutions(34);
    }

    private @NonNull List<Size> getCameraSupportedHighResolutions() {
        return this.mCameraInfo.getSupportedHighResolutions(34);
    }

    private boolean shouldIncludeHighResolutions() {
        for (UseCaseConfig<?> childConfig : this.mChildrenConfigs) {
            ResolutionSelector resolutionSelector;
            if (childConfig.isHighResolutionDisabled(false) || !(childConfig instanceof ImageOutputConfig) || (resolutionSelector = ((ImageOutputConfig)((Object)childConfig)).getResolutionSelector(null)) == null || resolutionSelector.getAllowedResolutionMode() != 1) continue;
            return true;
        }
        return false;
    }

    private @NonNull List<Size> selectParentResolutions(@NonNull List<Size> candidateParentResolutions) {
        ArrayList<Size> result = new ArrayList<Size>();
        if (this.needToAddSensorResolutions()) {
            result.addAll(this.selectParentResolutionsByAspectRatio(this.mSensorAspectRatio, candidateParentResolutions, false));
        }
        result.addAll(this.selectParentResolutionsByAspectRatio(this.mFallbackAspectRatio, candidateParentResolutions, false));
        result.addAll(this.selectOtherAspectRatioParentResolutionsWithFovPriority(candidateParentResolutions, false));
        if (result.isEmpty()) {
            Logger.w(TAG, "Failed to find a parent resolution that does not result in double-cropping, this might due to camera not supporting 4:3 and 16:9resolutions or a strict ResolutionSelector settings. Starting resolution selection process with resolutions that might have a smaller FOV.");
            result.addAll(this.selectOtherAspectRatioParentResolutionsWithFovPriority(candidateParentResolutions, true));
        }
        Logger.d(TAG, "Parent resolutions: " + result);
        return result;
    }

    private List<Size> selectParentResolutionsByAspectRatio(@NonNull Rational aspectRatio, @NonNull List<Size> candidateParentResolutions, boolean allowDoubleCropping) {
        List<Size> candidates = ResolutionsMerger.filterResolutionsByAspectRatio(aspectRatio, candidateParentResolutions);
        ResolutionsMerger.sortInDescendingOrder(candidates);
        HashSet<Size> sizesTooLarge = new HashSet<Size>(candidates);
        for (UseCaseConfig<?> childConfig : this.mChildrenConfigs) {
            List<Size> childSizes = this.getSortedChildSizes(childConfig);
            if (!allowDoubleCropping) {
                childSizes = this.filterOutChildSizesCausingDoubleCropping(aspectRatio, childSizes);
            }
            if (childSizes.isEmpty()) {
                return new ArrayList<Size>();
            }
            candidates = ResolutionsMerger.filterOutParentSizeThatIsTooSmall(childSizes, candidates);
            sizesTooLarge.retainAll(ResolutionsMerger.getParentSizesThatAreTooLarge(childSizes, candidates));
        }
        ArrayList<Size> result = new ArrayList<Size>();
        for (Size candidate : candidates) {
            if (sizesTooLarge.contains(candidate)) continue;
            result.add(candidate);
        }
        return result;
    }

    private @NonNull List<Size> selectOtherAspectRatioParentResolutionsWithFovPriority(@NonNull List<Size> candidates, boolean allowDoubleCropping) {
        Map<Rational, List<Size>> ratioToSizesMap = this.groupSizesByAspectRatio(candidates);
        ArrayList<Rational> ratios = new ArrayList<Rational>(ratioToSizesMap.keySet());
        this.sortByFov(ratios);
        ArrayList<Size> result = new ArrayList<Size>();
        for (Rational ratio : ratios) {
            if (ratio.equals((Object)AspectRatioUtil.ASPECT_RATIO_16_9) || ratio.equals((Object)AspectRatioUtil.ASPECT_RATIO_4_3)) continue;
            List<Size> sizes = Objects.requireNonNull(ratioToSizesMap.get(ratio));
            result.addAll(this.selectParentResolutionsByAspectRatio(ratio, sizes, allowDoubleCropping));
        }
        return result;
    }

    private @NonNull Map<Rational, List<Size>> groupSizesByAspectRatio(@NonNull List<Size> sizes) {
        HashMap<Rational, List<Size>> result = new HashMap<Rational, List<Size>>();
        result.put(AspectRatioUtil.ASPECT_RATIO_4_3, new ArrayList());
        result.put(AspectRatioUtil.ASPECT_RATIO_16_9, new ArrayList());
        ArrayList<Rational> ratios = new ArrayList<Rational>();
        ratios.add(AspectRatioUtil.ASPECT_RATIO_4_3);
        ratios.add(AspectRatioUtil.ASPECT_RATIO_16_9);
        for (Size size : sizes) {
            if (size.getHeight() <= 0) continue;
            List group = null;
            for (Rational ratio : ratios) {
                if (!AspectRatioUtil.hasMatchingAspectRatio(size, ratio)) continue;
                group = (List)result.get(ratio);
                break;
            }
            if (group == null) {
                group = new ArrayList();
                Rational newRatio = ResolutionsMerger.toRational(size);
                ratios.add(newRatio);
                result.put(newRatio, group);
            }
            ((List)Objects.requireNonNull(group)).add(size);
        }
        return result;
    }

    private @NonNull List<Size> getSortedChildSizes(@NonNull UseCaseConfig<?> childConfig) {
        if (!this.mChildrenConfigs.contains(childConfig)) {
            throw new IllegalArgumentException("Invalid child config: " + childConfig);
        }
        if (this.mChildSizesCache.containsKey(childConfig)) {
            return Objects.requireNonNull(this.mChildSizesCache.get(childConfig));
        }
        List<Size> childSizes = this.mSizeSorter.getSortedSupportedOutputSizes(childConfig);
        childSizes = ResolutionsMerger.filterOutChildSizesThatWillNeverBeSelected(childSizes);
        this.mChildSizesCache.put(childConfig, childSizes);
        return childSizes;
    }

    private boolean needToAddSensorResolutions() {
        for (Size size : this.getChildrenRequiredResolutions()) {
            if (AspectRatioUtil.hasMatchingAspectRatio(size, this.mFallbackAspectRatio)) continue;
            return true;
        }
        return false;
    }

    private @NonNull Set<Size> getChildrenRequiredResolutions() {
        HashSet<Size> result = new HashSet<Size>();
        for (UseCaseConfig<?> childConfig : this.mChildrenConfigs) {
            List<Size> childSizes = this.getSortedChildSizes(childConfig);
            result.addAll(childSizes);
        }
        return result;
    }

    private @NonNull List<Size> filterOutChildSizesCausingDoubleCropping(@NonNull Rational parentAspectRatio, @NonNull List<Size> childSizes) {
        ArrayList<Size> result = new ArrayList<Size>();
        for (Size childSize : childSizes) {
            if (this.isDoubleCropping(parentAspectRatio, childSize)) continue;
            result.add(childSize);
        }
        return result;
    }

    private boolean isDoubleCropping(@NonNull Rational parentRatio, @NonNull Size childSize) {
        if (this.mSensorAspectRatio.equals((Object)parentRatio) || AspectRatioUtil.hasMatchingAspectRatio(childSize, parentRatio)) {
            return false;
        }
        return this.areCroppingInDifferentDirection(this.mSensorAspectRatio.floatValue(), parentRatio.floatValue(), ResolutionsMerger.toRationalWithMod16Considered(childSize).floatValue());
    }

    private boolean isDoubleCropping(@NonNull Size parentSize, @NonNull Size childSize) {
        Rational parentRatio = ResolutionsMerger.toRationalWithMod16Considered(parentSize);
        return this.isDoubleCropping(parentRatio, childSize);
    }

    private boolean areCroppingInDifferentDirection(float sensorRatioValue, float parentRatioValue, float childRatioValue) {
        if (sensorRatioValue == parentRatioValue || parentRatioValue == childRatioValue) {
            return false;
        }
        if (sensorRatioValue > parentRatioValue) {
            return parentRatioValue < childRatioValue;
        }
        return parentRatioValue > childRatioValue;
    }

    private void sortByFov(@NonNull List<Rational> ratios) {
        Rational actualSensorAspectRatio = ResolutionsMerger.toRational(this.mSensorSize);
        Collections.sort(ratios, new CompareAspectRatioByOverlappingAreaToReference(actualSensorAspectRatio, true));
    }

    @VisibleForTesting
    static @NonNull Rect getCropRectOfReferenceAspectRatio(@NonNull Size targetSize, @NonNull Size referenceSize) {
        Rational referenceRatio = ResolutionsMerger.toRational(referenceSize);
        return ResolutionsMerger.getCenterCroppedRectangle(referenceRatio, targetSize);
    }

    private static @NonNull List<Size> getSupportedPrivResolutions(@NonNull List<Pair<Integer, Size[]>> supportedResolutionsMap) {
        for (Pair<Integer, Size[]> pair : supportedResolutionsMap) {
            if (!((Integer)pair.first).equals(34)) continue;
            return Arrays.asList((Size[])pair.second);
        }
        return new ArrayList<Size>();
    }

    private static @NonNull Rational getSensorAspectRatio(@NonNull Size sensorSize) {
        Rational result = ResolutionsMerger.findCloserAspectRatio(sensorSize);
        Logger.d(TAG, "The closer aspect ratio to the sensor size (" + sensorSize + ") is " + result + ".");
        return result;
    }

    private static @NonNull Rational findCloserAspectRatio(@NonNull Size size) {
        double widthHeightRatio = (double)size.getWidth() / (double)size.getHeight();
        if (widthHeightRatio > SAME_AREA_WIDTH_HEIGHT_RATIO) {
            return AspectRatioUtil.ASPECT_RATIO_16_9;
        }
        return AspectRatioUtil.ASPECT_RATIO_4_3;
    }

    @VisibleForTesting
    static @NonNull Rect reverseRect(@NonNull Rect rect) {
        return new Rect(rect.top, rect.left, rect.bottom, rect.right);
    }

    private static @NonNull Rect getCenterCroppedRectangle(@NonNull Rational cropRatio, @NonNull Size baseSize) {
        RectF cropRectInFloat;
        int width = baseSize.getWidth();
        int height = baseSize.getHeight();
        Rational referenceRatio = ResolutionsMerger.toRational(baseSize);
        if (cropRatio.floatValue() == referenceRatio.floatValue()) {
            cropRectInFloat = new RectF(0.0f, 0.0f, (float)width, (float)height);
        } else if (cropRatio.floatValue() > referenceRatio.floatValue()) {
            float cropHeight = (float)width / cropRatio.floatValue();
            float yOffset = ((float)height - cropHeight) / 2.0f;
            cropRectInFloat = new RectF(0.0f, yOffset, (float)width, yOffset + cropHeight);
        } else {
            float cropWidth = (float)height * cropRatio.floatValue();
            float xOffset = ((float)width - cropWidth) / 2.0f;
            cropRectInFloat = new RectF(xOffset, 0.0f, xOffset + cropWidth, (float)height);
        }
        Rect result = new Rect();
        cropRectInFloat.round(result);
        return result;
    }

    private static @NonNull Rational getFallbackAspectRatio(@NonNull Rational sensorAspectRatio) {
        if (sensorAspectRatio.equals((Object)AspectRatioUtil.ASPECT_RATIO_4_3)) {
            return AspectRatioUtil.ASPECT_RATIO_16_9;
        }
        if (sensorAspectRatio.equals((Object)AspectRatioUtil.ASPECT_RATIO_16_9)) {
            return AspectRatioUtil.ASPECT_RATIO_4_3;
        }
        throw new IllegalArgumentException("Invalid sensor aspect-ratio: " + sensorAspectRatio);
    }

    @VisibleForTesting
    static void sortInDescendingOrder(@NonNull List<Size> resolutions) {
        Collections.sort(resolutions, new CompareSizesByArea(true));
    }

    private static @NonNull List<Size> removeDuplicates(@NonNull List<Size> resolutions) {
        if (resolutions.isEmpty()) {
            return resolutions;
        }
        return new ArrayList<Size>(new LinkedHashSet<Size>(resolutions));
    }

    @VisibleForTesting
    static @NonNull List<Size> filterResolutionsByAspectRatio(@NonNull Rational aspectRatio, @NonNull List<Size> resolutionsToFilter) {
        ArrayList<Size> result = new ArrayList<Size>();
        for (Size resolution : resolutionsToFilter) {
            if (!AspectRatioUtil.hasMatchingAspectRatio(resolution, aspectRatio)) continue;
            result.add(resolution);
        }
        return result;
    }

    @VisibleForTesting
    static @NonNull List<Size> filterOutParentSizeThatIsTooSmall(@NonNull Collection<Size> childSizes, @NonNull List<Size> parentSizes) {
        if (childSizes.isEmpty() || parentSizes.isEmpty()) {
            return new ArrayList<Size>();
        }
        ArrayList<Size> result = new ArrayList<Size>();
        for (Size parentSize : parentSizes) {
            if (!ResolutionsMerger.isAnyChildSizeCanBeCroppedOutWithoutUpscalingParent(childSizes, parentSize)) continue;
            result.add(parentSize);
        }
        return result;
    }

    private static List<Size> filterOutChildSizesThatWillNeverBeSelected(@NonNull List<Size> childSizes) {
        HashMap<Rational, Size> smallestSizeMap = new HashMap<Rational, Size>();
        ArrayList<Size> result = new ArrayList<Size>();
        for (Size size : childSizes) {
            Rational keyRatio = null;
            for (Rational seenRatio : smallestSizeMap.keySet()) {
                if (!AspectRatioUtil.hasMatchingAspectRatio(size, seenRatio)) continue;
                keyRatio = seenRatio;
                break;
            }
            if (keyRatio != null) {
                Size smallestSize = Objects.requireNonNull((Size)smallestSizeMap.get(keyRatio));
                if (size.getHeight() > smallestSize.getHeight() || size.getWidth() > smallestSize.getWidth() || size.getWidth() == smallestSize.getWidth() && size.getHeight() == smallestSize.getHeight()) {
                    continue;
                }
            } else {
                keyRatio = ResolutionsMerger.toRational(size);
            }
            result.add(size);
            smallestSizeMap.put(keyRatio, size);
        }
        return result;
    }

    private static boolean isAnyChildSizeCanBeCroppedOutWithoutUpscalingParent(@NonNull Collection<Size> childSizes, @NonNull Size parentSize) {
        for (Size childSize : childSizes) {
            if (ResolutionsMerger.hasUpscaling(childSize, parentSize)) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    static @NonNull List<Size> getParentSizesThatAreTooLarge(@NonNull Collection<Size> childSizes, @NonNull List<Size> parentSizes) {
        if (childSizes.isEmpty() || parentSizes.isEmpty()) {
            return new ArrayList<Size>();
        }
        parentSizes = ResolutionsMerger.removeDuplicates(parentSizes);
        ArrayList<Size> result = new ArrayList<Size>();
        for (Size parentSize : parentSizes) {
            if (!ResolutionsMerger.isAllChildSizesCanBeCroppedOutWithoutUpscalingParent(childSizes, parentSize)) continue;
            result.add(parentSize);
        }
        if (!result.isEmpty()) {
            result.remove(result.size() - 1);
        }
        return result;
    }

    private static boolean isAllChildSizesCanBeCroppedOutWithoutUpscalingParent(@NonNull Collection<Size> childSizes, @NonNull Size parentSize) {
        for (Size childSize : childSizes) {
            if (!ResolutionsMerger.hasUpscaling(childSize, parentSize)) continue;
            return false;
        }
        return true;
    }

    @VisibleForTesting
    static boolean hasUpscaling(@NonNull Size childSize, @NonNull Size parentSize) {
        return childSize.getHeight() > parentSize.getHeight() || childSize.getWidth() > parentSize.getWidth();
    }

    private static @NonNull Rational toRationalWithMod16Considered(@NonNull Size size) {
        if (AspectRatioUtil.hasMatchingAspectRatio(size, AspectRatioUtil.ASPECT_RATIO_4_3)) {
            return AspectRatioUtil.ASPECT_RATIO_4_3;
        }
        if (AspectRatioUtil.hasMatchingAspectRatio(size, AspectRatioUtil.ASPECT_RATIO_16_9)) {
            return AspectRatioUtil.ASPECT_RATIO_16_9;
        }
        return ResolutionsMerger.toRational(size);
    }

    private static @NonNull Rational toRational(@NonNull Size size) {
        return new Rational(size.getWidth(), size.getHeight());
    }

    private static float computeAreaOverlapping(@NonNull Rational croppingRatio, @NonNull Rational baseRatio) {
        float baseRatioValue;
        float croppingRatioValue = croppingRatio.floatValue();
        return croppingRatioValue > (baseRatioValue = baseRatio.floatValue()) ? baseRatioValue / croppingRatioValue : croppingRatioValue / baseRatioValue;
    }

    private static class CompareAspectRatioByOverlappingAreaToReference
    implements Comparator<Rational> {
        private final @NonNull Rational mReferenceAspectRatio;
        private final boolean mReverse;

        CompareAspectRatioByOverlappingAreaToReference(@NonNull Rational referenceAspectRatio, boolean reverse) {
            this.mReferenceAspectRatio = referenceAspectRatio;
            this.mReverse = reverse;
        }

        @Override
        public int compare(@NonNull Rational lhs, @NonNull Rational rhs) {
            float lhsOverlapping = ResolutionsMerger.computeAreaOverlapping(lhs, this.mReferenceAspectRatio);
            float rhsOverlapping = ResolutionsMerger.computeAreaOverlapping(rhs, this.mReferenceAspectRatio);
            if (this.mReverse) {
                return Float.compare(rhsOverlapping, lhsOverlapping);
            }
            return Float.compare(lhsOverlapping, rhsOverlapping);
        }
    }
}

