/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.resolutionselector;

import android.util.Size;
import androidx.annotation.RestrictTo;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class ResolutionStrategy {
    public static final @NonNull ResolutionStrategy HIGHEST_AVAILABLE_STRATEGY = new ResolutionStrategy();
    public static final int FALLBACK_RULE_NONE = 0;
    public static final int FALLBACK_RULE_CLOSEST_HIGHER_THEN_LOWER = 1;
    public static final int FALLBACK_RULE_CLOSEST_HIGHER = 2;
    public static final int FALLBACK_RULE_CLOSEST_LOWER_THEN_HIGHER = 3;
    public static final int FALLBACK_RULE_CLOSEST_LOWER = 4;
    private @Nullable Size mBoundSize = null;
    private int mFallbackRule = 0;

    private ResolutionStrategy() {
    }

    public ResolutionStrategy(@NonNull Size boundSize, int fallbackRule) {
        this.mBoundSize = boundSize;
        this.mFallbackRule = fallbackRule;
    }

    public @Nullable Size getBoundSize() {
        return this.mBoundSize;
    }

    public int getFallbackRule() {
        return this.mFallbackRule;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface ResolutionFallbackRule {
    }
}

