/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.resolutionselector;

import androidx.annotation.RestrictTo;
import androidx.camera.core.resolutionselector.AspectRatioStrategy;
import androidx.camera.core.resolutionselector.ResolutionFilter;
import androidx.camera.core.resolutionselector.ResolutionStrategy;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class ResolutionSelector {
    public static final int PREFER_CAPTURE_RATE_OVER_HIGHER_RESOLUTION = 0;
    public static final int PREFER_HIGHER_RESOLUTION_OVER_CAPTURE_RATE = 1;
    private final @NonNull AspectRatioStrategy mAspectRatioStrategy;
    private final @Nullable ResolutionStrategy mResolutionStrategy;
    private final @Nullable ResolutionFilter mResolutionFilter;
    private final int mAllowedResolutionMode;

    ResolutionSelector(@NonNull AspectRatioStrategy aspectRatioStrategy, @Nullable ResolutionStrategy resolutionStrategy, @Nullable ResolutionFilter resolutionFilter, int allowedResolutionMode) {
        this.mAspectRatioStrategy = aspectRatioStrategy;
        this.mResolutionStrategy = resolutionStrategy;
        this.mResolutionFilter = resolutionFilter;
        this.mAllowedResolutionMode = allowedResolutionMode;
    }

    public @NonNull AspectRatioStrategy getAspectRatioStrategy() {
        return this.mAspectRatioStrategy;
    }

    public @Nullable ResolutionStrategy getResolutionStrategy() {
        return this.mResolutionStrategy;
    }

    public @Nullable ResolutionFilter getResolutionFilter() {
        return this.mResolutionFilter;
    }

    public int getAllowedResolutionMode() {
        return this.mAllowedResolutionMode;
    }

    public static final class Builder {
        private @Nullable AspectRatioStrategy mAspectRatioStrategy = AspectRatioStrategy.RATIO_4_3_FALLBACK_AUTO_STRATEGY;
        private @Nullable ResolutionStrategy mResolutionStrategy = null;
        private @Nullable ResolutionFilter mResolutionFilter = null;
        private int mAllowedResolutionMode = 0;

        public Builder() {
        }

        private Builder(@NonNull ResolutionSelector resolutionSelector) {
            this.mAspectRatioStrategy = resolutionSelector.getAspectRatioStrategy();
            this.mResolutionStrategy = resolutionSelector.getResolutionStrategy();
            this.mResolutionFilter = resolutionSelector.getResolutionFilter();
            this.mAllowedResolutionMode = resolutionSelector.getAllowedResolutionMode();
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public static @NonNull Builder fromResolutionSelector(@NonNull ResolutionSelector resolutionSelector) {
            return new Builder(resolutionSelector);
        }

        public @NonNull Builder setAspectRatioStrategy(@NonNull AspectRatioStrategy aspectRatioStrategy) {
            this.mAspectRatioStrategy = aspectRatioStrategy;
            return this;
        }

        public @NonNull Builder setResolutionStrategy(@NonNull ResolutionStrategy resolutionStrategy) {
            this.mResolutionStrategy = resolutionStrategy;
            return this;
        }

        public @NonNull Builder setResolutionFilter(@NonNull ResolutionFilter resolutionFilter) {
            this.mResolutionFilter = resolutionFilter;
            return this;
        }

        public @NonNull Builder setAllowedResolutionMode(int mode) {
            this.mAllowedResolutionMode = mode;
            return this;
        }

        public @NonNull ResolutionSelector build() {
            return new ResolutionSelector(this.mAspectRatioStrategy, this.mResolutionStrategy, this.mResolutionFilter, this.mAllowedResolutionMode);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface AllowedResolutionMode {
    }
}

