/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.processing.util;

import android.graphics.Rect;
import android.util.Size;
import androidx.camera.core.impl.utils.TransformUtils;
import androidx.camera.core.processing.SurfaceEdge;
import androidx.camera.core.processing.util.AutoValue_OutConfig;
import com.google.auto.value.AutoValue;
import java.util.UUID;
import org.jspecify.annotations.NonNull;

@AutoValue
public abstract class OutConfig {
    abstract @NonNull UUID getUuid();

    public abstract int getTargets();

    public abstract int getFormat();

    public abstract @NonNull Rect getCropRect();

    public abstract @NonNull Size getSize();

    public abstract int getRotationDegrees();

    public abstract boolean isMirroring();

    public abstract boolean shouldRespectInputCropRect();

    public static @NonNull OutConfig of(@NonNull SurfaceEdge inputEdge) {
        return OutConfig.of(inputEdge.getTargets(), inputEdge.getFormat(), inputEdge.getCropRect(), TransformUtils.getRotatedSize(inputEdge.getCropRect(), inputEdge.getRotationDegrees()), inputEdge.getRotationDegrees(), inputEdge.isMirroring());
    }

    public static @NonNull OutConfig of(int targets, int format, @NonNull Rect cropRect, @NonNull Size size, int rotationDegrees, boolean mirroring) {
        return OutConfig.of(targets, format, cropRect, size, rotationDegrees, mirroring, false);
    }

    public static @NonNull OutConfig of(int targets, int format, @NonNull Rect cropRect, @NonNull Size size, int rotationDegrees, boolean mirroring, boolean shouldRespectInputCropRect) {
        return new AutoValue_OutConfig(UUID.randomUUID(), targets, format, cropRect, size, rotationDegrees, mirroring, shouldRespectInputCropRect);
    }
}

