/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.processing.concurrent;

import android.graphics.Matrix;
import android.graphics.Rect;
import android.util.Size;
import androidx.annotation.MainThread;
import androidx.camera.core.Logger;
import androidx.camera.core.ProcessingException;
import androidx.camera.core.SurfaceOutput;
import androidx.camera.core.SurfaceRequest;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.impl.StreamSpec;
import androidx.camera.core.impl.utils.Threads;
import androidx.camera.core.impl.utils.TransformUtils;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.FutureCallback;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.camera.core.processing.Node;
import androidx.camera.core.processing.SurfaceEdge;
import androidx.camera.core.processing.SurfaceProcessorInternal;
import androidx.camera.core.processing.TargetUtils;
import androidx.camera.core.processing.concurrent.AutoValue_DualSurfaceProcessorNode_In;
import androidx.camera.core.processing.concurrent.DualOutConfig;
import androidx.camera.core.processing.util.OutConfig;
import androidx.core.util.Preconditions;
import com.google.auto.value.AutoValue;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class DualSurfaceProcessorNode
implements Node<In, Out> {
    private static final String TAG = "DualSurfaceProcessorNode";
    final @NonNull SurfaceProcessorInternal mSurfaceProcessor;
    final @NonNull CameraInternal mPrimaryCameraInternal;
    final @NonNull CameraInternal mSecondaryCameraInternal;
    private @Nullable Out mOutput;
    private @Nullable In mInput;

    public DualSurfaceProcessorNode(@NonNull CameraInternal primaryCameraInternal, @NonNull CameraInternal secondaryCameraInternal, @NonNull SurfaceProcessorInternal surfaceProcessor) {
        this.mPrimaryCameraInternal = primaryCameraInternal;
        this.mSecondaryCameraInternal = secondaryCameraInternal;
        this.mSurfaceProcessor = surfaceProcessor;
    }

    @Override
    @MainThread
    public @NonNull Out transform(@NonNull In in) {
        Threads.checkMainThread();
        this.mInput = in;
        this.mOutput = new Out();
        SurfaceEdge primaryInputSurfaceEdge = this.mInput.getPrimarySurfaceEdge();
        SurfaceEdge secondaryInputSurfaceEdge = this.mInput.getSecondarySurfaceEdge();
        for (DualOutConfig config : this.mInput.getOutConfigs()) {
            this.mOutput.put(config, this.transformSingleOutput(primaryInputSurfaceEdge, config.getPrimaryOutConfig()));
        }
        this.sendSurfaceRequest(this.mPrimaryCameraInternal, primaryInputSurfaceEdge, this.mOutput, true);
        this.sendSurfaceRequest(this.mSecondaryCameraInternal, secondaryInputSurfaceEdge, this.mOutput, false);
        this.sendSurfaceOutputs(this.mPrimaryCameraInternal, this.mSecondaryCameraInternal, primaryInputSurfaceEdge, secondaryInputSurfaceEdge, this.mOutput);
        return this.mOutput;
    }

    private @NonNull SurfaceEdge transformSingleOutput(@NonNull SurfaceEdge input, @NonNull OutConfig outConfig) {
        Rect cropRect = outConfig.getCropRect();
        int rotationDegrees = outConfig.getRotationDegrees();
        boolean mirroring = outConfig.isMirroring();
        Matrix sensorToBufferTransform = new Matrix();
        Size rotatedCropSize = TransformUtils.getRotatedSize(cropRect, rotationDegrees);
        Preconditions.checkArgument((boolean)TransformUtils.isAspectRatioMatchingWithRoundingError(rotatedCropSize, outConfig.getSize()));
        Rect newCropRect = TransformUtils.sizeToRect(outConfig.getSize());
        StreamSpec streamSpec = input.getStreamSpec().toBuilder().setResolution(outConfig.getSize()).build();
        SurfaceEdge outputSurface = new SurfaceEdge(outConfig.getTargets(), outConfig.getFormat(), streamSpec, sensorToBufferTransform, false, newCropRect, input.getRotationDegrees() - rotationDegrees, -1, input.isMirroring() != mirroring);
        return outputSurface;
    }

    private void sendSurfaceRequest(@NonNull CameraInternal cameraInternal, @NonNull SurfaceEdge input, @NonNull Map<DualOutConfig, SurfaceEdge> outputs, boolean isPrimary) {
        SurfaceRequest surfaceRequest = input.createSurfaceRequest(cameraInternal, isPrimary);
        try {
            this.mSurfaceProcessor.onInputSurface(surfaceRequest);
        }
        catch (ProcessingException e) {
            Logger.e(TAG, "Failed to send SurfaceRequest to SurfaceProcessor.", e);
        }
    }

    private void sendSurfaceOutputs(@NonNull CameraInternal primaryCameraInternal, @NonNull CameraInternal secondaryCameraInternal, @NonNull SurfaceEdge primarySurfaceEdge, @NonNull SurfaceEdge secondarySurfaceEdge, @NonNull Map<DualOutConfig, SurfaceEdge> outputs) {
        for (Map.Entry<DualOutConfig, SurfaceEdge> output : outputs.entrySet()) {
            this.createAndSendSurfaceOutput(primaryCameraInternal, secondaryCameraInternal, primarySurfaceEdge, secondarySurfaceEdge, output);
            output.getValue().addOnInvalidatedListener(() -> this.createAndSendSurfaceOutput(primaryCameraInternal, secondaryCameraInternal, primarySurfaceEdge, secondarySurfaceEdge, output));
        }
    }

    private void createAndSendSurfaceOutput(@NonNull CameraInternal primaryCameraInternal, @NonNull CameraInternal secondaryCameraInternal, @NonNull SurfaceEdge primarySurfaceEdge, @NonNull SurfaceEdge secondarySurfaceEdge, Map.Entry<DualOutConfig, SurfaceEdge> output) {
        final SurfaceEdge outputEdge = output.getValue();
        SurfaceOutput.CameraInputInfo primaryCameraInputInfo = SurfaceOutput.CameraInputInfo.of(primarySurfaceEdge.getStreamSpec().getResolution(), output.getKey().getPrimaryOutConfig().getCropRect(), primarySurfaceEdge.hasCameraTransform() ? primaryCameraInternal : null, output.getKey().getPrimaryOutConfig().getRotationDegrees(), output.getKey().getPrimaryOutConfig().isMirroring());
        SurfaceOutput.CameraInputInfo secondaryCameraInputInfo = SurfaceOutput.CameraInputInfo.of(secondarySurfaceEdge.getStreamSpec().getResolution(), output.getKey().getSecondaryOutConfig().getCropRect(), secondarySurfaceEdge.hasCameraTransform() ? secondaryCameraInternal : null, output.getKey().getSecondaryOutConfig().getRotationDegrees(), output.getKey().getSecondaryOutConfig().isMirroring());
        ListenableFuture<SurfaceOutput> future = outputEdge.createSurfaceOutputFuture(output.getKey().getPrimaryOutConfig().getFormat(), primaryCameraInputInfo, secondaryCameraInputInfo);
        Futures.addCallback(future, new FutureCallback<SurfaceOutput>(){

            @Override
            public void onSuccess(@Nullable SurfaceOutput output) {
                Preconditions.checkNotNull((Object)output);
                try {
                    DualSurfaceProcessorNode.this.mSurfaceProcessor.onOutputSurface(output);
                }
                catch (ProcessingException e) {
                    Logger.e(DualSurfaceProcessorNode.TAG, "Failed to send SurfaceOutput to SurfaceProcessor.", e);
                }
            }

            @Override
            public void onFailure(@NonNull Throwable t) {
                if (outputEdge.getTargets() == 2 && t instanceof CancellationException) {
                    Logger.d(DualSurfaceProcessorNode.TAG, "Downstream VideoCapture failed to provide Surface.");
                } else {
                    Logger.w(DualSurfaceProcessorNode.TAG, "Downstream node failed to provide Surface. Target: " + TargetUtils.getHumanReadableName(outputEdge.getTargets()), t);
                }
            }
        }, CameraXExecutors.mainThreadExecutor());
    }

    @Override
    public void release() {
        this.mSurfaceProcessor.release();
        Threads.runOnMain(() -> {
            if (this.mOutput != null) {
                for (SurfaceEdge surface : this.mOutput.values()) {
                    surface.close();
                }
            }
        });
    }

    @AutoValue
    public static abstract class In {
        public abstract @NonNull SurfaceEdge getPrimarySurfaceEdge();

        public abstract @NonNull SurfaceEdge getSecondarySurfaceEdge();

        public abstract @NonNull List<DualOutConfig> getOutConfigs();

        public static @NonNull In of(@NonNull SurfaceEdge primaryEdge, @NonNull SurfaceEdge secondaryEdge, @NonNull List<DualOutConfig> configs) {
            return new AutoValue_DualSurfaceProcessorNode_In(primaryEdge, secondaryEdge, configs);
        }
    }

    public static class Out
    extends HashMap<DualOutConfig, SurfaceEdge> {
    }
}

