/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.processing;

import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.util.Size;
import androidx.annotation.MainThread;
import androidx.camera.core.Logger;
import androidx.camera.core.ProcessingException;
import androidx.camera.core.SurfaceOutput;
import androidx.camera.core.SurfaceRequest;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.impl.StreamSpec;
import androidx.camera.core.impl.utils.Threads;
import androidx.camera.core.impl.utils.TransformUtils;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.FutureCallback;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.camera.core.processing.AutoValue_SurfaceProcessorNode_In;
import androidx.camera.core.processing.Node;
import androidx.camera.core.processing.SurfaceEdge;
import androidx.camera.core.processing.SurfaceProcessorInternal;
import androidx.camera.core.processing.TargetUtils;
import androidx.camera.core.processing.util.OutConfig;
import androidx.core.util.Consumer;
import androidx.core.util.Preconditions;
import com.google.auto.value.AutoValue;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class SurfaceProcessorNode
implements Node<In, Out> {
    private static final String TAG = "SurfaceProcessorNode";
    final @NonNull SurfaceProcessorInternal mSurfaceProcessor;
    final @NonNull CameraInternal mCameraInternal;
    private @Nullable Out mOutput;
    private @Nullable In mInput;

    public SurfaceProcessorNode(@NonNull CameraInternal cameraInternal, @NonNull SurfaceProcessorInternal surfaceProcessor) {
        this.mCameraInternal = cameraInternal;
        this.mSurfaceProcessor = surfaceProcessor;
    }

    @Override
    @MainThread
    public @NonNull Out transform(@NonNull In input) {
        Threads.checkMainThread();
        this.mInput = input;
        this.mOutput = new Out();
        SurfaceEdge inputSurface = input.getSurfaceEdge();
        for (OutConfig config : input.getOutConfigs()) {
            this.mOutput.put(config, this.transformSingleOutput(inputSurface, config));
        }
        this.sendSurfaceRequest(inputSurface);
        this.sendSurfaceOutputs(inputSurface, this.mOutput);
        this.setUpRotationUpdates(inputSurface, this.mOutput);
        return this.mOutput;
    }

    private @NonNull SurfaceEdge transformSingleOutput(@NonNull SurfaceEdge input, @NonNull OutConfig outConfig) {
        Rect newCropRect;
        Rect cropRect = outConfig.getCropRect();
        int rotationDegrees = outConfig.getRotationDegrees();
        boolean mirroring = outConfig.isMirroring();
        Matrix sensorToBufferTransform = new Matrix(input.getSensorToBufferTransform());
        Matrix newTransform = TransformUtils.getRectToRect(new RectF(cropRect), TransformUtils.sizeToRectF(outConfig.getSize()), rotationDegrees, mirroring);
        sensorToBufferTransform.postConcat(newTransform);
        Size rotatedCropSize = TransformUtils.getRotatedSize(cropRect, rotationDegrees);
        Preconditions.checkArgument((boolean)TransformUtils.isAspectRatioMatchingWithRoundingError(rotatedCropSize, outConfig.getSize()));
        if (outConfig.shouldRespectInputCropRect()) {
            Preconditions.checkArgument((boolean)outConfig.getCropRect().contains(input.getCropRect()), (Object)String.format("Output crop rect %s must contain input crop rect %s", outConfig.getCropRect(), input.getCropRect()));
            newCropRect = new Rect();
            RectF newCropRectF = new RectF(input.getCropRect());
            newTransform.mapRect(newCropRectF);
            newCropRectF.round(newCropRect);
        } else {
            newCropRect = TransformUtils.sizeToRect(outConfig.getSize());
        }
        StreamSpec streamSpec = input.getStreamSpec().toBuilder().setResolution(outConfig.getSize()).build();
        SurfaceEdge outputSurface = new SurfaceEdge(outConfig.getTargets(), outConfig.getFormat(), streamSpec, sensorToBufferTransform, false, newCropRect, input.getRotationDegrees() - rotationDegrees, -1, input.isMirroring() != mirroring);
        return outputSurface;
    }

    private void sendSurfaceRequest(@NonNull SurfaceEdge input) {
        try {
            this.mSurfaceProcessor.onInputSurface(input.createSurfaceRequest(this.mCameraInternal));
        }
        catch (ProcessingException e) {
            Logger.e(TAG, "Failed to send SurfaceRequest to SurfaceProcessor.", e);
        }
    }

    private void sendSurfaceOutputs(@NonNull SurfaceEdge input, @NonNull Map<OutConfig, SurfaceEdge> outputs) {
        for (Map.Entry<OutConfig, SurfaceEdge> output : outputs.entrySet()) {
            this.createAndSendSurfaceOutput(input, output);
            output.getValue().addOnInvalidatedListener(() -> this.createAndSendSurfaceOutput(input, output));
        }
    }

    private void createAndSendSurfaceOutput(@NonNull SurfaceEdge input, Map.Entry<OutConfig, SurfaceEdge> output) {
        final SurfaceEdge outputEdge = output.getValue();
        SurfaceOutput.CameraInputInfo cameraInputInfo = SurfaceOutput.CameraInputInfo.of(input.getStreamSpec().getResolution(), output.getKey().getCropRect(), input.hasCameraTransform() ? this.mCameraInternal : null, output.getKey().getRotationDegrees(), output.getKey().isMirroring());
        ListenableFuture<SurfaceOutput> future = outputEdge.createSurfaceOutputFuture(output.getKey().getFormat(), cameraInputInfo, null);
        Futures.addCallback(future, new FutureCallback<SurfaceOutput>(){

            @Override
            public void onSuccess(@Nullable SurfaceOutput output) {
                Preconditions.checkNotNull((Object)output);
                try {
                    SurfaceProcessorNode.this.mSurfaceProcessor.onOutputSurface(output);
                }
                catch (ProcessingException e) {
                    Logger.e(SurfaceProcessorNode.TAG, "Failed to send SurfaceOutput to SurfaceProcessor.", e);
                }
            }

            @Override
            public void onFailure(@NonNull Throwable t) {
                if (outputEdge.getTargets() == 2 && t instanceof CancellationException) {
                    Logger.d(SurfaceProcessorNode.TAG, "Downstream VideoCapture failed to provide Surface.");
                } else {
                    Logger.w(SurfaceProcessorNode.TAG, "Downstream node failed to provide Surface. Target: " + TargetUtils.getHumanReadableName(outputEdge.getTargets()), t);
                }
            }
        }, CameraXExecutors.mainThreadExecutor());
    }

    void setUpRotationUpdates(@NonNull SurfaceEdge inputEdge, @NonNull Map<OutConfig, SurfaceEdge> outputs) {
        inputEdge.addTransformationUpdateListener((Consumer<SurfaceRequest.TransformationInfo>)((Consumer)info -> {
            for (Map.Entry output : outputs.entrySet()) {
                int rotationDegrees = info.getRotationDegrees() - ((OutConfig)output.getKey()).getRotationDegrees();
                if (((OutConfig)output.getKey()).isMirroring()) {
                    rotationDegrees = -rotationDegrees;
                }
                rotationDegrees = TransformUtils.within360(rotationDegrees);
                ((SurfaceEdge)output.getValue()).updateTransformation(rotationDegrees, -1);
            }
        }));
    }

    @Override
    public void release() {
        this.mSurfaceProcessor.release();
        Threads.runOnMain(() -> {
            if (this.mOutput != null) {
                for (SurfaceEdge surface : this.mOutput.values()) {
                    surface.close();
                }
            }
        });
    }

    public @NonNull SurfaceProcessorInternal getSurfaceProcessor() {
        return this.mSurfaceProcessor;
    }

    @AutoValue
    public static abstract class In {
        public abstract @NonNull SurfaceEdge getSurfaceEdge();

        public abstract @NonNull List<OutConfig> getOutConfigs();

        public static @NonNull In of(@NonNull SurfaceEdge edge, @NonNull List<OutConfig> configs) {
            return new AutoValue_SurfaceProcessorNode_In(edge, configs);
        }
    }

    public static class Out
    extends HashMap<OutConfig, SurfaceEdge> {
    }
}

