/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.processing;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.util.Size;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.impl.CameraCaptureResult;
import androidx.camera.core.impl.utils.Exif;
import androidx.camera.core.impl.utils.TransformUtils;
import androidx.camera.core.internal.utils.ImageUtil;
import androidx.camera.core.processing.AutoValue_Packet;
import androidx.core.util.Preconditions;
import com.google.auto.value.AutoValue;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@AutoValue
public abstract class Packet<T> {
    public abstract @NonNull T getData();

    public abstract @Nullable Exif getExif();

    public abstract int getFormat();

    public abstract @NonNull Size getSize();

    public abstract @NonNull Rect getCropRect();

    public abstract int getRotationDegrees();

    public abstract @NonNull Matrix getSensorToBufferTransform();

    public abstract @NonNull CameraCaptureResult getCameraCaptureResult();

    public boolean hasCropping() {
        return TransformUtils.hasCropping(this.getCropRect(), this.getSize());
    }

    public static @NonNull Packet<Bitmap> of(@NonNull Bitmap data, @NonNull Exif exif, @NonNull Rect cropRect, int rotationDegrees, @NonNull Matrix sensorToBufferTransform, @NonNull CameraCaptureResult cameraCaptureResult) {
        return new AutoValue_Packet<Bitmap>(data, exif, 42, new Size(data.getWidth(), data.getHeight()), cropRect, rotationDegrees, sensorToBufferTransform, cameraCaptureResult);
    }

    public static @NonNull Packet<ImageProxy> of(@NonNull ImageProxy data, @Nullable Exif exif, @NonNull Rect cropRect, int rotationDegrees, @NonNull Matrix sensorToBufferTransform, @NonNull CameraCaptureResult cameraCaptureResult) {
        return Packet.of(data, exif, new Size(data.getWidth(), data.getHeight()), cropRect, rotationDegrees, sensorToBufferTransform, cameraCaptureResult);
    }

    public static @NonNull Packet<ImageProxy> of(@NonNull ImageProxy data, @Nullable Exif exif, @NonNull Size size, @NonNull Rect cropRect, int rotationDegrees, @NonNull Matrix sensorToBufferTransform, @NonNull CameraCaptureResult cameraCaptureResult) {
        if (ImageUtil.isJpegFormats(data.getFormat())) {
            Preconditions.checkNotNull((Object)exif, (Object)"JPEG image must have Exif.");
        }
        return new AutoValue_Packet<ImageProxy>(data, exif, data.getFormat(), size, cropRect, rotationDegrees, sensorToBufferTransform, cameraCaptureResult);
    }

    public static @NonNull Packet<byte[]> of(byte @NonNull [] data, @NonNull Exif exif, int format, @NonNull Size size, @NonNull Rect cropRect, int rotationDegrees, @NonNull Matrix sensorToBufferTransform, @NonNull CameraCaptureResult cameraCaptureResult) {
        return new AutoValue_Packet<byte[]>(data, exif, format, size, cropRect, rotationDegrees, sensorToBufferTransform, cameraCaptureResult);
    }
}

