/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.internal.utils;

import androidx.camera.core.ImageInfo;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.impl.CameraCaptureMetaData;
import androidx.camera.core.impl.CameraCaptureResult;
import androidx.camera.core.impl.CameraCaptureResults;
import androidx.camera.core.internal.utils.ArrayRingBuffer;
import androidx.camera.core.internal.utils.RingBuffer;
import org.jspecify.annotations.NonNull;

public final class ZslRingBuffer
extends ArrayRingBuffer<ImageProxy> {
    public ZslRingBuffer(int ringBufferCapacity, @NonNull RingBuffer.OnRemoveCallback<ImageProxy> onRemoveCallback) {
        super(ringBufferCapacity, onRemoveCallback);
    }

    @Override
    public void enqueue(@NonNull ImageProxy imageProxy) {
        if (this.isValidZslFrame(imageProxy.getImageInfo())) {
            super.enqueue(imageProxy);
        } else {
            this.mOnRemoveCallback.onRemove(imageProxy);
        }
    }

    private boolean isValidZslFrame(@NonNull ImageInfo imageInfo) {
        CameraCaptureResult cameraCaptureResult = CameraCaptureResults.retrieveCameraCaptureResult(imageInfo);
        if (cameraCaptureResult == null) {
            return false;
        }
        if (cameraCaptureResult.getAfState() != CameraCaptureMetaData.AfState.LOCKED_FOCUSED && cameraCaptureResult.getAfState() != CameraCaptureMetaData.AfState.PASSIVE_FOCUSED) {
            return false;
        }
        if (cameraCaptureResult.getAeState() != CameraCaptureMetaData.AeState.CONVERGED) {
            return false;
        }
        return cameraCaptureResult.getAwbState() == CameraCaptureMetaData.AwbState.CONVERGED;
    }
}

