/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.internal.compat.workaround;

import android.media.MediaCodec;
import androidx.camera.core.Preview;
import androidx.camera.core.impl.DeferrableSurface;
import androidx.camera.core.impl.SessionConfig;
import androidx.camera.core.internal.compat.quirk.DeviceQuirks;
import androidx.camera.core.internal.compat.quirk.SurfaceOrderQuirk;
import androidx.camera.core.streamsharing.StreamSharing;
import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.NonNull;

public class SurfaceSorter {
    private static final int PRIORITY_PREVIEW_SURFACE = 0;
    private static final int PRIORITY_OTHERS = 1;
    private static final int PRIORITY_MEDIA_CODEC_SURFACE = 2;
    private final boolean mHasQuirk = DeviceQuirks.get(SurfaceOrderQuirk.class) != null;

    public void sort(@NonNull List<SessionConfig.OutputConfig> outputConfigs) {
        if (!this.mHasQuirk) {
            return;
        }
        Collections.sort(outputConfigs, (outputConfig1, outputConfig2) -> {
            int p1 = this.getSurfacePriority(outputConfig1.getSurface());
            int p2 = this.getSurfacePriority(outputConfig2.getSurface());
            return p1 - p2;
        });
    }

    private int getSurfacePriority(@NonNull DeferrableSurface surface) {
        if (surface.getContainerClass() == MediaCodec.class) {
            return 2;
        }
        if (surface.getContainerClass() == Preview.class || surface.getContainerClass() == StreamSharing.class) {
            return 0;
        }
        return 1;
    }
}

