/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.internal.compat.workaround;

import androidx.camera.core.ImageProxy;
import androidx.camera.core.impl.Quirks;
import androidx.camera.core.internal.compat.quirk.IncorrectJpegMetadataQuirk;
import java.nio.ByteBuffer;
import org.jspecify.annotations.NonNull;

public class JpegMetadataCorrector {
    private final IncorrectJpegMetadataQuirk mQuirk;

    public JpegMetadataCorrector(@NonNull Quirks quirks) {
        this.mQuirk = quirks.get(IncorrectJpegMetadataQuirk.class);
    }

    public boolean needCorrectJpegMetadata() {
        return this.mQuirk != null;
    }

    public byte @NonNull [] jpegImageToJpegByteArray(@NonNull ImageProxy image) {
        if (this.mQuirk == null) {
            ImageProxy.PlaneProxy[] planes = image.getPlanes();
            ByteBuffer buffer = planes[0].getBuffer();
            byte[] data = new byte[buffer.capacity()];
            buffer.rewind();
            buffer.get(data);
            return data;
        }
        return this.mQuirk.jpegImageToJpegByteArray(image);
    }
}

