/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.internal.compat.workaround;

import androidx.annotation.VisibleForTesting;
import androidx.camera.core.internal.compat.quirk.DeviceQuirks;
import androidx.camera.core.internal.compat.quirk.LargeJpegImageQuirk;
import org.jspecify.annotations.NonNull;

public class InvalidJpegDataParser {
    private final LargeJpegImageQuirk mQuirk = DeviceQuirks.get(LargeJpegImageQuirk.class);

    public int getValidDataLength(byte @NonNull [] bytes) {
        if (this.mQuirk == null || !this.mQuirk.shouldCheckInvalidJpegData(bytes)) {
            return bytes.length;
        }
        int jfifEoiMarkEndPosition = InvalidJpegDataParser.getJfifEoiMarkEndPosition(bytes);
        return jfifEoiMarkEndPosition != -1 ? jfifEoiMarkEndPosition : bytes.length;
    }

    @VisibleForTesting
    public static int getJfifEoiMarkEndPosition(byte @NonNull [] bytes) {
        int markPosition = 2;
        while (true) {
            if (markPosition + 4 > bytes.length || bytes[markPosition] != -1) {
                return -1;
            }
            int segmentLength = (bytes[markPosition + 2] & 0xFF) << 8 | bytes[markPosition + 3] & 0xFF;
            if (bytes[markPosition] == -1 && bytes[markPosition + 1] == -38) break;
            markPosition += segmentLength + 2;
        }
        int eoiPosition = markPosition + 2;
        while (true) {
            if (eoiPosition + 2 > bytes.length) {
                return -1;
            }
            if (bytes[eoiPosition] == -1 && bytes[eoiPosition + 1] == -39) break;
            ++eoiPosition;
        }
        return eoiPosition + 2;
    }
}

