/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.internal.compat.quirk;

import android.os.Build;
import androidx.camera.core.impl.CaptureConfig;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.Quirk;
import org.jspecify.annotations.NonNull;

public final class ImageCaptureRotationOptionQuirk
implements Quirk {
    static boolean load() {
        return ImageCaptureRotationOptionQuirk.isHuaweiMate20Lite() || ImageCaptureRotationOptionQuirk.isHonor9X() || ImageCaptureRotationOptionQuirk.isEmulatorAndApi21();
    }

    private static boolean isHuaweiMate20Lite() {
        return "HUAWEI".equalsIgnoreCase(Build.BRAND) && "SNE-LX1".equalsIgnoreCase(Build.MODEL);
    }

    private static boolean isHonor9X() {
        return "HONOR".equalsIgnoreCase(Build.BRAND) && "STK-LX1".equalsIgnoreCase(Build.MODEL);
    }

    private static boolean isEmulatorAndApi21() {
        return ImageCaptureRotationOptionQuirk.isEmulator() && Build.VERSION.SDK_INT == 21;
    }

    private static boolean isEmulator() {
        return Build.FINGERPRINT.startsWith("generic") || Build.FINGERPRINT.startsWith("unknown") || Build.MODEL.contains("google_sdk") || Build.MODEL.contains("Emulator") || Build.MODEL.contains("Cuttlefish") || Build.MODEL.contains("Android SDK built for x86") || Build.MANUFACTURER.contains("Genymotion") || Build.BRAND.startsWith("generic") && Build.DEVICE.startsWith("generic") || Build.PRODUCT.equals("google_sdk") || Build.HARDWARE.contains("ranchu");
    }

    public boolean isSupported(@NonNull Config.Option<?> option) {
        return option != CaptureConfig.OPTION_ROTATION;
    }
}

