/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.internal.compat.quirk;

import androidx.camera.core.Logger;
import androidx.camera.core.impl.Quirk;
import androidx.camera.core.impl.QuirkSettings;
import androidx.camera.core.impl.QuirkSettingsHolder;
import androidx.camera.core.impl.Quirks;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.internal.compat.quirk.DeviceQuirksLoader;
import androidx.core.util.Consumer;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class DeviceQuirks {
    private static final String TAG = "DeviceQuirks";
    private static volatile @NonNull Quirks sQuirks;

    private DeviceQuirks() {
    }

    public static @NonNull Quirks getAll() {
        return sQuirks;
    }

    public static <T extends Quirk> @Nullable T get(@NonNull Class<T> quirkClass) {
        return sQuirks.get(quirkClass);
    }

    static {
        QuirkSettingsHolder.instance().observe(CameraXExecutors.directExecutor(), (Consumer<QuirkSettings>)((Consumer)quirkSettings -> {
            sQuirks = new Quirks(DeviceQuirksLoader.loadQuirks(quirkSettings));
            Logger.d(TAG, "core DeviceQuirks = " + Quirks.toString(sQuirks));
        }));
    }
}

