/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.internal.compat;

import android.media.Image;
import android.media.ImageWriter;
import android.view.Surface;
import androidx.annotation.IntRange;
import androidx.annotation.RequiresApi;
import androidx.camera.core.impl.utils.MainThreadAsyncHandler;
import java.util.concurrent.Executor;
import org.jspecify.annotations.NonNull;

@RequiresApi(value=23)
final class ImageWriterCompatApi23Impl {
    static @NonNull ImageWriter newInstance(@NonNull Surface surface, @IntRange(from=1L) int maxImages) {
        return ImageWriter.newInstance((Surface)surface, (int)maxImages);
    }

    static @NonNull Image dequeueInputImage(@NonNull ImageWriter imageWriter) {
        return imageWriter.dequeueInputImage();
    }

    static void queueInputImage(@NonNull ImageWriter imageWriter, @NonNull Image image) {
        imageWriter.queueInputImage(image);
    }

    static void close(ImageWriter imageWriter) {
        imageWriter.close();
    }

    static void setOnImageReleasedListener(@NonNull ImageWriter imageWriter, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull ImageWriter.OnImageReleasedListener releasedListener, @NonNull Executor executor) {
        imageWriter.setOnImageReleasedListener(writer -> executor.execute(() -> releasedListener.onImageReleased(writer)), MainThreadAsyncHandler.getInstance());
    }

    private ImageWriterCompatApi23Impl() {
    }
}

