/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.internal;

import android.annotation.SuppressLint;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.util.Rational;
import androidx.annotation.IntRange;
import androidx.camera.core.UseCase;
import androidx.camera.core.impl.StreamSpec;
import androidx.camera.core.internal.utils.ImageUtil;
import androidx.core.util.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.jspecify.annotations.NonNull;

public class ViewPorts {
    private ViewPorts() {
    }

    public static @NonNull Map<UseCase, Rect> calculateViewPortRects(@NonNull Rect fullSensorRect, boolean isFrontCamera, @NonNull Rational viewPortAspectRatio, @IntRange(from=0L, to=359L) int outputRotationDegrees, int scaleType, int layoutDirection, @NonNull Map<UseCase, StreamSpec> useCaseStreamSpecs) {
        Preconditions.checkArgument((fullSensorRect.width() > 0 && fullSensorRect.height() > 0 ? 1 : 0) != 0, (Object)"Cannot compute viewport crop rects zero sized sensor rect.");
        RectF fullSensorRectF = new RectF(fullSensorRect);
        HashMap<UseCase, Matrix> useCaseToSensorTransformations = new HashMap<UseCase, Matrix>();
        RectF sensorIntersectionRect = new RectF(fullSensorRect);
        for (Map.Entry<UseCase, StreamSpec> entry : useCaseStreamSpecs.entrySet()) {
            Matrix useCaseToSensorTransformation = new Matrix();
            RectF srcRect = new RectF(0.0f, 0.0f, (float)entry.getValue().getResolution().getWidth(), (float)entry.getValue().getResolution().getHeight());
            useCaseToSensorTransformation.setRectToRect(srcRect, fullSensorRectF, Matrix.ScaleToFit.CENTER);
            useCaseToSensorTransformations.put(entry.getKey(), useCaseToSensorTransformation);
            RectF useCaseSensorRect = new RectF();
            useCaseToSensorTransformation.mapRect(useCaseSensorRect, srcRect);
            sensorIntersectionRect.intersect(useCaseSensorRect);
        }
        Rational rotatedViewPortAspectRatio = ImageUtil.getRotatedAspectRatio(outputRotationDegrees, viewPortAspectRatio);
        RectF viewPortRect = ViewPorts.getScaledRect(sensorIntersectionRect, rotatedViewPortAspectRatio, scaleType, isFrontCamera, layoutDirection, outputRotationDegrees);
        HashMap<UseCase, Rect> useCaseOutputRects = new HashMap<UseCase, Rect>();
        RectF useCaseOutputRect = new RectF();
        Matrix sensorToUseCaseTransformation = new Matrix();
        for (Map.Entry entry : useCaseToSensorTransformations.entrySet()) {
            ((Matrix)entry.getValue()).invert(sensorToUseCaseTransformation);
            sensorToUseCaseTransformation.mapRect(useCaseOutputRect, viewPortRect);
            Rect outputCropRect = new Rect();
            useCaseOutputRect.round(outputCropRect);
            useCaseOutputRects.put((UseCase)entry.getKey(), outputCropRect);
        }
        return useCaseOutputRects;
    }

    @SuppressLint(value={"SwitchIntDef"})
    public static @NonNull RectF getScaledRect(@NonNull RectF fittingRect, @NonNull Rational containerAspectRatio, int scaleType, boolean isFrontCamera, int layoutDirection, @IntRange(from=0L, to=359L) int rotationDegrees) {
        if (scaleType == 3) {
            return fittingRect;
        }
        Matrix viewPortToSurfaceTransformation = new Matrix();
        RectF viewPortRect = new RectF(0.0f, 0.0f, (float)containerAspectRatio.getNumerator(), (float)containerAspectRatio.getDenominator());
        switch (scaleType) {
            case 1: {
                viewPortToSurfaceTransformation.setRectToRect(viewPortRect, fittingRect, Matrix.ScaleToFit.CENTER);
                break;
            }
            case 0: {
                viewPortToSurfaceTransformation.setRectToRect(viewPortRect, fittingRect, Matrix.ScaleToFit.START);
                break;
            }
            case 2: {
                viewPortToSurfaceTransformation.setRectToRect(viewPortRect, fittingRect, Matrix.ScaleToFit.END);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected scale type: " + scaleType);
            }
        }
        RectF viewPortRectInSurfaceCoordinates = new RectF();
        viewPortToSurfaceTransformation.mapRect(viewPortRectInSurfaceCoordinates, viewPortRect);
        return ViewPorts.correctStartOrEnd(ViewPorts.shouldMirrorStartAndEnd(isFrontCamera, layoutDirection), rotationDegrees, fittingRect, viewPortRectInSurfaceCoordinates);
    }

    private static RectF correctStartOrEnd(boolean isMirrored, @IntRange(from=0L, to=359L) int rotationDegrees, RectF containerRect, RectF cropRect) {
        boolean rtlRotation270;
        boolean rtlRotation180;
        boolean ltrRotation270;
        boolean rtlRotation90;
        boolean ltrRotation0 = rotationDegrees == 0 && !isMirrored;
        boolean bl = rtlRotation90 = rotationDegrees == 90 && isMirrored;
        if (ltrRotation0 || rtlRotation90) {
            return cropRect;
        }
        boolean rtlRotation0 = rotationDegrees == 0 && isMirrored;
        boolean bl2 = ltrRotation270 = rotationDegrees == 270 && !isMirrored;
        if (rtlRotation0 || ltrRotation270) {
            return ViewPorts.flipHorizontally(cropRect, containerRect.centerX());
        }
        boolean ltrRotation90 = rotationDegrees == 90 && !isMirrored;
        boolean bl3 = rtlRotation180 = rotationDegrees == 180 && isMirrored;
        if (ltrRotation90 || rtlRotation180) {
            return ViewPorts.flipVertically(cropRect, containerRect.centerY());
        }
        boolean ltrRotation180 = rotationDegrees == 180 && !isMirrored;
        boolean bl4 = rtlRotation270 = rotationDegrees == 270 && isMirrored;
        if (ltrRotation180 || rtlRotation270) {
            return ViewPorts.flipHorizontally(ViewPorts.flipVertically(cropRect, containerRect.centerY()), containerRect.centerX());
        }
        throw new IllegalArgumentException("Invalid argument: mirrored " + isMirrored + " rotation " + rotationDegrees);
    }

    private static boolean shouldMirrorStartAndEnd(boolean isFrontCamera, int layoutDirection) {
        return isFrontCamera ^ layoutDirection == 1;
    }

    private static RectF flipHorizontally(RectF original, float flipLineX) {
        return new RectF(ViewPorts.flipX(original.right, flipLineX), original.top, ViewPorts.flipX(original.left, flipLineX), original.bottom);
    }

    private static RectF flipVertically(RectF original, float flipLineY) {
        return new RectF(original.left, ViewPorts.flipY(original.bottom, flipLineY), original.right, ViewPorts.flipY(original.top, flipLineY));
    }

    private static float flipX(float x, float flipLineX) {
        return flipLineX + flipLineX - x;
    }

    private static float flipY(float y, float flipLineY) {
        return flipLineY + flipLineY - y;
    }
}

