/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.internal;

import android.util.Rational;
import android.util.Size;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.core.impl.ImageOutputConfig;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.impl.utils.AspectRatioUtil;
import androidx.camera.core.impl.utils.CameraOrientationUtil;
import androidx.camera.core.impl.utils.CompareSizesByArea;
import androidx.camera.core.internal.SupportedOutputSizesSorter;
import androidx.camera.core.internal.utils.SizeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

class SupportedOutputSizesSorterLegacy {
    private static final String TAG = "SupportedOutputSizesCollector";
    private final int mSensorOrientation;
    private final int mLensFacing;
    private final Rational mFullFovRatio;
    private final boolean mIsSensorLandscapeResolution;

    SupportedOutputSizesSorterLegacy(@NonNull CameraInfoInternal cameraInfoInternal, @Nullable Rational fullFovRatio) {
        this.mSensorOrientation = cameraInfoInternal.getSensorRotationDegrees();
        this.mLensFacing = cameraInfoInternal.getLensFacing();
        this.mFullFovRatio = fullFovRatio;
        this.mIsSensorLandscapeResolution = this.mFullFovRatio != null ? this.mFullFovRatio.getNumerator() >= this.mFullFovRatio.getDenominator() : true;
    }

    @NonNull List<Size> sortSupportedOutputSizes(@NonNull List<Size> resolutionCandidateList, @NonNull UseCaseConfig<?> useCaseConfig) {
        if (resolutionCandidateList.isEmpty()) {
            return resolutionCandidateList;
        }
        ArrayList<Size> descendingSizeList = new ArrayList<Size>(resolutionCandidateList);
        Collections.sort(descendingSizeList, new CompareSizesByArea(true));
        ArrayList<Size> filteredSizeList = new ArrayList<Size>();
        ImageOutputConfig imageOutputConfig = (ImageOutputConfig)((Object)useCaseConfig);
        Size maxSize = imageOutputConfig.getMaxResolution(null);
        Size maxSupportedOutputSize = (Size)descendingSizeList.get(0);
        if (maxSize == null || SizeUtil.getArea(maxSupportedOutputSize) < SizeUtil.getArea(maxSize)) {
            maxSize = maxSupportedOutputSize;
        }
        Size targetSize = this.getTargetSize(imageOutputConfig);
        Size minSize = SizeUtil.RESOLUTION_VGA;
        int defaultSizeArea = SizeUtil.getArea(SizeUtil.RESOLUTION_VGA);
        int maxSizeArea = SizeUtil.getArea(maxSize);
        if (maxSizeArea < defaultSizeArea) {
            minSize = SizeUtil.RESOLUTION_ZERO;
        } else if (targetSize != null && SizeUtil.getArea(targetSize) < defaultSizeArea) {
            minSize = targetSize;
        }
        for (Size outputSize : descendingSizeList) {
            if (SizeUtil.getArea(outputSize) > SizeUtil.getArea(maxSize) || SizeUtil.getArea(outputSize) < SizeUtil.getArea(minSize) || filteredSizeList.contains(outputSize)) continue;
            filteredSizeList.add(outputSize);
        }
        if (filteredSizeList.isEmpty()) {
            throw new IllegalArgumentException("All supported output sizes are filtered out according to current resolution selection settings. \nminSize = " + minSize + "\nmaxSize = " + maxSize + "\ninitial size list: " + descendingSizeList);
        }
        Rational aspectRatio = this.getTargetAspectRatioByLegacyApi(imageOutputConfig, filteredSizeList);
        targetSize = targetSize == null ? imageOutputConfig.getDefaultResolution(null) : targetSize;
        ArrayList<Size> resultSizeList = new ArrayList<Size>();
        Map<Object, Object> aspectRatioSizeListMap = new HashMap();
        if (aspectRatio == null) {
            resultSizeList.addAll(filteredSizeList);
            if (targetSize != null) {
                SupportedOutputSizesSorter.sortSupportedSizesByFallbackRuleClosestHigherThenLower(resultSizeList, targetSize, true);
            }
        } else {
            aspectRatioSizeListMap = SupportedOutputSizesSorter.groupSizesByAspectRatio(filteredSizeList);
            if (targetSize != null) {
                for (Rational rational : aspectRatioSizeListMap.keySet()) {
                    SupportedOutputSizesSorter.sortSupportedSizesByFallbackRuleClosestHigherThenLower((List)aspectRatioSizeListMap.get(rational), targetSize, true);
                }
            }
            ArrayList<Object> aspectRatios = new ArrayList<Object>(aspectRatioSizeListMap.keySet());
            Collections.sort(aspectRatios, new AspectRatioUtil.CompareAspectRatiosByMappingAreaInFullFovAspectRatioSpace(aspectRatio, this.mFullFovRatio));
            for (Rational rational : aspectRatios) {
                for (Size size : (List)aspectRatioSizeListMap.get(rational)) {
                    if (resultSizeList.contains(size)) continue;
                    resultSizeList.add(size);
                }
            }
        }
        return resultSizeList;
    }

    private Rational getTargetAspectRatioByLegacyApi(@NonNull ImageOutputConfig imageOutputConfig, @NonNull List<Size> resolutionCandidateList) {
        Rational outputRatio = null;
        if (imageOutputConfig.hasTargetAspectRatio()) {
            int aspectRatio = imageOutputConfig.getTargetAspectRatio();
            outputRatio = SupportedOutputSizesSorter.getTargetAspectRatioRationalValue(aspectRatio, this.mIsSensorLandscapeResolution);
        } else {
            Size targetSize = this.getTargetSize(imageOutputConfig);
            if (targetSize != null) {
                outputRatio = SupportedOutputSizesSorterLegacy.getAspectRatioGroupKeyOfTargetSize(targetSize, resolutionCandidateList);
            }
        }
        return outputRatio;
    }

    private @Nullable Size getTargetSize(@NonNull ImageOutputConfig imageOutputConfig) {
        int targetRotation = imageOutputConfig.getTargetRotation(0);
        Size targetSize = imageOutputConfig.getTargetResolution(null);
        targetSize = SupportedOutputSizesSorterLegacy.flipSizeByRotation(targetSize, targetRotation, this.mLensFacing, this.mSensorOrientation);
        return targetSize;
    }

    private static @Nullable Rational getAspectRatioGroupKeyOfTargetSize(@Nullable Size targetSize, @NonNull List<Size> resolutionCandidateList) {
        if (targetSize == null) {
            return null;
        }
        List<Rational> aspectRatios = SupportedOutputSizesSorter.getResolutionListGroupingAspectRatioKeys(resolutionCandidateList);
        for (Rational aspectRatio : aspectRatios) {
            if (!AspectRatioUtil.hasMatchingAspectRatio(targetSize, aspectRatio)) continue;
            return aspectRatio;
        }
        return new Rational(targetSize.getWidth(), targetSize.getHeight());
    }

    private static @Nullable Size flipSizeByRotation(@Nullable Size size, int targetRotation, int lensFacing, int sensorOrientation) {
        Size outputSize = size;
        if (size != null && SupportedOutputSizesSorterLegacy.isRotationNeeded(targetRotation, lensFacing, sensorOrientation)) {
            outputSize = new Size(size.getHeight(), size.getWidth());
        }
        return outputSize;
    }

    private static boolean isRotationNeeded(int targetRotation, int lensFacing, int sensorOrientation) {
        int relativeRotationDegrees = CameraOrientationUtil.surfaceRotationToDegrees(targetRotation);
        boolean isOppositeFacingScreen = 1 == lensFacing;
        int sensorRotationDegrees = CameraOrientationUtil.getRelativeImageRotation(relativeRotationDegrees, sensorOrientation, isOppositeFacingScreen);
        return sensorRotationDegrees == 90 || sensorRotationDegrees == 270;
    }
}

