/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.internal;

import android.graphics.Rect;
import android.util.Pair;
import android.util.Range;
import android.util.Size;
import androidx.camera.core.Preview;
import androidx.camera.core.UseCase;
import androidx.camera.core.impl.AttachedSurfaceInfo;
import androidx.camera.core.impl.CameraConfig;
import androidx.camera.core.impl.CameraDeviceSurfaceManager;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.core.impl.StreamSpec;
import androidx.camera.core.impl.SurfaceConfig;
import androidx.camera.core.impl.SurfaceStreamSpecQueryResult;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.impl.UseCaseConfigFactory;
import androidx.camera.core.impl.utils.TransformUtils;
import androidx.camera.core.internal.CameraUseCaseAdapter;
import androidx.camera.core.internal.StreamSpecQueryResult;
import androidx.camera.core.internal.StreamSpecsCalculator;
import androidx.camera.core.internal.SupportedOutputSizesSorter;
import androidx.camera.core.streamsharing.StreamSharing;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016Jb\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\r2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0016JJ\u0010\u001c\u001a&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u001f0\u001e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00120\u001e0\u001d2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J^\u0010!\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00120\u001e2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020$0\u001e2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Landroidx/camera/core/internal/StreamSpecsCalculatorImpl;", "Landroidx/camera/core/internal/StreamSpecsCalculator;", "useCaseConfigFactory", "Landroidx/camera/core/impl/UseCaseConfigFactory;", "cameraDeviceSurfaceManager", "Landroidx/camera/core/impl/CameraDeviceSurfaceManager;", "<init>", "(Landroidx/camera/core/impl/UseCaseConfigFactory;Landroidx/camera/core/impl/CameraDeviceSurfaceManager;)V", "setCameraDeviceSurfaceManager", "", "calculateSuggestedStreamSpecs", "Landroidx/camera/core/internal/StreamSpecQueryResult;", "cameraMode", "", "cameraInfoInternal", "Landroidx/camera/core/impl/CameraInfoInternal;", "newUseCases", "", "Landroidx/camera/core/UseCase;", "attachedUseCases", "cameraConfig", "Landroidx/camera/core/impl/CameraConfig;", "sessionType", "targetFrameRate", "Landroid/util/Range;", "isFeatureComboInvocation", "", "findMaxSupportedFrameRate", "calculateSuggestedStreamSpecsForAttachedUseCases", "Landroid/util/Pair;", "", "Landroidx/camera/core/impl/StreamSpec;", "Landroidx/camera/core/impl/AttachedSurfaceInfo;", "calculateSuggestedStreamSpecsForNewUseCases", "attachedSurfaceInfoToUseCaseMap", "configPairMap", "Landroidx/camera/core/internal/CameraUseCaseAdapter$ConfigPair;", "camera-core_release"})
public final class StreamSpecsCalculatorImpl
implements StreamSpecsCalculator {
    @NotNull
    private final UseCaseConfigFactory useCaseConfigFactory;
    @Nullable
    private CameraDeviceSurfaceManager cameraDeviceSurfaceManager;

    public StreamSpecsCalculatorImpl(@NotNull UseCaseConfigFactory useCaseConfigFactory, @Nullable CameraDeviceSurfaceManager cameraDeviceSurfaceManager) {
        Intrinsics.checkNotNullParameter((Object)useCaseConfigFactory, (String)"useCaseConfigFactory");
        this.useCaseConfigFactory = useCaseConfigFactory;
        this.cameraDeviceSurfaceManager = cameraDeviceSurfaceManager;
    }

    public /* synthetic */ StreamSpecsCalculatorImpl(UseCaseConfigFactory useCaseConfigFactory, CameraDeviceSurfaceManager cameraDeviceSurfaceManager, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            cameraDeviceSurfaceManager = null;
        }
        this(useCaseConfigFactory, cameraDeviceSurfaceManager);
    }

    @Override
    public void setCameraDeviceSurfaceManager(@NotNull CameraDeviceSurfaceManager cameraDeviceSurfaceManager) {
        Intrinsics.checkNotNullParameter((Object)cameraDeviceSurfaceManager, (String)"cameraDeviceSurfaceManager");
        this.cameraDeviceSurfaceManager = cameraDeviceSurfaceManager;
    }

    @Override
    @NotNull
    public StreamSpecQueryResult calculateSuggestedStreamSpecs(int cameraMode, @NotNull CameraInfoInternal cameraInfoInternal, @NotNull List<? extends UseCase> newUseCases, @NotNull List<? extends UseCase> attachedUseCases, @NotNull CameraConfig cameraConfig, int sessionType, @NotNull Range<Integer> targetFrameRate, boolean isFeatureComboInvocation, boolean findMaxSupportedFrameRate) {
        Intrinsics.checkNotNullParameter((Object)cameraInfoInternal, (String)"cameraInfoInternal");
        Intrinsics.checkNotNullParameter(newUseCases, (String)"newUseCases");
        Intrinsics.checkNotNullParameter(attachedUseCases, (String)"attachedUseCases");
        Intrinsics.checkNotNullParameter((Object)cameraConfig, (String)"cameraConfig");
        Intrinsics.checkNotNullParameter(targetFrameRate, (String)"targetFrameRate");
        Pair<Map<UseCase, StreamSpec>, Map<AttachedSurfaceInfo, UseCase>> result = this.calculateSuggestedStreamSpecsForAttachedUseCases(cameraMode, cameraInfoInternal, attachedUseCases);
        Object object = result.second;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"second");
        Map map = (Map)object;
        Map<UseCase, CameraUseCaseAdapter.ConfigPair> map2 = CameraUseCaseAdapter.getConfigs((Collection<UseCase>)newUseCases, cameraConfig.getUseCaseConfigFactory(), this.useCaseConfigFactory, sessionType, targetFrameRate);
        Intrinsics.checkNotNullExpressionValue(map2, (String)"getConfigs(...)");
        StreamSpecQueryResult surfaceStreamSpecQueryResult = this.calculateSuggestedStreamSpecsForNewUseCases(cameraMode, cameraInfoInternal, newUseCases, map, map2, isFeatureComboInvocation, findMaxSupportedFrameRate);
        Object object2 = result.first;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"first");
        return new StreamSpecQueryResult(MapsKt.plus((Map)((Map)object2), surfaceStreamSpecQueryResult.getStreamSpecs()), surfaceStreamSpecQueryResult.getMaxSupportedFrameRate());
    }

    private final Pair<Map<UseCase, StreamSpec>, Map<AttachedSurfaceInfo, UseCase>> calculateSuggestedStreamSpecsForAttachedUseCases(int cameraMode, CameraInfoInternal cameraInfoInternal, List<? extends UseCase> attachedUseCases) {
        List existingSurfaces = new ArrayList();
        String string = cameraInfoInternal.getCameraId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCameraId(...)");
        String cameraId = string;
        Map suggestedStreamSpecs = new LinkedHashMap();
        Map surfaceInfoUseCaseMap = new LinkedHashMap();
        for (UseCase useCase : attachedUseCases) {
            AttachedSurfaceInfo attachedSurfaceInfo;
            StreamSpec attachedStreamSpec;
            SurfaceConfig surfaceConfig;
            if (useCase.getAttachedStreamSpec() == null) {
                boolean $i$a$-requireNotNull-StreamSpecsCalculatorImpl$calculateSuggestedStreamSpecsForAttachedUseCases$attachedStreamSpec$232 = false;
                String $i$a$-requireNotNull-StreamSpecsCalculatorImpl$calculateSuggestedStreamSpecsForAttachedUseCases$attachedStreamSpec$232 = "Attached stream spec cannot be null for already attached use cases.";
                throw new IllegalArgumentException($i$a$-requireNotNull-StreamSpecsCalculatorImpl$calculateSuggestedStreamSpecsForAttachedUseCases$attachedStreamSpec$232.toString());
            }
            CameraDeviceSurfaceManager cameraDeviceSurfaceManager = this.cameraDeviceSurfaceManager;
            if (cameraDeviceSurfaceManager == null) {
                String string2 = "Required value was null.";
                throw new IllegalStateException(string2.toString());
            }
            int n = cameraMode;
            String string2 = cameraId;
            int n2 = useCase.getImageFormat();
            Size size = useCase.getAttachedSurfaceResolution();
            if (size == null) {
                int n3 = n2;
                String string4 = string2;
                int n4 = n;
                CameraDeviceSurfaceManager cameraDeviceSurfaceManager2 = cameraDeviceSurfaceManager;
                boolean bl = false;
                String string5 = "Attached surface resolution cannot be null for already attached use cases.";
                CameraDeviceSurfaceManager cameraDeviceSurfaceManager3 = cameraDeviceSurfaceManager2;
                int n5 = n4;
                String string3 = string4;
                int n6 = n3;
                String string7 = string5;
                throw new IllegalArgumentException(string7.toString());
            }
            Intrinsics.checkNotNullExpressionValue((Object)cameraDeviceSurfaceManager.transformSurfaceConfig(n, string2, n2, size, useCase.getCurrentConfig().getStreamUseCase()), (String)"transformSurfaceConfig(...)");
            int n7 = useCase.getImageFormat();
            Size size2 = useCase.getAttachedSurfaceResolution();
            Intrinsics.checkNotNull((Object)size2);
            Range<Integer> range = useCase.getCurrentConfig().getTargetFrameRate(StreamSpec.FRAME_RATE_RANGE_UNSPECIFIED);
            if (range == null) {
                String string8 = "Required value was null.";
                throw new IllegalArgumentException(string8.toString());
            }
            Intrinsics.checkNotNullExpressionValue((Object)AttachedSurfaceInfo.create(surfaceConfig, n7, size2, attachedStreamSpec.getDynamicRange(), StreamSharing.getCaptureTypes(useCase), attachedStreamSpec.getImplementationOptions(), useCase.getCurrentConfig().getSessionType(0), range, useCase.getCurrentConfig().isStrictFrameRateRequired()), (String)"create(...)");
            existingSurfaces.add(attachedSurfaceInfo);
            surfaceInfoUseCaseMap.put(attachedSurfaceInfo, useCase);
            suggestedStreamSpecs.put(useCase, attachedStreamSpec);
        }
        return new Pair((Object)suggestedStreamSpecs, (Object)surfaceInfoUseCaseMap);
    }

    private final StreamSpecQueryResult calculateSuggestedStreamSpecsForNewUseCases(int cameraMode, CameraInfoInternal cameraInfoInternal, List<? extends UseCase> newUseCases, Map<AttachedSurfaceInfo, ? extends UseCase> attachedSurfaceInfoToUseCaseMap, Map<UseCase, ? extends CameraUseCaseAdapter.ConfigPair> configPairMap, boolean isFeatureComboInvocation, boolean findMaxSupportedFrameRate) {
        String string = cameraInfoInternal.getCameraId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCameraId(...)");
        String cameraId = string;
        Map suggestedStreamSpecs = new LinkedHashMap();
        int maxSupportedFrameRate = Integer.MAX_VALUE;
        if (!newUseCases.isEmpty()) {
            String combinedUseCaseConfig;
            Rect sensorRect;
            Rect rect;
            Map configToUseCaseMap = new LinkedHashMap();
            Map configToSupportedSizesMap = new LinkedHashMap();
            try {
                rect = cameraInfoInternal.getSensorRect();
            }
            catch (NullPointerException nullPointerException) {
                rect = null;
            }
            Rect rect2 = sensorRect = rect;
            SupportedOutputSizesSorter supportedOutputSizesSorter = new SupportedOutputSizesSorter(cameraInfoInternal, (Size)(rect2 != null ? TransformUtils.rectToSize(rect2) : null));
            boolean isPreviewStabilizationOn = false;
            for (UseCase useCase : newUseCases) {
                CameraUseCaseAdapter.ConfigPair configPair;
                if (configPairMap.get(useCase) == null) {
                    String string2 = "Required value was null.";
                    throw new IllegalArgumentException(string2.toString());
                }
                Intrinsics.checkNotNullExpressionValue(useCase.mergeConfigs(cameraInfoInternal, configPair.mExtendedConfig, configPair.mCameraConfig), (String)"mergeConfigs(...)");
                configToUseCaseMap.put(combinedUseCaseConfig, useCase);
                List<Size> list = supportedOutputSizesSorter.getSortedSupportedOutputSizes((UseCaseConfig<?>)((Object)combinedUseCaseConfig));
                Intrinsics.checkNotNullExpressionValue(list, (String)"getSortedSupportedOutputSizes(...)");
                configToSupportedSizesMap.put(combinedUseCaseConfig, list);
                if (!(useCase instanceof Preview) && !(useCase instanceof StreamSharing)) continue;
                isPreviewStabilizationOn = combinedUseCaseConfig.getPreviewStabilizationMode() == 2;
            }
            CameraDeviceSurfaceManager cameraDeviceSurfaceManager = this.cameraDeviceSurfaceManager;
            if (cameraDeviceSurfaceManager == null) {
                combinedUseCaseConfig = "Required value was null.";
                throw new IllegalStateException(combinedUseCaseConfig.toString());
            }
            SurfaceStreamSpecQueryResult surfaceStreamSpecQueryResult = cameraDeviceSurfaceManager.getSuggestedStreamSpecs(cameraMode, cameraId, new ArrayList(attachedSurfaceInfoToUseCaseMap.keySet()), configToSupportedSizesMap, isPreviewStabilizationOn, CameraUseCaseAdapter.hasVideoCapture((Collection<UseCase>)newUseCases), isFeatureComboInvocation, findMaxSupportedFrameRate);
            Intrinsics.checkNotNullExpressionValue((Object)surfaceStreamSpecQueryResult, (String)"getSuggestedStreamSpecs(...)");
            SurfaceStreamSpecQueryResult surfaceStreamSpecQueryResult2 = surfaceStreamSpecQueryResult;
            Map<UseCaseConfig<?>, StreamSpec> map = surfaceStreamSpecQueryResult2.component1();
            Map<AttachedSurfaceInfo, StreamSpec> streamSpecMapForAttachedSurfaces = surfaceStreamSpecQueryResult2.component2();
            int maxSupportedFps = surfaceStreamSpecQueryResult2.component3();
            for (Map.Entry entry : configToUseCaseMap.entrySet()) {
                StreamSpec streamSpec = map.get(entry.getKey());
                if (streamSpec == null) {
                    String string3 = "Required value was null.";
                    throw new IllegalArgumentException(string3.toString());
                }
                suggestedStreamSpecs.put(entry.getValue(), streamSpec);
            }
            for (Map.Entry<Object, Object> entry : streamSpecMapForAttachedSurfaces.entrySet()) {
                if (!attachedSurfaceInfoToUseCaseMap.containsKey(entry.getKey())) continue;
                UseCase useCase = attachedSurfaceInfoToUseCaseMap.get(entry.getKey());
                if (useCase == null) {
                    String string4 = "Required value was null.";
                    throw new IllegalArgumentException(string4.toString());
                }
                suggestedStreamSpecs.put(useCase, entry.getValue());
            }
            maxSupportedFrameRate = maxSupportedFps;
        }
        return new StreamSpecQueryResult(suggestedStreamSpecs, maxSupportedFrameRate);
    }
}

