/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.internal;

import androidx.annotation.GuardedBy;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\b\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0013\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0016J\b\u0010\u0010\u001a\u00020\fH\u0016J\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001J\b\u0010\u0012\u001a\u00020\fH\u0002J\b\u0010\u0013\u001a\u00020\fH\u0002J\u0006\u0010\u0014\u001a\u00020\fR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u0004\u0018\u00010\n8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Landroidx/camera/core/internal/ScreenFlashWrapper;", "Landroidx/camera/core/ImageCapture$ScreenFlash;", "screenFlash", "<init>", "(Landroidx/camera/core/ImageCapture$ScreenFlash;)V", "lock", "Ljava/lang/Object;", "isClearScreenFlashPending", "", "pendingListener", "Landroidx/camera/core/ImageCapture$ScreenFlashListener;", "apply", "", "expirationTimeMillis", "", "screenFlashListener", "clear", "getBaseScreenFlash", "completePendingScreenFlashListener", "completePendingScreenFlashClear", "completePendingTasks", "Companion", "camera-core_release"})
public final class ScreenFlashWrapper
implements ImageCapture.ScreenFlash {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final ImageCapture.ScreenFlash screenFlash;
    @NotNull
    private final Object lock;
    @GuardedBy(value="lock")
    private boolean isClearScreenFlashPending;
    @GuardedBy(value="lock")
    @Nullable
    private ImageCapture.ScreenFlashListener pendingListener;
    @NotNull
    private static final String TAG = "ScreenFlashWrapper";

    private ScreenFlashWrapper(ImageCapture.ScreenFlash screenFlash) {
        this.screenFlash = screenFlash;
        this.lock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(long expirationTimeMillis, @NotNull ImageCapture.ScreenFlashListener screenFlashListener) {
        Intrinsics.checkNotNullParameter((Object)screenFlashListener, (String)"screenFlashListener");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.isClearScreenFlashPending = true;
            this.pendingListener = screenFlashListener;
            Unit unit = Unit.INSTANCE;
        }
        ImageCapture.ScreenFlash screenFlash = this.screenFlash;
        if (screenFlash != null) {
            screenFlash.apply(expirationTimeMillis, () -> ScreenFlashWrapper.apply$lambda$2(this));
        } else {
            ScreenFlashWrapper $this$apply_u24lambda_u243 = this;
            boolean bl = false;
            Logger.e(TAG, "apply: screenFlash is null!");
            $this$apply_u24lambda_u243.completePendingScreenFlashListener();
        }
    }

    @Override
    public void clear() {
        this.completePendingScreenFlashClear();
    }

    @Nullable
    public final ImageCapture.ScreenFlash getBaseScreenFlash() {
        return this.screenFlash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void completePendingScreenFlashListener() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            ImageCapture.ScreenFlashListener screenFlashListener = this.pendingListener;
            if (screenFlashListener != null) {
                screenFlashListener.onCompleted();
            }
            this.pendingListener = null;
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void completePendingScreenFlashClear() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (this.isClearScreenFlashPending) {
                ImageCapture.ScreenFlash screenFlash = this.screenFlash;
                if (screenFlash != null) {
                    screenFlash.clear();
                } else {
                    ScreenFlashWrapper $this$completePendingScreenFlashClear_u24lambda_u246_u24lambda_u245 = this;
                    boolean bl2 = false;
                    Logger.e(TAG, "completePendingScreenFlashClear: screenFlash is null!");
                }
            } else {
                Logger.w(TAG, "completePendingScreenFlashClear: none pending!");
            }
            this.isClearScreenFlashPending = false;
            Unit unit = Unit.INSTANCE;
        }
    }

    public final void completePendingTasks() {
        this.completePendingScreenFlashListener();
        this.completePendingScreenFlashClear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void apply$lambda$2(ScreenFlashWrapper this$0) {
        Object object = this$0.lock;
        synchronized (object) {
            boolean bl = false;
            if (this$0.pendingListener == null) {
                Logger.w(TAG, "apply: pendingListener is null!");
            }
            this$0.completePendingScreenFlashListener();
            Unit unit = Unit.INSTANCE;
        }
    }

    @JvmStatic
    @NotNull
    public static final ScreenFlashWrapper from(@Nullable ImageCapture.ScreenFlash screenFlash) {
        return Companion.from(screenFlash);
    }

    public /* synthetic */ ScreenFlashWrapper(ImageCapture.ScreenFlash screenFlash, DefaultConstructorMarker $constructor_marker) {
        this(screenFlash);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Landroidx/camera/core/internal/ScreenFlashWrapper$Companion;", "", "<init>", "()V", "TAG", "", "from", "Landroidx/camera/core/internal/ScreenFlashWrapper;", "screenFlash", "Landroidx/camera/core/ImageCapture$ScreenFlash;", "camera-core_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ScreenFlashWrapper from(@Nullable ImageCapture.ScreenFlash screenFlash) {
            return new ScreenFlashWrapper(screenFlash, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

