/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.internal;

import android.media.MediaCodec;
import android.util.Range;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.CaptureConfig;
import androidx.camera.core.impl.DeferrableSurface;
import androidx.camera.core.impl.SessionConfig;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nJ\u0012\u0010\u000b\u001a\u00020\f*\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u0018\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r*\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u0012\u0010\u0010\u001a\u00020\f*\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\f\u0010\u0010\u001a\u00020\f*\u00020\nH\u0002J\f\u0010\u0011\u001a\u00020\f*\u00020\u0012H\u0002\u00a8\u0006\u0014"}, d2={"Landroidx/camera/core/internal/HighSpeedFpsModifier;", "", "<init>", "()V", "modifyFpsForPreviewOnlyRepeating", "", "outputConfigs", "", "Landroidx/camera/core/impl/SessionConfig$OutputConfig;", "repeatingConfigBuilder", "Landroidx/camera/core/impl/CaptureConfig$Builder;", "isHighSpeedFixedFps", "", "Landroid/util/Range;", "", "toPreviewOnlyRange", "hasVideoSurface", "isVideoSurface", "Landroidx/camera/core/impl/DeferrableSurface;", "Companion", "camera-core_release"})
@SourceDebugExtension(value={"SMAP\nHighSpeedFpsModifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HighSpeedFpsModifier.kt\nandroidx/camera/core/internal/HighSpeedFpsModifier\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,90:1\n1#2:91\n1755#3,3:92\n1755#3,3:95\n*S KotlinDebug\n*F\n+ 1 HighSpeedFpsModifier.kt\nandroidx/camera/core/internal/HighSpeedFpsModifier\n*L\n80#1:92,3\n85#1:95,3\n*E\n"})
public final class HighSpeedFpsModifier {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private static final String TAG = "HighSpeedFpsModifier";
    private static final int PREVIEW_ONLY_FPS_LOWER = 30;

    public final void modifyFpsForPreviewOnlyRepeating(@NotNull Collection<? extends SessionConfig.OutputConfig> outputConfigs, @NotNull CaptureConfig.Builder repeatingConfigBuilder) {
        block1: {
            Range<Integer> range;
            Range<Integer> range2;
            Range<Integer> range3;
            Intrinsics.checkNotNullParameter(outputConfigs, (String)"outputConfigs");
            Intrinsics.checkNotNullParameter((Object)repeatingConfigBuilder, (String)"repeatingConfigBuilder");
            if (outputConfigs.size() != 2 || !this.hasVideoSurface(outputConfigs) || this.hasVideoSurface(repeatingConfigBuilder) || (range3 = repeatingConfigBuilder.getExpectedFrameRateRange()) == null) break block1;
            Range<Integer> it = range2 = range3;
            boolean bl = false;
            Object object = range = this.isHighSpeedFixedFps(it) ? range2 : null;
            if (range != null) {
                it = range;
                boolean bl2 = false;
                repeatingConfigBuilder.setExpectedFrameRateRange(this.toPreviewOnlyRange(it));
            }
        }
    }

    private final boolean isHighSpeedFixedFps(Range<Integer> $this$isHighSpeedFixedFps) {
        return ((Number)((Object)$this$isHighSpeedFixedFps.getUpper())).intValue() >= 120 && Intrinsics.areEqual((Object)$this$isHighSpeedFixedFps.getLower(), (Object)$this$isHighSpeedFixedFps.getUpper());
    }

    private final Range<Integer> toPreviewOnlyRange(Range<Integer> $this$toPreviewOnlyRange) {
        Range range;
        Range it = range = new Range((Comparable)Integer.valueOf(30), $this$toPreviewOnlyRange.getUpper());
        boolean bl = false;
        Logger.d(TAG, "Modified high-speed FPS range from " + $this$toPreviewOnlyRange + " to " + it);
        return range;
    }

    private final boolean hasVideoSurface(Collection<? extends SessionConfig.OutputConfig> $this$hasVideoSurface) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = $this$hasVideoSurface;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    SessionConfig.OutputConfig it = (SessionConfig.OutputConfig)element$iv;
                    boolean bl2 = false;
                    DeferrableSurface deferrableSurface2 = it.getSurface();
                    Intrinsics.checkNotNullExpressionValue((Object)deferrableSurface2, (String)"getSurface(...)");
                    if (!this.isVideoSurface(deferrableSurface2)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean hasVideoSurface(CaptureConfig.Builder $this$hasVideoSurface) {
        boolean bl;
        block3: {
            Set<DeferrableSurface> set = $this$hasVideoSurface.getSurfaces();
            Intrinsics.checkNotNullExpressionValue(set, (String)"getSurfaces(...)");
            Iterable $this$any$iv = set;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    DeferrableSurface it = (DeferrableSurface)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (!this.isVideoSurface(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isVideoSurface(DeferrableSurface $this$isVideoSurface) {
        return Intrinsics.areEqual($this$isVideoSurface.getContainerClass(), MediaCodec.class);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Landroidx/camera/core/internal/HighSpeedFpsModifier$Companion;", "", "<init>", "()V", "TAG", "", "PREVIEW_ONLY_FPS_LOWER", "", "camera-core_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

